# DeepLabv3

## 论文

DeepLabv3:Rethinking Atrous Convolution for Semantic Image Segmentation

- https://arxiv.org/abs/1706.05587

## 模型结构

DeepLabV3 是 DeepLab 系列语义分割算法的第三代版本，主要用于语义分割任务。

<img src="./Doc/Images/deeplabv3_01.jpg" style="zoom:80%;" align=middle>

## 算法原理
DeepLabv3 的核心原理如下：

1. **空洞卷积（Atrous convolution）**：传统卷积通过滑动窗口提取特征，但感受野有限。Deeplabv3 采用空洞卷积在不增加计算量和参数的前提下，显著扩大卷积的感受野，能捕捉更广泛的上下文信息，同时保持特征图的空间分辨率。
2. **空洞空间金字塔池化（Atrous Spatial Pyramid Pooling）**：通过不同空洞率的卷积，同时处理小物体（小感受野）和大物体（大感受野）的特征，再将所有分支的输出拼接融合，使模型对物体尺度变化更鲁棒。
3.  **编码器-解码器（Encoder-Decoder）**：编码器‌负责特征提取，采用空洞空间金字塔池化 （ASPP）模块，通过不同膨胀率的空洞卷积获取多尺度上下文信息；解码器‌通过插值上采样和卷积操作恢复物体边界细节，与编码器输出的特征图融合后生成高分辨率分割结果。

## 环境配置

### Docker（方法一）

拉取镜像：

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/migraphx:4.3.0-ubuntu20.04-dtk24.04.1-py3.10
```

创建并启动容器：

```
docker run --shm-size 16g --network=host --name=deeplabv3_migraphx --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/deeplabv3_migraphx:/home/deeplabv3_migraphx -v /opt/hyhal:/opt/hyhal:ro -it <Your Image ID> /bin/bash

# 激活dtk
source /opt/dtk/env.sh
```

### Dockerfile（方法二）

```
cd ./docker
docker build --no-cache -t deeplabv3_migraphx:2.0 .

docker run --shm-size 16g --network=host --name=deeplabv3_migraphx --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/deeplabv3_migraphx:/home/deeplabv3_migraphx -v /opt/hyhal:/opt/hyhal:ro -it <Your Image ID> /bin/bash

# 激活dtk
source /opt/dtk/env.sh
```

## 模型文件
```
# 安装onnx
pip install onnx

# 进入deeplabv3 migraphx工程根目录
cd <path_to_deeplabv3_migraphx> 

# 进入Python目录
cd Python/

# 运行convert.py 生成模型文件 文件保存在Resource/Models目录下
python convert.py
```


## 数据集

根据提供的样本数据，进行图像分割。

## 推理

### Python版本推理

下面介绍如何运行python代码示例，Python示例的详细说明见Doc目录下的Tutorial_Python.md。

#### 设置环境变量

```
export PYTHONPATH=/opt/dtk/lib:$PYTHONPATH
```

#### 运行示例

```Python
# 进入deeplabv3 migraphx工程根目录
cd <path_to_deeplabv3_migraphx> 

# 进入示例程序目录
cd Python/

# 安装依赖
pip install -r requirements.txt -i https://pypi.tuna.tsinghua.edu.cn/simple

# 运行示例
python DeepLabV3.py
```

### C++版本推理

注意：当使用操作系统不一样时，CMakeList需要做相应的修改：

```
# ubuntu操作系统
${CMAKE_CURRENT_SOURCE_DIR}/depend/lib64/ 修改为 ${CMAKE_CURRENT_SOURCE_DIR}/depend/lib/

# centos操作系统
${CMAKE_CURRENT_SOURCE_DIR}/depend/lib/ 修改为 ${CMAKE_CURRENT_SOURCE_DIR}/depend/lib64/
```

下面介绍如何运行C++代码示例，C++示例的详细说明见Doc目录下的Tutorial_Cpp.md。

#### 安装Opencv依赖

```python
cd <path_to_deeplabv3_migraphx>
sh ./3rdParty/InstallOpenCVDependences.sh
```


#### 安装OpenCV并构建工程

```
rbuild build -d depend
```

#### 设置环境变量

将依赖库依赖加入环境变量LD_LIBRARY_PATH，在~/.bashrc中添加如下语句：

当操作系统是ubuntu系统时：

```
export LD_LIBRARY_PATH=<path_to_deeplabv3_migraphx>/depend/lib/:$LD_LIBRARY_PATH
```

当操作系统是centos系统时：

```
export LD_LIBRARY_PATH=<path_to_deeplabv3_migraphx>/depend/lib64/:$LD_LIBRARY_PATH
```

然后执行:

```
source ~/.bashrc
```

#### 运行示例

```python
# 进入deeplabv3 migraphx工程根目录
cd <path_to_deeplabv3_migraphx> 

# 进入build目录
cd build/

# 执行示例程序
./DeepLabV3
```

## result

### Python版本

python程序运行结束后，会在当前目录中生成分割图像。

<img src="./Doc/Images/deeplabv3_02.png" style="zoom:100%;" align=middle>

### C++版本

C++程序运行结束后，会在build目录生成分割图像。

<img src="./Doc/Images/deeplabv3_03.png" style="zoom:100%;" align=middle>

### 精度

无

## 应用场景

### 算法类别

`图像分割`

### 热点应用行业

`制造`,`交通`,`医疗`

## 源码仓库及问题反馈

https://developer.sourcefind.cn/codes/modelzoo/deeplabv3_migraphx

## 参考资料

https://arxiv.org/abs/1706.05587

