#ifndef __DEEPLABV3_H__
#define __DEEPLABV3_H__

#include <migraphx/program.hpp>
#include <CommonDefinition.h>



namespace migraphxSamples
{

 class DeepLabV3{
    public:
    DeepLabV3();

    ~DeepLabV3();

    ErrorCode Initialize(InitializationParameterOfSegmentation initParamOfSegmentationUnet);

    ErrorCode Segmentation(const cv::Mat& srcImage, cv::Mat& maskImage);

    private:
    cv::FileStorage configurationFile;

    migraphx::program net;
    cv::Size inputSize;
    std::string inputName;
    migraphx::shape inputShape;
    float scale;
 };   

} // namespace migraphxSamples


#endif