#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <DeepLabV3.h>
#include <SimpleLog.h>
#include <Filesystem.h>

int main(){

    migraphxSamples::DeepLabV3 deeplabv3;
    migraphxSamples::InitializationParameterOfSegmentation initParamOfSegmentationUnet;
    initParamOfSegmentationUnet.configFilePath = CONFIG_FILE;
    migraphxSamples::ErrorCode errorCode       = deeplabv3.Initialize(initParamOfSegmentationUnet);
    if(errorCode != migraphxSamples::SUCCESS)
    {
        LOG_ERROR(stdout, "fail to initialize DeepLabV3!\n");
        exit(-1);
    }
    LOG_INFO(stdout, "succeed to initialize DeepLabV3\n");

    // 读取图像
    cv::Mat srcImage = cv::imread("../Resource/Images/000001.jpg", 1);

    // 推理
    cv::Mat maskImage;
    deeplabv3.Segmentation(srcImage, maskImage);
    LOG_INFO(stdout, "========== Segmentation Results ==========\n");
    LOG_INFO(stdout, "Segmentation results have been saved to ./Result.jpg\n");
    cv::imwrite("./Result.jpg", maskImage);

    return 0;

}
