# DDQ
## 论文
`Dense Distinct Query for End-to-End Object Detection`
- https://arxiv.org/abs/2303.12776
## 模型结构
DDQ首先像传统检测器一样铺设密集查询，然后选择不同的查询进行一对一分配,融合了传统和最近的端到端检测器的优点，并显着提高了包括 FCN、R-CNN 和 DETR 在内的各种检测器的性能。

<div align=center>
    <img src="./assets/ddq.png"/>
</div>

## 算法原理
DDQ 的流程图如下。 (a) 展示了 DDQ 应用于类似 FCOS 结构的应用，这是一个全卷积网络 (FCN)，因此被称为 DDQ FCN。金字塔混合操作分别应用于分类和回归分支的最后两层和最后的卷积层。
类无关的非极大值抑制 (NMS) 用作独特查询的选择操作。最终，只有独特的查询会在计算损失之前被分配标签。 (b) 展示了 DDQ 在 R-CNN 结构中的设计 (DDQ R-CNN)。DDQ FCN 的分类和回归分支的最后特征图被连接并过滤为独特查询。
然后，这些独特查询将与对应的边界框一起发送到精炼头进行处理。 (c) 展示了 DDQ 在 DETR 结构中的设计 (DDQ DETR)。
在选择独特查询之后，编码器中剩余的特征嵌入将通过线性投影到独特查询的内容部分。它们对应的边界框将映射到位置嵌入部分。两个部分将被发送到六个精炼阶段。在如此长的精炼架构中，DQS 将在每个精炼阶段之前应用，以确保独特性。
<div align=center>
    <img src="./assets/ddq_pipeline.png"/>
</div>

## 环境配置
### Docker（方法一）
此处提供[光源](https://www.sourcefind.cn/#/service-details)拉取docker镜像的地址与使用步骤，以及[光合](https://developer.hpccube.com/tool/)开发者社区深度学习库下载地址
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-centos7.6-dtk24.04-py310 
docker run -it --shm-size=128G -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal:/opt/hyhal:ro --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name ddq_mmcv  <your IMAGE ID> bash # <your IMAGE ID>为以上拉取的docker的镜像ID替换，本镜像为：c85ed27005f2
cd /path/your_code_data/ddq_mmcv
pip install -r requirements/multimodal.txt -i https://mirrors.aliyun.com/pypi/simple/
pip install mmcv-2.0.1_das1.0+gitc0ccf15.abi0.dtk2404.torch2.1.-cp310-cp310-manylinux2014_x86_64.whl
pip install mmdet -i https://mirrors.aliyun.com/pypi/simple/

```
### Dockerfile（方法二）
此处提供dockerfile的使用方法
```
docker build --no-cache -t ddq:latest .
docker run -it --shm-size=128G -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal:/opt/hyhal:ro --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name ddq_mmcv  ddq  bash
cd /path/your_code_data/ddq_mmcv
pip install -r requirements/multimodal.txt -i https://mirrors.aliyun.com/pypi/simple/
pip install mmcv-2.0.1_das1.0+gitc0ccf15.abi0.dtk2404.torch2.1.-cp310-cp310-manylinux2014_x86_64.whl
pip install mmdet -i https://mirrors.aliyun.com/pypi/simple/
```
### Anaconda（方法三）
此处提供本地配置、编译的详细步骤，例如：

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。
```
#DTK驱动：dtk24.04
# python：python3.10
# torch: 2.1.0
# torchvision: 0.16.0
conda create -n ddq python=3.10
conda activate ddq
pip install torch-2.1.0+das1.0+git00661e0.abi0.dtk2404-cp310-cp310-manylinux2014_x86_64.whl
pip install torchvision-0.16.0+das1.0+gitc9e7141.abi0.dtk2404.torch2.1-cp310-cp310-manylinux2014_x86_64.whl
pip install mmcv-2.0.1_das1.0+gitc0ccf15.abi0.dtk2404.torch2.1.-cp310-cp310-manylinux2014_x86_64.whl

```
`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应`

其它依赖环境安装如下：
```
cd /path/your_code_data/ddq_mmcv
pip install -r requirements/multimodal.txt -i https://mirrors.aliyun.com/pypi/simple/
pip install mmdet -i https://mirrors.aliyun.com/pypi/simple/
```
## 数据集

dataset数据结构如下:
数据集SCNet快速下载链接[coco](http://113.200.138.88:18080/aidatasets/coco2017)


```

├── data
│   ├── coco
│   │   ├── annotations
│   │   │      ├──instances_train2017.json
│   │   │      ├──instances_val2017.json
│   │   ├── train2017
│   │   ├── val2017
```

## 训练

### 单机单卡
```
bash ./tools/dist_train.sh configs/ddq/ddq-detr-4scale_r50_8xb2-12e_coco.py 1
```
### 单机多卡
```
bash tools/dist_train.sh configs/ddq/ddq-detr-4scale_r50_8xb2-12e_coco.py 4
```

## 推理

模型权重SCNet下载链接[ddq_models](http://113.200.138.88:18080/aimodels/ddq_models)

### 单机单卡

Evaluate：
```
HIP_VISIBLE_DEVICES=0 python tools/test.py configs/ddq/ddq-detr-4scale_r50_8xb2-12e_coco.py path/to/model.pth
```

Inference Demo：
```
python demo/image_demo.py demo/demo.jpg configs/ddq/ddq-detr-4scale_r50_8xb2-12e_coco.py --weights path/to/model.pth --device cuda --out-dir outputs
```


### 多卡推理

```
HIP_VISIBLE_DEVICES=0,1,2,3 python tools/test.py configs/ddq/ddq-detr-4scale_r50_8xb2-12e_coco.py path/to/model.pth
```

## result
Inference Demo result：

<div align=center>
    <img src="./assets/demo.jpg"/>
</div>



### 精度
使用四张DCU-K100 AI卡推理

|       Model       | Backbone | Lr schd | Augmentation | box AP(val) |                                 Config                                 |
| :---------------: | :------: | :-----: | :----------: | :---------: |:----------------------------------------------------------------------:|
|  DDQ DETR-4scale  |   R-50   |   12e   |     DETR     |    51.4     |       [config](configs/ddq/ddq-detr-4scale_r50_8xb2-12e_coco.py)       | 
| DDQ DETR-5scale\* |   R-50   |   12e   |     DETR     |    52.1     |       [config](configs/ddq/ddq-detr-5scale_r50_8xb2-12e_coco.py)       | 
| DDQ DETR-4scale\* |  Swin-L  |   30e   |     DETR     |    58.7     |           [config](configs/ddq/ddq-detr-4scale_swinl_8xb2-30e_coco.py)           | 



## 应用场景
### 算法类别
`目标检测`
### 热点应用行业
`科研,制造,医疗,家居,教育`
## 源码仓库及问题反馈
- https://developer.hpccube.com/codes/luopl/ddq_mmcv
## 参考资料
- https://github.com/open-mmlab/mmdetection/tree/main/configs/ddq

