# DBNet

## 论文

Real-time Scene Text Detection with Differentiable Binarization

- https://arxiv.org/pdf/1911.08947.pdf

## 模型结构

DBNet 模型网络结构主要分为 3 个模块：

- 第一模块（1）：使用的是一个 FPN  结构，分为自底向上的卷积操作与自顶向下的上采样，以此来获取多尺度的特征。1 图下面部分是 3x3 的卷积操作，按照卷积公式分别获取原图大小比例的 `1/2、1/4、1/8、1/16、1/32` 的特征图；然后自顶向下进行上采样 x2，然后与自底向上生成的相同大小的特征图融合；融合之后再采用 3x3 的卷积消除上采样的混叠效应；最后对每层输出结果进行上采样，统一为 1/4 大小的特征图。

- 第二模块（2）：将 1/4 大小的特征图经过一系列卷积和转置卷积的机构获取概率图 **P** 和阈值图 **T**，可参考 FCN 网络结构，目的是生成与原图一样大小的特征图 P 和 T。

- 第三模块（3）：将特征图 P 和 T 经过 DB 方法（后续介绍）得到近似二值图。

  ![db](./imgs/paper/db.jpg)

## 算法原理

DBNet的是将二值化操作插入到分割网络中进行联合优化，这样网络可以自适应的预测图像中每一个像素点的阈值（区别去传统方法的固定阈值），从而可完全区分前景和背景的像素。

二值化阈值由网络学习得到，彻底将二值化这一步骤加入到网络里一起训练，这样最终的输出图对于阈值就会具有非常强的鲁棒性，在简化了后处理的同时提高了文本检测的效果。

![segmentation](./imgs/segmentation.png)

### 环境配置

### Docker（方法一）

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.10

docker run --shm-size 10g --network=host -v /opt/hyhal:/opt/hyhal:ro  --name=dbnet --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/dbnet -it <your IMAGE ID> bash 

pip install -r requirements.txt
```

### Dockerfile（方法二）

```plaintext
docker build --no-cache -t dbnet:latest .
docker run --rm --shm-size 10g --network=host -v /opt/hyhal:/opt/hyhal:ro  --name=dbnet --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/../../dbnet:/home/dbnet -it <your IMAGE ID> bash
# 若遇到Dockerfile启动的方式安装环境需要长时间等待，可注释掉里面的pip安装，启动容器后再安装python库：pip install -r requirements.txt
```
### conda（方法三）
关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装。
```
DTK驱动:dtk24.04.1
python:3.10
torch:2.1.0
torchvision:0.16.0
apx:1.1.0
```
Tips：以上dtk驱动、torch等工具版本需要严格一一对应。

其它依赖库参照requirements.txt安装：
```
pip install -r requirements.txt -i http://mirrors.aliyun.com/pypi/simple/ --trusted-host mirrors.aliyun.com
```

## 数据集

在本测试中可以使用icdar2015数据集。下载链接：链接：https://pan.baidu.com/s/1sWVoJlb3Ieh0ztxw_5rW6Q?pwd=6zm0 
提取码：6zm0 

数据在SCNet上的下载地址： http://113.200.138.88:18080/aidatasets/project-dependency/icdar2015

```
── test
├── test.txt
├── train
└── train.txt
```

### 训练

将训练数据解压到datasets目录下。

### 单机单卡

    ./run.sh

### 单机多卡

   ```

    export HIP_VISIBLE_DEVICES=0,1
    python -m torch.distributed.launch --nproc_per_node 2 --master_port 12345 tools/train.py --config_file "config/icdar2015_resnet18_FPN_DBhead_polyLR.yaml"

    ```

## result

![image-20240307095138277](./imgs/result.png)

### 精度

测试数据使用的是icdar2015数据集，使用的加速卡是DCU Z100L。

| 卡数 |                 精度                  |
| :--: | :-----------------------------------: |
|  1   | recall: 0.767070, precision: 0.894410 |

## 应用场景

### 算法类别

文本检测

### 热点行业

制造,能源,交通,网安

## 源码仓库及问题反馈

https://developer.sourcefind.cn/codes/modelzoo/dbnet_pytorch

## 参考资料

https://github.com/WenmuZhou/DBNet.pytorch
