# DBNet

## 模型介绍

DBNet的是将二值化操作插入到分割网络中进行联合优化，这样网络可以自适应的预测图像中每一个像素点的阈值（区别去传统方法的固定阈值），从而可完全区分前景和背景的像素。

二值化阈值由网络学习得到，彻底将二值化这一步骤加入到网络里一起训练，这样最终的输出图对于阈值就会具有非常强的鲁棒性，在简化了后处理的同时提高了文本检测的效果。

## 模型结构

DBNet 模型网络结构主要分为 3 个模块：

- 第一模块（1）：使用的是一个 FPN  结构，分为自底向上的卷积操作与自顶向下的上采样，以此来获取多尺度的特征。1 图下面部分是 3x3 的卷积操作，按照卷积公式分别获取原图大小比例的 `1/2、1/4、1/8、1/16、1/32` 的特征图；然后自顶向下进行上采样 x2，然后与自底向上生成的相同大小的特征图融合；融合之后再采用 3x3 的卷积消除上采样的混叠效应；最后对每层输出结果进行上采样，统一为 1/4 大小的特征图。
- 第二模块（2）：将 1/4 大小的特征图经过一系列卷积和转置卷积的机构获取概率图 **P** 和阈值图 **T**，可参考 FCN 网络结构，目的是生成与原图一样大小的特征图 P 和 T。
- 第三模块（3）：将特征图 P 和 T 经过 DB 方法（后续介绍）得到近似二值图。

## 数据集

在本测试中可以使用icdar2015数据集。

## DBNet训练

### 环境配置

提供[光源](https://www.sourcefind.cn/#/service-details)拉取的训练的docker镜像：

* 训练镜像：docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.10.0-centos7.6-dtk-22.10.1-py37-latest
* pip install -r requirements.txt

### 训练

将训练数据解压到datasets目录下。

训练命令：

    ./run.sh

## 准确率数据

测试数据使用的是icdar2015数据集，使用的加速卡是DCU Z100L。

| 卡数 |                 精度                 |
| :--: | :-----------------------------------: |
|  1  | recall: 0.767070, precision: 0.894410 |

### 历史版本

https://developer.hpccube.com/codes/modelzoo/dbnet

### 参考

https://github.com/WenmuZhou/DBNet.pytorch
