# DASD-4B-Thinking
## 论文
[DASD-4B-Thinking](https://arxiv.org/abs/2512.20908)

## 模型简介
DASD-4B-Thinking是一个紧凑而强大的40亿参数稠密语言模型，专门针对数学、代码生成和科学推理领域的长链条思维（Long-CoT）推理任务进行优化。该模型基于Qwen3-4B-Instruct-2507（非思维型学生模型）进行后训练，并通过分布式对齐序列蒸馏流程从gpt-oss-120b（教师模型）进行知识蒸馏，仅使用较少量训练样本（44.8万）即实现了卓越的长链条思维推理性能，其训练数据规模远小于现有许多更大参数量模型所需的训练量。
<div align=center>
    <img src="./doc/perf.jpg"/>
</div>
## 环境依赖

| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.2 |
| python | 3.10.12 |
| transformers | >=4.57.1 |
| vllm | 0.11.0+das.opt1.alpha.dtk25042.20251225.gca4598a4 |
| torch | 2.5.1+das.opt1.dtk25042 |
| triton | 3.1.0+das.opt1.dtk25042.20251224.gaa867475 |


推荐使用镜像:harbor.sourcefind.cn:5443/dcu/admin/base/vllm:0.11.0-ubuntu22.04-dtk25.04.2-tx-1226-das1.7-py3.10-20251226
- 挂载地址`-v`根据实际模型情况修改

```bash
docker run -it --shm-size 60g --network=host --name DASD-4B-Thinking  --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /opt/hyhal/:/opt/hyhal/:ro -v /path/your_code_path/:/path/your_code_path/  harbor.sourcefind.cn:5443/dcu/admin/base/vllm:0.11.0-ubuntu22.04-dtk25.04.2-tx-1226-das1.7-py3.10-20251226 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。

## 数据集
暂无

## 训练
暂无

## 推理

### vllm
#### 单机推理

```bash
## serve启动
可参考vllm_serve.sh脚本
vllm serve Alibaba-Apsara/DASD-4B-Thinking  --trust-remote-code --dtype bfloat16  -tp 1  --max-model-len 32768 --port 8010
## client访问
可参考vllm_cilent.sh
curl -X POST "http://localhost:8010/v1/chat/completions"      -H "Content-Type: application/json"     --data '{
                "model": "Alibaba-Apsara/DASD-4B-Thinking",
                "messages": [
                        {
                                "role": "user",
                                "content": "请介绍下自己"
                        }
                ]
        }'

```

## 效果展示
<div align=center>
    <img src="./doc/result.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：vllm。

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| DASD-4B-Thinking | 4B | BW1000 | 1 | [下载地址](https://www.modelscope.cn/models/Alibaba-Apsara/DASD-4B-Thinking) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/dasd-4b-thinking_vllm

## 参考资料
- https://hf-mirror.com/Alibaba-Apsara/DASD-4B-Thinking
