# CycleGAN
## 论文
[CycleGAN](https://arxiv.org/pdf/1703.10593.pdf)

## 模型简介
CycleGAN是一种基于循环一致性的生成对抗网络，主要用于非配对数据的跨域图像转换，核心应用包括‌网络结构创新‌、‌超分辨率重建‌和‌风格迁移‌。

### CycleGAN网络结构
**‌双生成器架构**‌：包含两个生成器（G和F）及两个判别器（D_X和D_Y），通过循环一致性损失（Cycle-Consistency Loss）实现无监督训练。‌‌

**‌注意力机制**‌：部分改进版本引入残差网络和注意力模块，增强低光照图像等特殊场景的细节保留能力。‌‌

**‌性能对比**‌：在Enlighten和LOL数据集上，改进后的CycleGAN相比传统GAN模型（如UNIT）PSNR提升约3-5 dB
<img src="https://junyanz.github.io/CycleGAN/images/teaser_high_res.jpg" width="1000px"/>


## 环境依赖

| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.2 |
| python | 3.10.12 |
| transformers | 4.57.1 |
| vllm | 0.11.0+das.opt1.alpha.8e22ded.dtk25042 |
| torch | 2.5.1+das.opt1.dtk25042 |
| triton | 3.1+das.opt1.3c5d12d.dtk25041 |
| flash_attn | 2.6.1+das.opt1.dtk2504 |
| flash_mla | 1.0.0+das.opt1.dtk25042 |

当前仅支持镜像:
- 挂载地址`-v`根据实际模型情况修改

```bash
docker run -it --shm-size 60g --network=host --name cyclegan --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /opt/hyhal/:/opt/hyhal/:ro -v /path/your_code_path/:/path/your_code_path/ image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.4.1-ubuntu22.04-dtk25.04.1-py3.11 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。

## 数据集
使用以下脚本下载数据集。许多数据集是由其他研究人员收集的。如果您使用这些数据，请引用他们的论文。
```bash
bash ./datasets/download_dataset.sh dataset_name
```

- `facades`：来自 [CMP Facades 数据集](http://cmp.felk.cvut.cz/~tylecr1/facade/) 的 400 张图像。[[引用](datasets/bibtex/facades.tex)]
- `cityscapes`：来自 [Cityscapes 训练集](https://www.cityscapes-dataset.com/) 的 2975 张图像。[[引用](datasets/bibtex/cityscapes.tex)]。注意：由于许可问题，我们不在我们的仓库中托管该数据集。请直接从 Cityscapes 网页下载数据集。有关详细信息，请参阅 [./datasets/prepare_cityscapes_dataset.py](file:///Users/dlyrm/work_space/model_zoo/cyclegan_pytorch/datasets/prepare_cityscapes_dataset.py)。
- `maps`：从 Google Maps 抓取的 1096 张训练图像。
- `horse2zebra`：使用关键词 `wild horse` 和 `zebra` 从 [ImageNet](http://www.image-net.org/) 下载的 939 张马的图像和 1177 张斑马的图像。
- `apple2orange`：使用关键词 `apple` 和 `navel orange` 从 [ImageNet](http://www.image-net.org/) 下载的 996 张苹果图像和 1020 张橙子图像。
- `summer2winter_yosemite`：使用 Flickr API 下载的 1273 张夏季约塞米蒂图像和 854 张冬季约塞米蒂图像。详情请见我们的论文。
- `monet2photo`、`vangogh2photo`、`ukiyoe2photo`、`cezanne2photo`：艺术图像从 [Wikiart](https://www.wikiart.org/) 下载。真实照片使用 *landscape* 和 *landscapephotography* 标签组合从 Flickr 下载。每类的训练集大小为：莫奈：1074，塞尚：584，梵高：401，浮世绘：1433，照片：6853。
- `iphone2dslr_flower`：两类图像均从 Flickr 下载。每类的训练集大小为 iPhone：1813，DSLR：3316。详情请见我们的论文。


## 训练
### 应用预训练模型

- 下载测试图片（由 [Alexei Efros](https://www.flickr.com/photos/aaefros) 拍摄）：
```
bash ./datasets/download_dataset.sh ae_photos
```
- 下载预训练模型 `style_cezanne`（对于 CPU 模型，使用 `style_cezanne_cpu`）：
```
bash ./pretrained_models/download_model.sh style_cezanne
```
- 现在，让我们生成保罗·塞尚风格的图像：
```
DATA_ROOT=./datasets/ae_photos name=style_cezanne_pretrained model=one_direction_test phase=test loadSize=256 fineSize=256 resize_or_crop="scale_width" th test.lua
```
测试结果将保存到 `./results/style_cezanne_pretrained/latest_test/index.html`。  
更多预训练模型请参见 [模型库](#model-zoo)。  
[./examples/test_vangogh_style_on_ae_photos.sh](file:///Users/dlyrm/work_space/model_zoo/cyclegan_pytorch/examples/test_vangogh_style_on_ae_photos.sh) 是一个示例脚本，它下载预训练的梵高风格网络并在 Efros 的照片上运行。

### 训练

- 下载数据集（例如来自 ImageNet 的斑马和马的图像）：
```bash
bash ./datasets/download_dataset.sh horse2zebra
```
- 训练模型：
```bash
DATA_ROOT=./datasets/horse2zebra name=horse2zebra_model th train.lua
```
- （仅限 CPU）不使用 GPU 或 CUDNN 的相同训练命令。设置环境变量 ```gpu=0 cudnn=0``` 强制仅使用 CPU：
```bash
DATA_ROOT=./datasets/horse2zebra name=horse2zebra_model gpu=0 cudnn=0 th train.lua
```
- （可选）启动显示服务器以在模型训练时查看结果。（详见 [显示界面](#display-ui)）：
```bash
th -ldisplay.start 8000 0.0.0.0
```

## 推理
### 测试

- 最后，测试模型：
```bash
DATA_ROOT=./datasets/horse2zebra name=horse2zebra_model phase=test th test.lua
```
测试结果将保存到这里的HTML文件中：`./results/horse2zebra_model/latest_test/index.html`。

这段命令会使用训练好的 `horse2zebra_model` 模型对 `./datasets/horse2zebra` 数据集中的测试图像进行转换测试，并将生成的结果以网页形式保存在指定路径下。


### 精度
DCU与GPU精度一致，推理框架：vllm。

## 预训练权重
下载方式
```
bash ./pretrained_models/download_model.sh model_name
```
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| latest_net_G | - | K100AI | 1 | - |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/cyclegan_pytorch

## 参考资料
- https://github.com/junyanz/CycleGAN
