# CRNN_pytorch

## 论文

[An End-to-End Trainable Neural Network for Image-based Sequence Recognition and Its Application to Scene Text Recognition](https://arxiv.org/abs/1507.05717)

## 模型结构

CRNN模型主要包括三个部分，分别称作卷积层、循环层、转录层。

![model_structure.jpg](asserts%2Fmodel_structure.jpg)

## 算法原理

CRNN网络将CNN和RNN网络结合，共同训练，使用CNN对输入图像提取特征，使用RNN对特征序列进行预测并输出预测标签，使用CTCLoss讲标签分布转换为最终的标签序列，其中RNN采用的双层各256单元的双向LSTM

![Algorithm.jpg](asserts%2FAlgorithm.jpg)

## 环境配置

### Docker (方法一)

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.10.0-centos7.6-dtk-22.10.1-py39-latest
docker run -it -v /path/your_code_data/:/path/your_code_data/ --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash

cd /path/workspace/
pip3 install -r requirements.txt
```

### Dockerfile (方法二)

```
cd ./docker
docker build --no-cache -t crnn_pytorch:last .
docker run -it -v /path/your_code_data/:/path/your_code_data/ --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash
```

### Anaconda (方法三)

1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装： https://developer.hpccube.com/tool/

```
DTK软件栈：dtk22.10
python：python3.8
pytorch：1.10.0
torchvision:0.10.0
```

Tips：以上dtk软件栈、python、pytorch等DCU相关工具版本需要严格一一对应

2、其他非特殊库直接按照requirements.txt安装

```
pip3 install -r requirements.txt
```



## 数据集

Synth90k(合成文本数据集-该数据集包含900万张由一组90k常见英语单词生成的图像)
- 数据集快速下载中心:
  - [SCNet AIDatasets](http://113.200.138.88:18080/aidatasets)
- 数据集快速通道下载地址：
  - [数据集快速下载地址](http://113.200.138.88:18080/aidatasets/project-dependency/synth90k)
- 官方下载地址
  - [训练数据](https://www.robots.ox.ac.uk/~vgg/data/text/)



数据集的目录结构如下：

```
├── IIIT5K_lmdb
│   ├── data.mdb
│   ├── error_image_log.txt
│   └── lock.mdb
└── MJ_LMDB
    ├── data.mdb
    └── lock.mdb


```

## 训练

### 单机单卡

```
export HIP_VISIBLE_DEVICES=0
export USE_MIOPEN_BATCHNORM=1
python3 train.py --adadelta --trainRoot ../Datasets/Synth90k/MJ_LMDB --valRoot ../Datasets/Synth90k/IIIT5K_lmdb --cuda --ngpu 1 --batchSize 64 --workers 8
```

### 单机多卡

```
#以单机四卡为例子
export HSA_FORCE_FINE_GRAIN_PCIE=1
export USE_MIOPEN_BATCHNORM=1
export HIP_VISIBLE_DEVICES=0,1,2,3
python -m torch.distributed.launch --nproc_per_node=4 train_ddp.py --adadelta --trainRoot ../Datasets/Synth90k/MJ_LMDB --valRoot ../Datasets/Synth90k/IIIT5K_lmdb --cuda --ngpu 4 --batchSize 64 --workers 8 
```

## 推理

#### 单卡推理
- 模型权重快速下载中心
  - [SCNet AIModels](http://113.200.138.88:18080/aimodels) 
- 模型权重快速通道下载地址
  - [模型权重快速下载地址](http://113.200.138.88:18080/aimodels/findsource-dependency/crnn_pytorch)
- 官方下载地址：
  - [权重下载地址](https://pan.baidu.com/s/1pLbeCND)

```
# 权重放置地址-[初始放在./data下]、测试图片等可在demo中进行更改
python demo.py
```
## result
此处以crnn模型进行推理测试<br>

| 输入 | 输出 |
|:--:|:--:|
|![demo.png](data%2Fdemo.png)|![result.jpg](asserts%2Fresult.jpg)|

### 精度

|   模型    | 数据类型 |  ACC   |   Loss   |
|:-------:|:----:|:------:|:--------:|
|  crnn   |  单精  | 0.9376 | 0.000768 |


## 应用场景
### 算法分类
OCR

### 热点应用行业
金融,零售,交通

## 源码仓库及问题反馈

https://developer.hpccube.com/codes/modelzoo/crnn_pytorch

## 参考资料

[GitHub - crnn.pytorch](https://github.com/meijieru/crnn.pytorch/tree/master)
