# Convolutional Recurrent Neural Network(CRNN)

## 模型介绍

CRNN是文本识别领域的一种经典算法，该算法的主要思想是认为文本识别需要对序列进行预测，所以采用了预测序列常用的RNN网络。算法通过CNN提取图片特征，然后采用RNN对序列进行预测，最终使用CTC方法得到最终结果。

## 模型结构

CRNN模型的主要结构包括基于CNN的图像特征提取模块以及基于双向LSTM的文字序列特征提取模块。

## Python版本推理

下面介绍如何运行Python代码示例，Python示例的详细说明见Doc目录下的Tutorial_Python.md。

### 下载镜像

在光源中下载MIGraphX镜像： 

```python
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:ort1.14.0_migraphx3.0.0-dtk22.10.1
```

### 设置Python环境变量

```
export PYTHONPATH=/opt/dtk/lib:$PYTHONPATH
```

### 安装依赖

CRNN工程的Python推理示例仅提供静态推理，可使用如下命令运行：

```
# 进入python示例目录
cd <path_to_crnn_migraphx>/Python

# 安装依赖
pip install -r requirements.txt
```

### 运行示例

在Python目录下执行如下命令运行该示例程序：

```
python Crnn_infer_migraphx.py 
```

文本识别结果为：

```
a-----v--a-i-l-a-bb-l-e--- => available
```

## C++版本推理

下面介绍如何运行C++代码示例，C++示例的详细说明见Doc目录下的Tutorial_Cpp.md。

### 下载镜像

在光源中下载MIGraphX镜像： 

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:ort1.14.0_migraphx3.0.0-dtk22.10.1
```

### 安装Opencv依赖

```python
cd <path_to_migraphx_samples>
sh ./3rdParty/InstallOpenCVDependences.sh
```

### 修改CMakeLists.txt

- 如果使用ubuntu系统，需要修改CMakeLists.txt中依赖库路径：
  将"${CMAKE_CURRENT_SOURCE_DIR}/depend/lib64/"修改为"${CMAKE_CURRENT_SOURCE_DIR}/depend/lib/"

- **MIGraphX2.3.0及以上版本需要c++17**


### 安装OpenCV并构建工程

```
rbuild build -d depend
```

### 设置环境变量

将依赖库依赖加入环境变量LD_LIBRARY_PATH，在~/.bashrc中添加如下语句：

**Centos**:

```
export LD_LIBRARY_PATH=<path_to_crnn_migraphx>/depend/lib64/:$LD_LIBRARY_PATH
```

**Ubuntu**:

```
export LD_LIBRARY_PATH=<path_to_crnn_migraphx>/depend/lib/:$LD_LIBRARY_PATH
```

然后执行:

```
source ~/.bashrc
```

### 运行示例

成功编译CRNN工程后，在build目录下输入如下命令运行该示例：

1. 静态推理

```
./CRNN 0
```

静态推理示例输入样本图像为：

![text0](./Resource/Images/CrnnDynamicPic/text0.jpg)

文本识别结果为：

```
a-----v--a-i-l-a-bb-l-e--- => available
```

2. 动态shape推理

```
# 开启环境变量
export MIGRAPHX_DYNAMIC_SHAPE=1

# 执行动态推理
./CRNN 1
```

文本识别结果：

```
available
migraphx
waiting
recognition
```

## 历史版本

​		https://developer.hpccube.com/codes/modelzoo/crnn_migraphx

## 参考

​		https://github.com/meijieru/crnn.pytorch
