# CRNN

## 模型介绍

CRNN是文本识别领域的一种经典算法，该算法的主要思想是认为文本识别需要对序列进行预测，所以采用了预测序列常用的RNN网络。算法通过CNN提取图片特征，然后采用RNN对序列进行预测，最终使用CTC方法得到最终结果。

## 模型结构

CRNN模型的主要结构包括基于CNN的图像特征提取模块以及基于双向LSTM的文字序列特征提取模块。

## 推理

### 环境配置

在[光源](https://www.sourcefind.cn/#/image/dcu/custom)可拉取用于推理的docker镜像，CRNN 模型推理推荐的镜像如下：

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:ort_dcu_1.14.0_migraphx2.5.2_dtk22.10.1
```

在[光合开发者社区](https://cancon.hpccube.com:65024/4/main/)可下载MIGraphX安装包，python依赖安装：

```
pip install -r requirements.txt
```

### 运行示例

CRNN模型的推理示例程序是Crnn_infer_migraphx.py，使用如下命令运行该推理示例：

```
python Crnn_infer_migraphx.py 
```

该示例输入样本图像为：

<img src="./data/text.jpg" alt="Result"  />

文本识别结果为：

```
a-----v--a-i-l-a-bb-l-e--- => available
```

## 历史版本

​		https://developer.hpccube.com/codes/modelzoo/crnn_migraphx

## 参考

​		https://github.com/meijieru/crnn.pytorch
