#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <Crnn.h>
#include <SimpleLog.h>
#include <Filesystem.h>

void MIGraphXSamplesUsage(char* programName)
{
    printf("Usage : %s <index> \n", programName);
    printf("index:\n");
    printf("\t 0) Crnn sample.\n");
    printf("\t 1) Crnn Dynamic sample.\n");
}

void Sample_Crnn();
void Sample_Crnn_Dynamic();

int main(int argc, char* argv[])
{
    if(argc < 2 || argc > 2)
    {
        MIGraphXSamplesUsage(argv[0]);
        return -1;
    }
    if(!strncmp(argv[1], "-h", 2))
    {
        MIGraphXSamplesUsage(argv[0]);
        return 0;
    }
    switch(*argv[1])
    {
    case '0': {
        Sample_Crnn();
        break;
    }
    case '1': {
        Sample_Crnn_Dynamic();
        break;
    }
    default: {
        MIGraphXSamplesUsage(argv[0]);
        break;
    }
    }
    return 0;
}

void Sample_Crnn()
{
    // 创建CRNN文本识别
    migraphxSamples::Crnn crnn;
    migraphxSamples::InitializationParameterOfOcr initParamOfOcrCRNN;
    initParamOfOcrCRNN.configFilePath    = CONFIG_FILE;
    migraphxSamples::ErrorCode errorCode = crnn.Initialize(initParamOfOcrCRNN, false);
    if(errorCode != migraphxSamples::SUCCESS)
    {
        LOG_ERROR(stdout, "fail to initialize crnn!\n");
        exit(-1);
    }
    LOG_INFO(stdout, "succeed to initialize crnn\n");

    // 读取测试图片
    cv::Mat srcImage = cv::imread("../Resource/Images/text.jpg", 1);

    // 推理
    std::vector<char> resultRaw;
    std::vector<char> resultSim;
    crnn.Infer(srcImage, resultRaw, true, false);
    crnn.Infer(srcImage, resultSim, false, false);

    // 获取推理结果
    LOG_INFO(stdout, "========== Ocr Results ==========\n");
    for(int i = 0; i < resultRaw.size(); i++)
    {
        std::cout << resultRaw.at(i);
    }
    std::cout << " => ";
    for(int i = 0; i < resultSim.size(); i++)
    {
        std::cout << resultSim.at(i);
    }
    std::cout << std::endl;
}

void Sample_Crnn_Dynamic()
{
    // 创建CRNN文本识别
    migraphxSamples::Crnn crnn;
    migraphxSamples::InitializationParameterOfOcr initParamOfOcrCRNN;
    initParamOfOcrCRNN.configFilePath    = CONFIG_FILE;
    migraphxSamples::ErrorCode errorCode = crnn.Initialize(initParamOfOcrCRNN, true);
    if(errorCode != migraphxSamples::SUCCESS)
    {
        LOG_ERROR(stdout, "fail to initialize crnn!\n");
        exit(-1);
    }
    LOG_INFO(stdout, "succeed to initialize crnn\n");

    // 读取测试图片
    std::vector<cv::Mat> srcImages;
    cv::String folder = "../Resource/Images/CrnnDynamicPic";
    std::vector<cv::String> imagePathList;
    cv::glob(folder, imagePathList);
    for(int i = 0; i < imagePathList.size(); ++i)
    {
        cv::Mat srcImage = cv::imread(imagePathList[i], 1);
        srcImages.push_back(srcImage);
    }

    // 获取推理结果
    LOG_INFO(stdout, "========== Ocr Results ==========\n");
    for(int i = 0; i < srcImages.size(); ++i)
    {
        std::vector<char> resultSim;
        crnn.Infer(srcImages[i], resultSim, false, true);

        for(int i = 0; i < resultSim.size(); i++)
        {
            std::cout << resultSim.at(i);
        }
        std::cout << std::endl;
    }
}