#ifndef __OCR_CRNN_H__
#define __OCR_CRNN_H__

#include <migraphx/program.hpp>
#include <CommonDefinition.h>

namespace migraphxSamples
{

class Crnn
{
public:
    Crnn();
    
    ~Crnn();

    ErrorCode Initialize(InitializationParameterOfOcr initializationParameterOfOcr, bool dynamic);

    ErrorCode Infer(const cv::Mat &srcImage, std::vector<char> &resultsChar, bool raw, bool dynamic);

private:
    cv::FileStorage configurationFile;

    migraphx::program net;
    cv::Size inputSize;
    std::string inputName;
    migraphx::shape inputShape;
   
};
}

#endif
