#ifndef __OCR_CRNN_H__
#define __OCR_CRNN_H__

#include <string>
#include <migraphx/program.hpp>
#include <opencv2/opencv.hpp>
#include <CommonDefinition.h>

using namespace std;
using namespace cv;
using namespace migraphx;

namespace migraphxSamples
{

class Crnn
{
public:
    Crnn();
    
    ~Crnn();

    ErrorCode Initialize(InitializationParameterOfOcr initializationParameterOfOcr, bool dynamic);

    ErrorCode Infer(const cv::Mat &srcImage, std::vector<char> &resultsChar, bool raw, bool dynamic);

    ErrorCode Reshape(const cv::Mat &srcImage);

private:
    ErrorCode DoCommonInitialization(InitializationParameterOfOcr initializationParameterOfOcr);

private:
    cv::FileStorage configurationFile;
    InitializationParameterOfOcr initializationParameter;
    FILE *logFile;

    migraphx::program net;
    cv::Size inputSize;
    string inputName;
    migraphx::shape inputShape;
   
};
}

#endif
