# CRNN

## 论文

An End-to-End Trainable Neural Network for Image-based Sequence Recognition and Its Application to Scene Text Recognition

- https://arxiv.org/abs/1507.05717

## 模型结构

CRNN模型的主要结构包括基于CNN的图像特征提取模块以及基于双向LSTM的文字序列特征提取模块。

<img src="./Doc/Images/CRNN_01.jpg" style="zoom:100%;" align=middle>

## 算法原理

CRNN是文本识别领域的一种经典算法，该算法的主要思想是认为文本识别需要对序列进行预测，所以采用了预测序列常用的RNN网络。该算法首先通过CNN提取图片特征，然后采用RNN对序列进行预测，最终使用CTC方法得到最终结果。

<img src="./Doc/Images/CRNN_02.png" style="zoom:100%;" align=middle>

## 环境配置

### Docker（方法一）

拉取镜像：

```plaintext
docker pull image.sourcefind.cn:5000/dcu/admin/base/migraphx:4.0.0-centos7.6-dtk23.04.1-py38-latest
```

创建并启动容器，安装相关依赖：

```plaintext
docker run --shm-size 16g --network=host --name=crnn_migraphx --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/crnn_migraphx:/home/crnn_migraphx -it <Your Image ID> /bin/bash

# 激活dtk
source /opt/dtk/env.sh
```

### Dockerfile（方法二）

```
cd ./docker
docker build --no-cache -t crnn_migraphx:2.0 .

docker run --shm-size 16g --network=host --name=crnn_migraphx --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/crnn_migraphx:/home/crnn_migraphx -it <Your Image ID> /bin/bash

# 激活dtk
source /opt/dtk/env.sh
```

## 数据集

根据提供的样本数据，进行文本识别。

## 推理

### Python版本推理

下面介绍如何运行Python代码示例，Python示例的详细说明见Doc目录下的Tutorial_Python.md。

#### 设置环境变量

```
export PYTHONPATH=/opt/dtk/lib:$PYTHONPATH
```

#### 运行示例

CRNN工程的Python推理示例仅提供静态推理，可使用如下命令运行：

```
# 进入python示例目录
cd <path_to_crnn_migraphx>/Python

# 安装依赖
pip install -r requirements.txt -i https://pypi.tuna.tsinghua.edu.cn/simple

# 运行示例
python Crnn_infer_migraphx.py 
```

### C++版本推理

下面介绍如何运行C++代码示例，C++示例的详细说明见Doc目录下的Tutorial_Cpp.md。


#### 构建工程

```
rbuild build -d depend
```

#### 设置环境变量

将依赖库依赖加入环境变量LD_LIBRARY_PATH，在~/.bashrc中添加如下语句：

```
export LD_LIBRARY_PATH=<path_to_crnn_migraphx>/depend/lib64/:$LD_LIBRARY_PATH
```

然后执行:

```
source ~/.bashrc
```

#### 运行示例

成功编译CRNN工程后，执行如下命令运行该示例：

```
# 进入crnn migraphx工程根目录
cd <path_to_crnn_migraphx> 

# 进入build目录
cd build/
```

1. 静态推理

```
./CRNN 0
```

2. 动态shape推理

```
# 执行动态推理示例程序
./CRNN 1
```

## result

### Python版本

输入样本图像得到文本识别的结果

<img src="./Resource/Images/text.jpg" style="zoom:100%;" align=middle>

```
a-----v--a-i-l-a-bb-l-e--- => available
```

### C++版本

静态推理：

输入样本图像得到文本识别的结果

<img src="./Resource/Images/CrnnDynamicPic/text0.jpg" style="zoom:100%;" align=middle>

```
a-----v--a-i-l-a-bb-l-e--- => available
```

动态推理：

可以连续对多张样本图像进行文本识别

<img src="./Resource/Images/CrnnDynamicPic/text0.jpg" style="zoom:100%;" align=middle>

<img src="./Resource/Images/CrnnDynamicPic/text1.jpg" style="zoom:80%;" align=middle>

<img src="./Resource/Images/CrnnDynamicPic/text2.jpg" style="zoom:60%;" align=middle>

<img src="./Resource/Images/CrnnDynamicPic/text3.jpg" style="zoom:80%;" align=middle>

```
available
migraphx
waiting
recognition
```

### 精度

无

## 应用场景

### 算法类别

`ocr`

### 热点应用行业

`金融`,`交通`,`教育`,`医疗`

## 源码仓库及问题反馈

https://developer.hpccube.com/codes/modelzoo/crnn_migraphx

## 参考资料

https://github.com/meijieru/crnn.pytorch
