# Convolutional Recurrent Neural Network(CRNN)

## 模型介绍

CRNN是文本识别领域的一种经典算法，该算法的主要思想是认为文本识别需要对序列进行预测，所以采用了预测序列常用的RNN网络。算法通过CNN提取图片特征，然后采用RNN对序列进行预测，最终使用CTC方法得到最终结果。

## 模型结构

CRNN模型的主要结构包括基于CNN的图像特征提取模块以及基于双向LSTM的文字序列特征提取模块。

## Python版本推理

下面介绍如何运行Python代码示例，Python示例的详细说明见Doc目录下的Tutorial_Python.md。

### 下载镜像

下载MIGraphX镜像： 

```python
docker pull sugonhub/migraphx:3.2.1-centos7.6-dtk-23.04.1-py38
```

### 设置Python环境变量

```
export PYTHONPATH=/opt/dtk/lib:$PYTHONPATH
```

### 安装依赖

CRNN工程的Python推理示例仅提供静态推理，可使用如下命令运行：

```
# 进入python示例目录
cd <path_to_crnn_migraphx>/Python

# 安装依赖
pip install -r requirements.txt
```

### 运行示例

在Python目录下执行如下命令运行该示例程序：

```
python Crnn_infer_migraphx.py 
```

文本识别结果为：

```
a-----v--a-i-l-a-bb-l-e--- => available
```

## C++版本推理

下面介绍如何运行C++代码示例，C++示例的详细说明见Doc目录下的Tutorial_Cpp.md。

### 下载镜像

下载MIGraphX镜像： 

```
docker pull sugonhub/migraphx:3.2.1-centos7.6-dtk-23.04.1-py38
```


### 构建工程

```
rbuild build -d depend
```

### 设置环境变量

将依赖库依赖加入环境变量LD_LIBRARY_PATH，在~/.bashrc中添加如下语句：

```
export LD_LIBRARY_PATH=<path_to_crnn_migraphx>/depend/lib64/:$LD_LIBRARY_PATH
```

然后执行:

```
source ~/.bashrc
```

### 运行示例

成功编译CRNN工程后，执行如下命令运行该示例：

```
# 进入crnn migraphx工程根目录
cd <path_to_crnn_migraphx> 

# 进入build目录
cd build/
```

1. 静态推理

```
./CRNN 0
```

静态推理示例输入样本图像为：

![text0](./Resource/Images/CrnnDynamicPic/text0.jpg)

文本识别结果为：

```
a-----v--a-i-l-a-bb-l-e--- => available
```

2. 动态shape推理

```
# 开启环境变量
export MIGRAPHX_DYNAMIC_SHAPE=1

# 执行动态推理示例程序
./CRNN 1
```

文本识别结果：

```
available
migraphx
waiting
recognition
```

## 源码仓库及问题反馈

​		https://developer.hpccube.com/codes/modelzoo/crnn_migraphx

## 参考

​		https://github.com/meijieru/crnn.pytorch
