# CRF-RNN
## 论文
[CRF-RNN](https://arxiv.org/pdf/1502.03240)


## 模型简介
提出了一种名为CRF-RNN的新型卷积神经网络，它将卷积神经网络（CNN）的强大特征学习能力与基于条件随机场（CRF）的概率图模型的结构化预测优势相结合，旨在解决像素级标注任务（如语义分割）中CNN在描绘视觉对象时边界不清晰和缺乏平滑性约束的问题。

![alt text](image.png)

核心贡献在于将具有高斯对势（Gaussian pairwise potentials）的密集CRF（dense CRF）的平均场（mean-field）近似推断过程，重新表述为一个循环神经网络（RNN）。这个CRF-RNN模块可以作为一个可插拔的组件，集成到传统的CNN架构中，从而形成一个能够进行端到端训练的深度网络。这种集成使得整个网络（包括CNN和CRF部分）可以使用标准的反向传播算法进行训练，避免了传统方法中将CRF作为离线后处理步骤的弊端。

## 环境依赖

| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.1 |
| python | 3.11 |
| torch | 2.4.1+das.opt1.dtk25041 |


推荐使用镜像:
- 挂载地址 `-v` 根据实际模型情况修改

```bash
docker run -it --shm-size 50g --network=host --name crf-rnn --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /opt/hyhal/:/opt/hyhal/:ro -v /path/your_code_path/:/path/your_code_path/ image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.4.1-ubuntu22.04-dtk25.04.1-py3.11 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装，其它包参照requirements.txt安装：
```
pip install -r requirements.txt
```

## 数据集
暂无

## 训练
暂无
<!-- ### 单机训练
```bash

``` -->

<!-- ### 多机训练
```bash

``` -->

## 推理

### 单机推理
```bash
python run_demo.py
```

<!-- ### 多机推理
```bash

``` -->


### 精度
DCU与GPU精度一致

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| crfasrnn | - | K100AI | 1 | [下载地址](https://github.com/sadeepj/crfasrnn_pytorch/releases/download/0.0.1/crfasrnn_weights.pth) |



## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/crf-rnn-pytorch

## 参考资料
- https://github.com/sadeepj/crfasrnn_pytorch
