# ConvNeXt
## 论文
`ConvNeXt V2: Co-designing and Scaling ConvNets with Masked Autoencoders`<br>
[论文链接](https://arxiv.org/abs/2301.00808)<br>
## 模型结构
全卷积掩码自动编码器（FCMAE）。它由基于稀疏卷积的ConvNeXt编码器和轻量级ConvNeXt块解码器组成。总的来说，我们的自动编码器的架构是不对称的。编码器只处理可见像素，解码器使用编码后的像素和掩码标记重建图像。损失仅计算在掩码区域上。<br>
![model_framework.png](asserts%2Fmodel_framework.png)
## 算法原理
ConvNeXt-v2的block中引入了一个完全基于卷积的遮蔽自编码器框架和一种新的全局响应归一化（GRN）层，可添加到ConvNeXt架构中，以增强通道间特征竞争,解决了直接在遮蔽输入上训练ConvNeXt时在MLP层出现的特征崩溃问题。<br>
![block.png](asserts%2Fblock.png)
## 环境配置
### Docker（方法一）

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-centos7.6-dtk24.04-py310
docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro --shm-size=80G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash

cd /your_code_path/convnext_mmcv
pip install mmdet -i https://mirrors.aliyun.com/pypi/simple/
pip install mmpretrain -i https://mirrors.aliyun.com/pypi/simple/

```
### Dockerfile（方法二）
```
cd ./docker
docker build --no-cache -t mmdet:last .
docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro --shm-size=80G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash
cd /your_code_path/convnext_mmcv
pip install mmdet -i https://mirrors.aliyun.com/pypi/simple/
pip install mmpretrain -i https://mirrors.aliyun.com/pypi/simple/
```
### Anaconda（方法三）
1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装： https://developer.sourcefind.cn/tool/
```
DTK软件栈: dtk24.04
python: python3.10
torch: 2.1
mmcv: 2.0.1

```

Tips：以上dtk软件栈、python、torch、mmcv等DCU相关工具版本需要严格一一对应

2、其他非特殊库直接按照requirements.txt安装

```
cd /your_code_path/convnext_mmcv
pip install mmdet -i https://mirrors.aliyun.com/pypi/simple/
pip install mmpretrain -i https://mirrors.aliyun.com/pypi/simple/
```

## 数据集
COCO2017（在网络良好的情况下，如果没有下载数据集，程序会默认在线下载数据集）

[训练数据](http://images.cocodataset.org/zips/train2017.zip)

[验证数据](http://images.cocodataset.org/zips/val2017.zip)

[测试数据](http://images.cocodataset.org/zips/test2017.zip)

[标签数据](https://github.com/ultralytics/yolov5/releases/download/v1.0/coco2017labels.zip)

数据集的目录结构如下：

```
├── images 
│   ├── train2017
│   ├── val2017
│   ├── test2017
├── labels
│   ├── train2017
│   ├── val2017
├── annotations
│   ├── instances_val2017.json
├── LICENSE
├── README.txt 
├── test-dev2017.txt
├── train2017.txt
├── val2017.txt

```
我们通过了mini数据集，供验证训练使用，如需正式使用，请下载完整COCO数据集或使用定制化数据集。
```bash
cd /your_code_path/convnext_mmcv
cd datasets/
unzip  coco_mini.zip
```
## 训练
- 数据集放置位置默认为当前目录下 datasets/
- 如需要变更数据集目录 请修改 [coco_instance.py](configs%2F_base_%2Fdatasets%2Fcoco_instance.py)下的 data_root
### 单机四卡
```bash
cd /your_code_path/convnext_mmcv
bash ./train_multi.sh
```
### 单机单卡
```bash
cd /your_code_path/convnext_mmcv
bash ./train.sh
```
## 推理
- 可使用官方模型权重进行推理，也可使用自己训练模型权重进行推理
- 这里以官方模型推理举例[[下载地址：mask-rcnn_convnext-v2-b_fpn_lsj-3x-fcmae_coco_20230113_110947-757ee2dd.pth](https://download.openmmlab.com/mmdetection/v3.0/convnextv2/mask-rcnn_convnext-v2-b_fpn_lsj-3x-fcmae_coco/mask-rcnn_convnext-v2-b_fpn_lsj-3x-fcmae_coco_20230113_110947-757ee2dd.pth)]
```bash
# 官方推理代码
python demo/image_demo.py demo/demo.jpg ./projects/ConvNeXt-V2/configs/mask-rcnn_convnext-v2-b_fpn_lsj-3x-fcmae_coco.py --weights mask-rcnn_convnext-v2-b_fpn_lsj-3x-fcmae_coco_20230113_110947-757ee2dd.pth --device cuda
```
## result
![result.png](asserts%2Fresult.png)
### 精度
|       模型名称       | Backbone | Pretrain | Aug | amp混精 | mask AP | Box AP |
|:----------------:|:---------:|:------:|:---:|:-----:|:-----:|:------:|
| Mask R-CNN |    ConvNeXt-V2-B   |   FCMAE   |  LSJ   |  on   |  46.4   |  52.9  |

## 应用场景
### 算法类别
`目标检测`
### 热点应用行业
`金融,交通,教育`
## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/convnext_mmcv
## 参考资料
- https://github.com/open-mmlab/mmdetection/tree/main
