import onnx

def get_input_details(onnx_file):
    # 加载ONNX模型
    model = onnx.load(onnx_file)

    # 获取输入信息
    input_details = []
    for input in model.graph.input:
        input_name = input.name
        input_shape = [dim.dim_value for dim in input.type.tensor_type.shape.dim]
        input_details.append((input_name, input_shape))

    return input_details

def get_output_details(onnx_file):
    # 加载ONNX模型
    model = onnx.load(onnx_file)

    # 获取输出信息
    output_details = []
    for output in model.graph.output:
        output_name = output.name
        output_shape = [dim.dim_value for dim in output.type.tensor_type.shape.dim]
        output_details.append((output_name, output_shape))

    return output_details

# 调用函数并打印输入和输出信息
onnx_file = "model.onnx"  # 将 "your_model.onnx" 替换为你的ONNX模型文件路径
input_details = get_input_details(onnx_file)
output_details = get_output_details(onnx_file)

print("输入信息：")
for name, shape in input_details:
    print("Input Name:", name)
    print("Input Shape:", shape)

print("输出信息：")
for name, shape in output_details:
    print("Output Name:", name)
    print("Output Shape:", shape)