# Caffe 模型转换为 ONNX 模型

## 1. 环境搭建

- onnx(version == 1.6.0)
```shell script
pip3 install onnx==1.6.0
```

- numpy(version >= 1.17.0)
```shell script
pip3 install numpy
```

## 2. caffe2onnx 工具使用
- 进入工具目录
``` shell script
cd <tnn_root_path>/tools/caffe2onnx/
```

- 模型下载
示例caffe模型[下载地址](https://github.com/GammaLab-HPC/dawnbench_inference_imagenet/tree/master/model),prototxt和caffemodel均需要下载。

- 使用转换工具
```shell script
python3 convert2onnx.py ./resnet50.prototxt ./resnet50.caffemodel -o ./test.onnx
```
- 转换工具脚本参数说明
```text
usage: caffe2onnx.py [-h] [-o ONNX_FILE] proto_file caffe_model_file

convert caffe model to onnx

positional arguments:
  proto_file        the path for prototxt file, the file name must end with .prototxt
  caffe_model_file  the path for caffe model file, the file name must end with .caffemodel!

options:
  -h, --help        show this help message and exit
  -o ONNX_FILE      the path for generate onnx file
```