# ControlNet

## 论文

**Adding Conditional Control to Text-to-Image Diffusion Models**

* https://arxiv.org/abs/2302.05543


## 模型结构

左图为stable diffusion模型，右图为controlne模型。

Prompt $`c_t`$ ：输入的文本提示词；

Time $`t`$ ：时间步；

Input $`z_t`$：t时刻的采样值；

Output $`\epsilon_{\theta}(z_t, t, c_t, c_f)`$ ：模型输出；

Condition $`c_f`$ ：控制条件（控制图像生成的图像）；

zero convolution：初始权重为零的卷积层；

锁符号：不进行训练的网络层；

蓝色部分：直接复制stable diffusion相应权重的网络层。

![Alt text](imgs/image-2.png)


## 算法原理

用途：该算法可以向stable diffusion模型中添加控制条件，让生成的图像更加可控。

原理：

1. 利用预训练的stable diffusion强大的文本-图像生成能力，在此基础上加入额外的神经网络模型，对其训练以生成控制stable diffusion的条件。

![Alt text](imgs/image-1.png)

2. 使用初始化权重为0的卷积层，这种架构确保在训练刚开始阶段不会向大型扩散模型的深层特征中添加有害噪音，并保护可训练副本中的大规模预训练骨干结构，避免受到此类噪音的破坏。

## 环境配置

### Docker (方法一)

    docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.13.1-centos7.6-dtk-23.04-py38-latest
    docker run --shm-size 10g --network=host --name=controlnet --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -it <your IMAGE ID> bash   
    pip install -r requirements.txt
    cd BasicSR 
    BASICSR_EXT=True python setup.py develop

### Dockerfile（方法二）

    # 需要在对应的目录下
    docker build -t <IMAGE_NAME>:<TAG> .
    # <your IMAGE ID>用以上拉取的docker的镜像ID替换
    docker run -it --shm-size 10g --network=host --name=controlnet --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined <your IMAGE ID> bash
    pip install -r requirements.txt
    cd BasicSR
    BASICSR_EXT=True python setup.py develop

### Anaconda (方法三)
1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装：
https://developer.hpccube.com/tool/

    DTK驱动：dtk23.04
    python：python3.8
    torch:1.13.1
    torchvision:0.14.1
    torchaudio:0.13.1
    deepspeed:0.9.2
    apex:0.1

Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应

2、其它非特殊库参照requirements.txt安装

    pip install -r requirements.txt

3、其他

    cd BasicSR
    BASICSR_EXT=True python setup.py develop

Tips: 使用阿里的pip源

## 数据集

下载地址：https://pan.baidu.com/s/1N_F57AaL8iCzIjg34tb53Q （提取码：kwai）

数据在SCNet上的快速下载地址 ：http://113.200.138.88:18080/aidatasets/project-dependency/controlnet_pytorch/-/tree/master/controlnet

    training
    |- fill50k
        |- source
            |- xxx.png
        |- target
            |- xxx.png
        |- prompt.json

## 训练

1、模型下载

* SD2 https://huggingface.co/stabilityai/stable-diffusion-2-1-base/tree/main （v2-1_512-ema-pruned.ckpt
）

   SD2 在SCNet上的快速下载地址 ：http://113.200.138.88:18080/aimodels/stable-diffusion-2-1-base

* SD1.5 https://huggingface.co/runwayml/stable-diffusion-v1-5/tree/main (v1-5-pruned.ckpt)

   SD1.5 在SCNet上的快速下载地址 ：http://113.200.138.88:18080/aimodels/stable-diffusion-v1-5

* CLIP https://pan.baidu.com/s/1gIxoKDTmnlOQCZfGxcmbeg 
(提取码：kwai)

   CLIP 在SCNet上的快速下载地址 ：http://113.200.138.88:18080/aidatasets/project-dependency/controlnet_pytorch

注意：SD2，SD1.5可任选其一，模型下载后存放在models文件夹中，上述CLIP适用于SD2，若要使用SD1.5，请参考`推理 clip-vit-large-patch14下载`进行模型准备。

2、生成初始模型
    
    # 使用SD1.5
    python tool_add_control.py ./models/v1-5-pruned.ckpt ./models/control_sd15_ini.ckpt

    # 使用SD2
    python tool_add_control_sd21.py ./models/v2-1_512-ema-pruned.ckpt ./models/control_sd21_ini.ckpt

3、训练

    # 使用SD1.5
    python tutorial_train.py

    # 使用SD2
    python tutorial_train_sd21.py

## 推理

1、模型下载

* https://huggingface.co/lllyasviel/ControlNet/tree/main/models

模型在SCNet上的快速下载地址

* http://113.200.138.88:18080/aimodels/ControlNet

注意：该连接中包含多个模型权重，可任选其中一个或多个模型下载并使用，每个模型的效果不同，模型下载后存放在models文件夹中。

2、clip-vit-large-patch14下载

链接：https://pan.baidu.com/s/1gt19fmJ3hlZfcnYZZJPimA 
（提取码：kwai）

在SCNet上的快速下载地址 ：http://113.200.138.88:18080/aimodels/clip-vit-large-patch14

    openai
    |- clip-vit-large-patch14
        |- config.json
        |- merges.txt
        |- preprocessor_config.json
        |- special_tokens_map.json
        |- tokenizer_config.json
        |- tokenizer.json
        |- vocab.json
        |- pytorch_model.bin

3、推理

快速测试（无webui）

    python test_inference.py \
    --input_image <输入图像> \
    --prompt <提示语> \
    --positive_prompt <正向提示语> \
    --negative_prompt <负向提示语> \
    --num_samples <每次生成图像数量> \
    --image_resolution <图像分辨率> \
    --ddim_steps <采样步数> \
    --guess_mode <是否使用猜测模式> \
    --strength \
    --scale \
    --seed <随机数种子> \
    --eta \
    --low_threshold <用于canny算法> \
    --high_threshold <用于canny算法>

注意：直接运行 `python test_inference.py` 会使用默认参数，该测试需要`control_sd15_canny.pth`。


带有webui的推理

    # control_sd15_canny.pth
    python gradio_canny2image.py  

    # control_sd15_mlsd.pth
    python gradio_hough2image.py

    # control_sd15_hed.pth
    python gradio_hed2image.py

    # control_sd15_scribble.pth
    python gradio_scribble2image.py

    # control_sd15_scribble.pth
    python gradio_scribble2image_interactive.py

    # control_sd15_scribble.pth
    python gradio_fake_scribble2image.py

    # control_sd15_openpose.pth
    python gradio_pose2image.py

    # control_sd15_seg.pth
    python gradio_seg2image.py

    # control_sd15_depth.pth
    python gradio_depth2image.py

    # control_sd15_normal.pth
    python gradio_normal2image.py

## result

![Alt text](test_results/test.png)

### 精度

无


## 应用场景

### 算法类别

`AIGC`

### 热点应用行业

`零售,广媒,设计`

## 源码仓库及问题反馈

* https://developer.hpccube.com/codes/modelzoo/controlnet_pytorch

## 参考资料

* https://github.com/lllyasviel/ControlNet/tree/main
* https://github.com/lllyasviel/ControlNet/issues/555
