# Conformer_Wenet_PyTorch

## 论文

`WeNet: Production Oriented Streaming and Non-streaming End-to-End Speech Recognition Toolkit`

- [https://arxiv.org/pdf/2102.01547.pdf](https://arxiv.org/pdf/2102.01547.pdf)

## 模型结构

Conformer模型是一种结合了Transformer的自注意力机制和卷积神经网络的模型结构，用于语音识别和自然语言处理任务，具有时域和频域特征的建模能力。

![model](./img/model.png)

## 算法原理

Conformer算法原理是通过结合多层的Transformer编码器和深度卷积神经网络，实现对输入序列的时域和频域特征进行建模，从而提高语音识别和自然语言处理任务的性能。

![conformer encoder](./img/conformer_encoder.png)

## 环境配置

### Docker（方法一）

此处提供[光源](https://www.sourcefind.cn/#/service-details)拉取docker镜像的地址与使用步骤

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:conformer_pytorch2.1.0-ubuntu20.04-dtk24.04.1-py3.8

docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal:/opt/hyhal:ro --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash

cd /path/workspace/
```

### Dockerfile（方法二）

此处提供dockerfile的使用方法

```
cd ./docker
docker build --no-cache -t conformer:latest .
docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal:/opt/hyhal:ro  --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash
```


## 数据集

`Aishell`

- [http://openslr.org/33/](http://openslr.org/33/)


`Aishell`在SCNet上的快速下载链接：


- [http://113.200.138.88:18080/aidatasets/project-dependency/aishell/-/raw/master/resource_aishell.tgz](http://113.200.138.88:18080/aidatasets/project-dependency/aishell/-/raw/master/resource_aishell.tgz)

- [http://113.200.138.88:18080/aidatasets/project-dependency/aishell/-/raw/master/data_aishell.tgz](http://113.200.138.88:18080/aidatasets/project-dependency/aishell/-/raw/master/data_aishell.tgz)

此处提供数据预处理脚本的使用方法

```
#如果自行下载了aishell数据集，只需要在run.sh文件中修改数据集路径，然后执行如下指令即可
cd ./examples/aishell/s0
#设置stage为-1会自动下载数据集，若有下载好的数据集，可手动设置run.sh脚本中的data路径即可省去下载过程
bash run.sh --stage -1 --stop_stage -1

bash run.sh --stage 0 --stop_stage 0

bash run.sh --stage 1 --stop_stage 1

bash run.sh --stage 2 --stop_stage 2

bash run.sh --stage 3 --stop_stage 3

```

预处理好的训练数据目录结构如下，用于正常训练的完整数据集请按此目录结构进行制备：
该工程数据集分为两个部分，一个是原始数据，另一个是索引和音频提取的特征文件

1、原始数据

```
├── data_aishell
│   ├── transcript
│   │   └── aishell_transcript_v0.8.txt
│   └── wav
│       ├── dev
│       ├── test
│       └── train
├── data_aishell.tgz
├── resource_aishell
│   ├── lexicon.txt
│   └── speaker.info
└── resource_aishell.tgz
```

2、索引和音频提取的特征文件

```
├── dev
│   ├── data.list
│   ├── text
│   └── wav.scp
├── dict
│   └── lang_char.txt
├── local
│   ├── dev
│   │   ├── text
│   │   ├── transcripts.txt
│   │   ├── utt.list
│   │   ├── wav.flist
│   │   ├── wav.scp
│   │   └── wav.scp_all
│   ├── test
│   │   ├── text
│   │   ├── transcripts.txt
│   │   ├── utt.list
│   │   ├── wav.flist
│   │   ├── wav.scp
│   │   └── wav.scp_all
│   └── train
│       ├── text
│       ├── transcripts.txt
│       ├── utt.list
│       ├── wav.flist
│       ├── wav.scp
│       └── wav.scp_all
├── test
│   ├── data.list
│   ├── text
│   └── wav.scp
└── train
    ├── data.list
    ├── global_cmvn
    ├── text
    └── wav.scp
```



## 训练

```
# 默认是4卡，可以通过修改run_train.sh文件修改卡数,数据集路径
# 需要注意训练默认在evaluation过程输出识别的结果，结果的输出会增加训练的时间，单独测试可以在./wenet/bin/recognize.py 文件中注释掉355行的logging.info('{} {}'.format(key, args.connect_symbol.join(content)))，不显示输出的结果，从而减少训练的耗时
bash train.sh 
```

## 推理

```
# 默认使用exp/conformer/final.pt进行推理，可以手动修改
# 注意如果训练过程中关闭了日志输出，需要手动打开，否则将不会输出识别的内容
bash validate.sh
```

## result

![result](./img/result.png)

### 精度

测试数据：[aishell](http://openslr.org/33/)，使用的加速卡:Z100L。

根据测试结果情况填写表格：

| 卡数 | 数据精度 |  精度   |
| :--: | :------: | :-----: |
|  4   |   fp32   | 93.1294 |

## 应用场景

### 算法类别

`语音识别`

### 热点应用行业

`金融,通信,广媒`

## 源码仓库及问题反馈

- [https://developer.hpccube.com/codes/modelzoo/conformer_pytorch](https://developer.hpccube.com/codes/modelzoo/conformer_pytorch)

## 参考资料

- https://github.com/wenet-e2e/wenet
