#!/usr/bin/env bash
PID_FILE=$2
echo $$ > $PID_FILE
CUR_DIR="$( cd "$(dirname "$0")" ; pwd )"
cd $CUR_DIR/examples/aishell/s0

# Dataset prepare
start=$(date +%s)
start_str=`date '+%Y-%m-%d %H:%M:%S' -d "@$start"`
echo "$start_str Begin dataset prepare"

bash run.sh --stage -1 --stop_stage -1
bash run.sh --stage 0 --stop_stage 0
bash run.sh --stage 1 --stop_stage 1
bash run.sh --stage 2 --stop_stage 2
bash run.sh --stage 3 --stop_stage 3

end=$(date +%s)
end_str=`date '+%Y-%m-%d %H:%M:%S' -d "@$end"`
echo "$end_str Finish dataset prepare"
data_prepare_time=$(($end-$start))
echo "Dataset prepare time: ${data_prepare_time}s"

# running training
bash run_train.sh $1 $2

