# Conformer_PyTorch

## 模型介绍

Conformer模型是一种基于自注意力机制（self-attention）的序列建模方法，被广泛应用于语音识别、语言建模、机器翻译、语义分析等自然语言处理任务中。本工程使用的是wenet工具包来调用conformer模型。

Wenet是一个开源的端到端语音识别（ASR）工具包，基于PyTorch实现，旨在提供一个简单、高效、灵活的ASR框架，帮助研究人员和开发者快速构建自己的语音识别系统。

Wenet的核心架构是基于端到端的深度神经网络（DNN）和自注意力机制（self-attention）实现的，其中包含了多种不同的模型结构和技术，如Conformer、Transformer、LSTM-TDNN等，可根据不同的任务需求进行选择。此外，Wenet还提供了一系列的工具和接口，方便用户进行模型的训练、推理、评估等操作，支持多种硬件平台和操作系统，如CPU、GPU、FPGA等。

## 模型结构



## 数据集

使用的数据集为Aishell，Aishell是北京壳牌壳牌科技有限公司发布的开源中文普通话语音语料库。来自中国不同口音地区的400人被邀请参加录音，这是在一个安静的室内环境中进行的，使用高保真麦克风，并将采样降至16kHz。人工抄写准确率95%以上，经过专业的语音标注和严格的质量检测。这些数据对学术使用是免费的。我们希望为语音识别领域的新研究者提供适量的数据。

数据集下载地址：http://openslr.org/33/



## 训练及推理

### 环境配置

在光源可拉取训练的docker镜像，本工程推荐的镜像如下：

docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.10.0-centos7.6-dtk-22.10-py38-latest

进入镜像后需要安装所需的三方依赖

```
pip3 install typeguard==2.13.3
```

### 数据预处理

```
cd ./examples/aishell/s0
#设置stage为0会自动下载数据集，若有下载好的数据集，可手动设置run.sh脚本中的data路径即可省去下载过程
bash run.sh --stage 0 --stop_stage 0

bash run.sh --stage 1 --stop_stage 1

bash run.sh --stage 2 --stop_stage 2

bash run.sh --stage 3 --stop_stage 3
```

### 训练

```
bash train.sh
```

### 推理

训练结束后，模型会保存在exp/conformer/final.pt路径下，可以直接执行如下指令查看推理结果（若需要使用其他预训练模型，请手动修改）

```
bash validate.sh
```

## 模型精度数据

| 卡数 |  精度   |
| :--: | :-----: |
| 4卡  | 93.1294 |



## 源码仓库及问题反馈

http://developer.hpccube.com/codes/modelzoo/conformer_pytorch.git

