# Codellama
Codellama模型是一系列7B、13B、34B和70B模型，使用500B-1T的tokens进行训练。
## 论文
`Code Llama: Open Foundation Models for Code`<br>
[CodeLlama](https://ai.meta.com/research/publications/code-llama-open-foundation-models-for-code/)
## 模型结构
codellama的模型结构主要基于llama2架构进行训练而来，使用了不同的训练方法得到了基于不同任务目的的代码生成模型。
<div align=center>
    <img src="./asserts/model_architecture.png"/>
</div>

## 算法原理
使用GQA模块能够带来更好的速度，使用GQA的head数量不同则会带来速度和性能平衡转换<br>
使用了RoPE位置旋转编码来替代Embedding编码，使得模型获得更好的外推性。<br>
<div align=center>
    <img src="./asserts/model_blocks.png"/>
</div>

## 环境配置
-v 路径、docker_name和imageID根据实际情况修改

### Docker（方法一）

```bash
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-centos7.6-dtk24.04-py310
docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro --shm-size=80G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash

cd /your_code_path/codellama_pytorch
pip install -r requirements.txt  
export HF_ENDPOINT=https://hf-mirror.com
```

### Dockerfile（方法二）

```bash
cd docker
docker build --no-cache -t codellama:latest .
docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro --shm-size=80G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash

cd /your_code_path/codellama_pytorch
pip install -r requirements.txt  
export HF_ENDPOINT=https://hf-mirror.com
```

### Anaconda（方法三）
关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。
```
DTK驱动: dtk24.04
python: python3.10
torch: 2.1.0
```
`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应`

其它非深度学习库安装方式如下：
```bash
pip install -r requirements.txt  -i http://mirrors.huaweicloud.com/repository/pypi/simple
export HF_ENDPOINT=https://hf-mirror.com
```

## 数据集
finetune训练样例数据采用verilog-dataset-v3 <br>
- 官方下载地址
  - [官方下载地址](https://hf-mirror.com/datasets/emilgoh/verilog-dataset-v3)

```angular2html
.
├── verilog-dataset-v3
│   ├── README.md
│   └── train.csv
......
```
<div align=center>
    <img src="./asserts/dataset.png"/>
</div>

## 训练
### 单机两卡
- lora微调
具体参数更改请在train.sh文件中进行,以下为必要参数 <br>
DATA_PATH="{数据集地址}" <br>
MODEL_PATH="{预训练模型加载地址}" <br>
- 全参微调 - 将lora_config地址空字符填充即可
LORA_CONFIG=""
```bash
bash ./train.sh
```

## 推理
基于Huggingface's Transformers进行推理.<br>

- 官方下载地址：
  - [下载地址](https://hf-mirror.com/meta-llama/CodeLlama-7b-Instruct-hf)
- 这里以官方模型推理举例

默认需存放至weights文件夹中<br>
也可自行更改 inference.py文件中的 model_name 参数<br>
```bash
HIP_VISIBLE_DEVICES=0 python inference.py
```
## Result
prompt：In Bash, how do I list all text files in the current directory (excluding subdirectories) that have been modified in the last month?",<br>
result：
<div align=center>
    <img src="./asserts/result.png"/>
</div>

### 精度
训练集verilog-dataset-v3

|  device  | lora_train_loss | steps |
|:--------:|:---------------:|:-----:|
|  A800*2  |     0.4743      | 2580  |
|  K100*2  |     0.4687      | 2580  |


NV:绿色 DCU:红色
<div align=center>
    <img src="./asserts/loss.jpg"/>
</div>

## 应用场景
### 算法类别
代码生成

### 热点应用行业
制造,能源,教育

## 预训练权重
模型目录结构如下：
```
.
└── CodeLlama-7b-Instruct-hf
    ├── config.json
    ├── generation_config.json
    ├── LICENSE
    ├── model-00001-of-00002.safetensors
    ├── model-00002-of-00002.safetensors
    ├── model.safetensors.index.json
    ├── pytorch_model-00001-of-00003.bin
    ├── pytorch_model-00002-of-00003.bin
    ├── pytorch_model-00003-of-00003.bin
    ├── pytorch_model.bin.index.json
    ├── README.md
    ├── special_tokens_map.json
    ├── tokenizer_config.json
    ├── tokenizer.json
    ├── tokenizer.model
    └── USE_POLICY.md
```

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/codellama_pytorch

## 参考资料
- https://hf-mirror.com/meta-llama/CodeLlama-7b-Instruct-hf
- https://github.com/meta-llama/codellama
- https://hf-mirror.com/datasets/emilgoh/verilog-dataset-v3
