#export CUDA_VISIBLE_DEVICES=1,2
DATA_PATH="./data/verilog-dataset-v3/train.csv"

OUTPUT_PATH="./outputs"
MODEL_PATH="./weights/CodeLlama-7b-Instruct-hf"
DEEPSEPPD_CONFIG="./dp_configs/ds_config_stage3.json"
LORA_CONFIG="./lora_config.json"

deepspeed --include="localhost:2,3" --master_port 25923 fintune.py \
    --model_name_or_path $MODEL_PATH \
    --data_path $DATA_PATH \
    --output_dir $OUTPUT_PATH \
    --num_train_epochs 3 \
    --model_max_length 2048 \
    --per_device_train_batch_size 2 \
    --per_device_eval_batch_size 1 \
    --gradient_accumulation_steps 4 \
    --evaluation_strategy "no" \
    --save_strategy "steps" \
    --save_steps 100 \
    --save_total_limit 100 \
    --learning_rate 2e-5 \
    --warmup_steps 10 \
    --logging_steps 1 \
    --lr_scheduler_type "cosine" \
    --gradient_checkpointing True \
    --report_to "all" \
    --deepspeed  $DEEPSEPPD_CONFIG \
    --bf16 True \
    --lora_config $LORA_CONFIG

