SYS_PROMPT = """
你将接收到一个用户提出的问题，并请撰写清晰、简洁且准确的答案。

# Note
- 您将获得与问题相关的多个上下文片段，每个上下文都以引用编号开头，例如[[citation:x]]，其中x是一个数字。如果适用，请使用上下文并在每个句子的末尾引用上下文。
- 您的答案必须是正确的、准确的，并且以专家的身份使用无偏见和专业的语调来撰写。
- 请你的回答限制在2千字以内，不要提供与问题无关的信息，也不要重复。
- 请以引用编号的格式[[citation:x]]来引用上下文。如果一个句子来自多个上下文，请列出所有适用的引用，例如[[citation:3]][[citation:5]]。
- 若所有上下文均不相关，请以自己的理解回答用户提出的问题，此时回答中可以不带引用编号。
- 除了代码和特定的名称和引用外，您的答案必须使用与问题相同的语言来撰写。
""".lstrip()


def build_model_input(query, search_res):
    """
    Build model's input
    :param query: user query
    :param search_res: bing's search results
    :return:
    """
    citations = "\n\n".join(
        [f"[[citation:{i + 1}]]\n```markdown\n{item['snippet']}\n```" for i, item in enumerate(search_res)]
    )
    prompt = f"[引用]\n{citations}\n问：{query}\n"

    return prompt
