# codegeex4_pytorch
它是一个在GLM-4-9B上持续训练的多语言代码生成模型，显著增强了其代码生成能力。
## 论文
暂无

## 模型结构

基于transformer结构
<div align=center>
    <img src="./asserts/transformers.png" witdh=300 height=400/>
</div>

## 算法原理

CodeGeeX4基于第四代模型的实现了128K 长文本能力，并且生成速度全面超越上一代模型，实现3倍速生成，首响速度提高了8倍以上。
<div align=center>
    <img src="./asserts/model.png"/>
</div>

## 环境配置
-v 路径、docker_name和imageID根据实际情况修改

### Docker（方法一）

```bash
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-centos7.6-dtk24.04-py310
docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro --shm-size=80G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash

cd /your_code_path/codegeex4_pytorch
pip install -r requirements.txt
pip install -U huggingface_hub hf_transfer
export HF_ENDPOINT=https://hf-mirror.com
```

### Dockerfile（方法二）

```bash
cd docker
docker build --no-cache -t codegeex4:latest .
docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro --shm-size=80G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash

cd /your_code_path/codegeex4_pytorch
pip install -r requirements.txt
pip install -U huggingface_hub hf_transfer
export HF_ENDPOINT=https://hf-mirror.com

```

### Anaconda（方法三）
关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。
```
DTK驱动: dtk24.04
python: python3.10
torch: 2.1.0
```
`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应`

其它非深度学习库安装方式如下：
```bash
pip install -r requirements.txt
pip install -U huggingface_hub hf_transfer
export HF_ENDPOINT=https://hf-mirror.com
```

## 数据集
暂无

## 训练
暂无

## 推理

基于Huggingface's Transformers进行推理

模型下载后 默认需存放至weights文件夹中

也可自行更改 inference.py文件中的 model_name 参数

```python
HIP_VISIBLE_DEVICES=0 python inference.py
```
## Result
prompt：write a quick sort.<br>
<div align=center>
    <img src="./asserts/result.png"/>
</div>

### 精度
暂无

## 应用场景
### 算法类别
代码生成

### 热点应用行业
制造,能源,教育

## 预训练权重

- 模型权重快速下载中心
  - [SCNet AIModels](http://113.200.138.88:18080/aimodels) 
- 模型权重快速通道下载地址
  - [模型权重快速下载地址](http://113.200.138.88:18080/aimodels/thudm/codegeex4-all-9b)
- 官方下载地址：
  - [codegeex4-all-9b](https://huggingface.co/THUDM/codegeex4-all-9b)


模型目录结构如下：

```bash
└── codegeex4-all-9b
    ├── config.json
    ├── configuration_chatglm.py
    ├── configuration.json
    ├── generation_config.json
    ├── LICENSE
    ├── model-00001-of-00004.safetensors
    ├── model-00002-of-00004.safetensors
    ├── model-00003-of-00004.safetensors
    ├── model-00004-of-00004.safetensors
    ├── modeling_chatglm.py
    ├── model.safetensors.index.json
    ├── README.md
    ├── README_zh.md
    ├── tokenization_chatglm.py
    ├── tokenizer_config.json
    └── tokenizer.model
```

## 源码仓库及问题反馈
- https://developer.hpccube.com/codes/modelzoo/codegeex4_pytorch

## 参考资料
- https://github.com/THUDM/CodeGeeX4/tree/main
- https://huggingface.co/THUDM/codegeex4-all-9b
