# co-detr
## 论文
`DETRs with Collaborative Hybrid Assignments Training`<br>
[论文链接](https://arxiv.org/abs/2211.12860)<br>
## 模型结构
为了缓解解码器中较少的正向查询对编码器输出的稀疏监督，我们引入了具有不同一对多标签分配范式的通用辅助头，例如ATSS和Faster R-CNN。不同的标签分配丰富了对编码器输出的监督，这迫使它具有足够的鉴别力，以支持这些头部的训练收敛。
辅助分支只在训练时使用，推理时不需要。
![model_framework.png](asserts%2Fmodel_framework.png)
## 算法原理
co-detr通过增加辅助分支优化query稀疏问题--由于使用匈牙利批量，每个真值只能匹配1个query导致的。辅助分支利用一对多的样本匹配方法，比如atss,faster-rcnn等，一个真值匹配多个预测值，提高样本数量。
![model_head.png](asserts%2Fmodel_head.png)
## 环境配置
### Docker（方法一）

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-centos7.6-dtk24.04-py310
docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro --shm-size=80G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash

cd /your_code_path/co-detr_mmcv
pip install mmdet -i https://mirrors.aliyun.com/pypi/simple/

```
### Dockerfile（方法二）
```
cd ./docker
docker build --no-cache -t mmdet:last .
docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro --shm-size=80G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash
cd /your_code_path/co-detr_mmcv
pip install mmdet -i https://mirrors.aliyun.com/pypi/simple/
```
### Anaconda（方法三）
1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装： https://developer.hpccube.com/tool/
```
DTK软件栈: dtk24.04
python: python3.10
torch: 2.1
mmcv: 2.0.0

```

Tips：以上dtk软件栈、python、torch、mmcv等DCU相关工具版本需要严格一一对应

2、其他非特殊库直接按照requirements.txt安装

```
cd /your_code_path/co-detr_mmcv
pip install mmdet -i https://mirrors.aliyun.com/pypi/simple/
```

## 数据集
COCO2017（在网络良好的情况下，如果没有下载数据集，程序会默认在线下载数据集）

[训练数据](http://images.cocodataset.org/zips/train2017.zip)

[验证数据](http://images.cocodataset.org/zips/val2017.zip)

[测试数据](http://images.cocodataset.org/zips/test2017.zip)

[标签数据](https://github.com/ultralytics/yolov5/releases/download/v1.0/coco2017labels.zip)

数据集的目录结构如下：

```
├── images 
│   ├── train2017
│   ├── val2017
│   ├── test2017
├── labels
│   ├── train2017
│   ├── val2017
├── annotations
│   ├── instances_val2017.json
├── LICENSE
├── README.txt 
├── test-dev2017.txt
├── train2017.txt
├── val2017.txt

```
我们通过了mini数据集，供验证训练使用，如需正式使用，请下载完整COCO数据集或使用定制化数据集。
```bash
cd /your_code_path/co-detr_mmcv
cd datasets/
unzip  coco_mini.zip
```
## 训练
- 数据集放置位置默认为当前目录下 datasets/
- 如需要变更数据集目录 请修改 [co_dino_5scale_r50_lsj_8xb2_1x_coco.py](projects%2FCO-DETR%2Fconfigs%2Fcodino%2Fco_dino_5scale_r50_lsj_8xb2_1x_coco.py)下的 data_root
### 单机单卡
```bash
cd /your_code_path/co-detr_mmcv
chmod -R 7777 train.sh 
bash ./train.sh
```
### 单机四卡
```bash
cd /your_code_path/co-detr_mmcv
chmod -R 7777 train_multi.sh 
bash ./train_multi.sh 
```
## 推理
- 可使用官方模型权重进行推理，也可使用自己训练模型权重进行推理
- 这里以官方模型推理举例[[下载地址：co_dino_5scale_r50_lsj_8xb2_1x_coco-69a72d67.pth](https://download.openmmlab.com/mmdetection/v3.0/codetr/co_dino_5scale_r50_lsj_8xb2_1x_coco/co_dino_5scale_r50_lsj_8xb2_1x_coco-69a72d67.pth)]
```python
# 官方推理代码
python demo/image_demo.py demo/demo.jpg ./projects/CO-DETR/configs/codino/co_dino_5scale_r50_lsj_8xb2_1x_coco.py --weights co_dino_5scale_r50_lsj_8xb2_1x_coco-69a72d67.pth --device cuda
```
## result
![result.png](asserts%2Fresult.png)
### 精度
|  模型名称   | Backbone | Epochs | Aug | Dataset | amp混精 | Box AP |
|:-------:|:---------:|:------:|:---:|:-------:|:-----:|:------:|
| Co-detr |    R50     |   12   |  LSJ   |  COCO   |  on   |  51.3  |
## 应用场景
### 算法类别
`目标检测`
### 热点应用行业
`金融,交通,教育`
## 源码仓库及问题反馈
- https://developer.hpccube.com/codes/modelzoo/co-detr_mmcv
## 参考资料
- https://github.com/open-mmlab/mmdetection/tree/main
