# 代码与脚本 Code and Scripts

### training/

预训练与指令精调代码，Wiki：

- 预训练：[https://github.com/ymcui/Chinese-LLaMA-Alpaca-2/wiki/pt_scripts_zh](https://github.com/ymcui/Chinese-LLaMA-Alpaca-2/wiki/pt_scripts_zh)
- 指令精调：[https://github.com/ymcui/Chinese-LLaMA-Alpaca-2/wiki/sft_scripts_zh](https://github.com/ymcui/Chinese-LLaMA-Alpaca-2/wiki/sft_scripts_zh)

Pre-training and instruction finetuning code, Wiki:

- Pre-training: https://github.com/ymcui/Chinese-LLaMA-Alpaca-2/wiki/pt_scripts_en
- Instruction finetuning: https://github.com/ymcui/Chinese-LLaMA-Alpaca-2/wiki/sft_scripts_en

### inference/

使用🤗transformers进行推理，Wiki：[https://github.com/ymcui/Chinese-LLaMA-Alpaca-2/wiki/inference_with_transformers_zh](https://github.com/ymcui/Chinese-LLaMA-Alpaca-2/wiki/inference_with_transformers_zh)

Inference using 🤗transformers, Wiki: https://github.com/ymcui/Chinese-LLaMA-Alpaca-2/wiki/inference_with_transformers_en

### openai_server_demo/

使用fastapi实现的仿OPENAI API风格的服务器，Wiki：[https://github.com/ymcui/Chinese-LLaMA-Alpaca-2/wiki/api_calls_zh](https://github.com/ymcui/Chinese-LLaMA-Alpaca-2/wiki/api_calls_zh)

A server that implements OPENAI API using fastapi, Wiki: [https://github.com/ymcui/Chinese-LLaMA-Alpaca-2/wiki/api_calls_en](https://github.com/ymcui/Chinese-LLaMA-Alpaca-2/wiki/api_calls_en)

### ceval/

C-Eval评测脚本，Wiki：[https://github.com/ymcui/Chinese-LLaMA-Alpaca-2/wiki/ceval_zh](https://github.com/ymcui/Chinese-LLaMA-Alpaca-2/wiki/ceval_zh)

Inference script for C-Eval, Wiki: https://github.com/ymcui/Chinese-LLaMA-Alpaca-2/wiki/ceval_en

### cmmlu/

CMMLU评测脚本，Wiki：[https://github.com/ymcui/Chinese-LLaMA-Alpaca-2/wiki/cmmlu_zh](https://github.com/ymcui/Chinese-LLaMA-Alpaca-2/wiki/cmmlu_zh)

Inference script for CMMLU, Wiki: https://github.com/ymcui/Chinese-LLaMA-Alpaca-2/wiki/cmmlu_en

### longbench/

LongBench评测脚本，Wiki：[https://github.com/ymcui/Chinese-LLaMA-Alpaca-2/wiki/longbench_zh](https://github.com/ymcui/Chinese-LLaMA-Alpaca-2/wiki/longbench_zh)

Inference script for LongBench, Wiki: https://github.com/ymcui/Chinese-LLaMA-Alpaca-2/wiki/longbench_en

### llama-cpp/

llama.cpp启动脚本、server脚本，Wiki：[https://github.com/ymcui/Chinese-LLaMA-Alpaca-2/wiki/llamacpp_zh](https://github.com/ymcui/Chinese-LLaMA-Alpaca-2/wiki/llamacpp_zh)

launch script and server script for llama.cpp, Wiki: https://github.com/ymcui/Chinese-LLaMA-Alpaca-2/wiki/llamacpp_en


### attn_ang_long_ctx_patches.py

Memory efficient attention补丁和NTK上下文拓展方法补丁。

Patches for memory efficient attention and NTK context size scaling.

### merge_llama2_with_chinese_lora_low_mem.py

低资源版合并LLaMA-2/Alpaca-2 LoRA脚本，Wiki：[https://github.com/ymcui/Chinese-LLaMA-Alpaca-2/wiki/manual_conversion_zh](https://github.com/ymcui/Chinese-LLaMA-Alpaca-2/wiki/manual_conversion_zh)

Script for merging LLaMA-2/Alpaca-2 LoRA (low-resource version). Wiki: https://github.com/ymcui/Chinese-LLaMA-Alpaca-2/wiki/manual_conversion_en

### tokenizer/

Chinese-LLaMA-2 & Chinese-Alpaca-2 tokenizer