# ChatGLM-6B

## 论文

`GLM: General Language Model Pretraining with Autoregressive Blank Infilling`

- [https://arxiv.org/abs/2103.10360](https://arxiv.org/abs/2103.10360)

## 模型结构

ChatGLM-6B 是清华大学开源的开源的、支持中英双语的对话语言模型，基于 [General Language Model (GLM)](https://github.com/THUDM/GLM) 架构，具有 62 亿参数。ChatGLM-6B 使用了和 ChatGPT 相似的技术，针对中文问答和对话进行了优化。经过约 1T 标识符的中英双语训练，辅以监督微调、反馈自助、人类反馈强化学习等技术的加持，62 亿参数的 ChatGLM-6B 已经能生成相当符合人类偏好的回答。ChatGLM-6B采用Transformer模型结构：

<div align="center">
<img src="doc/transformers.jpg" width="300" height="400">
</div>



以下是ChatGLM-6B的主要网络参数配置：


| 模型名称   | 隐含层维度 | 层数 | 头数 | 词表大小 | 位置编码 | 最大序列长度 |
| ---------- | ---------- | ---- | ---- | -------- | -------- | ------------ |
| ChatGLM-6B | 4096       | 28   | 32   | 130528   | RoPE     | 2048         |

## 算法原理

ChatGLM-6B基于GLM架构开发。GLM是一种基于Transformer的语言模型，以自回归空白填充为训练目标， 同时具备自回归和自编码能力。

<div align="center">
<img src="doc/GLM.png" width="550" height="200">
</div>
本项目主要针对ChatGLM-6B推理性能优化，达到DCU平台较快的对话效果

## 环境配置

### 环境准备

在光源可拉取推理的docker镜像，拉取方式如下：

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:glm-ft-v1.0
```

### 容器启动

模型推理容器启动命令参考如下，用户根据需要修改：

```
# <container_name> 自定义容器名
# <project_path> 当前工程所在路径
docker run -it --name=<container_name> -v <project_path>:/work -w /work --device=/dev/kfd --device=/dev/dri --security-opt seccomp=unconfined --cap-add=SYS_PTRACE --shm-size=16G --group-add 39 image.sourcefind.cn:5000/dcu/admin/base/custom:glm-ft-v1.0 /bin/bash
```

### 编译方法

```
mkdir build
cd build
cmake ..
make -j4
```

编译后会在build目录下生成：

1. main: 示例程序

2. quant: 量化程序

3. benchmark: 性能测试程序

## 数据集

无

## 推理

### 原版模型下载

[原版模型下载]([THUDM/chatglm-6b · Hugging Face](https://huggingface.co/THUDM/chatglm-6b))

[SCNet快速下载]([THUDM/chatglm-6b · SCNet](http://113.200.138.88:18080/aimodels/chatglm-6b))

### ChatGLM原版模型转换

```
# 将模型转换脚本tools/chatglm_export.py移动到python的ChatGLM-6B环境中，也可以使用"pip3 install -r requirements.txt"命令根据工程自带的requirements.txt安装模型转换时需要的相关依赖
# 如果使用自己finetune的模型可能需要修改chatglm_export.py文件中创建tokenizer, model的代码
# 执行：
python3 chatglm_export.py ./chatglm-6b.bin # 导出浮点模型，参数为导出的模型路径

# 第二步将导出的模型进行低比特量化，将第一步导出的模型文件放在容器中，以/home/model/为例
# 在容器内执行，其中-p参数指定未量化的模型存放路径，-o指定量化后的模型保存路径
cd build
./quant -p /home/model/chatglm-6b.bin -o chatglm-6b-fp16.bin -b 16 #导出fp16模型
./quant -p /home/model/chatglm-6b.bin -o chatglm-6b-int8.bin -b 8 #导出int8模型
```

### 运行示例程序

```
./main -h 可以查看具体参数信息，以下是一些简单示例：
```

### 运行ChatGLM-6B模型实例

```
./main -p chatglm-6b-int8.bin
```

### 推理性能测试

可以使用benchmark程序进行测速，根据./benchmark -h描述进行配置和测试，不同配置、不同输入，推理速度也会有一些差别
```
./benchmark -p ~/chatglm-6b-int8.bin -f ../benchmark/prompts/beijing.txt -b 1
./benchmark -p ~/chatglm-6b-fp16.bin -f ../benchmark/prompts/hello.txt -b 512 -l 18
```

## result

![chatglm6b推理](doc/chatglm6b.gif)

### 精度

无

## 应用场景

### 算法类别

`对话问答`

### 热点应用行业

`医疗,科研,金融,教育`

## 源码仓库及问题反馈

https://developer.hpccube.com/codes/modelzoo/chatglm6b_fastllm

## 参考资料

https://github.com/THUDM/ChatGLM-6B
