//
// Created by 41020 on 2023/6/19.
//

#ifndef FASTLLM_CHATGLM_C_H
#define FASTLLM_CHATGLM_C_H

#ifdef __cplusplus
extern "C" {
#endif

    typedef void* ModelHandle;

    /*
    *   @brief                  初始化引擎
    *   @param model            输入推理引擎handle
    *   @param modelPath        输入模型存放路径
    *   @param deviceId         输入模型推理运行的dcu设备号
    *   @return                 成功返回0；失败返回对应错误码
    */
    int initLLMEngine(ModelHandle& model, const char* modelPath, int deviceId);

    /*
    *   @brief                  获取场景分类单张图片推理结果
    *   @note                   每次返回行人检测个数（最大不超过100）
    *   @param model            输入推理引擎handle
    *   @param prompt           输入的问题
    *   @param output           输出的回答，内存会在接口内申请，下次调用时释放并重新生成
    *   @return                 成功返回0；失败返回对应错误码
    */
    int chat(ModelHandle model, const char* prompt, char*& output);

    /*
    *   @brief                  释放推理引擎资源
    *   @param model            输入需要释放推理引擎handle
    *   @return                 成功返回0；失败返回对应错误码
    */
    int releaseLLMEngine(ModelHandle model);

#ifdef __cplusplus
}
#endif

#endif //FASTLLM_CHATGLM_C_H
