# ChatGLM3

## 论文

`GLM: General Language Model Pretraining with Autoregressive Blank Infilling`

- [https://arxiv.org/abs/2103.10360](https://arxiv.org/abs/2103.10360)

## 模型结构

ChatGLM3 是智谱AI和清华大学 KEG 实验室联合发布的新一代对话预训练模型。ChatGLM3-6B 是 ChatGLM3 系列中的开源模型，在保留了前两代模型对话流畅、部署门槛低等众多优秀特性的基础上，ChatGLM3-6B 具有更强大的基础模型、更完整的功能支持、更全面的开源序列。

<div align="center">
<img src="doc/transformers.jpg" width="300" height="400">
</div>




以下是ChatGLM3-6B的主要网络参数配置：


| 模型名称    | 隐含层维度 | 层数 | 头数 | 词表大小 | 位置编码 | 最大序列长度 |
| ----------- | ---------- | ---- | ---- | -------- | -------- | ------------ |
| ChatGLM3-6B | 4096       | 28   | 32   | 65024    | RoPE     | 8192         |

## 算法原理

ChatGLM3-6B基于GLM架构开发。GLM是一种基于Transformer的语言模型，以自回归空白填充为训练目标， 同时具备自回归和自编码能力。

<div align="center">
<img src="doc/GLM.png" width="550" height="200">
</div>

本项目主要针对ChatGLM3-6B推理性能优化，达到DCU平台较快的对话效果

## 环境配置

### 环境准备

在光源可拉取推理的docker镜像，拉取方式如下：

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:lmdeploy-dtk23.10-torch1.13-py38
```

### 容器启动

模型推理容器启动命令参考如下，用户根据需要修改：

```
# <container_name> 自定义容器名
# <project_path> 当前工程所在路径
docker run -it --name=<container_name> -v <project_path>:/work -v /opt/hyhal:/opt/hyhal --device=/dev/kfd --device=/dev/dri --security-opt seccomp=unconfined --cap-add=SYS_PTRACE --ipc=host --network host --shm-size=16G --group-add video image.sourcefind.cn:5000/dcu/admin/base/custom:lmdeploy-dtk23.10-torch1.13-py38 /bin/bash
```

### 安装方法

```
#进入本工程目录
cd package
python setup.py install
```

## 数据集

无

## 推理

### 原版模型下载

[原版模型下载]([THUDM/chatglm3-6b · Hugging Face](https://huggingface.co/THUDM/chatglm3-6b))

### ChatGLM3原版模型转换

```
# 将模型转换脚本chatglm_export.py移动到原版ChatGLM3-6B环境中，也可以使用"pip3 install -r requirements.txt"命令根据工程自带的requirements.txt安装相关依赖
# 如果使用自己finetune的模型需要修改chatglm_export.py文件中创建tokenizer, model时的模型存放路径
# 执行：
python3 chatglm_export.py chatglm3-6b-fp16.bin float16 # 导出fp16模型，参数为导出的模型路径
python3 chatglm_export.py chatglm3-6b-int8.bin int8 #    导出int8模型，参数为导出的模型路径
```


### 运行ChatGLM3-6B模型实例

```
# 命令行聊天程序，使用了模型创建以及流式对话效果
python cli_demo.py -p chatglm3-6b-fp16.bin

# 简易webui，需要先安装streamlit-chat，并且需要在容器启动时映射streamlit的端口到外部网络
streamlit run web_demo.py chatglm3-6b-fp16.bin 

# 按照openai接口实现的api_server的实例:
# 需要先进入api_server_demo，安装所需依赖：
cd api_server_demo
pip install -r requirements.txt
# 运行api_server服务，使用-p指定转换后的模型文件，客户端代码可以参考openai-client.py实现：
python fastllm-openai.py -p ../chatglm3-6b-fp16.bin 
# 如果需要测试服务的并发性能，可以使用openai-client.py，修改其中的prompt和concurrencys变量值后执行：
python openai-client.py
```


## result

![chatglm3-6b推理](doc/chatglm3-6b.gif)

### 精度

无

## 应用场景

### 算法类别

`对话问答`

### 热点应用行业

`医疗,科研,金融,教育`

## 源码仓库及问题反馈

https://developer.hpccube.com/codes/modelzoo/chatglm3_fastllm

## 参考资料

https://github.com/THUDM/ChatGLM3
