# ChatGLM3-6B

## 论文
`GLM: General Language Model Pretraining with Autoregressive Blank Infilling`
- [https://arxiv.org/abs/2103.10360](https://arxiv.org/abs/2103.10360)

## 模型结构
ChatGLM3 是智谱AI和清华大学 KEG 实验室联合发布的新一代对话预训练模型。ChatGLM3-6B 是 ChatGLM3 系列中的开源模型，在保留了前两代模型对话流畅、部署门槛低等众多优秀特性的基础上，ChatGLM3-6B的基础模型ChatGLM3-6B-Base 采用了更多样的训练数据、更充分的训练步数和更合理的训练策略。

ChatGLM3-6B同样采用Transformer模型结构：

<div align="center">
<img src="./media/transformers.jpg" width="300" height="400">
</div>

以下是ChatGLM2-6B的主要网络参数配置：


| 模型名称 | 隐含层维度 | 层数 | 头数 | 词表大小 | 位置编码 | 最大长 |
| -------- | -------- | -------- | -------- | -------- | -------- | -------- | 
|ChatGLM3-6B | 4,096 | 28 | 32 | 65024 |  RoPE | 8192 |


## 算法原理
模型基于 [General Language Model (GLM)](https://github.com/THUDM/GLM) 架构，GLM是一种基于Transformer的语言模型，以自回归空白填充为训练目标，同时具备自回归和自编码能力。

<div align="center">
<img src="./media/GLM.png" width="550" height="200">
</div>


## 环境配置

### Docker(方式一)
推荐使用docker方式运行，提供拉取的docker镜像：
```bash
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-centos7.6-dtk23.10.1-py310
```

进入docker，安装docker中没有的依赖:
```bash
docker run -dit --network=host --name=chatglm3 --privileged --device=/dev/kfd --device=/dev/dri --ipc=host --shm-size=16G  --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root --ulimit stack=-1:-1 --ulimit memlock=-1:-1 image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-centos7.6-dtk23.10.1-py310
docker exec -it chatglm3 /bin/bash
pip install -r requirements.txt -i http://mirrors.aliyun.com/pypi/simple/ --trusted-host mirrors.aliyun.com
cd finetune_demo
pip install -r requirements.txt -i http://mirrors.aliyun.com/pypi/simple/ --trusted-host mirrors.aliyun.com
```
### Conda（方法二）
1. 创建conda虚拟环境：

```bash
conda create -n chatglm python=3.10
```

2. 关于本项目DCU显卡所需的工具包、深度学习库等均可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。

- [DTK 23.10.1](https://cancon.hpccube.com:65024/1/main/DTK-23.10.1)
- [Pytorch 2.1](https://cancon.hpccube.com:65024/4/main/pytorch/previous_release/dtk23.10)
- [Deepspeed 0.12.3](https://cancon.hpccube.com:65024/4/main/deepspeed/previous_release/dtk23.10)

    Tips：以上dtk驱动、python、deepspeed等工具版本需要严格一一对应。

3. 其它依赖库参照requirements.txt安装：
```bash
pip install -r requirements.txt -i http://mirrors.aliyun.com/pypi/simple/ --trusted-host mirrors.aliyun.com
cd finetune_demo
pip install -r requirements.txt -i http://mirrors.aliyun.com/pypi/simple/ --trusted-host mirrors.aliyun.com
```

### 注意

```python
#到虚拟环境下对应的python/site-packages注释掉一些版本判断
site-packages/accelerate/accelerator.py 文件

 287             #if not is_deepspeed_available():
 288             #    raise ImportError("DeepSpeed is not installed => run `pip install deepspeed` or build it from source.")
 289             #if compare_versions("deepspeed", "<", "0.9.3"):
 290             #    raise ImportError("DeepSpeed version must be >= 0.9.3. Please update DeepSpeed.")
 
site-packages/transformers/utils/versions.py 文件
 43     #if not ops[op](version.parse(got_ver), version.parse(want_ver)):
 44     #    raise ImportError(
 45     #        f"{requirement} is required for a normal functioning of this module, but found {pkg}=={got_ver}.{hint}"
 46     #    )
```

## 数据集
单轮对话数据以[ADGEN](https://aclanthology.org/D19-1321.pdf) (广告生成) 数据集为例介绍代码的使用方法，该数据集任务为根据输入（content）生成一段广告词（summary），以下为下载地址：
- [Google Drive](https://drive.google.com/file/d/13_vf0xRTQsyneRKdD1bZIr93vBGOczrk/view?usp=sharing) 或者 [Tsinghua Cloud](https://cloud.tsinghua.edu.cn/f/b3f119a008264b1cabd1/?dl=1)
下载处理好的 ADGEN 数据集，将解压后的AdvertiseGen目录放到 [finetune_demo/data](./finetune_demo/data)目录下。数据集目录结构如下：
```
 ── AdvertiseGen
    │   ├── dev.json
    │   └── train.json
```
通过以下方式将数据集处理成模型需要的格式:
```bash
cd finetune_demo
python process.py
```

### 模型下载
| Model | Seq Length |                                                              Download                                                               
| :---: |:---------------------------:|:-----------------------------------------------------------------------------------------------------------------------------------:
| ChatGLM3-6B | 8k |      [HuggingFace](https://huggingface.co/THUDM/chatglm3-6b) \| [ModelScope](https://modelscope.cn/models/ZhipuAI/chatglm3-6b)      
| ChatGLM3-6B-Base | 8k | [HuggingFace](https://huggingface.co/THUDM/chatglm3-6b-base) \| [ModelScope](https://modelscope.cn/models/ZhipuAI/chatglm3-6b-base) 
| ChatGLM3-6B-32K | 32k |                                   [HuggingFace](https://huggingface.co/THUDM/chatglm3-6b-32k) \| [ModelScope](https://modelscope.cn/models/ZhipuAI/chatglm3-6b-32k) 

## 训练

### SFT微调

#### 单轮对话微调
```bash
    cd ./finetune_demo
    bash sft.sh
```
注意：请根据自己的需求配置其中的模型路径、数据集路径；batchsize、学习率等参数在./finetune_demo/configs/sft.yaml；

#### 推理验证
对于输入输出格式的微调，可使用 `sft_inf.sh` 进行基本的推理验证。

在完成微调任务之后，我们可以查看到 `output` 文件夹下多了很多个`checkpoint-*`的文件夹，这些文件夹代表了训练的轮数。 我们选择最后一轮的微调权重，并使用inference进行导入。

注意：此时要将hf上下载的原生`tokenizer_config.json` 和`tokenization_chatglm.py` 两个文件放入要待测的 checkpoint 文件夹下，比如./finetune_demo/output/checkpoint-3000/

```bash
	cd ./finetune_demo
	bash sft_inf.sh
```



### LORA微调

#### 单轮对话微调

```bash
	cd ./fintune_demo
	bash lora.sh
```

注意：请根据自己的需求配置其中的模型路径、数据集路径；batchsize、学习率等参数在 ./finetune_demo/configs/lora.yaml；

#### 推理验证

在完成微调任务之后，我们可以查看到 `output` 文件夹下多了很多个`checkpoint-*`的文件夹，这些文件夹代表了训练的轮数。 我们选择最后一轮的微调权重，并使用inference进行导入。

注意：经过LORA微调训练后的checkpoint无需复制原生GLM3的tokenizer文件到其目录下。

```bash
	cd ./finetune_demo
	bash lora_inf.sh
```



## Result

### SFT微调

#### 单轮对话微调推理结果

<div align="center">
<img src="./media/结果2.jpg" width="300" height="400">
</div>

### LORA微调

#### 单轮对话微调推理结果

<div align="center">
<img src="./media/结果2.jpg" width="300" height="400">
</div>




### 精度
无


## 应用场景

### 算法类别

`对话问答`

### 热点应用行业

`医疗,教育,科研,金融`

## 源码仓库及问题反馈

- https://developer.hpccube.com/codes/modelzoo/chatglm3-6b_pytorch

## 参考

- [THUDM/ChatGLM3-6B](https://github.com/THUDM/ChatGLM3/tree/main)

