# ChatGLM3-6B

## 论文
`GLM: General Language Model Pretraining with Autoregressive Blank Infilling`
- [https://arxiv.org/abs/2103.10360](https://arxiv.org/abs/2103.10360)

## 模型结构
ChatGLM3 是智谱AI和清华大学 KEG 实验室联合发布的新一代对话预训练模型。ChatGLM3-6B 是 ChatGLM3 系列中的开源模型，在保留了前两代模型对话流畅、部署门槛低等众多优秀特性的基础上，ChatGLM3-6B的基础模型ChatGLM3-6B-Base 采用了更多样的训练数据、更充分的训练步数和更合理的训练策略。

ChatGLM3-6B同样采用Transformer模型结构：

<div align="center">
<img src="./media/transformers.jpg" width="300" height="400">
</div>

以下是ChatGLM2-6B的主要网络参数配置：


| 模型名称 | 隐含层维度 | 层数 | 头数 | 词表大小 | 位置编码 | 最大长 |
| -------- | -------- | -------- | -------- | -------- | -------- | -------- | 
|ChatGLM3-6B | 4,096 | 28 | 32 | 65024 |  RoPE | 8192 |


## 算法原理
模型基于 [General Language Model (GLM)](https://github.com/THUDM/GLM) 架构，GLM是一种基于Transformer的语言模型，以自回归空白填充为训练目标，同时具备自回归和自编码能力。

<div align="center">
<img src="./media/GLM.png" width="550" height="200">
</div>


## 环境配置

### Docker(方式一)
推荐使用docker方式运行，提供拉取的docker镜像：
```bash
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.4.1-ubuntu22.04-dtk25.04-py3.10-fixpy
```

进入docker，安装docker中没有的依赖:
```bash
# -v 映射目录根据本机自行修改
docker run -dit --network=host --name=chatglm3 --privileged --device=/dev/kfd --device=/dev/dri --ipc=host --shm-size=16G   -v /opt/hyhal/:/opt/hyhal/:ro -v /物理机目录:/容器内目录 --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root --ulimit stack=-1:-1 --ulimit memlock=-1:-1 image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.4.1-ubuntu22.04-dtk25.04-py3.10-fixpy

# 启动容器
docker exec -it chatglm3 /bin/bash

# 环境包替换安装
## 执行该命令时，选择Y即可
apt remove python3-blinker
## sentence-transformers和transformers、numpy等库有依赖冲突，需要两步安装
pip install -r requirements.txt -i http://mirrors.aliyun.com/pypi/simple/ --trusted-host mirrors.aliyun.com
pip install transformers==4.40.0 numpy==1.24.3 nltk==3.9.1 -i http://mirrors.aliyun.com/pypi/simple/ --trusted-host mirrors.aliyun.com
cd finetune_demo
pip install -r requirements.txt -i http://mirrors.aliyun.com/pypi/simple/ --trusted-host mirrors.aliyun.com
```
### Conda（方法二）
1. 创建conda虚拟环境：

```bash
conda create -n chatglm python=3.10
```

2. 关于本项目DCU显卡所需的工具包、深度学习库等均可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。

- [DTK 25.04](https://download.sourcefind.cn:65024/1/main/latest)
- [Pytorch 2.4.1](https://download.sourcefind.cn:65024/4/main/pytorch/DAS1.5)
- [Deepspeed 0.14.2](https://download.sourcefind.cn:65024/4/main/deepspeed/DAS1.5)

    Tips：以上dtk驱动、python、deepspeed等工具版本需要严格一一对应。

3. 其它依赖库参照requirements.txt安装：
```bash
pip install -r requirements.txt -i http://mirrors.aliyun.com/pypi/simple/ --trusted-host mirrors.aliyun.com
cd finetune_demo
pip install -r requirements.txt -i http://mirrors.aliyun.com/pypi/simple/ --trusted-host mirrors.aliyun.com
```

### 注意

```python
#到虚拟环境下对应的python/site-packages注释掉一些版本判断
site-packages/accelerate/accelerator.py 文件

 287             #if not is_deepspeed_available():
 288             #    raise ImportError("DeepSpeed is not installed => run `pip install deepspeed` or build it from source.")
 289             #if compare_versions("deepspeed", "<", "0.9.3"):
 290             #    raise ImportError("DeepSpeed version must be >= 0.9.3. Please update DeepSpeed.")
 
site-packages/transformers/utils/versions.py 文件
 43     #if not ops[op](version.parse(got_ver), version.parse(want_ver)):
 44     #    raise ImportError(
 45     #        f"{requirement} is required for a normal functioning of this module, but found {pkg}=={got_ver}.{hint}"
 46     #    )
```

## 数据集

无

### 模型下载

| Model | Seq Length |                                                              Download                                                               
| :---: |:---------------------------:|:-----------------------------------------------------------------------------------------------------------------------------------:
| ChatGLM3-6B | 8k |      [HuggingFace](https://huggingface.co/THUDM/chatglm3-6b) \| [ModelScope](https://modelscope.cn/models/ZhipuAI/chatglm3-6b)   \| [SCNet]    
| ChatGLM3-6B-Base | 8k | [HuggingFace](https://huggingface.co/THUDM/chatglm3-6b-base) \| [ModelScope](https://modelscope.cn/models/ZhipuAI/chatglm3-6b-base) \| [SCNet]
| ChatGLM3-6B-32K | 32k |                                   [HuggingFace](https://huggingface.co/THUDM/chatglm3-6b-32k) \| [ModelScope](https://modelscope.cn/models/ZhipuAI/chatglm3-6b-32k) \| [SCNet]

## 训练

无


## 推理
使用以下的脚本推理时。都需要指定已经下载到本地的模型路径，如果没有指定，会从huggingface自动下载，指定模型路径方式如下：
### cli_demo
```
# 需修改路径
export MODEL_PATH=/models/chatglm3/chatglm3-6b
export TOKENIZER_PATH=/models/chatglm3/chatglm3-6b
# 推理
cd basic_demo
export HIP_VISIBLE_DEVICES=0
export PYTHONWARNINGS="ignore"
python cli_demo.py
```
<div align="center">
<img src="./media/cli_demo.png">
</div>

### web_demo_gradio
```
# 需修改路径
export MODEL_PATH=/models/chatglm3/chatglm3-6b
export TOKENIZER_PATH=/models/chatglm3/chatglm3-6b
# 推理
cd basic_demo
export HIP_VISIBLE_DEVICES=0
export PYTHONWARNINGS="ignore"
python web_demo_gradio.py
```
<div align="center">
<img src="./media/gradio.png">
</div>

### web_demo_streamlit
```
# 需修改路径
export MODEL_PATH=/models/chatglm3/chatglm3-6b
export TOKENIZER_PATH=/models/chatglm3/chatglm3-6b
# 推理
cd basic_demo
export HIP_VISIBLE_DEVICES=0
export PYTHONWARNINGS="ignore"
streamlit run web_demo_streamlit.py
```
<div align="center">
<img src="./media/streamlit.png">
</div>

### api_server
#### 服务端启动命令
```
# 需修改路径
export MODEL_PATH=/models/chatglm3/chatglm3-6b
export TOKENIZER_PATH=/models/chatglm3/chatglm3-6b
export EMBEDDING_PATH=/home/model/BAAI/bge-m3/
# 推理(案例中修改了api_server.py 536行的端口号，项目中的端口未更新，仍为8000端口)
python api_server.py
```
<div align="center">
<img src="./media/server.png">
</div>

#### api调用案例
```
curl -X POST "http://127.0.0.1:8000/v1/chat/completions" \
-H "Content-Type: application/json" \
-d "{\"model\": \"chatglm3-6b\", \"messages\": [{\"role\": \"system\", \"content\": \"You are ChatGLM3, a large language model trained by Zhipu.AI. Follow the user's instructions carefully. Respond using markdown.\"}, {\"role\": \"user\", \"content\": \"你好，给我讲一个故事，大概100字\"}], \"stream\": false, \"max_tokens\": 100, \"temperature\": 0.8, \"top_p\": 0.8}"
```
<div align="center">
<img src="./media/client.png">
</div>

### 精度
无


## 应用场景

### 算法类别

`对话问答`

### 热点应用行业

`医疗,教育,科研,金融`

## 源码仓库及问题反馈

- https://developer.sourcefind.cn/codes/modelzoo/chatglm3-6b_pytorch

## 参考

- [THUDM/ChatGLM3-6B](https://github.com/THUDM/ChatGLM3/tree/main)

