# ChatGLM2-6B_CPP

## 模型介绍
ChatGLM**2**-6B 是开源中英双语对话模型 [ChatGLM-6B](https://github.com/THUDM/ChatGLM-6B) 的第二代版本，在保留了初代模型对话流畅、部署门槛较低等众多优秀特性的基础之上，ChatGLM**2**-6B 引入了更好的模型效果，更长的上下文等新特性

本项目主要针对ChatGLM2-6B在DCU平台的推理性能优化，达到DCU平台较快的对话效果。

## 模型推理

### 下载镜像

在光源可拉取推理的docker镜像，拉取方式如下：

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:glm-ft-v1.0
```

### 安装方法

```
#进入本工程目录
cd package
python setup install
```

### ChatGLM2原版模型转换

```
# 将模型转换脚本chatglm_export.py移动到原版ChatGLM2-6B环境中，也可以根据工程自带的requirements.txt安装相关依赖
# 如果使用自己finetune的模型需要修改chatglm_export.py文件中创建tokenizer, model时的模型存放路径
# 执行：
python3 chatglm_export.py chatglm2-6b-fp16.bin float16 # 导出fp16模型，参数为导出的模型路径
python3 chatglm_export.py chatglm2-6b-int8.bin int8 #    导出int8模型，参数为导出的模型路径
```


### 运行ChatGLM2-6B模型实例

```
# 命令行聊天程序，使用了模型创建以及流式对话效果
python cli_demo.py -p chatglm2-6b-fp16.bin

# 简易webui，需要先安装streamlit-chat
streamlit run web_demo.py chatglm2-6b-fp16.bin 
```

## 源码仓库及问题反馈

https://developer.hpccube.com/codes/modelzoo/chatglm2-6b_cpp

## 参考

https://github.com/THUDM/ChatGLM2-6B
