import json

def convert_txt_to_json(txt_file):
    json_data = []
    with open(txt_file, 'r', encoding='gb18030') as file:
        for line in file:
            line = line.strip()
            if line:
                prompt = line[0]
                response = line[1:]
                json_entry = {'prompt': prompt, 'response': response}
                json_data.append(json_entry)
    
    return json_data

txt_file = 'The-Lord-of-the-Rings-1.txt'  # 替换成你的文本文件路径
json_data = convert_txt_to_json(txt_file)

# 将JSON数据写入文件
json_file = 'The-Lord-of-the-Rings-1.json'  # 输出的JSON文件路径
with open(json_file, 'w', encoding='utf-8') as file:
    for entry in json_data:
        json.dump(entry, file, ensure_ascii=False)
        file.write('\n')

