# ChartVerse-Coder
## 论文
[ChartVerse-Coder](https://arxiv.org/abs/2601.13606)

## 模型简介
ChartVerse-Coder是一种复杂度感知的图表代码生成器，能够从零开始自主合成多样化、高复杂度的图表代码，是opendatalab/ChartVerse项目的核心组件。 区别于此前基于模板或种子约束的生成范式，ChartVerse-Coder通过高温采样技术生成图表代码，实现对长尾图表分布的广泛探索，并生成具有高结构复杂度的多样化真实场景图表。核心特性如下:  
- 自主合成能力：无需模板或种子图表，从零生成多样化图表代码    
- 复杂度感知训练：采用相对位置编码（RPE）引导的过滤机制，专注掌握高复杂度可视化范式     
- 高多样性输出：生成图表覆盖三维绘图、层次化结构、多子图布局等多元形态      
- 迭代式自增强机制：通过"生成-过滤-重训练"循环实现代码质量的渐进式优化   
## 环境依赖

| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.2 |
| python | 3.10.12 |
| transformers | >=4.57.1 |
| vllm | 0.11.0+das.opt1.alpha.dtk25042.20251225.gca4598a4 |
| torch | 2.5.1+das.opt1.dtk25042 |
| triton | 3.1.0+das.opt1.dtk25042.20251224.gaa867475 |


推荐使用镜像:harbor.sourcefind.cn:5443/dcu/admin/base/vllm:0.11.0-ubuntu22.04-dtk25.04.2-tx-1226-das1.7-py3.10-20251226
- 挂载地址`-v`根据实际模型情况修改

```bash
docker run -it --shm-size 60g --network=host --name ChartVerse-Coder --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /opt/hyhal/:/opt/hyhal/:ro -v /path/your_code_path/:/path/your_code_path/  harbor.sourcefind.cn:5443/dcu/admin/base/vllm:0.11.0-ubuntu22.04-dtk25.04.2-tx-1226-das1.7-py3.10-20251226 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。

## 数据集
暂无

## 训练
暂无

## 推理

### vllm
#### 单机推理

```bash
## serve启动
可参考vllm_serve.sh脚本
vllm serve opendatalab/ChartVerse-Coder  --trust-remote-code --dtype bfloat16 -tp 1 --max-model-len 32768 --port 8010
## client访问
可参考vllm_cilent.sh
curl -X POST "http://localhost:8010/v1/chat/completions"      -H "Content-Type: application/json"     --data '{
                "model": "opendatalab/ChartVerse-Coder",
                "messages": [
                        {
                                "role": "user",
                                "content": "请介绍下自己"
                        }
                ]
        }'


```

## 效果展示
<div align=center>
    <img src="./doc/result.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：vllm。

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| ChartVerse-Coder | 8B | K100AI | 1 | [下载地址](https://huggingface.co/opendatalab/ChartVerse-Coder) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/chartverse-coder_vllm

## 参考资料
- https://huggingface.co/opendatalab/ChartVerse-Coder
