# centernet
## 论文
`Objects as Points`<br>
[论文链接](https://arxiv.org/pdf/1904.07850.pdf)<br>
`Probabilistic two-stage detection`<br>
[论文链接](https://arxiv.org/abs/2103.07461)
## 模型结构
Centernet对于输入图像(512,512,3)，下采样率为4，CenterNet将得到平面大小为(128,128)的输出。CenterNet的prediction head也由三个分支组成，分别为heatmap head，dimension head和offset head。
![模型结构](resources%2Fimg.png)
## 算法原理
 CenterNet是一种anchor free的目标检测算法,就是直接回归检测到的物体而不是回归anchors,不需要提前设定anchors
![img_1.png](resources%2Fimg_1.png)
## 环境配置
### Docker（方法一）

```
docker pull  image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.10
docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal:/opt/hyhal:ro --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash
cd /path/workspace/
pip install mmdet==3.2.0 -i https://mirrors.aliyun.com/pypi/simple/
```
### Dockerfile（方法二）
```
cd ./docker
docker build --no-cache -t mmdet:3.0 .
docker run -it -v /path/your_code_data/:/path/your_code_data/ --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash
cd /path/workspace/
```
### Anaconda（方法三）
1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装： https://developer.hpccube.com/tool/
```
DTK软件栈: dtk24.04.1
python: python3.10
torch: 2.1.0
torchvision: 0.16.0
mmcv: 2.0.1

```

Tips：以上dtk软件栈、python、torch、mmcv等DCU相关工具版本需要严格一一对应

2、其他非特殊库直接按照requirements.txt安装

```
cd workspace/
pip install mmdet==3.2.0 -i https://mirrors.aliyun.com/pypi/simple/
```

## 数据集
COCO2017（在网络良好的情况下，如果没有下载数据集，程序会默认在线下载数据集）
- 数据集快速下载中心:
  - [SCNet AIDatasets](http://113.200.138.88:18080/aidatasets)
- 数据集快速通道下载地址：
  - [数据集快速下载地址](http://113.200.138.88:18080/aidatasets/coco2017)
- 官方下载地址：
  - [训练数据](http://images.cocodataset.org/zips/train2017.zip)
  - [验证数据](http://images.cocodataset.org/zips/val2017.zip)
  - [测试数据](http://images.cocodataset.org/zips/test2017.zip)
  - [标签数据](https://github.com/ultralytics/yolov5/releases/download/v1.0/coco2017labels.zip)

数据集的目录结构如下：

```
├── images 
│   ├── train2017
│   ├── val2017
│   ├── test2017
├── labels
│   ├── train2017
│   ├── val2017
├── annotations
│   ├── instances_val2017.json
├── LICENSE
├── README.txt 
├── test-dev2017.txt
├── train2017.txt
├── val2017.txt

```

## 训练
- 数据集放置位置默认为当前目录下 data/
- 如需要变更数据集目录 请修改 configs/\_base_\/datasets/coco_detection.py 下的 data_root
```python
bash ./train.sh
```
## 推理
- 可使用官方模型权重进行推理，也可使用自己训练模型权重进行推理
- 这里以官方模型推理举例[[下载地址：centernet-update_r50-caffe_fpn_ms-1x_coco_20230512_203845-8306baf2.pth](https://download.openmmlab.com/mmdetection/v3.0/centernet/centernet-update_r50-caffe_fpn_ms-1x_coco/centernet-update_r50-caffe_fpn_ms-1x_coco_20230512_203845-8306baf2.pth)]
```python
# 官方推理代码
python demo/image_demo.py demo/demo.jpg ./configs/centernet/centernet-update_r50-caffe_fpn_ms-1x_coco.py --weights centernet-update_r50-caffe_fpn_ms-1x_coco_20230512_203845-8306baf2.pth --device cuda
```
## result
![demo.jpg](resources%2Fdemo.jpg)
### 精度
|       模型名称       | batchsize | amp混精 |  Box AP  |
|:----------------:|:---------:|:-----:|:----:|
| centernet-update |    16     |  off  | 40.1 |
## 应用场景
### 算法类别
`目标检测`
### 热点应用行业
`金融,交通,教育`
## 源码仓库及问题反馈
- https://developer.hpccube.com/codes/modelzoo/mmcv_centernet
## 参考资料
- https://github.com/open-mmlab/mmdetection/tree/v3.2.0
