# CenterFace
## 论文
[CenterFace: Joint Face Detection and Alignment Using Face as Point](https://arxiv.org/abs/1911.03599)

## 模型结构
CenterFace是一种人脸检测算法，采用了轻量级网络mobileNetV2作为主干网络，结合特征金字塔网络（FPN）实现anchor free的人脸检测。
![Architecture of the CenterFace](Architecture of the CenterFace.png)

## 算法原理
CenterFace模型是一种基于单阶段人脸检测算法，作者借鉴了CenterNet的思想，将人脸检测转换为标准点问题，根据人脸中心点来回归人脸框的大小和五个标志点。

## 环境配置
### Docker（方法一）

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.13.1-centos7.6-dtk-23.04.1-py38-latest

docker run docker run -it -v /path/your_code_data/:/path/your_code_data/ --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash

cd /path/workspace/
pip3 install -r requirements.txt
```

### Dockerfile（方法二）

```
cd ./docker

docker build --no-cache -t centerface:latest .

docker run -it -v /path/your_code_data/:/path/your_code_data/ --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash
```

### Anaconda（方法三）

1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装： https://developer.hpccube.com/tool/

```
DTK软件栈：dtk23.04.1
python：python3.8
torch：1.13.1
torchvision：0.14.1
```
`Tips：以上dtk驱动、python、paddle等DCU相关工具版本需要严格一一对应`

2、其他非特殊库直接按照requirements.txt安装

```
pip3 install -r requirements.txt
```

## 数据集

[WIDER_FACE](http://shuoyang1213.me/WIDERFACE/index.html)

![datasets](datasets.png)

下载图片红框中三个数据并解压，也可直接点击下面链接直接下载：

[WIDER Face Training Images(Tencent Drive)](https://share.weiyun.com/5WjCBWV)

[WIDER Face Validation Images(Tencent Drive)](https://share.weiyun.com/5ot9Qv1)

[WIDER Face Testing Images(Tencent Drive)](https://share.weiyun.com/5vSUomP)

annotation文件使用的是coco的格式，可以通过百度网盘下载

[Baidu](https://pan.baidu.com/s/1j_2wggZ3bvCuOAfZvjWqTg) 提取码：f9hh

数据集全部解压后的目录结构如下：

```
├── WIDER_train
│   ├── images
├── WIDER_test
│   ├── images
├── WIDER_val
│   ├── images
├── annotations
│   ├── train_wider_face.json
│   ├── val_wider_face.json

```

## 训练
### 单机单卡

```
cd ./src
bash train.sh
```

### 单机多卡

```
cd ./src
bash train_multi.sh
```

## 推理
#### 单卡推理
```
cd ./src
python test_wider_face.py
```

## result
![Result](draw_img.jpg)

### 精度
WIDER_FACE验证集上的测试结果如下

| Method | Easy | Medium | Hard|
|:--------:| :--------:| :---------:| :------:|
| ours(one scale) | 0.9264 | 0.9133 | 0.7479 |
| original | 0.922 | 0.911  | 0.782|


## 应用场景
### 算法类别
人脸识别

### 热点应用行业
教育,交通,公安,医疗

## 预训练权重
./models/model_best.pth

## 源码仓库及问题反馈
https://developer.hpccube.com/codes/modelzoo/centerface_pytorch

## 参考资料
https://github.com/chenjun2hao/CenterFace.pytorch
