# CenterFace
## 论文
[CenterFace: Joint Face Detection and Alignment Using Face as Point](https://arxiv.org/abs/1911.03599)

## 模型结构
CenterFace是一种人脸检测算法，采用了轻量级网络mobileNetV2作为主干网络，结合特征金字塔网络（FPN）实现anchor free的人脸检测。
<div align=center>
    <img src="./doc/Architecture of the CenterFace.png"/>
</div>

## 算法原理
CenterFace模型是一种基于单阶段人脸检测算法，作者借鉴了CenterNet的思想，将人脸检测转换为标准点问题，根据人脸中心点来回归人脸框的大小和五个标志点。

| 参数 | 说明 |
| :------: | :------: |
| F | Feature Map |
| HM | 人脸分类的HeatMap |
| Offset | 人脸框中心点偏移 |
| WH | 人脸框宽，高 |
| x_l,y_l | 人脸框左上角点的x,y坐标 |
| x_r,y_r | 人脸框右下角点的x,y坐标 |
| c | Confidence |

<div align=center>
    <img src="./doc/process.png"/>
</div>

## 环境配置
### Docker（方法一）

-v 路径、docker_name和imageID根据实际情况修改

```bash
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-centos7.6-dtk23.10.1-py38
docker run -it -v /path/your_code_data/:/path/your_code_data/ --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash

cd /your_code_path/centerface_pytorch/
pip3 install -r requirements.txt
```

### Dockerfile（方法二）

-v 路径、docker_name和imageID根据实际情况修改

```bash
cd ./docker
docker build --no-cache -t centerface:latest .
docker run -it -v /path/your_code_data/:/path/your_code_data/ --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash

cd /your_code_path/centerface_pytorch/
pip3 install -r requirements.txt
```

### Anaconda（方法三）

1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装： https://developer.hpccube.com/tool/

```
DTK软件栈：dtk23.10.1
python：python3.8
torch：2.1.0
torchvision：0.14.1
```
`Tips：以上dtk驱动、python、paddle等DCU相关工具版本需要严格一一对应`

2、其他非特殊库直接按照requirements.txt安装

```
pip3 install -r requirements.txt
```

## 数据集

[WIDER_FACE](http://113.200.138.88:18080/aidatasets/project-dependency/wider_face)

<div align=center>
    <img src="./doc/datasets.png"/>
</div>

下载图片红框中三个数据并解压，也可直接点击下面链接直接下载：

[WIDER Face Training Images(Tencent Drive)](https://share.weiyun.com/5WjCBWV)

[WIDER Face Validation Images(Tencent Drive)](https://share.weiyun.com/5ot9Qv1)

[WIDER Face Testing Images(Tencent Drive)](https://share.weiyun.com/5vSUomP)


数据集全部解压后的目录结构如下：

```
├── wider_face:  存放数据集根目录
│   ├── WIDER_train: 训练集解压后的文件目录
│       └── images:
│           ├──  0--Parade:         对应该类别的所有图片
│           ├──  ........
│           └──  61--Street_Battle: 对应该类别的所有图片
│   ├── WIDER_val: 验证集解压后的文件目录
│       └── images:
│           ├──  0--Parade:         对应该类别的所有图片
│           ├──  ........
│           └──  61--Street_Battle: 对应该类别的所有图片
│   ├── WIDER_test: 训练集解压后的文件目录
│       └── images:
│           ├──  0--Parade:         对应该类别的所有图片
│           ├──  ........
│           └──  61--Street_Battle: 对应该类别的所有图片
```

解压完成后执行以下步骤：
1. 将训练图片放置于 ./datasets/images/train的目录下，验证数据放置于./datasets/images/val目录下，存放目录结如下
```
├── images
│   ├── train
│       ├── 0--Parade
│       ├──  ........
│       └──  61--Street_Battle
│   ├── val
│       ├── 0--Parade
│       ├──  ........
│       └──  61--Street_Battle
```

2. 如果是使用WIDER_train、WIDER_val数据, 可直接将./datasets/labels/下的train_wider_face.json重命名为train_face.json, val_wider_face.json重命名为val_face.json即可，无需进行标注文件格式转换；
反之，需要将训练图片/验证图片对应的人脸标注信息文件train.txt/val.txt，放置于 ./datasets/annotations/下（train存放训练图片的标注文件，val存放验证图片的标注文件），存放目录结构如下：

```
├── annotations
│   ├── train
│       ├── train.txt
│   ├── val
│       ├── val.txt
```

特别地，标注信息的格式为：

```
# img_file/image_name # #+空格+img_file/image_name
x, y, w, h, left_eye_x, left_eye_y, flag, right_eye_x, right_eye_y, flag, nose_x, nose_y, flag, left_mouth_x, left_mouth_y, flag, right_mouth_x, right_mouth_y, flag, confidence  # x和y是检测框左上角的坐标
```

举个例子：
./datasets/annotations/train/train.txt是wider_face训练数据集的标注信息

```
# 0--Parade/0_Parade_marchingband_1_849.jpg
449 330 122 149 488.906 373.643 0.0 542.089 376.442 0.0 515.031 412.83 0.0 485.174 425.893 0.0 538.357 431.491 0.0 0.82
...
```

3. 生成训练所需的json格式标注数据：
```bash
cd ./datasets
python gen_data.py
```

执行完成后会在./datasets/labels下生成训练数据的标注文件 train_face.json、val_face.json


## 训练
默认训练模型保存在./exp/下，如需修改为自己的路径，可以对`centerface_pytorch/src/lib/opts_pose.py`的284行进行修改

### 单机单卡
```bash
cd ./src
bash train.sh
```

### 单机多卡
```bash
cd ./src
bash train_multi.sh
```

## 推理
#### 单卡推理
```bash
cd lib/external/
bash make.sh
cd ../../
python test_wider_face.py
```

## result
<div align=center>
    <img src="./doc/draw_img.jpg"/>
</div>

### 精度

WIDER_FACE验证集上的测试结果如下:

| Device | Easy(AP) | Medium(AP) | Hard(AP)|
| :------: | :------: | :------: | :------: |
| Z100L | 0.9264 | 0.9133 | 0.7479 |
| V100S | 0.922 | 0.911  | 0.782|

## 应用场景
### 算法类别
人脸识别

### 热点应用行业
教育,交通,公安,医疗

## 源码仓库及问题反馈
https://developer.hpccube.com/codes/modelzoo/centerface_pytorch

## 参考资料
https://github.com/chenjun2hao/CenterFace.pytorch
