import json
import os
import shutil


def main(args):
    with open(args.data_record_path, "r") as f:
        for line in f.readlines():
            line = json.loads(line.strip())
            for key, path in line.items():
                save_path = os.path.join(args.save_root, key)
                os.makedirs(save_path, exist_ok=True)
                shutil.copy2(path, save_path)


if __name__ == "__main__":
    from argparse import ArgumentParser
    
    parser = ArgumentParser()
    
    parser.add_argument("--data_record_path", type=str)
    
    parser.add_argument("--save_root", type=str)
    
    args = parser.parse_args()
    
    main(args)
