#!/bin/bash

# 初始/恢复点模型路径
model_root="/home/vtryon/catvton_v0/pretrained_models/stable-diffusion-inpainting"
train_data_record_path="/home/vtryon/catvton_v0/datasets/train_data.jsonl"
eval_data_record_path="/home/vtryon/catvton_v0/datasets/eval_data.jsonl"
height=512
width=384
vae_subfolder="sd-vae-ft-mse"
weight_dtype="bf16"
max_steps=32000
logging_steps=1000
global_steps=0
batch_size=8
gradient_accumulation_steps=4
extra_condition_key="openpose"
eval_output_dir=${max_steps}_${extra_condition_key}
checkpoint_dir=${max_steps}_${extra_condition_key}


accelerate launch train.py \
--model_root=${model_root} \
--train_data_record_path=${train_data_record_path} \
--eval_data_record_path=${eval_data_record_path} \
--height=${height} \
--width=${width} \
--eval_output_dir=${eval_output_dir} \
--checkpoint_dir=${checkpoint_dir} \
--vae_subfolder=${vae_subfolder} \
--weight_dtype=${weight_dtype} \
--max_steps=${max_steps} \
--logging_steps=${logging_steps} \
--global_steps=${global_steps} \
--batch_size=${batch_size} \
--gradient_accumulation_steps=${gradient_accumulation_steps} \
--extra_condition_key=${extra_condition_key}
