<!--
 * @Author: zhuww
 * @email: zhuww@sugon.com
 * @Date: 2023-09-08 11:08:07
 * @LastEditTime: 2023-09-19 14:10:01
-->
# BLOOM

## 论文
`BLOOM: A 176B-Parameter Open-Access Multilingual Language Model`

- [https://arxiv.org/abs/2211.05100](https://arxiv.org/abs/2211.05100)

## 模型结构
BLOOM是一个开源的支持最多59种语言和176B参数的大语言模型。它是在Megatron-LM GPT2的基础上修改训练出来的，主要使用了解码器唯一结构，对词嵌入层的归一化，使用GeLU激活函数的线性偏差注意力位置编码等技术。它的训练集包含了45种自然语言和12种编程语言，1.5TB的预处理文本转化为了350B的唯一token。bigscience在hugging face上发布的bloom模型包含多个参数多个版本。

![img](./docs/bloom.png)

## 算法原理
BLOOM是一种自回归大型语言模型(LLM)，经过训练，可使用工业规模的计算资源根据大量文本数据的提示继续文本。因此，它能够以46种语言和13种编程语言输出连贯的文本，与人类编写的文本几乎没有区别。还可以通过将BLOOM转换为文本生成任务来指示BLOOM执行尚未明确训练的文本任务。

![img](./docs/bloom_1.png)

## 环境配置

提供[光源](https://www.sourcefind.cn/#/service-details)拉取推理的docker镜像：
```
docker pull docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:fastertransformer-dtk23.04-latest
# <Image ID>用上面拉取docker镜像的ID替换
# <Host Path>主机端路径
# <Container Path>容器映射路径
docker run -it --name llama --shm-size=32G  --device=/dev/kfd --device=/dev/dri/ --cap-add=SYS_PTRACE --security-opt seccomp=unconfined --ulimit memlock=-1:-1 --ipc=host --network host --group-add video -v <Host Path>:<Container Path> <Image ID> /bin/bash
```

镜像版本依赖：
* DTK驱动：dtk23.04
* Pytorch: 1.10
* python: python3.8

激活镜像环境：
`source /opt/dtk-23.04/env.sh`

测试目录：
`/opt/FasterTransformer`

## 数据集
训练数据包括46种自然语言，13种编程语言，在1.6T的预处理文本中，转换为350B个唯一标记。

## 推理

### 模型下载

[bloom 7B](https://huggingface.co/bigscience/bloomz-7b1-mt)

模型转换

```bash
cd /opt/FasterTransformer/build
python ../examples/pytorch/gpt/utils/huggingface_bloom_convert.py \
--input-dir=/data/models/llama-7b-infer/ \
--output-dir=/data/models/llama-7b-hf/ \
-tp 1 --data-type fp16 -p 8 -v
```

其中：`--input-dir`为模型输入路径，`--output-dir`为模型输出路径，`-tp `为推理的tp大小，`--data-type`为推理的数据类型，`-p`为转换时的并行线程数，`-v`为启用详细日志记录.

### 运行 LLama-7b

1. 生成`gemm_config.in`文件

data_type = 0 (FP32) or 1 (FP16)

```bash
./bin/gpt_gemm 1 1 20 32 128 16384 250880 1 1
```

上述参数对应为

```bash 
./bin/gpt_gemm <batch_size> <beam_width> <max_input_len> <head_number> <size_per_head> <inter_size> <vocab_size> <data_type> <tensor_para_size> 
```

2. 配置`../examples/cpp/multi_gpu_gpt/gpt_config.ini`

其中：data_type = 1时，data_type = fp16,tensor_para_size和模型转换设置的tp数保持一致，model_name=bloom_7b，model_dir为对应的模型权重，request_batch_size为推理的batch_size数量，max_seq_len=2048，request_output_len为输出长度,`../examples/cpp/multi_gpu_gpt/start_ids.csv`可以修改输入的起始id.

3. 运行

```bash
./bin/multi_gpu_gpt_example
```
该程序会读取`../examples/cpp/multi_gpu_gpt/start_ids.csv`中的id作为输入tokens,生成的结果会保存在`.out`.

### 参数配置说明

从huggingface下载bloom模型，可以查看config.json文件，如下左边为fastertransformer参数，后边对应config.son文件中的参数值.

```bash
head_num=num_attention_heads
size_per_head=n_embed // num_attention_heads
vocab_size=vocab_size
decoder_layers=n_layer
inter_size=4*n_embed
```

## result
```
build/
    out
```
执行一下命令可以解析out结果：
```bash
python bloom_token_converter.py
其中，`tokenizer`为原模型路径
```

## 精度
无

## 应用场景

### 算法类别
NLP

### 热点应用行业
金融,科研,教育

## 源码仓库及问题反馈
* [https://developer.hpccube.com/codes/modelzoo/bloom_fastertransformer](https://developer.hpccube.com/codes/modelzoo/bloom_fastertransformer)

## 参考资料
* [https://github.com/NVIDIA/FasterTransformer](https://github.com/NVIDIA/FasterTransformer)
