#!/bin/bash

exp_name="finetune-xgenmmv1-phi3_4k_instruct"
data_path="/blip-3_pytorch/data_configs/example_data_config.yaml"


if [[ ! -e $exp_name ]]; then
    mkdir $exp_name
fi

pretrained_ckpt="/blip-3_pytorch/pretrain_model/xgen-mm-phi3-mini-base-r-v1.5.pt"

HIP_VISIBLE_DEVICES=4,5,6,7 python -m torch.distributed.run --nproc_per_node=4 --nnodes=1 --master_port 9650 /blip-3_pytorch/open_flamingo/train/instruction_finetune.py \
    --lm_path /blip-3_pytorch/pretrain_model/Phi-3-mini-4k-instruct \
    --tokenizer_path /blip-3_pytorch/pretrain_model/Phi-3-mini-4k-instruct \
    --conv_template_name phi_3 \
    --vision_encoder_path /blip-3_pytorch/pretrain_model/siglip-so400m-patch14-384 \
    --vision_encoder_pretrained google \
    --model_family 'xgenmm_v1' \
    --num_vision_tokens 128 \
    --pretrained ${pretrained_ckpt} \
    --data_path ${data_path} \
    --data_sampler_group_by_length \
    --image_aspect_ratio anyres --anyres_patch_sampling \
    --batch_size 8 \
    --fsdp \
    --no_save_optim_state \
    --gradient_checkpointing \
    --fsdp_sharding_strategy hybrid \
    --workers 4 \
    --num_epochs 1 \
    --warmup_steps  2000 \
    --learning_rate 2e-5 \
    --weight_decay 0.0 \
    --lr_scheduler cosine \
    --precision amp_bf16 \
    --run_name ${exp_name} 2>&1 | tee ${exp_name}/terminal_output.log;
    # --report_to_wandb \
    # --wandb_project "blip3-xgenmm-finetune" \
    
