#include <vector>
#include <iostream>
#include "device.h"
#include "tabulate.h"
#include <gtest/gtest.h>
#include "utilities.h"

class TestTabulateSeT : public ::testing::Test
{
protected:
  // em_x = tf.random.uniform([4, 16], minval=0, maxval=0.2, dtype = tf.float64)
  std::vector<double > info = {
    -2.1000000000000000e+01, 2.1000000000000000e+01, 1.0500000000000000e+02, 1.0000000000000000e+00, 1.0000000000000000e+01, -1.0000000000000000e+00
  };  
  std::vector<double > em_x = {
    9.3816147034272368e-01, -1.6703373029862567e-01, -4.4294526064601734e-02, -2.8798505489184573e-01, -1.6703373029862567e-01, 9.2489218226366088e-01, -2.8928196536572048e-01, -4.7833509099876154e-01, -4.4294526064601734e-02, -2.8928196536572048e-01, 5.7034320185695120e-01, 1.8771147911830000e-01, -2.8798505489184573e-01, -4.7833509099876154e-01, 1.8771147911830000e-01, 4.0174654365823070e-01, 8.4370316144902313e-01, -3.7813146789689916e-02, -3.6989397568296523e-01, -4.0554075086539937e-01, -3.7813146789689916e-02, 6.5766402633747112e-01, -4.2312966361682885e-01, 1.2685067374257861e-01, -3.6989397568296523e-01, -4.2312966361682885e-01, 6.0171576901660107e-01, 9.8283160997298613e-02, -4.0554075086539937e-01, 1.2685067374257861e-01, 9.8283160997298613e-02, 2.1324148100625978e-01, 9.7843596341516559e-01, -1.0492833888237871e-01, -1.0538688914576379e-01, -2.0453551592353389e-01, -1.0492833888237871e-01, 7.7943976693565231e-01, -1.5898500035781410e-01, 9.4834209331437741e-02, -1.0538688914576379e-01, -1.5898500035781410e-01, 7.4778071691708869e-01, -6.1895255142095873e-01, -2.0453551592353389e-01, 9.4834209331437741e-02, -6.1895255142095873e-01, 6.0844713798743799e-01, 1.0079020879244640e+00, -2.3855984150631487e-01, -3.4608276043004524e-02, -4.7448768267289088e-01, -2.3855984150631487e-01, 4.9732018171028253e-01, -3.1320787082485729e-01, -1.4528004145602180e-01, -3.4608276043004524e-02, -3.1320787082485729e-01, 4.7696729363954582e-01, 1.1723268074231248e-01, -4.7448768267289088e-01, -1.4528004145602180e-01, 1.1723268074231248e-01, 4.0511515406019899e-01, 6.9317482874286218e-01, 3.8721526993960850e-02, -1.4829415254252801e-01, 1.9079858574793401e-01, 3.8721526993960850e-02, 4.0694636061668399e-01, -1.6669745680958750e-01, -2.9455183336619600e-01, -1.4829415254252801e-01, -1.6669745680958750e-01, 3.5115749833010762e-01, 2.7972274527006624e-02, 1.9079858574793401e-01, -2.9455183336619600e-01, 2.7972274527006624e-02, 2.9261590797274251e-01, 1.0547679530528609e+00, -7.5579498870314032e-01, -2.5907966401834215e-01, 2.4868586817732710e-01, -7.5579498870314032e-01, 7.7943976693565231e-01, -2.7840391808748116e-02, -1.2197364072902048e-02, -2.5907966401834215e-01, -2.7840391808748116e-02, 2.9514791871283574e-01, -1.4724344774699041e-01, 2.4868586817732710e-01, -1.2197364072902048e-02, -1.4724344774699041e-01, 2.7333766016385419e-01, 7.1494810971572931e-01, -3.8965690625377569e-01, -2.0579233200987346e-01, 1.5638053130676866e-01, -3.8965690625377569e-01, 5.7034320185695120e-01, -2.4759451701376567e-01, 1.7075608253389668e-01, -2.0579233200987346e-01, -2.4759451701376567e-01, 4.4489736273181785e-01, -3.3903230422862907e-01, 1.5638053130676866e-01, 1.7075608253389668e-01, -3.3903230422862907e-01, 2.7328888249045513e-01, 8.2256346358859145e-01, -3.0201999278197073e-01, -1.0847299712994765e-01, -3.3355086180245408e-01, -3.0201999278197073e-01, 6.2584346461620799e-01, -2.3661062787307036e-02, 2.5559368174587482e-02, -1.0847299712994765e-01, -2.3661062787307036e-02, 6.2471079378938721e-01, -3.9923912886685187e-01, -3.3355086180245408e-01, 2.5559368174587482e-02, -3.9923912886685187e-01, 4.9732018171028253e-01, 7.4300380743635475e-01, -4.4058918654051710e-01, -2.5375568912718455e-01, 5.6029289688609013e-02, -4.4058918654051710e-01, 4.3025970692640908e-01, -1.0172468432781301e-02, -1.2941908849275471e-01, -2.5375568912718455e-01, -1.0172468432781301e-02, 4.2845986148404269e-01, -1.7460159217638957e-01, 5.6029289688609013e-02, -1.2941908849275471e-01, -1.7460159217638957e-01, 3.8138264541081690e-01, 7.4620920788925238e-01, -1.6424881399213448e-01, -2.2361648073503249e-01, -4.0424642786821852e-01, -1.6424881399213448e-01, 6.6730350814323314e-01, -2.1317459925340326e-01, 1.9376435628360764e-01, -2.2361648073503249e-01, -2.1317459925340326e-01, 5.8089947575573275e-01, -1.0277026325170427e-01, -4.0424642786821852e-01, 1.9376435628360764e-01, -1.0277026325170427e-01, 3.1673915325970592e-01, 9.3159182283013242e-01, 2.7352164674733859e-01, -3.0194015433346399e-01, -1.6581739923723970e-01, 2.7352164674733859e-01, 8.7811025837608414e-01, -5.3657994020118693e-01, -1.4168666065928759e-02, -3.0194015433346399e-01, -5.3657994020118693e-01, 5.7772908002379919e-01, -2.6766718990342830e-01, -1.6581739923723970e-01, -1.4168666065928759e-02, -2.6766718990342830e-01, 4.3044918224444273e-01, 7.5776646946384441e-01, -2.8544634168978411e-01, -4.6917826735271817e-01, 9.0648108100258265e-02, -2.8544634168978411e-01, 6.3333781479517670e-01, -1.5635743535006455e-01, -3.2225585549698127e-01, -4.6917826735271817e-01, -1.5635743535006455e-01, 5.8894646017949193e-01, -4.7549586643753167e-02, 9.0648108100258265e-02, -3.2225585549698127e-01, -4.7549586643753167e-02, 5.1470686148396338e-01, 8.9120731219577032e-01, -4.8913932884415684e-01, -2.8535162253723745e-01, -3.9481172797096048e-01, -4.8913932884415684e-01, 6.8161288899055572e-01, 5.3745624046182272e-02, -9.6415050020146331e-03, -2.8535162253723745e-01, 5.3745624046182272e-02, 3.7216282686452884e-01, 1.8327616930599899e-01, -3.9481172797096048e-01, -9.6415050020146331e-03, 1.8327616930599899e-01, 2.9889755032428134e-01, 6.6730350814323314e-01, -1.9772856508212072e-01, -1.3214864503616511e-01, 1.9656713013350754e-01, -1.9772856508212072e-01, 6.4107564273521156e-01, -3.6750949174506781e-01, -2.1514707877261979e-01, -1.3214864503616511e-01, -3.6750949174506781e-01, 4.7696729363954582e-01, -1.0605540579882382e-01, 1.9656713013350754e-01, -2.1514707877261979e-01, -1.0605540579882382e-01, 2.8720166306787565e-01, 9.3159182283013242e-01, -3.9105219662031382e-01, -4.6012852922712744e-01, -3.7107529450742310e-01, -3.9105219662031382e-01, 6.4624598213814299e-01, -1.9218513692914521e-01, 8.7864237420793134e-02, -4.6012852922712744e-01, -1.9218513692914521e-01, 5.5411629355023162e-01, 1.5181004010991156e-01, -3.7107529450742310e-01, 8.7864237420793134e-02, 1.5181004010991156e-01, 5.4717905839342551e-01, 5.5411629355023162e-01, -1.3154982153268135e-01, -2.2683561534265623e-02, -8.5067568027022145e-02, -1.3154982153268135e-01, 4.6158852919583448e-01, -7.4818007595887706e-02, -2.3446129520432515e-01, -2.2683561534265623e-02, -7.4818007595887706e-02, 4.0511515406019899e-01, -2.4964155806145566e-01, -8.5067568027022145e-02, -2.3446129520432515e-01, -2.4964155806145566e-01, 3.9586735852137039e-01, 9.4162575876886123e-01, 1.6551527461893110e-02, -1.7195190048425002e-01, -8.5321232935839153e-02, 1.6551527461893110e-02, 7.4304915761252677e-01, -1.1678199974326212e-01, -4.3729941122496446e-01, -1.7195190048425002e-01, -1.1678199974326212e-01, 6.9317482874286218e-01, 1.9191976680315659e-01, -8.5321232935839153e-02, -4.3729941122496446e-01, 1.9191976680315659e-01, 2.8206822618179617e-01, 7.5776646946384441e-01, 1.3081288362678634e-02, -3.2517003355282742e-01, -3.5562946132636442e-01, 1.3081288362678634e-02, 7.0400669442030783e-01, -2.7774712576896132e-01, -1.7472226352059492e-01, -3.2517003355282742e-01, -2.7774712576896132e-01, 5.1099339330908866e-01, 7.5918257186359903e-02, -3.5562946132636442e-01, -1.7472226352059492e-01, 7.5918257186359903e-02, 2.8288909669360418e-01, 7.4778071691708869e-01, -3.9041097955700099e-01, -5.2895674526793196e-03, -4.0620032081707269e-01, -3.9041097955700099e-01, 6.0650459602198470e-01, -1.5236577918073632e-01, 1.3182011644234659e-03, -5.2895674526793196e-03, -1.5236577918073632e-01, 5.8972872609679527e-01, -1.4295182509075030e-01, -4.0620032081707269e-01, 1.3182011644234659e-03, -1.4295182509075030e-01, 4.2821165206248513e-01, 6.2471079378938699e-01, 6.0802406816920937e-02, -3.5127267686929931e-01, -3.3963258237386684e-01, 6.0802406816920937e-02, 6.0313886404423811e-01, -2.6977044122265748e-01, -1.6348825415331092e-01, -3.5127267686929931e-01, -2.6977044122265748e-01, 5.4552055268521205e-01, -1.9316799462722023e-02, -3.3963258237386684e-01, -1.6348825415331092e-01, -1.9316799462722023e-02, 4.8171669294486208e-01, 7.0578073898484561e-01, -9.8967741792306413e-02, 1.2502659893584156e-01, -3.7971201998874682e-01, -9.8967741792306413e-02, 7.0400669442030783e-01, -6.5060917634508969e-02, -1.0206531635166906e-01, 1.2502659893584156e-01, -6.5060917634508969e-02, 6.0506774685063136e-01, -2.9019848494979322e-01, -3.7971201998874682e-01, -1.0206531635166906e-01, -2.9019848494979322e-01, 3.3340397458978077e-01, 9.7231560474448697e-01, -4.8839770953582246e-02, -5.2649040695832883e-01, 7.6239831325479152e-02, -4.8839770953582246e-02, 8.5066067412859170e-01, -2.8381943351894323e-01, -4.3719342578830916e-01, -5.2649040695832883e-01, -2.8381943351894323e-01, 7.8694914200240895e-01, -6.9042842925044076e-02, 7.6239831325479152e-02, -4.3719342578830916e-01, -6.9042842925044076e-02, 3.1673915325970592e-01, 1.1146471781363385e+00, -4.1950872828895774e-01, -7.5099287814360732e-02, -7.0747093773604913e-02, -4.1950872828895774e-01, 8.7811025837608414e-01, -7.1680109826753424e-01, 1.5469221891377744e-01, -7.5099287814360732e-02, -7.1680109826753424e-01, 7.8157368152678353e-01, -1.8674982324145417e-01, -7.0747093773604913e-02, 1.5469221891377744e-01, -1.8674982324145417e-01, 6.3333781479517670e-01, 9.4162575876886123e-01, -3.5756088285386567e-01, -4.9692587682641537e-02, -1.9259678748208950e-01, -3.5756088285386567e-01, 5.7304538706875918e-01, -1.7263416631604137e-01, 1.7497761971314219e-01, -4.9692587682641537e-02, -1.7263416631604137e-01, 5.4717905839342551e-01, 1.8011611616770615e-01, -1.9259678748208950e-01, 1.7497761971314219e-01, 1.8011611616770615e-01, 1.6303735520554410e-01, 1.1146471781363385e+00, -2.9955742667885321e-01, -4.6620550078880341e-01, -3.1378159981378489e-01, -2.9955742667885321e-01, 8.8424257114190075e-01, -2.5441067597713185e-01, -2.1591071501682862e-01, -4.6620550078880341e-01, -2.5441067597713185e-01, 7.7959145539751795e-01, -1.2407187853083543e-01, -3.1378159981378489e-01, -2.1591071501682862e-01, -1.2407187853083543e-01, 5.8972872609679527e-01, 6.0506774685063081e-01, -7.0161191563646669e-02, -3.3988044762842473e-01, -1.9107644999487627e-01, -7.0161191563646669e-02, 4.3045264342637135e-01, 2.0824077812721109e-02, -2.5586718835495170e-01, -3.3988044762842473e-01, 2.0824077812721109e-02, 4.0694636061668399e-01, -3.6902580613623392e-02, -1.9107644999487627e-01, -2.5586718835495170e-01, -3.6902580613623392e-02, 3.5713610126062301e-01, 1.0507172480981881e+00, -5.7238843768987546e-01, -8.6532548307818979e-02, -2.4797217908729449e-01, -5.7238843768987546e-01, 6.4845065425155790e-01, -2.3798654086704824e-01, -9.0951164465072995e-02, -8.6532548307818979e-02, -2.3798654086704824e-01, 4.3025970692640908e-01, 5.1916371214171878e-02, -2.4797217908729449e-01, -9.0951164465072995e-02, 5.1916371214171878e-02, 3.5115749833010762e-01, 9.7070728754011626e-01, -1.9667254906106676e-01, 1.3881360342029997e-01, 1.8332147125431175e-01, -1.9667254906106676e-01, 6.4107564273521156e-01, 6.9919471349729312e-02, -2.0671318712854408e-01, 1.3881360342029997e-01, 6.9919471349729312e-02, 1.7842412973820965e-01, -2.8800113566320312e-02, 1.8332147125431175e-01, -2.0671318712854408e-01, -2.8800113566320312e-02, 8.7697980056291452e-02, 9.9699133925078010e-01, -1.9566669897090611e-01, 1.1472638955603826e-02, -3.8137297906451501e-01, -1.9566669897090611e-01, 7.8694914200240895e-01, -4.8668226019268873e-01, -4.3398812393252877e-02, 1.1472638955603826e-02, -4.8668226019268873e-01, 4.4489736273181785e-01, -5.7511361787363047e-02, -3.8137297906451501e-01, -4.3398812393252877e-02, -5.7511361787363047e-02, 2.9261590797274251e-01, 5.8721566479597598e-01, 2.1741339413236024e-01, -4.6310740433823661e-01, 1.5212653882669683e-01, 2.1741339413236024e-01, 5.7772908002379919e-01, -1.1309986042713593e-01, -4.6297902780444065e-02, -4.6310740433823661e-01, -1.1309986042713593e-01, 5.3524434793006614e-01, 7.7916319803791656e-02, 1.5212653882669683e-01, -4.6297902780444065e-02, 7.7916319803791656e-02, 3.3070548705408681e-01, 6.4845065425155790e-01, -1.1573648783331206e-01, -1.1295787224086569e-02, -3.2976819109974104e-01, -1.1573648783331206e-01, 5.7304538706875918e-01, -4.4057056903958502e-01, 1.5118880665101278e-01, -1.1295787224086569e-02, -4.4057056903958502e-01, 5.0847535644168274e-01, -2.7508898922066710e-01, -3.2976819109974104e-01, 1.5118880665101278e-01, -2.7508898922066710e-01, 4.6158852919583448e-01, 9.2489218226366110e-01, 1.9293109981997125e-01, -4.6858170396716431e-01, 4.2486849070578564e-02, 1.9293109981997125e-01, 8.8759600097388758e-01, -9.3159319915253995e-03, -2.1166189641553734e-01, -4.6858170396716431e-01, -9.3159319915253995e-03, 5.8089947575573275e-01, -3.8498930024537814e-01, 4.2486849070578564e-02, -2.1166189641553734e-01, -3.8498930024537814e-01, 4.0608640117736616e-01, 9.0810287860174088e-01, -4.5026066211118843e-01, -2.4234797312679049e-01, -1.1635894709323868e-01, -4.5026066211118843e-01, 8.3522648701948565e-01, 7.0167369514544164e-02, -3.0380780947210834e-01, -2.4234797312679049e-01, 7.0167369514544164e-02, 2.8658902506762818e-01, 4.2786039330881952e-02, -1.1635894709323868e-01, -3.0380780947210834e-01, 4.2786039330881952e-02, 2.2990742509977113e-01, 8.7859873068865801e-01, -4.0521290114598696e-01, -3.4537197184419777e-02, -5.1541416274527041e-01, -4.0521290114598696e-01, 7.7073679568840003e-01, -5.2766218816177624e-01, 7.2009349057603700e-02, -3.4537197184419777e-02, -5.2766218816177624e-01, 5.3524434793006614e-01, 1.2774094128859217e-01, -5.1541416274527041e-01, 7.2009349057603700e-02, 1.2774094128859217e-01, 4.2821165206248513e-01, 8.0017606793538776e-01, -3.6273937320056748e-01, -4.8244644816054216e-01, 1.9000791267873704e-01, -3.6273937320056748e-01, 5.6353888423218390e-01, 3.7095579553517985e-02, 1.0807739396133707e-01, -4.8244644816054216e-01, 3.7095579553517985e-02, 4.2845986148404269e-01, -1.2901615367558902e-01, 1.9000791267873704e-01, 1.0807739396133707e-01, -1.2901615367558902e-01, 2.3908528931221024e-01, 8.7859873068865801e-01, -5.7342075379041779e-01, -2.2560792912032243e-01, 1.3840168053297142e-01, -5.7342075379041779e-01, 6.2584346461620799e-01, -1.0147381298988209e-01, -1.8792520225770581e-01, -2.2560792912032243e-01, -1.0147381298988209e-01, 4.9480400405457242e-01, -1.3243403061658676e-01, 1.3840168053297142e-01, -1.8792520225770581e-01, -1.3243403061658676e-01, 2.5543672306163845e-01, 9.7843596341516559e-01, -3.0135276617413775e-02, -6.3204064126440895e-01, 7.7858338769721036e-02, -3.0135276617413775e-02, 7.3888148744521942e-01, -2.8105601448216994e-01, -1.4222291428374428e-01, -6.3204064126440895e-01, -2.8105601448216994e-01, 5.3087899217465850e-01, -1.9954226724405721e-03, 7.7858338769721036e-02, -1.4222291428374428e-01, -1.9954226724405721e-03, 3.7962008200748842e-01, 7.3888148744521942e-01, -3.9876854953397894e-01, 7.9344112776459683e-02, 3.0881146913585039e-02, -3.9876854953397894e-01, 5.8894646017949193e-01, -2.9566251514384462e-01, -2.1875193893336647e-01, 7.9344112776459683e-02, -2.9566251514384462e-01, 2.1324148100625978e-01, 1.1337428718710466e-01, 3.0881146913585039e-02, -2.1875193893336647e-01, 1.1337428718710466e-01, 1.3167057692769979e-01, 7.2588662899153644e-01, -4.0491835492648354e-01, 3.8294782214220321e-02, -1.6245502019487457e-01, -4.0491835492648354e-01, 6.9978773302195119e-01, -2.6130189173261692e-01, -1.4963646270159869e-01, 3.8294782214220321e-02, -2.6130189173261692e-01, 4.9396599356834686e-01, -2.0453500637835592e-01, -1.6245502019487457e-01, -1.4963646270159869e-01, -2.0453500637835592e-01, 4.3044918224444273e-01, 5.4829965643085543e-01, -8.6258333909827428e-02, -9.0863809928147868e-02, -2.5335540346466701e-01, -8.6258333909827428e-02, 4.8256071581125803e-01, -1.5824234665042425e-01, -6.2251154159746636e-02, -9.0863809928147868e-02, -1.5824234665042425e-01, 3.3070548705408681e-01, -1.2171470598287978e-01, -2.5335540346466701e-01, -6.2251154159746636e-02, -1.2171470598287978e-01, 2.9993528142734771e-01, 9.9699133925078010e-01, -5.5720924928656934e-02, -3.7563354786645231e-01, -1.7003176037775222e-01, -5.5720924928656934e-02, 7.1322781206304275e-01, -1.4028476150114413e-01, -4.0725518739947821e-02, -3.7563354786645231e-01, -1.4028476150114413e-01, 6.5766402633747112e-01, -3.7470308102778649e-01, -1.7003176037775222e-01, -4.0725518739947821e-02, -3.7470308102778649e-01, 4.5518325168409662e-01, 7.2306489407047936e-01, -5.5652304518705331e-01, -1.7548443714837653e-01, -9.7244252488182109e-02, -5.5652304518705331e-01, 5.8721566479597631e-01, 1.5466175158937293e-02, 2.3395338180958331e-01, -1.7548443714837653e-01, 1.5466175158937293e-02, 5.1099339330908866e-01, 1.2309721775318454e-01, -9.7244252488182109e-02, 2.3395338180958331e-01, 1.2309721775318454e-01, 2.9948736341201787e-01, 8.9120731219577032e-01, 1.3828785543997540e-01, -6.5808954835297839e-01, 2.3928953196716229e-02, 1.3828785543997540e-01, 8.8759600097388758e-01, -1.6580688159465298e-01, -1.0200920121572279e-01, -6.5808954835297839e-01, -1.6580688159465298e-01, 6.0844713798743799e-01, -1.8482739703288106e-01, 2.3928953196716229e-02, -1.0200920121572279e-01, -1.8482739703288106e-01, 2.7328888249045513e-01, 9.7231560474448697e-01, -1.5360824814848673e-01, -3.0175556482836241e-01, 1.4427139165494557e-01, -1.5360824814848673e-01, 7.7073679568840003e-01, -4.4616437520485569e-01, -4.3386642987381790e-02, -3.0175556482836241e-01, -4.4616437520485569e-01, 6.8161288899055572e-01, -3.3586190220507495e-01, 1.4427139165494557e-01, -4.3386642987381790e-02, -3.3586190220507495e-01, 3.7736584257608707e-01, 8.4370316144902313e-01, -3.4786444025064711e-01, -4.9627086468803983e-01, -3.0284479791966981e-02, -3.4786444025064711e-01, 7.7959145539751795e-01, 5.4105959194424263e-02, -5.6892292757652424e-02, -4.9627086468803983e-01, 5.4105959194424263e-02, 3.7736584257608707e-01, 1.4233877887889113e-01, -3.0284479791966981e-02, -5.6892292757652424e-02, 1.4233877887889113e-01, 2.4312804865275472e-01, 9.3816147034272368e-01, -2.0860974495653162e-01, -3.7166959734666666e-01, 5.6250602465564153e-03, -2.0860974495653162e-01, 9.0810287860174088e-01, -9.1069253660888416e-02, -6.4962854816729276e-01, -3.7166959734666666e-01, -9.1069253660888416e-02, 8.1523507511884086e-01, -6.6856471628686520e-02, 5.6250602465564153e-03, -6.4962854816729276e-01, -6.6856471628686520e-02, 5.4817010902737695e-01, 8.3348751379486785e-01, -5.7386182749623121e-02, -1.2725671252595133e-01, -2.6056306991901751e-01, -5.7386182749623121e-02, 5.2909436738615123e-01, -4.2596706647156624e-01, -1.0919830944239709e-02, -1.2725671252595133e-01, -4.2596706647156624e-01, 3.7962008200748842e-01, 7.0344098964105775e-02, -2.6056306991901751e-01, -1.0919830944239709e-02, 7.0344098964105775e-02, 2.2679728457111192e-01, 1.0079020879244640e+00, -6.4116619730398172e-01, 1.1959784878009472e-02, -3.5036660259057062e-01, -6.4116619730398172e-01, 7.2588662899153644e-01, 1.5457663848526185e-01, -1.3123176159456695e-01, 1.1959784878009472e-02, 1.5457663848526185e-01, 7.2306489407047936e-01, 1.1120004060087613e-01, -3.5036660259057062e-01, -1.3123176159456695e-01, 1.1120004060087613e-01, 6.5291435452372704e-01, 6.5291435452372693e-01, -2.0669331449151485e-01, -1.0009057137401539e-01, -1.0458759498524857e-01, -2.0669331449151485e-01, 4.8256071581125803e-01, -1.0975185704675450e-01, -7.1400789900385064e-02, -1.0009057137401539e-01, -1.0975185704675450e-01, 3.1774836143047369e-01, -1.3420181173883666e-01, -1.0458759498524857e-01, -7.1400789900385064e-02, -1.3420181173883666e-01, 1.7842412973820965e-01, 7.4304915761252677e-01, -3.7474512353359690e-02, -2.0605417465948622e-01, 2.8786202774685965e-02, -3.7474512353359690e-02, 6.4624598213814299e-01, -1.8088533245882277e-01, -2.7294935111478841e-01, -2.0605417465948622e-01, -1.8088533245882277e-01, 4.5625158241504560e-01, -2.5573952710441156e-01, 2.8786202774685965e-02, -2.7294935111478841e-01, -2.5573952710441156e-01, 4.3045264342637135e-01, 8.1523507511884286e-01, -1.1206588973386064e-01, -2.9038245483951325e-01, -9.4044512167176214e-02, -1.1206588973386064e-01, 6.9069450025674883e-01, -3.6666406927828260e-01, -2.6295004305146680e-01, -2.9038245483951325e-01, -3.6666406927828260e-01, 6.0313886404423811e-01, -1.1364153715298203e-01, -9.4044512167176214e-02, -2.6295004305146680e-01, -1.1364153715298203e-01, 5.0847535644168274e-01, 7.8157368152678375e-01, -3.6689153089953208e-01, -1.6343042599874896e-01, 2.0681260422479955e-01, -3.6689153089953208e-01, 7.5302376148517924e-01, -3.9141809592987054e-01, -4.9792782459804974e-01, -1.6343042599874896e-01, -3.9141809592987054e-01, 4.8171669294486208e-01, 1.8620912874547166e-01, 2.0681260422479955e-01, -4.9792782459804974e-01, 1.8620912874547166e-01, 4.5625158241504560e-01, 8.5066067412859170e-01, -6.6383544595733118e-02, -4.9833493744041324e-01, 3.5985625651793141e-02, -6.6383544595733118e-02, 7.6738392766662211e-01, -1.9489169085491792e-01, -6.4543919151000315e-02, -4.9833493744041324e-01, -1.9489169085491792e-01, 5.4829965643085543e-01, -2.7028089635457442e-01, 3.5985625651793141e-02, -6.4543919151000315e-02, -2.7028089635457442e-01, 3.9586735852137039e-01, 8.8424257114190075e-01, -5.0968059146564315e-01, -9.5512640917474467e-03, -7.2900503108297598e-02, -5.0968059146564315e-01, 7.0578073898484561e-01, -7.9000528792048164e-02, -3.4471532290325835e-01, -9.5512640917474467e-03, -7.9000528792048164e-02, 6.9978773302195119e-01, -2.3508453941888172e-01, -7.2900503108297598e-02, -3.4471532290325835e-01, -2.3508453941888172e-01, 5.1462854065795050e-01, 8.3522648701948565e-01, -4.4716582952086292e-01, 5.4799614348689352e-02, -2.2914542894364148e-02, -4.4716582952086292e-01, 8.3348751379486763e-01, -6.7279352271601633e-01, -3.4916341927887895e-02, 5.4799614348689352e-02, -6.7279352271601633e-01, 7.6738392766662211e-01, -1.6809648395494664e-01, -2.2914542894364148e-02, -3.4916341927887895e-02, -1.6809648395494664e-01, 7.1322781206304275e-01, 9.7070728754011626e-01, -2.5224986479466716e-01, 5.5579119983494740e-02, -3.6768489956717509e-01, -2.5224986479466716e-01, 5.3965948062451941e-01, -4.4192312892226593e-01, 3.1513756645368173e-02, 5.5579119983494740e-02, -4.4192312892226593e-01, 5.3087899217465850e-01, 7.9885677144886064e-02, -3.6768489956717509e-01, 3.1513756645368173e-02, 7.9885677144886064e-02, 1.6104012331629208e-01, 8.6130335545327363e-01, -9.6129435640763802e-02, -1.4801620948352356e-02, 7.8150102857998158e-02, -9.6129435640763802e-02, 6.7625303314120611e-01, -5.5027301017164576e-02, -1.7520377876997034e-01, -1.4801620948352356e-02, -5.5027301017164576e-02, 3.1774836143047369e-01, -1.2376278479081343e-01, 7.8150102857998158e-02, -1.7520377876997034e-01, -1.2376278479081343e-01, 1.0841353470308304e-01, 7.4620920788925238e-01, -1.6394859485203073e-01, -2.0029713033714130e-01, -1.8645272306202978e-01, -1.6394859485203073e-01, 5.3965948062451941e-01, -3.8230461309700781e-01, 1.3847290923401767e-01, -2.0029713033714130e-01, -3.8230461309700781e-01, 5.1462854065795050e-01, -1.8561874788646704e-01, -1.8645272306202978e-01, 1.3847290923401767e-01, -1.8561874788646704e-01, 2.9993528142734771e-01, 6.7625303314120611e-01, -1.6815361388865593e-01, -3.3930776213055852e-01, -1.2114679754832709e-01, -1.6815361388865593e-01, 5.6353888423218390e-01, -7.5784855072358825e-02, -3.3221823724983218e-01, -3.3930776213055852e-01, -7.5784855072358825e-02, 5.1470686148396338e-01, -4.1819974401314991e-02, -1.2114679754832709e-01, -3.3221823724983218e-01, -4.1819974401314991e-02, 4.2819483757235705e-01, 1.0507172480981881e+00, -1.4246809991945683e-01, 4.1456358442478705e-02, -4.5365891641821365e-01, -1.4246809991945683e-01, 7.1494810971572931e-01, -2.4883057770682826e-01, -2.4395987950943798e-01, 4.1456358442478705e-02, -2.4883057770682826e-01, 5.4552055268521205e-01, 1.2834013149857285e-01, -4.5365891641821365e-01, -2.4395987950943798e-01, 1.2834013149857285e-01, 3.3340397458978077e-01, 6.9069450025674894e-01, -3.8338543582916840e-01, -1.6642138961100816e-01, -3.5535624148913159e-01, -3.8338543582916840e-01, 5.2909436738615123e-01, 9.6172848604107755e-02, 5.5205364851978050e-02, -1.6642138961100816e-01, 9.6172848604107755e-02, 4.2819483757235710e-01, 5.9926260952505861e-03, -3.5535624148913159e-01, 5.5205364851978050e-02, 5.9926260952505861e-03, 2.6226647193037689e-01, 8.6130335545327363e-01, -6.2395423965096508e-02, -3.8567287714901394e-01, -1.5408554583685347e-01, -6.2395423965096508e-02, 7.4300380743635475e-01, -4.7285239739268992e-01, -3.2035899709108612e-02, -3.8567287714901394e-01, -4.7285239739268992e-01, 6.0171576901660107e-01, -1.0536966428907621e-01, -1.5408554583685347e-01, -3.2035899709108612e-02, -1.0536966428907621e-01, 4.9396599356834686e-01, 7.5302376148517924e-01, -6.0232285163413626e-02, -2.7132649171672180e-01, -1.4054053948995909e-01, -6.0232285163413626e-02, 6.0650459602198470e-01, -2.4794771537629287e-01, -1.4485909587327089e-01, -2.7132649171672180e-01, -2.4794771537629287e-01, 4.5518325168409662e-01, -1.6092902586109215e-01, -1.4054053948995909e-01, -1.4485909587327089e-01, -1.6092902586109215e-01, 4.0174654365823070e-01, 1.0547679530528609e+00, -6.4439808979974744e-01, 6.9192182950400305e-02, -3.3250796613430167e-01, -6.4439808979974744e-01, 8.2256346358859145e-01, -4.8266166410158140e-01, -7.9980773185718390e-02, 6.9192182950400305e-02, -4.8266166410158140e-01, 8.0017606793538776e-01, -2.7854894491724819e-02, -3.3250796613430167e-01, -7.9980773185718390e-02, -2.7854894491724819e-02, 5.4817010902737695e-01, 1.5502492798962887e+01, -9.4036183520005387e+00, -9.0871843532376817e-01, 1.5458603036460241e+00, -9.4036183520005387e+00, 5.8545618851096108e+00, 8.7584459712876173e-01, -1.0260595565373307e+00, -9.0871843532376817e-01, 8.7584459712876173e-01, 7.5773424105520826e-01, -3.2391012220482440e-01, 1.5458603036460241e+00, -1.0260595565373307e+00, -3.2391012220482440e-01, 6.6152719782725655e-01, 1.5881484684546885e+01, -8.5373015094081293e+00, 1.2910407629253464e+00, 1.2854398517437213e+00, -8.5373015094081293e+00, 5.0892253563939507e+00, -3.8569840009954620e-01, -9.9850386318081996e-01, 1.2910407629253464e+00, -3.8569840009954620e-01, 4.1577040236200724e-01, -9.1388286019611339e-02, 1.2854398517437213e+00, -9.9850386318081996e-01, -9.1388286019611339e-02, 2.9351817210899528e-01, 1.8355238388750472e+01, -9.9693288297551721e+00, 1.4065955534477488e+00, 1.5236758321532125e+00, -9.9693288297551721e+00, 5.4788018334752540e+00, -7.5992948757336931e-01, -6.6807507000148814e-01, 1.4065955534477488e+00, -7.5992948757336931e-01, 5.8340911874120316e-01, 9.9856752432820606e-03, 1.5236758321532125e+00, -6.6807507000148814e-01, 9.9856752432820606e-03, 5.5177690536312463e-01, 1.7078778656839585e+01, -6.5205205128653105e+00, 1.5817366283975822e+00, -9.3640888727240412e-01, -6.5205205128653105e+00, 2.9619037115622602e+00, -1.1542576186016471e+00, -8.8584406490304773e-02, 1.5817366283975822e+00, -1.1542576186016471e+00, 8.3454304950111569e-01, 3.1272631908606119e-01, -9.3640888727240412e-01, -8.8584406490304773e-02, 3.1272631908606119e-01, 7.8087115310507782e-01, 1.5669862194862620e+01, -6.2090727600143900e+00, 1.3817794924064011e+00, -1.1475004406408358e+00, -6.2090727600143900e+00, 2.5567265715258070e+00, -5.4440265806779431e-01, 3.8699899553155109e-01, 1.3817794924064011e+00, -5.4440265806779431e-01, 3.6446802134584444e-01, -2.8076757475429592e-01, -1.1475004406408358e+00, 3.8699899553155109e-01, -2.8076757475429592e-01, 2.6130199022294265e-01, 1.7118875747980759e+01, -5.9277226216953718e+00, 1.9346813580902582e+00, -1.6872205590095239e+00, -5.9277226216953718e+00, 2.1086146215067632e+00, -8.0747551757328861e-01, 4.7699095328329716e-01, 1.9346813580902582e+00, -8.0747551757328861e-01, 5.5797080293767543e-01, 8.9832319658025406e-02, -1.6872205590095239e+00, 4.7699095328329716e-01, 8.9832319658025406e-02, 5.5399995944851188e-01, 1.7058565959549352e+01, -5.9263293882909478e+00, 1.5342405590746959e+00, -1.1630302303586997e+00, -5.9263293882909478e+00, 2.6205293378999683e+00, -4.7688305722955537e-01, 3.1804603922241220e-01, 1.5342405590746959e+00, -4.7688305722955537e-01, 3.1296424858530869e-01, -2.8669977614844999e-01, -1.1630302303586997e+00, 3.1804603922241220e-01, -2.8669977614844999e-01, 2.7020324134820112e-01, 1.6874725411781530e+01, -6.9150979008264484e+00, 1.0065221329504688e+00, -1.8347878924481371e+00, -6.9150979008264484e+00, 3.5369590566282492e+00, -5.2228937791154206e-01, 2.3672173077240022e-01, 1.0065221329504688e+00, -5.2228937791154206e-01, 6.0329263881086503e-01, 4.6309711033365369e-02, -1.8347878924481371e+00, 2.3672173077240022e-01, 4.6309711033365369e-02, 5.8765944434164141e-01, 1.6856507449690348e+01, -6.8342292657673545e+00, 8.9036581290816785e-01, -4.5904138300777919e-01, -6.8342292657673545e+00, 3.9011240056387244e+00, -4.1077122687276202e-02, 5.6895999928936403e-01, 8.9036581290816785e-01, -4.1077122687276202e-02, 2.7435588945926814e-01, 1.9420750375548933e-02, -4.5904138300777919e-01, 5.6895999928936403e-01, 1.9420750375548933e-02, 1.7277500144155888e-01, 1.7645529606875833e+01, -3.2538877192050002e+00, -5.5012517023538066e-01, 1.0677788759412139e+00, -3.2538877192050002e+00, 1.0546932562360065e+00, -2.3658187113371332e-01, 2.1841816790460902e-01, -5.5012517023538066e-01, -2.3658187113371332e-01, 7.1656120537425561e-01, -1.7040630728823944e-01, 1.0677788759412139e+00, 2.1841816790460902e-01, -1.7040630728823944e-01, 5.0974972717888634e-01, 1.7839842450333954e+01, -5.7379299944719877e+00, -1.9569351707197109e+00, 1.7713682302855058e+00, -5.7379299944719877e+00, 2.4328041444884976e+00, -1.7544854846175517e-02, -1.6864721058949111e-01, -1.9569351707197109e+00, -1.7544854846175517e-02, 1.0677513531326404e+00, -5.9215023869599626e-01, 1.7713682302855058e+00, -1.6864721058949111e-01, -5.9215023869599626e-01, 4.6360784428232726e-01, 1.5732517152453081e+01, -7.4014739000296572e+00, -1.6207000095637598e+00, 1.2383190370614494e+00, -7.4014739000296572e+00, 3.9409851277204022e+00, 7.5740083786654211e-01, -5.5800827056355640e-01, -1.6207000095637598e+00, 7.5740083786654211e-01, 7.7642511193896813e-01, -4.9466228929792039e-01, 1.2383190370614494e+00, -5.5800827056355640e-01, -4.9466228929792039e-01, 3.1958775176868037e-01, 1.6183696670937064e+01, -8.4210107899133941e+00, -1.4603023231162975e+00, -4.8487004987150362e-01, -8.4210107899133941e+00, 5.1398804721325435e+00, 2.1595570912014417e-01, 8.3208280045450567e-01, -1.4603023231162975e+00, 2.1595570912014417e-01, 5.4394923212798296e-01, -3.4805126389386676e-01, -4.8487004987150362e-01, 8.3208280045450567e-01, -3.4805126389386676e-01, 4.8452486035887499e-01, 1.6451611837149500e+01, -4.2969418428867261e+00, -7.3888024461400414e-01, -2.0815144409407478e+00, -4.2969418428867261e+00, 1.5430243106399666e+00, 1.8729935762291541e-01, 1.4033663037202498e-01, -7.3888024461400414e-01, 1.8729935762291541e-01, 7.4205169442909757e-01, 5.7628851673904691e-02, -2.0815144409407478e+00, 1.4033663037202498e-01, 5.7628851673904691e-02, 6.5242091014819859e-01, 1.5883062757360207e+01, -7.5907511804771470e+00, -9.7007798581707783e-01, 7.0138283553798109e-01, -7.5907511804771470e+00, 4.0217572548274134e+00, -2.6014708482761550e-02, -5.3204932822260864e-01, -9.7007798581707783e-01, -2.6014708482761550e-02, 1.0259721921051177e+00, -1.8715321271601759e-01, 7.0138283553798109e-01, -5.3204932822260864e-01, -1.8715321271601759e-01, 5.5149306670030152e-01, 1.5978116669665239e+01, -7.4006259214596790e+00, -6.7969646246634663e-01, 6.5546600275605982e-01, -7.4006259214596790e+00, 3.6071706440359010e+00, 5.3491110661316954e-01, -5.2666565248665098e-01, -6.7969646246634663e-01, 5.3491110661316954e-01, 4.7936057181766917e-01, -1.5025322700354665e-01, 6.5546600275605982e-01, -5.2666565248665098e-01, -1.5025322700354665e-01, 4.3112434274449579e-01, 1.6757855414725086e+01, -3.1391994419655687e+00, -3.6827363627511667e+00, -2.7493582565171533e+00, -3.1391994419655687e+00, 1.2878229875735527e+00, 6.2385886839847293e-01, 3.4411042773468631e-01, -3.6827363627511667e+00, 6.2385886839847293e-01, 1.2200979174145221e+00, 9.3261333604507307e-02, -2.7493582565171533e+00, 3.4411042773468631e-01, 9.3261333604507307e-02, 1.1795148354251150e+00, 1.5763176470987085e+01, -7.2993099681066589e+00, 2.1748999120100793e-01, -4.7546386776476129e-01, -7.2993099681066589e+00, 3.4569862729331460e+00, -1.6096289888525245e-01, 3.5019733955885657e-01, 2.1748999120100793e-01, -1.6096289888525245e-01, 4.2354082998887993e-01, -3.1304152419179737e-01, -4.7546386776476129e-01, 3.5019733955885657e-01, -3.1304152419179737e-01, 3.4623783030108429e-01, 1.7657045077804337e+01, -5.4634153749758578e+00, -2.8502393669993009e+00, 1.2603451180663379e+00, -5.4634153749758578e+00, 2.3705777605989660e+00, 4.7298264603542695e-01, -1.8824806410410400e-01, -2.8502393669993009e+00, 4.7298264603542695e-01, 8.1312479693863837e-01, -4.9719372983025689e-01, 1.2603451180663379e+00, -1.8824806410410400e-01, -4.9719372983025689e-01, 4.2735579792528156e-01, 1.7234879466141379e+01, -6.9447619542898051e+00, -1.3909105342656662e+00, -1.4629483521415327e+00, -6.9447619542898051e+00, 3.2257037587765272e+00, 3.4613714263225803e-01, 7.1038882433094597e-01, -1.3909105342656662e+00, 3.4613714263225803e-01, 5.4019461216426035e-01, -2.4590599471464314e-01, -1.4629483521415327e+00, 7.1038882433094597e-01, -2.4590599471464314e-01, 4.4551884917879320e-01, 1.7438713147183115e+01, -8.4187054220745114e+00, 9.9555878171084999e-01, 1.3301908774116342e+00, -8.4187054220745114e+00, 4.1903876236321533e+00, -7.3825814341549312e-01, -6.7163472873814567e-01, 9.9555878171084999e-01, -7.3825814341549312e-01, 5.8548847257088532e-01, 1.6930014844653318e-01, 1.3301908774116342e+00, -6.7163472873814567e-01, 1.6930014844653318e-01, 5.3684670796748524e-01, 1.6505843421877792e+01, -8.9672859383958023e+00, -5.9586737243852639e-01, -4.9508712315185199e-01, -8.9672859383958023e+00, 4.8781866610061115e+00, 2.8538236205314221e-01, 3.0156093579837179e-01, -5.9586737243852639e-01, 2.8538236205314221e-01, 4.8868089712416274e-01, -4.4039031061756390e-01, -4.9508712315185199e-01, 3.0156093579837179e-01, -4.4039031061756390e-01, 4.7201467710741113e-01, 1.8009048716596261e+01, -9.5048416816852885e+00, -1.4889359349719808e+00, 5.5230572557832114e-01, -9.5048416816852885e+00, 5.0429843614824552e+00, 8.0889627597129587e-01, -2.6367499950333312e-01, -1.4889359349719808e+00, 8.0889627597129587e-01, 1.1121395372372715e+00, -9.0442258964978972e-01, 5.5230572557832114e-01, -2.6367499950333312e-01, -9.0442258964978972e-01, 8.5074190371660285e-01, 1.8969812503837847e+01, -7.7867026450257386e+00, 1.6621469974591756e+00, -1.3535726585282810e+00, -7.7867026450257386e+00, 3.2242358228553925e+00, -5.5729571150631485e-01, 5.2143834192344174e-01, 1.6621469974591756e+00, -5.5729571150631485e-01, 7.4287944271406869e-01, -4.0168187357492424e-01, -1.3535726585282810e+00, 5.2143834192344174e-01, -4.0168187357492424e-01, 5.7837665640757685e-01, 1.6268715288654960e+01, -8.9640581019331016e+00, 1.9472562726742195e+00, 1.1634394630256961e+00, -8.9640581019331016e+00, 5.2999985470828141e+00, -9.0781775797605180e-01, -9.9127146007630118e-01, 1.9472562726742195e+00, -9.0781775797605180e-01, 5.5880703055816960e-01, -2.0482720926808279e-02, 1.1634394630256961e+00, -9.9127146007630118e-01, -2.0482720926808279e-02, 4.2314243080374431e-01, 1.7309134332310190e+01, -6.7958317179822716e+00, 1.7430014752690762e-01, 7.4781078592582828e-01, -6.7958317179822716e+00, 2.7832702389289379e+00, -2.9174947002806606e-01, -2.5266256491062944e-01, 1.7430014752690762e-01, -2.9174947002806606e-01, 4.3576818045690519e-01, -8.8896184051415236e-02, 7.4781078592582828e-01, -2.5266256491062944e-01, -8.8896184051415236e-02, 3.9997224840640028e-01, 1.7153574941598098e+01, -6.8846934950832344e+00, 1.8254724366772068e+00, 4.8039342168786198e-01, -6.8846934950832344e+00, 2.8276344038991410e+00, -5.6790635321077287e-01, -1.9270510354144452e-01, 1.8254724366772068e+00, -5.6790635321077287e-01, 6.9227219483725666e-01, -1.2709334375461934e-01, 4.8039342168786198e-01, -1.9270510354144452e-01, -1.2709334375461934e-01, 4.2917978157262676e-01, 1.8132184964363688e+01, -3.1733007722489184e+00, 1.7825953260422662e+00, -1.3140033285181132e+00, -3.1733007722489184e+00, 6.9684206950381822e-01, -5.4962857370590601e-01, -1.0351982721358500e-02, 1.7825953260422662e+00, -5.4962857370590601e-01, 6.5568195496490611e-01, 1.7607191243391238e-01, -1.3140033285181132e+00, -1.0351982721358500e-02, 1.7607191243391238e-01, 6.2263345089164690e-01, 1.6127141186360564e+01, -9.2175933167952362e+00, 4.5482959624410402e-01, 1.5607705465624031e+00, -9.2175933167952362e+00, 5.8646726994165235e+00, -7.6823914094072088e-01, -5.4262462349906693e-01, 4.5482959624410402e-01, -7.6823914094072088e-01, 5.9151161800332619e-01, -2.4286672705208728e-01, 1.5607705465624031e+00, -5.4262462349906693e-01, -2.4286672705208728e-01, 3.5666849406587792e-01, 1.6165753976243874e+01, -7.3811188161212806e+00, -2.9732014153906883e-01, 1.0894338527618317e+00, -7.3811188161212806e+00, 3.4986894854838320e+00, 1.2640223060154221e-02, -7.0520798584256972e-01, -2.9732014153906883e-01, 1.2640223060154221e-02, 5.6149770153482581e-01, 3.6870659678219064e-02, 1.0894338527618317e+00, -7.0520798584256972e-01, 3.6870659678219064e-02, 4.5536900447269846e-01, 1.5398988006027349e+01, -8.1208517349885732e+00, 8.6228252695234930e-01, 1.1537806103765487e+00, -8.1208517349885732e+00, 4.3222427499704104e+00, -5.2765755042823237e-01, -6.0836165343511328e-01, 8.6228252695234930e-01, -5.2765755042823237e-01, 4.7558839586188817e-01, -2.2039226845147369e-01, 1.1537806103765487e+00, -6.0836165343511328e-01, -2.2039226845147369e-01, 3.6326310248611182e-01, 1.6653862335772988e+01, -6.3212833166201801e+00, 1.7035548874689670e+00, 1.7818121037836856e+00, -6.3212833166201801e+00, 3.2372475346428593e+00, -1.6771360201147706e-01, -7.3260377579450964e-01, 1.7035548874689670e+00, -1.6771360201147706e-01, 4.5584861179226355e-01, 1.7938188763718371e-01, 1.7818121037836856e+00, -7.3260377579450964e-01, 1.7938188763718371e-01, 3.0343699262163576e-01, 1.6005636284380316e+01, -8.9463211901340483e+00, -1.4995353233230992e+00, 1.6144976837089247e+00, -8.9463211901340483e+00, 5.4553198002689216e+00, 8.2430401820014310e-01, -7.7450210219583759e-01, -1.4995353233230992e+00, 8.2430401820014310e-01, 3.0203181275741886e-01, -5.0431498184811262e-02, 1.6144976837089247e+00, -7.7450210219583759e-01, -5.0431498184811262e-02, 2.6690426032037673e-01, 1.5957019862552055e+01, -8.4122236810732502e+00, 1.4776406260905088e+00, 1.1752014846148688e+00, -8.4122236810732502e+00, 5.1499519890947365e+00, -1.2438745362258066e+00, -2.4793216417570077e-01, 1.4776406260905088e+00, -1.2438745362258066e+00, 4.3907159105778493e-01, -1.3201484086761139e-01, 1.1752014846148688e+00, -2.4793216417570077e-01, -1.3201484086761139e-01, 2.8971532780081477e-01, 1.7264626784129828e+01, -7.1717293181514563e+00, 1.8173778481524891e-01, 1.6638776173614904e+00, -7.1717293181514563e+00, 3.3498514787396210e+00, 5.3070406002362888e-02, -8.3211897250151612e-01, 1.8173778481524891e-01, 5.3070406002362888e-02, 3.5750188990225340e-01, 1.7905618157975495e-01, 1.6638776173614904e+00, -8.3211897250151612e-01, 1.7905618157975495e-01, 3.5631089226304219e-01, 1.6951331209440209e+01, -6.9265044010797432e+00, 1.6649505088436367e+00, 1.2476223930507584e+00, -6.9265044010797432e+00, 3.0908353140153588e+00, -7.9349084304257178e-01, -5.5641718253825512e-01, 1.6649505088436367e+00, -7.9349084304257178e-01, 5.1957810047939335e-01, -1.8256034059952314e-01, 1.2476223930507584e+00, -5.5641718253825512e-01, -1.8256034059952314e-01, 4.4508123489757256e-01, 1.9012236387930873e+01, -8.2612906987401367e+00, 1.7822397061112394e+00, 1.3130655015793740e+00, -8.2612906987401367e+00, 3.9785776745364090e+00, -4.5911569699280996e-01, -7.8540804412996457e-01, 1.7822397061112394e+00, -4.5911569699280996e-01, 7.1651557376422037e-01, -2.1545675296134048e-01, 1.3130655015793740e+00, -7.8540804412996457e-01, -2.1545675296134048e-01, 3.0131845380712763e-01, 1.6597075714728486e+01, -5.7800006677690803e+00, 1.5381006811275582e+00, -1.5197413389828438e+00, -5.7800006677690803e+00, 3.0963818435550561e+00, -7.6010709310479962e-01, 4.4547615970032189e-01, 1.5381006811275582e+00, -7.6010709310479962e-01, 3.1280696744315561e-01, -1.7575813761777823e-01, -1.5197413389828438e+00, 4.4547615970032189e-01, -1.7575813761777823e-01, 1.6771576241498387e-01, 1.7019126909133337e+01, -6.6527113537535385e+00, 1.3704144651040868e+00, 1.5022343603610107e+00, -6.6527113537535385e+00, 2.9978544936485725e+00, -1.8662862581940526e-01, -6.5208288251651947e-01, 1.3704144651040868e+00, -1.8662862581940526e-01, 5.2409376673618568e-01, -7.5645601483690317e-02, 1.5022343603610107e+00, -6.5208288251651947e-01, -7.5645601483690317e-02, 3.2522439346024634e-01, 1.7662116032947637e+01, -7.3173562685033531e+00, -4.8473999550733515e-01, 1.2177126365029898e+00, -7.3173562685033531e+00, 3.0582743607486380e+00, 9.5372312198528986e-02, -4.4792222499260004e-01, -4.8473999550733515e-01, 9.5372312198528986e-02, 4.2961213757689048e-01, -2.5302983486156821e-01, 1.2177126365029898e+00, -4.4792222499260004e-01, -2.5302983486156821e-01, 3.5756224652772239e-01, 1.6523014322908107e+01, -8.0087006367676903e+00, 1.8183754790473388e+00, 1.3553052743949423e+00, -8.0087006367676903e+00, 4.0733577269970231e+00, -1.1117655839274267e+00, -7.2719651384385020e-01, 1.8183754790473388e+00, -1.1117655839274267e+00, 5.2643538086294572e-01, 1.0149565570079074e-01, 1.3553052743949423e+00, -7.2719651384385020e-01, 1.0149565570079074e-01, 4.9227647014805931e-01, 1.7397143785954697e+01, 9.1482994934314243e-01, -1.2055972918955953e+00, 1.5195127886243485e+00, 9.1482994934314243e-01, 6.0050109036606192e-01, 2.3235888502821123e-01, -2.5896893411041405e-01, -1.2055972918955953e+00, 2.3235888502821123e-01, 4.5114243240770924e-01, -3.9549546725682455e-01, 1.5195127886243485e+00, -2.5896893411041405e-01, -3.9549546725682455e-01, 3.9713449207042850e-01, 1.6754962568939149e+01, -6.9909519455758877e+00, 1.3238214949533700e-02, 1.7461462053388506e+00, -6.9909519455758877e+00, 3.5271059676844763e+00, -4.8608852379905848e-01, -3.9767641403791087e-01, 1.3238214949533700e-02, -4.8608852379905848e-01, 4.6008364836193916e-01, -2.3283300864365591e-01, 1.7461462053388506e+00, -3.9767641403791087e-01, -2.3283300864365591e-01, 3.6997630813085547e-01, 1.6914438459335880e+01, -8.2018573101250176e+00, 1.8607992969625340e+00, 3.6214197147114746e-01, -8.2018573101250176e+00, 4.1440760753178036e+00, -7.4448077344820940e-01, 2.1802370922440709e-02, 1.8607992969625340e+00, -7.4448077344820940e-01, 4.2429585090834404e-01, 1.5770605248055045e-01, 3.6214197147114746e-01, 2.1802370922440709e-02, 1.5770605248055045e-01, 3.0822560548642208e-01, 1.7076011430674352e+01, -8.8780259960025418e+00, 4.1114807990525343e-01, 1.7160868438637338e+00, -8.8780259960025418e+00, 4.6868693538444646e+00, -3.9792997857664614e-01, -7.8413912548256937e-01, 4.1114807990525343e-01, -3.9792997857664614e-01, 4.9907853940129265e-01, -2.2844650397698621e-01, 1.7160868438637338e+00, -7.8413912548256937e-01, -2.2844650397698621e-01, 3.4562144955490959e-01, 1.6875577654372840e+01, -6.7321113543278024e+00, 1.5467259695484039e+00, 1.5835725354604495e+00, -6.7321113543278024e+00, 3.2243427952557981e+00, -3.9371520741376925e-01, -3.6997207365849999e-01, 1.5467259695484039e+00, -3.9371520741376925e-01, 7.3691512999550857e-01, -6.5365934650236268e-02, 1.5835725354604495e+00, -3.6997207365849999e-01, -6.5365934650236268e-02, 4.7827347437249718e-01, 1.7164841669190295e+01, -3.9184842337808603e+00, -1.9330224573943846e+00, -3.5384656982588716e+00, -3.9184842337808603e+00, 1.8459124004525904e+00, -2.7968361445259859e-01, 6.3051523823343891e-01, -1.9330224573943846e+00, -2.7968361445259859e-01, 9.1319007138394170e-01, 4.4823426503524189e-01, -3.5384656982588716e+00, 6.3051523823343891e-01, 4.4823426503524189e-01, 8.1043864783118424e-01, 1.7776298615595469e+01, -8.3125493630052887e+00, -7.7441931055878699e-01, 1.5226098031185762e+00, -8.3125493630052887e+00, 5.1190411322780580e+00, 2.2952835214172629e-02, -1.4773103203139837e-01, -7.7441931055878699e-01, 2.2952835214172629e-02, 8.5889441357603480e-01, -6.9917219907711145e-02, 1.5226098031185762e+00, -1.4773103203139837e-01, -6.9917219907711145e-02, 4.2035440559421033e-01, 1.5862691008342372e+01, -6.1176683909011116e+00, 1.2625855228210956e+00, -1.3435168854108823e+00, -6.1176683909011116e+00, 2.3824446972003832e+00, -5.4326864192360957e-01, 4.7940703668476647e-01, 1.2625855228210956e+00, -5.4326864192360957e-01, 4.3406572657200515e-01, 9.5842602881569275e-02, -1.3435168854108823e+00, 4.7940703668476647e-01, 9.5842602881569275e-02, 2.3854989743717084e-01, 1.8256070397132763e+01, -6.9737979519085576e+00, -2.4828924208535295e+00, -6.8067548292463942e-01, -6.9737979519085576e+00, 2.7984958050555582e+00, 6.3576956667988715e-01, 4.5488849481004173e-01, -2.4828924208535295e+00, 6.3576956667988715e-01, 1.1009943270852411e+00, -2.5112157021262832e-01, -6.8067548292463942e-01, 4.5488849481004173e-01, -2.5112157021262832e-01, 6.3576733446761735e-01, 1.7056582256752865e+01, -7.1009743841647808e+00, 1.1160779926499460e+00, 1.6103269168653844e+00, -7.1009743841647808e+00, 3.1733314893589308e+00, -7.0718250574770325e-01, -4.3660325341089939e-01, 1.1160779926499460e+00, -7.0718250574770325e-01, 5.0309713543792534e-01, -6.0959434222991160e-02, 1.6103269168653844e+00, -4.3660325341089939e-01, -6.0959434222991160e-02, 4.6051187668197546e-01, 1.8357242514234677e+01, -8.7847041747386729e+00, 2.9797124907094874e-01, -2.1027146029189812e+00, -8.7847041747386729e+00, 4.3983224978124813e+00, 1.6771532571466041e-01, 8.6501485551462776e-01, 2.9797124907094874e-01, 1.6771532571466041e-01, 6.6655368883518706e-01, -1.0627500830106132e-01, -2.1027146029189812e+00, 8.6501485551462776e-01, -1.0627500830106132e-01, 4.8427082375374647e-01, 1.6772311022508610e+01, -5.5233743204468615e+00, -1.4827239072848402e+00, -1.6683315295413981e-01, -5.5233743204468615e+00, 2.8632372577610519e+00, -1.9908041485308506e-01, 6.7147007749442378e-02, -1.4827239072848402e+00, -1.9908041485308506e-01, 5.8384443306666967e-01, 1.8696608263835957e-02, -1.6683315295413981e-01, 6.7147007749442378e-02, 1.8696608263835957e-02, 4.1948303453199803e-01, 1.6628501414098437e+01, -8.4601815957694324e+00, -1.2499311118743477e+00, 1.3390492539579859e+00, -8.4601815957694324e+00, 4.3761271922541898e+00, 6.0876619378843877e-01, -5.7252755667562849e-01, -1.2499311118743477e+00, 6.0876619378843877e-01, 5.4159859530740562e-01, 1.6462302179435517e-01, 1.3390492539579859e+00, -5.7252755667562849e-01, 1.6462302179435517e-01, 4.8726092250544450e-01, 1.7067254080129800e+01, -8.6191292214447621e+00, 8.4191297536122567e-01, 1.6991769398963010e+00, -8.6191292214447621e+00, 4.7912823899616992e+00, -9.5325899518160639e-01, -9.9723259667135367e-01, 8.4191297536122567e-01, -9.5325899518160639e-01, 8.3710075559284569e-01, 9.7283473262340187e-02, 1.6991769398963010e+00, -9.9723259667135367e-01, 9.7283473262340187e-02, 3.6200206548711727e-01, 1.7702046820994806e+01, 1.1560960095286070e+00, -3.3325166201283918e+00, -1.4775683676695714e+00, 1.1560960095286070e+00, 1.0791246214081565e+00, 1.8182679840027050e-01, -5.0410612828568047e-01, -3.3325166201283918e+00, 1.8182679840027050e-01, 9.5912816564144698e-01, 3.5209385289513767e-01, -1.4775683676695714e+00, -5.0410612828568047e-01, 3.5209385289513767e-01, 6.1173061322520472e-01, 1.7855425834543190e+01, -3.2697217693515706e+00, 1.4807091014457323e+00, -2.6764346453544805e+00, -3.2697217693515706e+00, 8.3027813273245776e-01, 4.0426879175947228e-02, 3.3848123209104880e-01, 1.4807091014457323e+00, 4.0426879175947228e-02, 6.9975094084688649e-01, -4.2689334899290365e-01, -2.6764346453544805e+00, 3.3848123209104880e-01, -4.2689334899290365e-01, 5.0049960147362493e-01, 1.6401315819584983e+01, -7.9740616572801812e+00, 1.0005058774036371e+00, -1.4203138481446598e+00, -7.9740616572801812e+00, 4.4023705076543553e+00, -9.1941184955615007e-01, 5.7637509877548454e-01, 1.0005058774036371e+00, -9.1941184955615007e-01, 4.5841164275306279e-01, 5.3383138750947870e-02, -1.4203138481446598e+00, 5.7637509877548454e-01, 5.3383138750947870e-02, 1.9979339037632937e-01, 1.7332501002967668e+01, -7.0781330453987845e+00, 9.2037176711584545e-01, -1.7498405404426292e+00, -7.0781330453987845e+00, 3.1470072102227165e+00, -6.9097983597892554e-01, 6.2185046840444402e-01, 9.2037176711584545e-01, -6.9097983597892554e-01, 5.5932116260968723e-01, 2.1858582089281359e-01, -1.7498405404426292e+00, 6.2185046840444402e-01, 2.1858582089281359e-01, 5.2680120312008438e-01, 1.7734484227892562e+01, -5.3654898514610219e+00, -1.6146396348259038e+00, 9.9033821011608625e-01, -5.3654898514610219e+00, 2.0384509120220251e+00, 2.5981041293593549e-01, 1.2547778095454426e-01, -1.6146396348259038e+00, 2.5981041293593549e-01, 7.0973144206899874e-01, -2.6410086403128091e-01, 9.9033821011608625e-01, 1.2547778095454426e-01, -2.6410086403128091e-01, 4.9890531981897601e-01, 1.7373803386373812e+01, -7.3655877697476715e+00, 7.8270125086657205e-02, -2.0999061171249407e+00, -7.3655877697476715e+00, 3.8164841996986887e+00, 3.9641030912017372e-02, 6.5278955794156168e-01, 7.8270125086657205e-02, 3.9641030912017372e-02, 4.1742585469994020e-01, 1.6686881152650240e-02, -2.0999061171249407e+00, 6.5278955794156168e-01, 1.6686881152650240e-02, 3.4144491013516665e-01, 1.7266719068868216e+01, -9.0704352506311370e+00, 1.0694216573455857e+00, -1.5795224196213768e+00, -9.0704352506311370e+00, 5.0037919681802911e+00, -9.3097451917909035e-01, 6.6974458417928873e-01, 1.0694216573455857e+00, -9.3097451917909035e-01, 7.5988767453192230e-01, 7.6311108649566889e-02, -1.5795224196213768e+00, 6.6974458417928873e-01, 7.6311108649566889e-02, 2.9489768008036216e-01, 1.6376515340100283e+01, -6.9793256398089296e+00, 1.5243144645041427e+00, 2.7079268382937571e-01, -6.9793256398089296e+00, 3.0541734354131531e+00, -7.7135074324503605e-01, -6.8397349674078733e-02, 1.5243144645041427e+00, -7.7135074324503605e-01, 3.6395566937932222e-01, 6.2728909404942329e-02, 2.7079268382937571e-01, -6.8397349674078733e-02, 6.2728909404942329e-02, 3.6164470489278866e-01, 1.7516133518582485e+01, -8.3514443126068123e+00, -1.7180303760588957e+00, 1.5748319209869406e+00, -8.3514443126068123e+00, 5.3528291603548226e+00, -3.9980896941006638e-01, -7.0540361469493940e-02, -1.7180303760588957e+00, -3.9980896941006638e-01, 1.2547848615007291e+00, -7.5175461576019531e-01, 1.5748319209869406e+00, -7.0540361469493940e-02, -7.5175461576019531e-01, 5.0207052491314630e-01, 1.6471332655238577e+01, -1.9840240794333170e+00, -2.7675952686613430e+00, 1.7245254662592493e+00, -1.9840240794333170e+00, 1.3786012470006792e+00, -1.7634724450792111e-01, -6.8648055131182217e-01, -2.7675952686613430e+00, -1.7634724450792111e-01, 7.1321367156083215e-01, -1.2327176278311069e-01, 1.7245254662592493e+00, -6.8648055131182217e-01, -1.2327176278311069e-01, 4.9397169669978858e-01, 1.7091226474203204e+01, -4.5675405166074583e+00, 1.4400642541699227e+00, 1.2141833386470169e+00, -4.5675405166074583e+00, 1.3161027292266854e+00, -3.1345863399964818e-01, -5.0066767853585703e-01, 1.4400642541699227e+00, -3.1345863399964818e-01, 6.7234081428616688e-01, -1.3503981152357039e-01, 1.2141833386470169e+00, -5.0066767853585703e-01, -1.3503981152357039e-01, 4.3385283110391992e-01, 1.8246506732367031e+01, -7.6558698630583821e+00, 1.9213354454183826e+00, 1.6373332810021559e+00, -7.6558698630583821e+00, 3.9467944680536289e+00, -4.0297301651530965e-01, -5.2963503443511684e-01, 1.9213354454183826e+00, -4.0297301651530965e-01, 5.3176392085153512e-01, 8.9574705000869517e-02, 1.6373332810021559e+00, -5.2963503443511684e-01, 8.9574705000869517e-02, 4.4536642738675492e-01, 1.7911671783219571e+01, -5.9985252112864700e+00, -4.4745656306102388e-01, 1.1721399057841080e+00, -5.9985252112864700e+00, 2.4139535616836252e+00, -1.7219293329619995e-01, -5.0172832204407780e-01, -4.4745656306102388e-01, -1.7219293329619995e-01, 9.7476836720338544e-01, -3.2171662686669505e-01, 1.1721399057841080e+00, -5.0172832204407780e-01, -3.2171662686669505e-01, 3.0939894061872220e-01, 1.6155032382388242e+01, -7.2064352418320210e+00, 2.5981969792469695e-01, 2.8727950159025917e-01, -7.2064352418320210e+00, 3.9980129943264391e+00, -5.1910321191687969e-01, 3.2409611261106097e-01, 2.5981969792469695e-01, -5.1910321191687969e-01, 6.1299094127694165e-01, -4.6966198549264621e-01, 2.8727950159025917e-01, 3.2409611261106097e-01, -4.6966198549264621e-01, 4.1154555711070495e-01, 1.5942674207027702e+01, -8.2948902984678892e+00, -1.9203061850624374e+00, 3.4964168574330856e-01, -8.2948902984678892e+00, 4.7444890690473800e+00, 6.1177999082136658e-01, -5.6828655972420206e-01, -1.9203061850624374e+00, 6.1177999082136658e-01, 6.4406756760102324e-01, 3.0795787565507104e-01, 3.4964168574330856e-01, -5.6828655972420206e-01, 3.0795787565507104e-01, 3.5590181457520187e-01, 1.6944946717618595e+01, -6.0254959800609988e+00, -2.8357767854573899e+00, 4.1473435870618813e-01, -6.0254959800609988e+00, 3.0665746424677778e+00, 2.3975145045391522e-01, 3.0627924467723289e-01, -2.8357767854573899e+00, 2.3975145045391522e-01, 1.2345787399737920e+00, -3.3814683111213717e-01, 4.1473435870618813e-01, 3.0627924467723289e-01, -3.3814683111213717e-01, 3.3103947150526031e-01, 1.7117314554066201e+01, -8.8236140201371818e+00, 1.0581536138514975e+00, 1.3980599420035920e+00, -8.8236140201371818e+00, 4.8129582535771425e+00, -8.8712259222580214e-01, -7.9225911531011384e-01, 1.0581536138514975e+00, -8.8712259222580214e-01, 5.7517102508127571e-01, 7.2363511911666983e-02, 1.3980599420035920e+00, -7.9225911531011384e-01, 7.2363511911666983e-02, 2.9909589630683520e-01, 1.6972810488291550e+01, -5.9892458751059818e+00, 1.2149630718729185e+00, -2.0798444379053964e+00, -5.9892458751059818e+00, 2.4380332297536320e+00, -2.0344300671588472e-01, 5.3145291090067048e-01, 1.2149630718729185e+00, -2.0344300671588472e-01, 6.6369223311103109e-01, -6.0094731681376024e-04, -2.0798444379053964e+00, 5.3145291090067048e-01, -6.0094731681376024e-04, 5.7957663759360090e-01, 1.7343766938479227e+01, -6.6063740219858600e+00, -2.4017757423619175e+00, 1.6051740578902221e+00, -6.6063740219858600e+00, 3.4993875746971375e+00, -3.2234547803818028e-02, -3.2663881218999763e-01, -2.4017757423619175e+00, -3.2234547803818028e-02, 1.2504135194559383e+00, -5.1587400430594810e-01, 1.6051740578902221e+00, -3.2663881218999763e-01, -5.1587400430594810e-01, 3.0068541586224429e-01, 1.6848023901869816e+01, -7.7245284650863724e+00, -6.3375161950989023e-01, 1.7598733104365907e+00, -7.7245284650863724e+00, 3.6368411257897200e+00, 5.4898635756645486e-01, -9.3708181741907781e-01, -6.3375161950989023e-01, 5.4898635756645486e-01, 7.2509667201839190e-01, -4.1251648474508129e-01, 1.7598733104365907e+00, -9.3708181741907781e-01, -4.1251648474508129e-01, 4.9975565734465982e-01, 1.7511854581625478e+01, -8.5404613942496930e+00, 4.7313924091567117e-01, -5.1532816823540972e-01, -8.5404613942496930e+00, 4.4031820387689145e+00, -3.6267289012126913e-01, -1.3528742104501390e-02, 4.7313924091567117e-01, -3.6267289012126913e-01, 6.9456125684342040e-01, -1.6317464306172286e-01, -5.1532816823540972e-01, -1.3528742104501390e-02, -1.6317464306172286e-01, 4.5384531453753552e-01, 1.6749377427726831e+01, -5.7772682564884885e+00, -1.9377388468336154e+00, 1.2795905554738882e+00, -5.7772682564884885e+00, 2.3751734474029860e+00, 3.8187973000458070e-01, -1.1511718783472463e-01, -1.9377388468336154e+00, 3.8187973000458070e-01, 1.1071634761400777e+00, -9.4204177495531310e-02, 1.2795905554738882e+00, -1.1511718783472463e-01, -9.4204177495531310e-02, 5.0911537749846014e-01, 1.6804926100729805e+01, -6.7694804790437084e+00, 1.3290892723432168e+00, -2.0329912302039057e+00, -6.7694804790437084e+00, 3.0050053244019006e+00, -6.0641807348948229e-01, 6.5667795941713925e-01, 1.3290892723432168e+00, -6.0641807348948229e-01, 4.4527286361472279e-01, -2.5453902810523399e-01, -2.0329912302039057e+00, 6.5667795941713925e-01, -2.5453902810523399e-01, 3.9739245233707388e-01, 1.5868413007832768e+01, -9.6058749345061720e+00, -1.2704002060724218e+00, 8.6185583106525021e-01, -9.6058749345061720e+00, 5.8473081312071127e+00, 7.6752664926696923e-01, -4.0695460424360097e-01, -1.2704002060724218e+00, 7.6752664926696923e-01, 1.1283540336783828e+00, -1.6618593567686379e-01, 8.6185583106525021e-01, -4.0695460424360097e-01, -1.6618593567686379e-01, 4.6113112128941769e-01, 1.8481541594398891e+01, -6.6615632043770274e+00, -7.2359822450546107e-01, -1.4644271889003471e+00, -6.6615632043770274e+00, 2.4918957745186043e+00, 9.0679417982270888e-02, 5.3245874472517518e-01, -7.2359822450546107e-01, 9.0679417982270888e-02, 4.0656985508236138e-01, 1.5911683154833606e-01, -1.4644271889003471e+00, 5.3245874472517518e-01, 1.5911683154833606e-01, 3.2173334280500521e-01, 1.6228236401107939e+01, -8.1101411423722158e+00, 1.3634571880312281e+00, -2.6078480124847037e-03, -8.1101411423722158e+00, 5.1879397503268816e+00, -2.9695259856663125e-01, -6.7344064243872026e-01, 1.3634571880312281e+00, -2.9695259856663125e-01, 5.2461909416950570e-01, -1.3795586005253810e-01, -2.6078480124847037e-03, -6.7344064243872026e-01, -1.3795586005253810e-01, 4.3066586374098781e-01, 1.5589961900178967e+01, -4.5372333345909119e+00, -3.3934718591944404e+00, 1.3540033039710933e+00, -4.5372333345909119e+00, 1.8585499822791560e+00, 6.1587937597953046e-01, -5.8318661350036138e-01, -3.3934718591944404e+00, 6.1587937597953046e-01, 1.4074389868822910e+00, -4.7675943751143041e-01, 1.3540033039710933e+00, -5.8318661350036138e-01, -4.7675943751143041e-01, 4.2143576596484850e-01, 1.5611938835367109e+01, -7.8362555612747959e+00, 1.1634362937361629e+00, 8.1530526315465568e-01, -7.8362555612747959e+00, 4.0174329797324688e+00, -7.4513440796506791e-01, -3.6945515457627198e-01, 1.1634362937361629e+00, -7.4513440796506791e-01, 3.9648861064960028e-01, -3.2953317777742928e-02, 8.1530526315465568e-01, -3.6945515457627198e-01, -3.2953317777742928e-02, 3.7578484154027375e-01, 1.8315149213395173e+01, -7.7012188993654940e+00, 1.1508124885520843e+00, 1.3123590383630339e+00, -7.7012188993654940e+00, 3.4780615549256009e+00, -1.9166820372788307e-01, -7.6063211015438847e-01, 1.1508124885520843e+00, -1.9166820372788307e-01, 5.4468638241889589e-01, -1.2072611619645017e-01, 1.3123590383630339e+00, -7.6063211015438847e-01, -1.2072611619645017e-01, 2.9841808326885588e-01, 1.6362440054767124e+01, -5.9499672523232112e+00, 1.0052721428804259e+00, -1.3668397556002811e+00, -5.9499672523232112e+00, 3.2387435072295325e+00, -7.2396011033843383e-02, -1.5809150279620302e-01, 1.0052721428804259e+00, -7.2396011033843383e-02, 7.2454982301604076e-01, -2.0381095229621829e-01, -1.3668397556002811e+00, -1.5809150279620302e-01, -2.0381095229621829e-01, 5.1930847189189466e-01, 1.5436369548255527e+01, -9.1710802008604020e+00, 1.4209357173119814e+00, -5.2333006294648410e-01, -9.1710802008604020e+00, 5.4880135746084751e+00, -9.2088987123056165e-01, 1.8726405116782840e-01, 1.4209357173119814e+00, -9.2088987123056165e-01, 8.3812049939319733e-01, 2.7683676776817306e-01, -5.2333006294648410e-01, 1.8726405116782840e-01, 2.7683676776817306e-01, 4.1959049781180191e-01, 1.5666964412535105e+01, -9.7207170538441261e+00, 1.4333836194418987e+00, 1.5960317913987163e+00, -9.7207170538441261e+00, 6.6896120732782265e+00, -5.5802284343341291e-01, -1.3529115567912897e+00, 1.4333836194418987e+00, -5.5802284343341291e-01, 4.9413228052236202e-01, -1.9425632733667825e-01, 1.5960317913987163e+00, -1.3529115567912897e+00, -1.9425632733667825e-01, 4.8918814427528240e-01, 1.5290527713026155e+01, -7.6833137332910173e+00, -1.0751883919467500e+00, 1.6910116895309504e+00, -7.6833137332910173e+00, 3.9082192239312277e+00, 4.6621331985589443e-01, -9.1883958537926080e-01, -1.0751883919467500e+00, 4.6621331985589443e-01, 5.9851497650838281e-01, -2.2322179187601654e-01, 1.6910116895309504e+00, -9.1883958537926080e-01, -2.2322179187601654e-01, 3.9830059929712897e-01, 1.7658936182671727e+01, -7.9196848078408060e+00, 2.0235234121177790e+00, 1.4901521845277215e+00, -7.9196848078408060e+00, 3.6001776162691934e+00, -1.0140973115763243e+00, -6.7507570700253083e-01, 2.0235234121177790e+00, -1.0140973115763243e+00, 6.3032871812139324e-01, -7.6750309951210835e-02, 1.4901521845277215e+00, -6.7507570700253083e-01, -7.6750309951210835e-02, 5.4789767104015730e-01, 1.5457997297160160e+01, -6.1526949506673070e+00, 6.7273961399725346e-01, 9.5770758001695433e-01, -6.1526949506673070e+00, 2.7731742075607597e+00, -4.3012052691323910e-01, -1.2255714588398386e-01, 6.7273961399725346e-01, -4.3012052691323910e-01, 3.3958384751714510e-01, -1.2798871872114692e-01, 9.5770758001695433e-01, -1.2255714588398386e-01, -1.2798871872114692e-01, 2.7268656714191419e-01, 1.7503328855994745e+01, -9.9687455312455189e+00, -1.0297062203185405e+00, -1.7031047478256800e+00, -9.9687455312455189e+00, 5.9614589455051270e+00, 6.5247739444482156e-01, 7.6794594281655504e-01, -1.0297062203185405e+00, 6.5247739444482156e-01, 3.5943482704316476e-01, -1.7606821206230184e-02, -1.7031047478256800e+00, 7.6794594281655504e-01, -1.7606821206230184e-02, 3.2716633335958190e-01, 1.6373795057571847e+01, -7.7660482226949981e+00, 1.5882849012515776e+00, -1.8494279583300000e-01, -7.7660482226949981e+00, 3.9632086562391491e+00, -1.0503970491370456e+00, -2.0638321023081674e-01, 1.5882849012515776e+00, -1.0503970491370456e+00, 7.3133644598289149e-01, 1.7037283334568715e-01, -1.8494279583300000e-01, -2.0638321023081674e-01, 1.7037283334568715e-01, 3.6991380078193070e-01, 1.7380218869596824e+01, -4.6733393169385451e+00, -1.0112374919091498e+00, 6.9440806713566350e-01, -4.6733393169385451e+00, 1.7664189364611840e+00, 5.2267413518611217e-01, -4.7073978286014190e-01, -1.0112374919091498e+00, 5.2267413518611217e-01, 7.8792508851916998e-01, -6.0593541507832505e-01, 6.9440806713566350e-01, -4.7073978286014190e-01, -6.0593541507832505e-01, 4.8532777010071737e-01, 1.6688480100290171e+01, -2.4452257429467745e+00, -4.3502468301668573e+00, 2.8686321885832311e-01, -2.4452257429467745e+00, 1.9558655769328408e+00, -2.2650646337660044e-01, 2.7255380760267456e-01, -4.3502468301668573e+00, -2.2650646337660044e-01, 1.8601358238474783e+00, -7.0528037041038183e-01, 2.8686321885832311e-01, 2.7255380760267456e-01, -7.0528037041038183e-01, 8.8533224650523568e-01, 1.7558888970958407e+01, -3.5525153278861916e+00, 1.3269063954226350e+00, 1.2711647576232004e+00, -3.5525153278861916e+00, 1.9328537647668227e+00, -7.6166921543233657e-01, 2.0334544186972267e-01, 1.3269063954226350e+00, -7.6166921543233657e-01, 4.4584049689038086e-01, 2.2203925188891041e-02, 1.2711647576232004e+00, 2.0334544186972267e-01, 2.2203925188891041e-02, 3.5499333012698542e-01, 1.7503104597019327e+01, -8.2902573074777788e+00, 1.4809359053080735e+00, 5.4433271851216269e-01, -8.2902573074777788e+00, 4.7655682747958519e+00, 4.0148581275228912e-02, -8.3819205806563979e-01, 1.4809359053080735e+00, 4.0148581275228912e-02, 7.9084822528710697e-01, -4.0761145344905420e-01, 5.4433271851216269e-01, -8.3819205806563979e-01, -4.0761145344905420e-01, 7.7052589374216640e-01, 1.6708990617842698e+01, -4.8454163020535930e+00, -2.2673879150930514e+00, -7.3833835476206833e-01, -4.8454163020535930e+00, 1.8474149183735951e+00, 5.7960906898683118e-01, -2.9034175784539162e-01, -2.2673879150930514e+00, 5.7960906898683118e-01, 9.1094402341096992e-01, 2.7337020492260133e-01, -7.3833835476206833e-01, -2.9034175784539162e-01, 2.7337020492260133e-01, 6.2002369775813038e-01, 1.6722997168847904e+01, -8.6990946412050523e+00, 3.1803438787591409e-01, 1.7340206087992600e+00, -8.6990946412050523e+00, 4.6729144559920757e+00, -4.4803121361281151e-01, -7.6591403512264922e-01, 3.1803438787591409e-01, -4.4803121361281151e-01, 6.2109380665325764e-01, -2.1702562038719872e-01, 1.7340206087992600e+00, -7.6591403512264922e-01, -2.1702562038719872e-01, 3.0659507102349531e-01, 1.6670375714696366e+01, -6.3873997157981712e+00, 1.1422940619218669e+00, 1.6114990153830422e+00, -6.3873997157981712e+00, 2.7467584657824697e+00, -1.4220435608326074e-01, -7.6707780933203606e-01, 1.1422940619218669e+00, -1.4220435608326074e-01, 4.0764553257721842e-01, -2.8201231903517046e-02, 1.6114990153830422e+00, -7.6707780933203606e-01, -2.8201231903517046e-02, 2.3272465802632000e-01, 1.7177850258051929e+01, -7.7485985175283538e+00, 1.7642463130395969e+00, 1.1947573624901038e+00, -7.7485985175283538e+00, 3.7541650257159613e+00, -9.4830419732951277e-01, -3.4701571693749028e-01, 1.7642463130395969e+00, -9.4830419732951277e-01, 2.7843609384632584e-01, 2.2138492879799063e-02, 1.1947573624901038e+00, -3.4701571693749028e-01, 2.2138492879799063e-02, 2.4621808163691816e-01, 1.7591518642987552e+01, -6.1334674582773179e+00, -1.0188517048841167e-01, -1.0141463265801072e+00, -6.1334674582773179e+00, 2.8881371999494077e+00, -6.5349503463848291e-01, 6.1786208815218846e-01, -1.0188517048841167e-01, -6.5349503463848291e-01, 6.8766586365008342e-01, -1.3177271773416527e-01, -1.0141463265801072e+00, 6.1786208815218846e-01, -1.3177271773416527e-01, 3.5763038289252136e-01, 1.6460555062664469e+01, -1.0801338119838852e-01, -2.1676479110304978e+00, 2.3797610762749716e-01, -1.0801338119838852e-01, 1.0801941303644456e+00, -5.3813243483207052e-01, -5.6237375422626656e-01, -2.1676479110304978e+00, -5.3813243483207052e-01, 5.7967459423528112e-01, 2.4903805958998279e-01, 2.3797610762749716e-01, -5.6237375422626656e-01, 2.4903805958998279e-01, 2.9853118936744938e-01, 1.6363067821237387e+01, -7.5801725217658182e+00, -2.3154589119114033e+00, 8.6491950425521069e-01, -7.5801725217658182e+00, 4.1093160719549147e+00, 7.5936478003922270e-01, -7.9305772741362146e-01, -2.3154589119114033e+00, 7.5936478003922270e-01, 5.5950251851751887e-01, 1.9960092492144615e-02, 8.6491950425521069e-01, -7.9305772741362146e-01, 1.9960092492144615e-02, 3.6240473105355619e-01, 1.7604721419101381e+01, -5.5982944484012851e+00, -5.1115292685000280e-01, 1.1238691719448353e+00, -5.5982944484012851e+00, 1.9974013218860862e+00, 4.2330085337569273e-01, -3.1553160809344194e-01, -5.1115292685000280e-01, 4.2330085337569273e-01, 3.9483438550305838e-01, 1.4146215690809766e-01, 1.1238691719448353e+00, -3.1553160809344194e-01, 1.4146215690809766e-01, 3.0911274591187871e-01, 1.7481000191587800e+01, -8.4105488031411451e+00, 1.3039429588996374e+00, -1.8943355562813982e+00, -8.4105488031411451e+00, 4.2117242584921115e+00, -9.9620212290555921e-01, 7.2096851111157401e-01, 1.3039429588996374e+00, -9.9620212290555921e-01, 1.0262916082555362e+00, 2.6308977000995892e-01, -1.8943355562813982e+00, 7.2096851111157401e-01, 2.6308977000995892e-01, 4.2893693974357433e-01, 1.6142451134319948e+01, -8.5829976232168583e+00, -1.1914111242942487e+00, -1.7828308739068168e+00, -8.5829976232168583e+00, 4.5916185650689387e+00, 6.9925837704708993e-01, 8.5594103603863902e-01, -1.1914111242942487e+00, 6.9925837704708993e-01, 6.4694343394202003e-01, -2.2381142282272101e-01, -1.7828308739068168e+00, 8.5594103603863902e-01, -2.2381142282272101e-01, 5.4706240054847100e-01, 1.6219952760326322e+01, -5.2583246351358710e+00, -1.1318857704341121e+00, 1.5464549680915729e+00, -5.2583246351358710e+00, 1.9538218170664110e+00, 4.7907376803457552e-01, -5.5765002134851860e-01, -1.1318857704341121e+00, 4.7907376803457552e-01, 8.0266791476788724e-01, 4.1910587271559552e-01, 1.5464549680915729e+00, -5.5765002134851860e-01, 4.1910587271559552e-01, 6.1337978657368797e-01, 1.6349812064295705e+01, -9.1250338518494676e+00, 1.4372115668954004e+00, 1.3574151001729744e+00, -9.1250338518494676e+00, 5.6689651253021376e+00, -7.7650769531650343e-01, -1.0781752355166871e+00, 1.4372115668954004e+00, -7.7650769531650343e-01, 5.1241508875946074e-01, -1.1886028240939153e-01, 1.3574151001729744e+00, -1.0781752355166871e+00, -1.1886028240939153e-01, 4.2133699414022918e-01, 1.7730633966916006e+01, -4.2079378425024334e+00, -2.4082318029242074e+00, -2.9326567435152695e+00, -4.2079378425024334e+00, 1.8729697103084302e+00, -1.7025332772484633e-01, 6.4769249581465438e-01, -2.4082318029242074e+00, -1.7025332772484633e-01, 9.6422971517920864e-01, 4.9637876618550530e-01, -2.9326567435152695e+00, 6.4769249581465438e-01, 4.9637876618550530e-01, 9.0607906741843292e-01, 1.6520034768467930e+01, -9.3863666536330559e+00, 1.6290624727505552e+00, 1.0051389816863621e+00, -9.3863666536330559e+00, 5.5944801287984092e+00, -9.4935489921666538e-01, -4.5064099036376648e-01, 1.6290624727505552e+00, -9.4935489921666538e-01, 5.8585060608512141e-01, -2.9952535059011953e-01, 1.0051389816863621e+00, -4.5064099036376648e-01, -2.9952535059011953e-01, 4.7197837495700723e-01, 1.7111516934883419e+01, -6.5918535028673038e+00, 1.6710814028293859e+00, -9.1262323378824761e-01, -6.5918535028673038e+00, 3.0835319597298456e+00, -2.6912281791743353e-01, 4.2893119166797788e-01, 1.6710814028293859e+00, -2.6912281791743353e-01, 4.2342213175980664e-01, -6.1060011100531768e-02, -9.1262323378824761e-01, 4.2893119166797788e-01, -6.1060011100531768e-02, 3.3382324238618233e-01, 1.7310554752654891e+01, -6.3254698558225808e+00, -1.5889046370618964e+00, 4.7998865450534484e-01, -6.3254698558225808e+00, 3.5951424725613625e+00, -4.3752933180985376e-01, -2.0052810357878864e-01, -1.5889046370618964e+00, -4.3752933180985376e-01, 1.1169674552585609e+00, -4.3289156862570732e-01, 4.7998865450534484e-01, -2.0052810357878864e-01, -4.3289156862570732e-01, 1.0348453338540857e+00, 1.5725152411710674e+01, -8.1251695223259723e+00, -1.6221105906193571e+00, -6.5726645228657188e-01, -8.1251695223259723e+00, 4.2655830965537183e+00, 6.8154083535105903e-01, 4.4651245957010732e-01, -1.6221105906193571e+00, 6.8154083535105903e-01, 6.2732001380343250e-01, -2.8865920201796080e-01, -6.5726645228657188e-01, 4.4651245957010732e-01, -2.8865920201796080e-01, 3.1861318811044576e-01, 1.5902288815268022e+01, -8.2452928765255784e+00, -2.0278743230239088e-01, 6.3486533567920422e-01, -8.2452928765255784e+00, 4.6020174712364978e+00, -3.3658080874833285e-01, -4.3977303097587184e-01, -2.0278743230239088e-01, -3.3658080874833285e-01, 6.0187702290916412e-01, 1.1014613257737753e-01, 6.3486533567920422e-01, -4.3977303097587184e-01, 1.1014613257737753e-01, 4.8184779224444352e-01, 1.6317485422902017e+01, -9.0944710620236826e+00, 1.3236077186681450e+00, 1.0543599207408361e+00, -9.0944710620236826e+00, 5.0770952150987654e+00, -6.8283997895415571e-01, -6.1415172571988774e-01, 1.3236077186681450e+00, -6.8283997895415571e-01, 4.6986429225388077e-01, -7.1779176794846591e-02, 1.0543599207408361e+00, -6.1415172571988774e-01, -7.1779176794846591e-02, 3.6646138105239617e-01, 1.6629466429731355e+01, -5.1277919122112783e+00, 1.4340055938268250e+00, 7.5497557373088631e-01, -5.1277919122112783e+00, 2.5533892790953709e+00, -6.1907458698641737e-01, 2.8548716783701866e-01, 1.4340055938268250e+00, -6.1907458698641737e-01, 5.5021114982679775e-01, 2.1988595200875122e-01, 7.5497557373088631e-01, 2.8548716783701866e-01, 2.1988595200875122e-01, 4.6790021907528190e-01, 1.8051015423857478e+01, -6.3374886699541655e+00, 6.7052196738207570e-01, 1.7901863112928220e+00, -6.3374886699541655e+00, 3.6107306567453308e+00, -1.1554776709999790e+00, -1.6138128679965386e-01, 6.7052196738207570e-01, -1.1554776709999790e+00, 6.6215475367233645e-01, -2.0835424063584101e-01, 1.7901863112928220e+00, -1.6138128679965386e-01, -2.0835424063584101e-01, 3.8230347739520337e-01, 1.4983783383912956e+01, -6.5303033327345901e+00, 1.5693503671455411e+00, 1.3115128213232672e+00, -6.5303033327345901e+00, 3.3609306656827300e+00, -3.8347465608612052e-01, -8.5246645597040638e-01, 1.5693503671455411e+00, -3.8347465608612052e-01, 4.6444575454540948e-01, 1.1133056795538820e-01, 1.3115128213232672e+00, -8.5246645597040638e-01, 1.1133056795538820e-01, 4.2050090792459205e-01, 1.6516272469929035e+01, -8.1086408858622381e+00, 1.2444910428820757e+00, 1.4111414188071807e+00, -8.1086408858622381e+00, 4.7397792897538693e+00, -3.4785795277638909e-01, -3.0333528301140100e-01, 1.2444910428820757e+00, -3.4785795277638909e-01, 6.7086370063026790e-01, 2.4773393103872440e-03, 1.4111414188071807e+00, -3.0333528301140100e-01, 2.4773393103872440e-03, 4.3791110589613524e-01, 1.6929227088899484e+01, -7.8477753916727986e+00, 5.9122351013238139e-01, 1.1995974186685161e+00, -7.8477753916727986e+00, 5.0130450761309371e+00, -4.8119378860454465e-01, -7.7299224219143381e-01, 5.9122351013238139e-01, -4.8119378860454465e-01, 6.6837844940101898e-01, -2.8293163674859706e-01, 1.1995974186685161e+00, -7.7299224219143381e-01, -2.8293163674859706e-01, 3.2651017287964618e-01, 1.5491954999314911e+01, -6.9941923612056076e+00, 1.6077749159874175e+00, 7.8834911790693296e-01, -6.9941923612056076e+00, 3.9990238979833492e+00, -3.1324180602386442e-01, -2.9940611862675603e-01, 1.6077749159874175e+00, -3.1324180602386442e-01, 3.8426170077342980e-01, 6.1325558045078110e-02, 7.8834911790693296e-01, -2.9940611862675603e-01, 6.1325558045078110e-02, 1.9844293738738106e-01, 1.8256490990353864e+01, -7.2596656308294474e+00, 7.2457573583544210e-02, 1.6393036849568940e+00, -7.2596656308294474e+00, 3.1514450092236164e+00, 1.1658304601420899e-01, -4.7408825564360935e-01, 7.2457573583544210e-02, 1.1658304601420899e-01, 4.8823333158455351e-01, -9.9774500139366201e-02, 1.6393036849568940e+00, -4.7408825564360935e-01, -9.9774500139366201e-02, 3.6855349855371966e-01, 1.6820120859691094e+01, -6.8557939495607343e+00, 9.3076613697930166e-01, 1.3614159506132830e+00, -6.8557939495607343e+00, 2.8579888611432107e+00, -4.9935124766213668e-01, -5.7041886268769781e-01, 9.3076613697930166e-01, -4.9935124766213668e-01, 4.6829838997314921e-01, -1.4197642929627971e-01, 1.3614159506132830e+00, -5.7041886268769781e-01, -1.4197642929627971e-01, 4.3316577284207314e-01, 1.6419872338608442e+01, -8.5832050734274041e+00, 1.7192566692161901e+00, -5.1218989222962830e-01, -8.5832050734274041e+00, 4.4976512426775175e+00, -9.1124533514664441e-01, 2.8795414896579641e-01, 1.7192566692161901e+00, -9.1124533514664441e-01, 7.4971043306955509e-01, -5.5608503289291955e-01, -5.1218989222962830e-01, 2.8795414896579641e-01, -5.5608503289291955e-01, 4.6700869661319677e-01, 1.8135538967327214e+01, -3.2166336691478290e+00, -2.4622113217501940e+00, -3.6996532735385559e+00, -3.2166336691478290e+00, 1.2549932403658035e+00, -2.2292652269956342e-01, 5.6100325796761008e-01, -2.4622113217501940e+00, -2.2292652269956342e-01, 1.0930566691740100e+00, 4.2547956233729428e-01, -3.6996532735385559e+00, 5.6100325796761008e-01, 4.2547956233729428e-01, 9.9882325270528738e-01, 1.7439351281629058e+01, -5.8296895831009508e+00, 1.5263763648410595e+00, -1.0127116989967861e+00, -5.8296895831009508e+00, 3.0345134422808195e+00, -1.2453100751923698e+00, 2.5921890911740408e-01, 1.5263763648410595e+00, -1.2453100751923698e+00, 6.4872185802115923e-01, -1.0471192819150560e-01, -1.0127116989967861e+00, 2.5921890911740408e-01, -1.0471192819150560e-01, 3.4321528712268262e-01, 1.8225452775936304e+01, -8.3661120474364186e+00, 1.6298037497783302e-01, 1.3744275939125781e+00, -8.3661120474364186e+00, 4.1934382694433019e+00, -4.2888473389741155e-01, -3.3111383016288920e-01, 1.6298037497783302e-01, -4.2888473389741155e-01, 3.9223109407533963e-01, -2.8438634962977571e-01, 1.3744275939125781e+00, -3.3111383016288920e-01, -2.8438634962977571e-01, 3.5861917482977251e-01, 1.7848001583696501e+01, -9.0977146732770837e+00, 1.3037096678166800e+00, -1.3549605490328065e-01, -9.0977146732770837e+00, 4.6663261401614928e+00, -6.7036638792592496e-01, 1.9232787391811296e-01, 1.3037096678166800e+00, -6.7036638792592496e-01, 1.1260447105843117e+00, -9.1370205009458638e-03, -1.3549605490328065e-01, 1.9232787391811296e-01, -9.1370205009458638e-03, 5.2699958100439070e-01
  };
  std::vector<double > em = em_x; 
  std::vector<double> table = {
    -1.0600000163027882e+02, 7.7059358807135015e+02, -5.6954714749735385e+03, 1.2167808756610991e+03, -7.6199102434332218e+01, 1.0706136029373441e+00, -1.0600000164528124e+02, 7.7059358630452323e+02, -5.6954715659539552e+03, 1.2167808757436076e+03, -7.6199099707724926e+01, 1.0706134206080884e+00, -1.0600000163027882e+02, 7.7059358807135015e+02, -5.6954714749735385e+03, 1.2167808756610991e+03, -7.6199102434332218e+01, 1.0706136029373441e+00, -1.0600000164528124e+02, 7.7059358630452323e+02, -5.6954715659539552e+03, 1.2167808757436076e+03, -7.6199099707724926e+01, 1.0706134206080884e+00, -9.6000006759336443e+01, 6.2969719646863621e+02, -4.2053706363664551e+03, 9.0372155784831205e+02, -5.7600014239472898e+01, 8.6528676197113796e-01, -9.6000006828502180e+01, 6.2969718981238339e+02, -4.2053709121998018e+03, 9.0372156236848912e+02, -5.7600006817493266e+01, 8.6528625106787871e-01, -9.6000006759336443e+01, 6.2969719646863621e+02, -4.2053706363664551e+03, 9.0372155784831205e+02, -5.7600014239472898e+01, 8.6528676197113796e-01, -9.6000006828502180e+01, 6.2969718981238339e+02, -4.2053709121998018e+03, 9.0372156236848912e+02, -5.7600006817493266e+01, 8.6528625106787871e-01, -8.6000028021606425e+01, 5.0303296429845562e+02, -3.0008648248894533e+03, 6.4939597734382562e+02, -4.2250984019314707e+01, 6.8180015607155764e-01, -8.6000028340480625e+01, 5.0303293978396903e+02, -3.0008656209622986e+03, 6.4939600529391078e+02, -4.2250965541906716e+01, 6.8179882734268982e-01, -8.6000028021606425e+01, 5.0303296429845562e+02, -3.0008648248894533e+03, 6.4939597734382562e+02, -4.2250984019314707e+01, 6.8180015607155764e-01, -8.6000028340480625e+01, 5.0303293978396903e+02, -3.0008656209622986e+03, 6.4939600529353049e+02, -4.2250965541830588e+01, 6.8179882733888086e-01, -7.6000116148038558e+01, 3.9060139597613619e+02, -2.0515743554479322e+03, 4.4772754091167945e+02, -2.9848087537832814e+01, 5.2014755686537917e-01, -7.6000117618125429e+01, 3.9060130821883052e+02, -2.0515765138621105e+03, 4.4772766653712006e+02, -2.9848047259266409e+01, 5.2014443989116910e-01, -7.6000116148038558e+01, 3.9060139597613619e+02, -2.0515743554479322e+03, 4.4772754091167945e+02, -2.9848087537832814e+01, 5.2014755686537917e-01, -7.6000117618125742e+01, 3.9060130821877993e+02, -2.0515765138659344e+03, 4.4772766652483722e+02, -2.9848047256692499e+01, 5.2014443976043645e-01, -6.6000481290731443e+01, 2.9240425245900917e+02, -1.3271250821434478e+03, 2.9263955624337893e+02, -2.0087224005740719e+01, 3.8031147992206349e-01, -6.6000488067863742e+01, 2.9240394960550276e+02, -1.3271304743966571e+03, 2.9264002765325057e+02, -2.0087154325946980e+01, 3.8030522013794582e-01, -6.6000481290731443e+01, 2.9240425245900917e+02, -1.3271250821434478e+03, 2.9263955624337893e+02, -2.0087224005740719e+01, 3.8031147992206349e-01, -6.6000488067883694e+01, 2.9240394960308691e+02, -1.3271304745319526e+03, 2.9264002727267626e+02, -2.0087154245656002e+01, 3.8030521605011575e-01, -5.6001992867343972e+01, 2.0844745574402617e+02, -7.9715799906587699e+02, 1.7805563184427194e+02, -1.2663929104029080e+01, 2.6224978307822894e-01, -5.6002024103130161e+01, 2.0844646075692629e+02, -7.9717003898786652e+02, 1.7805715054974732e+02, -1.2663864677938077e+01, 2.6224029170957303e-01, -5.6001992867343972e+01, 2.0844745574402617e+02, -7.9715799906587699e+02, 1.7805563184427194e+02, -1.2663929104029080e+01, 2.6224978307822894e-01, -5.6002024104383771e+01, 2.0844646064871867e+02, -7.9717004324410516e+02, 1.7805714044473001e+02, -1.2663862524337585e+01, 2.6224018166598279e-01, -4.6008230210744550e+01, 1.3874976550319553e+02, -4.3134867537287749e+02, 9.7902623595157010e+01, -7.2734403121911884e+00, 1.6589123996688057e-01, -4.6008373996710617e+01, 1.3874671965012058e+02, -4.3137141216256458e+02, 9.7906861443792735e+01, -7.2735856084076280e+00, 1.6588642735924275e-01, -4.6008230210744550e+01, 1.3874976550319553e+02, -4.3134867537287749e+02, 9.7902623595157010e+01, -7.2734403121911884e+00, 1.6589123996688057e-01, -4.6008374075307870e+01, 1.3874671513440606e+02, -4.3137152784492957e+02, 9.7906652364871050e+01, -7.2735401377994249e+00, 1.6588408717348646e-01, -3.6033642533368131e+01, 8.3364086172019398e+01, -1.9942175516407502e+02, 4.6124022747838069e+01, -3.6130563858549958e+00, 9.1249773312287188e-02, -3.6034298111245583e+01, 8.3355843868269616e+01, -1.9945266030093268e+02, 4.6135000705962462e+01, -3.6142786797647353e+00, 9.1293932043118198e-02, -3.6033642533368131e+01, 8.3364086172019398e+01, -1.9942175516407502e+02, 4.6124022747838069e+01, -3.6130563858549958e+00, 9.1249773312287188e-02, -3.6034302998781108e+01, 8.3355675173745269e+01, -1.9945516784358935e+02, 4.6132303200740992e+01, -3.6136582565667807e+00, 9.1261386291659793e-02, -2.6132076703837274e+01, 4.2398929436319683e+01, -7.1037171119057973e+01, 1.3425662262407457e+01, -7.5172495708992593e-01, 7.7522572203268742e-03, -2.6134776894873077e+01, 4.2384732735328775e+01, -7.1030526549717337e+01, 1.3431455085299461e+01, -7.5302028721199155e-01, 7.8186246126207160e-03, -2.6132076703837274e+01, 4.2398929436319683e+01, -7.1037171119057973e+01, 1.3425662262405055e+01, -7.5172495708944420e-01, 7.7522572203027138e-03, -2.6135071381093578e+01, 4.2379566840123424e+01, -7.1067162844830236e+01, 1.3434603316099608e+01, -7.5251233833488806e-01, 7.7734884077347950e-03, -2.2221480705551805e+01, 3.0067218434037404e+01, -4.1779705297521097e+01, -1.9077757705724110e+02, 3.6413466026808294e+02, -1.6067397401486718e+02, -2.2225430071703467e+01, 3.0060809113889512e+01, -4.1712800191721314e+01, -1.9084786311022177e+02, 3.6410062714257685e+02, -1.6063028238785057e+02, -2.2221480705551830e+01, 3.0067218434036263e+01, -4.1779705297545611e+01, -1.9077757705723738e+02, 3.6413466026815809e+02, -1.6067397401492047e+02, -2.2226913938674084e+01, 3.0042371820589185e+01, -4.1801582285426832e+01, -1.9048619249019526e+02, 3.6373874557858261e+02, -1.6052358406417352e+02, -2.1250858373060836e+01, 2.7343847665267702e+01, -3.6044215009418814e+01, -1.7618484800469861e+02, 3.3120085405644409e+02, -1.4534825256321494e+02, -2.1254939505030809e+01, 2.7342716030835884e+01, -3.5955450545431681e+01, -1.7635550119316844e+02, 3.3127447930769307e+02, -1.4533876561022046e+02, -2.1250858373060954e+01, 2.7343847665262818e+01, -3.6044215009514119e+01, -1.7618484800464822e+02, 3.3120085405666612e+02, -1.4534825256338749e+02, -2.1257155379297881e+01, 2.7317691772612619e+01, -3.6063526926252166e+01, -1.7588696592837897e+02, 3.3079005662384850e+02, -1.4519086534447842e+02, -2.0283472228681301e+01, 2.4763027042036295e+01, -3.0876160316998963e+01, -1.6184864900381874e+02, 2.9976970905591691e+02, -1.3084395423768876e+02, -2.0287461515322455e+01, 2.4769400540137131e+01, -3.0762734380983186e+01, -1.6214886052089241e+02, 2.9998995088792128e+02, -1.3088331758129965e+02, -2.0283472228681809e+01, 2.4763027042017129e+01, -3.0876160317336627e+01, -1.6184864900359682e+02, 2.9976970905662938e+02, -1.3084395423826805e+02, -2.0290765181946348e+01, 2.4735639907973120e+01, -3.0892738413082597e+01, -1.6154574482310053e+02, 2.9934595420013272e+02, -1.3068028494926122e+02, -1.9319499689234629e+01, 2.2323824431805683e+01, -2.6243395369841849e+01, -1.4782286378121026e+02, 2.6985759662396487e+02, -1.1715474197881395e+02, -1.9323022570439292e+01, 2.2340565860680357e+01, -2.6102786429129356e+01, -1.4828764857305418e+02, 2.7027298759214750e+02, -1.1726163007473576e+02, -1.9319499689236839e+01, 2.2323824431730525e+01, -2.6243395371031539e+01, -1.4782286378021576e+02, 2.6985759662609979e+02, -1.1715474198068593e+02, -1.9327939259284843e+01, 2.2295320666731183e+01, -2.6257097174199931e+01, -1.4751677383623073e+02, 2.6942341041084092e+02, -1.1698575776762208e+02, -1.8359079763330211e+01, 2.0025118950280675e+01, -2.2113826757823226e+01, -1.3415932552431914e+02, 2.4147795894487624e+02, -1.0427314537549884e+02, -1.8361534194530734e+01, 2.0055847278170305e+01, -2.1944107342764479e+01, -1.3482982214648752e+02, 2.4214772485703989e+02, -1.0447085300268679e+02, -1.8359079763339750e+01, 2.0025118949989704e+01, -2.2113826761939308e+01, -1.3415932552009582e+02, 2.4147795895089951e+02, -1.0427314538136979e+02, -1.8368836959765495e+01, 1.9995657614892380e+01, -2.2124533894067383e+01, -1.3385233293246981e+02, 2.4103659293914149e+02, -1.0410011400771683e+02, -1.7402299525814517e+01, 1.7865597763687486e+01, -1.8455503416511757e+01, -1.2090765118569301e+02, 2.1464125749038132e+02, -9.2190581022134992e+01, -1.7402744551259310e+01, 1.7914800567904472e+01, -1.8255754666855470e+01, -1.2183089355280822e+02, 2.1563582256173194e+02, -9.2507405324257306e+01, -1.7402299525855486e+01, 1.7865597762572605e+01, -1.8455503430527756e+01, -1.2090765116826699e+02, 2.1464125750558804e+02, -9.2190581039770791e+01, -1.7413567239985614e+01, 1.7835392747330133e+01, -1.8463115133795956e+01, -1.2060260469703572e+02, 2.1419685510959093e+02, -9.2015134441585104e+01, -1.6449179896085464e+01, 1.5843762224435309e+01, -1.5236722252652665e+01, -1.0811515163854509e+02, 1.8935506712501905e+02, -8.0897437157402223e+01, -1.6446174965543889e+01, 1.5916874201410112e+01, -1.5007553197461570e+01, -1.0934291295595986e+02, 1.9075532567542470e+02, -8.1366596347119696e+01, -1.6449179896260411e+01, 1.5843762220214204e+01, -1.5236722299508587e+01, -1.0811515156878269e+02, 1.8935506715588940e+02, -8.0897437207525684e+01, -1.6462173655481337e+01, 1.5813096619069219e+01, -1.5241142983208677e+01, -1.0781563484017332e+02, 1.8891289499393798e+02, -8.0721658713418606e+01, -1.5499661595231082e+01, 1.3957945516559789e+01, -1.2426145992195885e+01, -9.5826844741964834e+01, 1.6562434781973772e+02, -7.0383233416004117e+01, -1.5491037589250178e+01, 1.4061349904707843e+01, -1.2170301483989650e+01, -9.7412966929875139e+01, 1.6751874597575440e+02, -7.1041920384880939e+01, -1.5499661595973759e+01, 1.3957945500778198e+01, -1.2426146145776961e+01, -9.5826844470313858e+01, 1.6562434784656404e+02, -7.0383233547510557e+01, -1.5514618579274794e+01, 1.3927192540790591e+01, -1.2427264674287118e+01, -9.5537423121432880e+01, 1.6519113036542510e+02, -7.0209783384625098e+01, -1.4553592409098401e+01, 1.2206343505203831e+01, -9.9929274597052196e+00, -8.4085595900823435e+01, 1.4345191724964303e+02, -6.0636862050381758e+01, -1.4536130507533649e+01, 1.2347228125716077e+01, -9.7159302678980044e+00, -8.6081002959763751e+01, 1.4592996741513730e+02, -6.1523840242331410e+01, -1.4553592412232879e+01, 1.2206343446986155e+01, -9.9929279524397305e+00, -8.4085594870780753e+01, 1.4345191706222485e+02, -6.0636862352071532e+01, -1.4570766853404239e+01, 1.2175998366492486e+01, -9.9905856922863112e+00, -8.3812185051328299e+01, 1.4303633648493073e+02, -6.0469165577726159e+01, -1.3610717065161962e+01, 1.0587059629986399e+01, -7.9068321681349163e+00, -7.2932404423885004e+01, 1.2283913327111270e+02, -5.1646910322317169e+01, -1.3579708436673444e+01, 1.0773027159520954e+01, -7.6175370796795425e+00, -7.5376833196183071e+01, 1.2597958225245242e+02, -5.2797863799745748e+01, -1.3610717078313911e+01, 1.0587059418306087e+01, -7.9068337121483454e+00, -7.2932400620636059e+01, 1.2283913169238102e+02, -5.1646910832841897e+01, -1.3630368323321786e+01, 1.0557789879027116e+01, -7.9007777139483810e+00, -7.2682825476758552e+01, 1.2245259140017740e+02, -5.1489446559796768e+01, -1.2670671078399982e+01, 9.0981634949263963e+00, -6.1383490362855788e+00, -6.2406844162279825e+01, 1.0378677653422224e+02, -4.3402055519687693e+01, -1.2619333100308433e+01, 9.3364634226935799e+00, -5.8491811509717584e+00, -6.5316414528433455e+01, 1.0763857666200300e+02, -4.4841832720191050e+01, -1.2670671133253135e+01, 9.0981627374157021e+00, -6.1383537481895356e+00, -6.2406830503476570e+01, 1.0378676818216074e+02, -4.3402055529436716e+01, -1.2693036794620980e+01, 9.0708908225804148e+00, -6.1281713411274001e+00, -6.2191660620037396e+01, 1.0344456594081470e+02, -4.3260806640248063e+01, -1.1732979767504439e+01, 7.7377614739662697e+00, -4.6587775146685351e+00, -5.2547655563671029e+01, 8.6296103981829802e+01, -3.5891515805495345e+01, -1.1651721415208119e+01, 8.0340005825064456e+00, -4.3852919661646119e+00, -5.5898160750405737e+01, 9.0851291378134590e+01, -3.7622755083739385e+01, -1.1732979994779518e+01, 7.7377588120662892e+00, -4.6587914600219875e+00, -5.2547607987974565e+01, 8.6296066930227624e+01, -3.5891510429190419e+01, -1.1758218632638741e+01, 7.7137968422318544e+00, -4.6438239588320966e+00, -5.2381405657406454e+01, 8.6019170302439520e+01, -3.5774653697918737e+01, -1.0797063195543267e+01, 6.5040766534586290e+00, -3.4402783696562169e+00, -4.3393478931462226e+01, 7.0370032342568010e+01, -2.9105535302381853e+01, -1.0672637254876815e+01, 6.8603244928014488e+00, -3.1995767859681346e+00, -4.7101348454718874e+01, 7.5530774605740319e+01, -3.1094453979913311e+01, -1.0797064129672576e+01, 6.5040675030570139e+00, -3.4403181344841500e+00, -4.3393319126804485e+01, 7.0369884883020177e+01, -2.9105501594155889e+01, -1.0825134802124644e+01, 6.4853446725127366e+00, -3.4195560956016346e+00, -4.3296381389022351e+01, 7.0187483762520671e+01, -2.9024415860031247e+01, -9.8622468030169337e+00, 5.3955359781222549e+00, -2.4558741324534137e+00, -3.4983728078555984e+01, 5.6014425934291204e+01, -2.3035887876475471e+01, -9.6769173769353625e+00, 5.8079540801032961e+00, -2.2635143148159220e+00, -3.8890523502249145e+01, 6.1563046720547966e+01, -2.5198820521877391e+01, -9.8622505990399034e+00, 5.3955054149765509e+00, -2.4559821583353774e+00, -3.4983216045684472e+01, 5.6013889382190079e+01, -2.3035736114340502e+01, -9.8926597117464805e+00, 5.3849440641688187e+00, -2.4279562878572039e+00, -3.4983707025980287e+01, 5.5966629574570753e+01, -2.3006306589550750e+01, -8.9277749780883457e+00, 4.4108678323349286e+00, -1.6793815271288624e+00, -2.7359655656676122e+01, 4.3239544183593061e+01, -1.7676416286664047e+01, -8.6587749152265552e+00, 4.8674392165289442e+00, -1.5450097170494306e+00, -3.1230915545542118e+01, 4.8829474992442343e+01, -1.9874755288141955e+01, -8.9277901202336185e+00, 4.4107699183102085e+00, -1.6796551456533098e+00, -2.7358123514289456e+01, 4.3237769027728554e+01, -1.7675844947587926e+01, -8.9590559763951383e+00, 4.4128957610428623e+00, -1.6423658138809611e+00, -2.7493743583145054e+01, 4.3380518846300511e+01, -1.7719639183506050e+01, -7.9928164326293913e+00, 3.5492331091008302e+00, -1.0852462622393610e+00, -2.0565792757352423e+01, 3.2061909496398073e+01, -1.3023704651715642e+01, -7.6125412569887647e+00, 4.0287966748633526e+00, -1.0084592804412351e+00, -2.4116992333062022e+01, 3.7252797603904497e+01, -1.5077495076198684e+01, -7.9928747817255603e+00, 3.5489404571097585e+00, -1.0858609980296849e+00, -2.0561701094768868e+01, 3.2056747083970720e+01, -1.3021877019728107e+01, -8.0213899495838241e+00, 3.5708128515175943e+00, -1.0368753205735253e+00, -2.0877831538201836e+01, 3.2456559535389509e+01, -1.3165540198118645e+01, -7.0564174984379102e+00, 2.8104770395789380e+00, -6.4821407306458223e-01, -1.4652118176169953e+01, 2.2507145963021038e+01, -9.0780963613608154e+00, -6.5338936679228468e+00, 3.2846161494194233e+00, -6.1760141818709846e-01, -1.7606122820367215e+01, 2.6855555289500277e+01, -1.0803821410528570e+01, -7.0566263531717324e+00, 2.8097184139861691e+00, -6.4925197579297411e-01, -1.4643483271177150e+01, 2.2495243692983838e+01, -9.0734373052814821e+00, -7.0742646195707266e+00, 2.8621047467298468e+00, -5.8641470402843421e-01, -1.5178915176777426e+01, 2.3211717123277591e+01, -9.3414295847965061e+00, -6.1172231064332783e+00, 2.1957964102200167e+00, -3.4265643705632465e-01, -9.6769153352706798e+00, 1.4613873405033004e+01, -5.8450824172251430e+00, -5.4212678780860326e+00, 2.6341589573018260e+00, -3.4085224757280796e-01, -1.1835854891340576e+01, 1.7794701474942944e+01, -7.1075278532253687e+00, -6.1178367984533244e+00, 2.1945528943967396e+00, -3.4261268423617658e-01, -9.6695829134679272e+00, 1.4600877298870854e+01, -5.8381668136523013e+00, -6.1072022151656586e+00, 2.2922503774685161e+00, -2.6715334266026142e-01, -1.0408120531614587e+01, 1.5617405440391840e+01, -6.2270636615178061e+00, -5.1722074807324017e+00, 1.7098190643016411e+00, -1.4098618492175408e-01, -5.7061337346696464e+00, 8.4331806866534098e+00, -3.3349192888568142e+00, -4.2766424379800121e+00, 2.0860564217794284e+00, -1.5548660419053545e-01, -7.0034949575065015e+00, 1.0332245608764421e+01, -4.0873492185766374e+00, -5.1727690165421372e+00, 1.7132539127425084e+00, -1.2776576793785877e-01, -5.7565343018918274e+00, 8.4941254548170697e+00, -3.3479852132230872e+00, -5.0998839330979591e+00, 1.8678855512825561e+00, -5.7718910331047868e-02, -6.5095346397755423e+00, 9.5462002113817768e+00, -3.7632628689263172e+00, -4.2112469382255613e+00, 1.3675717927787789e+00, -9.4961575783498800e-03, -2.7877417589321136e+00, 3.9953503912711956e+00, -1.5499906707437840e+00, -3.1046711877098376e+00, 1.6568346830533449e+00, -4.5990009889900242e-02, -3.3140676307068091e+00, 4.7472200808709299e+00, -1.8492173878772247e+00, -4.1976749320353317e+00, 1.4246952243441517e+00, 8.7531923058200650e-02, -3.0996975434049761e+00, 4.4668738099197531e+00, -1.7103055321708385e+00, -4.0163145894665320e+00, 1.5923303121893606e+00, 5.8249749369824022e-02, -3.3748048713195491e+00, 4.7925769874900315e+00, -1.8598420111853879e+00, -3.1955533414298376e+00, 1.2168024121915868e+00, 9.9474205814620603e-02, -8.6811124876189694e-01, 1.1994338853723501e+00, -4.4837238870567747e-01, -1.9098914522594992e+00, 1.3654451552507061e+00, 2.9537044429980407e-03, -9.3701125207094127e-01, 1.2575365835116745e+00, -4.7248060681970733e-01, -3.0285770502890443e+00, 1.6166340190704305e+00, 4.8662683065338386e-01, -1.2308607057515726e+00, 1.6114560066217587e+00, -6.5896729332189652e-01, -2.8078044229222514e+00, 1.4555130910035559e+00, 9.0876948497501955e-02, -1.0566809618626720e+00, 1.3938154223720176e+00, -5.2279617091852160e-01, -1.9963264755188566e+00, 1.3672906754961440e+00, 2.0801988470625002e-01, 2.0083818728351077e-02, -1.5135587406137185e-02, -1.4175240342178652e-02, -6.9344786794476854e-01, 1.2280621078720415e+00, 1.2333381103148277e-02, -1.0895386066093759e-02, 2.1764282171790141e-02, -1.0106900291744604e-02, -1.2036881930169383e+00, 2.0482931230000392e+00, -1.2689218008973949e-01, -5.0580690719339239e-01, 3.4047786101030464e-01, -7.0959386937004015e-02, -1.4470760938303664e+00, 1.4285049373060201e+00, 5.5764887956399375e-02, -2.9461990750009881e-02, 2.3005167601875431e-02, -1.0760396189439407e-02, -4.3024292433642597e-01, 1.7121633497582587e+00, 3.5705413032693957e-02, -9.9216800479772127e-01, 1.5115432403429119e+00, -6.3985596276149748e-01, 5.4770961684437192e-01, 1.2565653391084903e+00, 9.1639130181564755e-03, -6.8547618650262643e-01, 1.2037212931265591e+00, -5.1526772142324506e-01, 4.8142431677326969e-01, 1.2842025505965851e+00, -3.1103960497811806e-01, -3.8667287940463613e-01, 9.2663039525338942e-01, -4.1330437951972537e-01, 1.9976512094478704e-02, 1.4898674304290889e+00, -2.1940405767858565e-03, -8.0791207141984167e-01, 1.3979310081478775e+00, -5.9845265079421794e-01, 1.1971451112382212e+00, 1.6539633089946477e+00, -2.7009878691796618e-01, -2.8868139196850624e+00, 4.7294193613612734e+00, -1.9578020397520424e+00, 1.8164162541717044e+00, 1.4570111710269262e+00, 2.2385898037164991e-02, -3.1195681762439769e+00, 4.9723722392038878e+00, -2.0423972644796100e+00, 1.5812403987207633e+00, 1.1421043858413655e+00, -4.4319666868952730e-02, -2.3144705949527720e+00, 3.7448930479898297e+00, -1.5426803544433196e+00, 1.4992161878806018e+00, 1.6612039136364238e+00, -2.2870713891204597e-02, -3.4442115437939465e+00, 5.5057190995408973e+00, -2.2657208348376137e+00, 2.4658130352390710e+00, 1.5819912227884063e+00, -1.3204477532594588e-01, -5.7752803465671017e+00, 9.0677018990478242e+00, -3.6843468204828174e+00, 3.1062201217160963e+00, 1.8205810727868250e+00, 7.3942159732456811e-02, -7.3418038323250947e+00, 1.1309154676354810e+01, -4.5733470083866452e+00, 2.5667672162869133e+00, 1.3762236869878626e+00, 5.4823291778512563e-02, -5.5558964069977943e+00, 8.5620133672289516e+00, -3.4575259608624478e+00, 2.9333361085351610e+00, 1.9771000784477066e+00, 2.1600903596218385e-02, -7.7786452012965430e+00, 1.2026327126407146e+01, -4.8722408979121159e+00, 3.5238342146994350e+00, 1.8411341262124141e+00, 1.0485737443151430e-01, -1.0316470080846322e+01, 1.5628354265192609e+01, -6.2547428286449396e+00, 4.3947471898784478e+00, 2.3129375587624681e+00, 1.6998863701958250e-01, -1.3069120913924280e+01, 1.9764673064124775e+01, -7.9234176878170990e+00, 3.5464051944219954e+00, 1.7786047141550632e+00, 1.8395466553434961e-01, -1.0256713338978345e+01, 1.5450540198835597e+01, -6.1709943751208902e+00, 4.3074781177775723e+00, 2.4284702978185178e+00, 1.2121907902830774e-01, -1.3510697720561426e+01, 2.0490823414440431e+01, -8.2265504110307699e+00, 4.5269670710447079e+00, 2.3411415500822019e+00, 3.7814443659878427e-01, -1.6533454371385766e+01, 2.4532574055181296e+01, -9.7222898630871342e+00, 5.6498078480438974e+00, 2.8871559084424092e+00, 3.1648740182441881e-01, -1.9832336139347099e+01, 2.9630584562783888e+01, -1.1804975183138390e+01, 4.5317970588477650e+00, 2.3235629480266455e+00, 4.0711209040396701e-01, -1.6523611973754900e+01, 2.4482080409856291e+01, -9.6968326211377835e+00, 5.6107427774726322e+00, 2.9693568967987254e+00, 2.6856229367890733e-01, -2.0186235796983127e+01, 3.0228033555488111e+01, -1.2057362656117963e+01, 5.5230828784340904e+00, 3.0159142144119913e+00, 7.5032702265793638e-01, -2.4452361306480910e+01, 3.5745746299744695e+01, -1.4059387633540990e+01, 6.8467243986091164e+00, 3.5205846294935204e+00, 5.5323452910250115e-01, -2.7424447720726722e+01, 4.0542113968978946e+01, -1.6058340606199877e+01, 5.5241079122419858e+00, 3.0111097413061287e+00, 7.6043241689918206e-01, -2.4453330947201032e+01, 3.5733842835424838e+01, -1.4052622761934279e+01, 6.8330970703372866e+00, 3.5730950345697865e+00, 5.0442967447855436e-01, -2.7630302835415993e+01, 4.0921397061842079e+01, -1.6223699529825666e+01, 6.5233214752268127e+00, 3.8455313715589599e+00, 1.2738445662734672e+00, -3.4142511056048967e+01, 4.9288751118195229e+01, -1.9258816488331760e+01, 7.9798691992574877e+00, 4.2304633704347614e+00, 9.4916911879724064e-01, -3.6082800915305256e+01, 5.2740474636382487e+01, -2.0757970588732530e+01, 6.5235391967368317e+00, 3.8442392655293900e+00, 1.2772689685023881e+00, -3.4144245582802192e+01, 4.9286600694030149e+01, -1.9257235266278844e+01, 7.9780164759860508e+00, 4.2581364755189171e+00, 9.0490824102641643e-01, -3.6146890048111374e+01, 5.2902251888236343e+01, -2.0834714063750525e+01, 7.5301209868737518e+00, 4.8266093670811516e+00, 1.9906532239804082e+00, -4.5696171225139402e+01, 6.5222794336738914e+01, -2.5330008845677121e+01, 9.0592048208341964e+00, 5.0524444639807982e+00, 1.5639083038511417e+00, -4.6227354827270197e+01, 6.6742768625790532e+01, -2.6090733281390481e+01, 7.5301672757177256e+00, 4.8262668988539703e+00, 1.9917837214882572e+00, -4.5697152262800707e+01, 6.5222641787790508e+01, -2.5329699752317662e+01, 9.0617089689058279e+00, 5.0627200474303731e+00, 1.5306087886050987e+00, -4.6201245261995687e+01, 6.6753711704174307e+01, -2.6103836713323240e+01, 8.5439978438576958e+00, 5.9605352581937785e+00, 2.9388171122244109e+00, -5.9213652478598007e+01, 8.3623964589400401e+01, -3.2288651007290504e+01, 1.0100238105795977e+01, 6.0156046860821641e+00, 2.4311227628788585e+00, -5.8189717323516248e+01, 8.2972590004142106e+01, -3.2212869674305303e+01, 8.5440076687321067e+00, 5.9604459430021439e+00, 2.9391801366526531e+00, -5.9214078468041464e+01, 8.3624068891376510e+01, -3.2288610777657510e+01, 1.0103667533796683e+01, 6.0158650887345448e+00, 2.4107760944314816e+00, -5.8125625048064265e+01, 8.2906979417176174e+01, -3.2191629006406409e+01, 9.5650113177877785e+00, 7.2498153679976820e+00, 4.1551371399277919e+00, -7.4795843598083408e+01, 1.0457037732454131e+02, -4.0151433068943419e+01, 1.1116968561077568e+01, 7.1347098863330896e+00, 3.5688140741297674e+00, -7.2151486218593305e+01, 1.0165680693075836e+02, -3.9206269356622016e+01, 9.5650133940644455e+00, 7.2497924894015711e+00, 4.1552503042122613e+00, -7.4796005009548836e+01, 1.0457044971811401e+02, -4.0151435976986221e+01, 1.1120034079668221e+01, 7.1303147700774092e+00, 3.5594873892317103e+00, -7.2082067018068685e+01, 1.0156598726189708e+02, -3.9171834664292227e+01, 1.0593064483227742e+01, 8.6969028070512202e+00, 5.6755396034912966e+00, -9.2539537763180832e+01, 1.2813560149579646e+02, -4.8933613418447223e+01, 1.2119543877083460e+01, 8.4137603187360543e+00, 4.9925034366798311e+00, -8.8194505075704640e+01, 1.2287993196505218e+02, -4.7096724506223822e+01, 1.0593064919257221e+01, 8.6968970567044934e+00, 5.6755738143875760e+00, -9.2539593640863643e+01, 1.2813563331215474e+02, -4.8933618162805772e+01, 1.2121921818513506e+01, 8.4078642204619420e+00, 4.9908632634858190e+00, -8.8134432374832016e+01, 1.2279086550380391e+02, -4.7060844505587738e+01, 1.1627957207938659e+01, 1.0303707615441018e+01, 7.5344011042552923e+00, -1.1253294830348190e+02, 1.5438372244089408e+02, -5.8647453529357783e+01, 1.3114510015623049e+01, 9.8513572940713416e+00, 6.7213349376406626e+00, -1.0635738219113546e+02, 1.4665751311861146e+02, -5.5881528760137869e+01, 1.1627957298834614e+01, 1.0303706197478814e+01, 7.5344111366673712e+00, -1.1253296638384563e+02, 1.5438373415898508e+02, -5.8647455853629580e+01, 1.3116237925845430e+01, 9.8455331102145145e+00, 6.7243141059359051e+00, -1.0631074264006560e+02, 1.4658112805680690e+02, -5.5849452095162235e+01, 1.2669386535689361e+01, 1.2071287030293307e+01, 9.7633555455962835e+00, -1.3485075345900265e+02, 1.8336444946299886e+02, -6.9300787627414508e+01, 1.4105804414673191e+01, 1.1444289269702800e+01, 8.7789794745243590e+00, -1.2666835962860844e+02, 1.7298274034188972e+02, -6.5547771558832267e+01, 1.2669386554490638e+01, 1.2071286687068984e+01, 9.7633584027450482e+00, -1.3485075900242089e+02, 1.8336445335820781e+02, -6.9300788508071975e+01, 1.4107018463574896e+01, 1.1439185153305873e+01, 8.7843335749580440e+00, -1.2663444344319166e+02, 1.7292158897636148e+02, -6.5521162694327174e+01, 1.3716937488160630e+01, 1.3999597459400730e+01, 1.2389915672436279e+01, -1.5954894249539399e+02, 2.1510813446746886e+02, -8.0895567204040049e+01, 1.5095682313349364e+01, 1.3189272906323732e+01, 1.1192627051714643e+01, -1.4915916817312757e+02, 2.0184825850919157e+02, -7.6081293415969839e+01, 1.3716937492019641e+01, 1.3999597377767842e+01, 1.2389916464009524e+01, -1.5954894412085929e+02, 2.1510813567394996e+02, -8.0895567498068928e+01, 1.5096520030681436e+01, 1.3185064407456906e+01, 1.1198910160279951e+01, -1.4913565617175487e+02, 2.0180124290250004e+02, -7.6060129778156622e+01, 1.4770075388032444e+01, 1.6087303167766446e+01, 1.5436222950666867e+01, -1.8666021493779203e+02, 2.4962122089688103e+02, -9.3426463524457304e+01, 1.6085379191481852e+01, 1.5083589447287226e+01, 1.3991739427782750e+01, -1.7386892459375579e+02, 2.3325385095807121e+02, -8.7470099643500802e+01, 1.4770075388818769e+01, 1.6087303148664304e+01, 1.5436223164442264e+01, -1.8666021539675981e+02, 2.4962122125116741e+02, -9.3426463615076329e+01, 1.6085951551006787e+01, 1.5080238931969067e+01, 1.3998101278449143e+01, -1.7385331837944693e+02, 2.3321864790104019e+02, -8.7453697552144448e+01, 1.5828143941097450e+01, 1.8331670220961666e+01, 1.8918268274003861e+01, -2.1619095210442941e+02, 2.8688297635978756e+02, -1.0687973526499771e+02, 1.7075534787366465e+01, 1.7125200136366264e+01, 1.7207074959934751e+01, -2.0084388544719391e+02, 2.6720765911058965e+02, -9.9705133726570395e+01, 1.5828143941256627e+01, 1.8331670216557445e+01, 1.8918268330404022e+01, -2.1619095222989833e+02, 2.8688297645950814e+02, -1.0687973529137253e+02, 1.7075923730873765e+01, 1.7122590193964911e+01, 1.7213058024904747e+01, -2.0083402645820061e+02, 2.6718180837697332e+02, -9.9692640534772679e+01, 1.6890371426423382e+01, 2.0728579569842751e+01, 2.2845917469463828e+01, -2.4812083435502871e+02, 3.2684448823688496e+02, -1.2123263616047282e+02, 1.8066449820492846e+01, 1.9312661524160735e+01, 2.0870036016187061e+01, -2.3013589616073858e+02, 3.0372498377642154e+02, -1.1277999824352135e+02, 1.6890371426455424e+01, 2.0728579568840633e+01, 2.2845917484032956e+01, -2.4812083438838550e+02, 3.2684448826399682e+02, -1.2123263616782057e+02, 1.8066713333743454e+01, 1.9310657703202459e+01, 2.0875423564416035e+01, -2.3013008228413184e+02, 3.0370630494679148e+02, -1.1277060230387309e+02, 1.7955886187113396e+01, 2.3272683588860026e+01, 2.7223982220959247e+01, -2.8240595076334000e+02, 3.6943078590316281e+02, -1.3645364576977221e+02, 1.9058236733002300e+01, 2.1644988962398710e+01, 2.5012267757287322e+01, -2.6180071928343307e+02, 3.4282650121799617e+02, -1.2669036882336400e+02, 1.7955886187119816e+01, 2.3272683588634656e+01, 2.7223982224651898e+01, -2.8240595077199526e+02, 3.6943078591032139e+02, -1.3645364577174797e+02, 1.9058414960148450e+01, 2.1643466247439289e+01, 2.5016983354038196e+01, -2.6179767020610126e+02, 3.4281320617581565e+02, -1.2668337355331974e+02, 1.9023741366983238e+01, 2.5957710504548576e+01, 3.2054387652193789e+01, -3.1898571318422574e+02, 4.1454655650462962e+02, -1.5250373535684176e+02, 2.0050906563887416e+01, 2.4121527381838824e+01, 2.9665428981325245e+01, -2.9589665055055406e+02, 3.8453661583827250e+02, -1.4143340987287985e+02, 1.9023741366984520e+01, 2.5957710504498362e+01, 3.2054387653114766e+01, -3.1898571318642672e+02, 4.1454655650647550e+02, -1.5250373535735841e+02, 2.0051026978020587e+01, 2.4120379273875816e+01, 2.9669474257430963e+01, -2.9589543070583102e+02, 3.8452729731205977e+02, -1.4142824748467820e+02, 2.0092947487287756e+01, 2.8776895490568755e+01, 3.7339233558876920e+01, -9.8781982607414882e+00, 7.0916635282296292e-01, -1.2340880155534291e-02, 2.1044418341890132e+01, 2.6741847681518077e+01, 3.4861073630499796e+01, -9.1700568642165461e+00, 6.5220324713443967e-01, -1.1045071585279443e-02, 2.0092947487288011e+01, 2.8776895490557653e+01, 3.7339233559103448e+01, -9.8781982608033179e+00, 7.0916635282857932e-01, -1.2340880155703077e-02, 2.1044499630877905e+01, 2.6740987496092696e+01, 3.4864491165514394e+01, -9.1707199731434574e+00, 6.5223741134844682e-01, -1.1045188698410773e-02, 2.1162510215379026e+01, 3.1723491960797684e+01, 4.3084295875067085e+01, -4.1033675985379521e+00, -6.6095139594000130e-01, 6.0977735530407223e-02, 2.2038706806958309e+01, 2.9505670300337073e+01, 4.0630600131872811e+01, -2.7905442844326718e+00, -8.3885972791335117e-01, 6.8309956404426039e-02, 2.1162510215379076e+01, 3.1723491960795304e+01, 4.3084295875120795e+01, -4.1033675985539224e+00, -6.6095139593840913e-01, 6.0977735530354210e-02, 2.2038761643178379e+01, 2.9505029336592230e+01, 4.0633451796171073e+01, -2.7913314472201640e+00, -8.3878528163749511e-01, 6.8307595298566767e-02, 3.1719012432820758e+01, 6.7480322661109355e+01, 1.3318978565899991e+02, -1.6791944323404795e+01, -1.0181217992701848e+00, 1.2989592638281225e-01, 3.2009499874031789e+01, 6.5013296175889408e+01, 1.3669799889514238e+02, -1.7009031615065428e+01, -1.0689880784706638e+00, 1.3388972346122466e-01, 3.1719012432820758e+01, 6.7480322661109355e+01, 1.3318978565899991e+02, -1.6791944323404795e+01, -1.0181217992701848e+00, 1.2989592638281225e-01, 3.2009500887769519e+01, 6.5013269472322307e+01, 1.3669829238273672e+02, -1.7009116366540379e+01, -1.0689798256828462e+00, 1.3388945486998777e-01, 4.1931127118492086e+01, 1.1600186087954401e+02, 3.1751764022286790e+02, -4.6438894455748802e+01, -8.7599401950869438e-01, 2.2297105562740663e-01, 4.2002297497564768e+01, 1.1479764873768737e+02, 3.2393143797302810e+02, -4.7847299173836262e+01, -7.8150712905299369e-01, 2.2131248436241077e-01, 4.1931127118492086e+01, 1.1600186087954401e+02, 3.1751764022286790e+02, -4.6438894455748802e+01, -8.7599401950869438e-01, 2.2297105562740663e-01, 4.2002297514594851e+01, 1.1479764793294436e+02, 3.2393145467669495e+02, -4.7847304068128608e+01, -7.8150664807362491e-01, 2.2131246858403722e-01, 5.1984670105634827e+01, 1.7926303194781252e+02, 6.2846495111925287e+02, -1.0034649475039414e+02, 2.4606292097951082e-01, 3.3256752105517051e-01, 5.2000554052128159e+01, 1.7883235795593501e+02, 6.3273302895025176e+02, -1.0138733878813618e+02, 3.2804187851642969e-01, 3.3055293107858102e-01, 5.1984670105634827e+01, 1.7926303194781252e+02, 6.2846495111925287e+02, -1.0034649475039414e+02, 2.4606292097951082e-01, 3.3256752105517051e-01, 5.2000554052402805e+01, 1.7883235793562420e+02, 6.3273302962903426e+02, -1.0138733898825184e+02, 3.2804189825766372e-01, 3.3055293042886030e-01, 6.1996666427075382e+01, 2.5724136589119979e+02, 1.0913830717468406e+03, -1.8317243758181812e+02, 2.5193786568880601e+00, 4.6277932792022042e-01, 6.2000133522892554e+01, 2.5710536851489377e+02, 1.0934673032018356e+03, -1.8370056934287794e+02, 2.5630609198690104e+00, 4.6162176037505448e-01, 6.1996666427075382e+01, 2.5724136589119979e+02, 1.0913830717468406e+03, -1.8317243758181812e+02, 2.5193786568880601e+00, 4.6277932792022042e-01, 6.2000133522896938e+01, 2.5710536851442714e+02, 1.0934673032246803e+03, -1.8370056934963364e+02, 2.5630609205366826e+00, 4.6162176035304603e-01, 7.1999279107664492e+01, 3.4965254984584158e+02, 1.7356304176273381e+03, -3.0063395678020430e+02, 6.2079056750108883e+00, 6.1505333334154833e-01, 7.2000032172982571e+01, 3.4961232791697932e+02, 1.7365043785874466e+03, -3.0086002522613632e+02, 6.2270725229979789e+00, 6.1452738833821030e-01, 7.1999279107664492e+01, 3.4965254984584158e+02, 1.7356304176273381e+03, -3.0063395678020430e+02, 6.2079056750108883e+00, 6.1505333334154833e-01, 7.2000032172982642e+01, 3.4961232791696904e+02, 1.7365043785881401e+03, -3.0086002522634379e+02, 6.2270725230187063e+00, 6.1452738833751985e-01, 8.1999844359310714e+01, 4.5636323545227941e+02, 2.5918884526432239e+03, -4.5885344883307727e+02, 1.1616256691917803e+01, 7.8948404417119522e-01, 8.2000007751936337e+01, 4.5635184072744744e+02, 2.5922210189842476e+03, -4.5894061525528980e+02, 1.1623761628208563e+01, 7.8927378661620728e-01, 8.1999844359310714e+01, 4.5636323545227941e+02, 2.5918884526432239e+03, -4.5885344883307727e+02, 1.1616256691917803e+01, 7.8948404417119522e-01, 8.2000007751936337e+01, 4.5635184072744744e+02, 2.5922210189842476e+03, -4.5894061525528980e+02, 1.1623761628208563e+01, 7.8927378661620728e-01
  };
  std::vector<double > expected_xyz_scatter = {
    1.4271973325754339e+00, 2.5214997685364109e+00, 3.1394341134078902e+00, 2.2727894815158436e+00, 1.9127738317829568e+00, 2.5288382955492263e+00, 3.1401587802428659e+00, 2.5252400661016079e+00, 9.4806287131835343e-01, 2.3778589851963829e+00, 2.8273548699126683e+00, 1.9358633427396228e+00, 2.1586806210305824e+00, 2.6256636737020518e+00, 3.3955783231847523e+00, 2.7091329174140033e+00, -1.9231004620365049e+00, -4.6499941633630704e-01, -1.1594526098009617e+00, -1.2686640472208488e+00, 2.0867847214069872e+00, 3.0003750888529219e+00, 3.6325449823191440e+00, 2.8788902557067368e+00, 1.2684738158575621e+00, 1.8537695728403008e+00, 2.1955525109720693e+00, 1.7836450721166277e+00, 1.8550735634159015e+00, 2.4434013845454778e+00, 3.0971074319021614e+00, 2.4481507963338514e+00, 1.6439641588553517e+00, 1.9173245315063490e+00, 2.4213050183154365e+00, 2.0154649449162125e+00, 8.6044027444396542e-01, 1.6761956340909820e+00, 1.9714372427825169e+00, 1.4694269993819085e+00, 1.1578881590922248e+00, 2.4304644465537262e+00, 2.8997419900334167e+00, 2.0775716876050363e+00, 2.3918652577373138e+00, 2.7767532459788180e+00, 3.5565699066582859e+00, 2.9253650111396308e+00, 1.6429790566102422e+00, 2.3353986933747315e+00, 2.8497701445565649e+00, 2.2665599345093730e+00, 6.2452940515269861e-01, 1.3483891434563131e+00, 1.5336055353368097e+00, 1.1476467351376733e+00, 2.3375903116778036e+00, 3.0294370345439616e+00, 3.8114115382246951e+00, 3.0486965696352639e+00, 6.1627879872497271e-01, 1.0222504107870520e+00, 1.1967221175625382e+00, 9.4398210879701261e-01, -1.7068032019607302e+00, 3.3613403560802918e-01, -1.0411939552994098e-01, -6.6667768860645871e-01, 1.8511171935709925e+00, 2.2616949107465572e+00, 2.8901786544735999e+00, 2.3344195582834213e+00, 1.8684390110773692e+00, 2.3089422940069237e+00, 2.9226805832398313e+00, 2.3717710946817374e+00, 1.9375672494736595e+00, 2.2557776291035463e+00, 2.8639227616937220e+00, 2.3752065452942275e+00, -3.2972712763415735e-02, 1.0799332278489837e+00, 1.0885237991034180e+00, 6.4736232064759269e-01, 2.8245006381754121e+00, 3.5259487523490192e+00, 4.6113702776738981e+00, 3.5998420702676723e+00, 2.5905343058532044e+00, 3.9030377854459730e+00, 4.9001863961421570e+00, 3.6937521865974929e+00, -2.0466716707172710e+00, -1.0685624603518851e-01, -7.3049231485296484e-01, -1.1126777403630335e+00, 4.5968126827466538e+00, 4.8629895439961155e+00, 6.7099151660558576e+00, 5.3272372780027073e+00, 1.3052826537711313e+00, 1.5171629367774915e+00, 1.9011692135645539e+00, 1.5983578000913097e+00, 2.7500355791930211e+00, 3.1012540902842334e+00, 4.0886454556166472e+00, 3.2988732261870899e+00, -3.7661410117701113e+00, -1.3602653035667422e+00, -2.5196607983439852e+00, -2.7610055328203522e+00, 2.4189623440903629e+00, 2.8963366391936933e+00, 3.8107924830413253e+00, 3.0083029750449866e+00, -3.4747440084737047e+00, -1.1388326294486402e+00, -2.4182412000178957e+00, -2.4782338467864626e+00, 1.8127024518519697e+00, 2.2230503769241436e+00, 2.7468475012971849e+00, 2.2887727041772736e+00, -1.2285895780562228e-01, 1.5434771625279660e+00, 1.6000755001429154e+00, 8.7985271502585627e-01, 1.9011366955569318e+00, 2.4167616547852120e+00, 3.1462829168951041e+00, 2.4517928223455625e+00, 3.4327869085046898e+00, 3.8030109751616310e+00, 4.8712356823465610e+00, 4.0764499721493568e+00, -1.2035506504910221e-01, 1.0522704557335492e+00, 9.2716931026249949e-01, 5.7901898977964616e-01, 2.3714074680568968e+00, 2.7069461333245264e+00, 3.4788009563530058e+00, 2.8668785353548181e+00, 1.3173599955901605e+00, 2.3373622162330081e+00, 2.7950932510153166e+00, 2.0958887568436859e+00, 8.4352826372327494e-01, 1.3787710702843035e+00, 1.6194525500748886e+00, 1.2753294206512922e+00, 2.1844818576218366e+00, 2.4600046540695972e+00, 3.2061976014984541e+00, 2.6275850202185489e+00, 7.7180988879817070e-01, 1.0272946579967681e+00, 1.2621894302014174e+00, 1.0265959882640883e+00, 1.6049231964243249e+00, 2.4546141304955089e+00, 3.1543902252316531e+00, 2.3261815654970941e+00, -1.5851508845166586e+00, 1.7616609630246921e-01, -4.6927862795076358e-01, -7.0847602690642730e-01, 9.7206101520523258e-01, 2.1984829496765985e+00, 2.5547429254737746e+00, 1.8332359752494667e+00, 1.7754746253185822e+00, 2.6825317821817345e+00, 3.3991991376107316e+00, 2.5509087537769037e+00, 1.0721995919270044e-01, 1.2979498217369176e+00, 1.3387413397315138e+00, 8.4672254891200061e-01, 2.9293634097685093e+00, 3.7870623674013393e+00, 4.9049858395715571e+00, 3.8089529879570825e+00, 8.4019940154161687e-01, 1.4394975389766356e+00, 1.7212747966327231e+00, 1.3114842544997232e+00, -4.4681831340750566e-01, 1.6558375814978303e+00, 1.5645433370489232e+00, 7.7463977013538887e-01, 5.8820535859917089e-01, 9.1338322532915583e-01, 1.1202010966286036e+00, 8.6364930010308649e-01, 7.0926056868283660e-01, 1.4218405965219119e+00, 1.6894042270047498e+00, 1.2378761768042328e+00, 2.3099219963216546e+00, 2.6932789796161916e+00, 3.5453161672341622e+00, 2.8363942767964803e+00, 1.8678281855424870e+00, 2.6920312666879047e+00, 3.2316323462531087e+00, 2.6004324324975743e+00, 1.4005208650900944e+00, 2.1811523726875692e+00, 2.7048686478151001e+00, 2.0527720081111767e+00, 2.3136081060507738e+00, 2.9431216274000898e+00, 3.7927332883433289e+00, 2.9867484155017419e+00, 2.4183082750679299e+00, 3.4684542472901878e+00, 4.3044551492126208e+00, 3.3503390337668466e+00, 1.3369220495937211e+00, 2.0576414218953958e+00, 2.5357049204003479e+00, 1.9409755276270539e+00, -2.1107398251243468e+00, -4.8988978509617087e-01, -1.0925226074379997e+00, -1.3770224787571617e+00, 1.6149648338580387e+00, 1.9730143918958940e+00, 2.5005508027915648e+00, 2.0369912328773259e+00, 1.9358903207989977e+00, 2.1474863817546317e+00, 2.7816238043705535e+00, 2.3089858393655152e+00, 5.9610253563576776e-01, 1.8174801336559421e+00, 2.1475049000471036e+00, 1.4151097394224248e+00, 5.1090833065932995e-01, 1.2160531841070317e+00, 1.3152029243838474e+00, 1.0054053301687891e+00, 2.1775101573737672e+00, 2.7592291083038578e+00, 3.5514577227476543e+00, 2.8051749838391071e+00, 1.4574449572780601e+00, 1.8257794999887023e+00, 2.3529474069241134e+00, 1.8687169225939499e+00, 3.9934672259732729e+00, 4.6069625003686925e+00, 6.0365399138833418e+00, 4.8498952298984239e+00, 5.0206849491088514e+02, 5.2990619575924950e+02, 5.0718360719485423e+02, 5.3078609113850609e+02, 4.2099706807708640e+02, 4.4995011865286330e+02, 4.2613481931665478e+02, 4.5054742567627943e+02, 6.4624126958401507e+02, 6.7232697462462943e+02, 6.5259938738906271e+02, 6.7148563064230416e+02, 4.2978137542372599e+02, 4.5001246708893814e+02, 4.3535643412910235e+02, 4.5267999547985386e+02, 3.3452377892226485e+02, 3.5665923744531250e+02, 3.3921143957791395e+02, 3.5904334578072132e+02, 4.2377024314145552e+02, 4.4269249140996482e+02, 4.3013979474766063e+02, 4.4602164788241845e+02, 4.0106095277790195e+02, 4.2025993436574691e+02, 4.0597499630524908e+02, 4.2366611812473144e+02, 3.8696471878412717e+02, 4.0913035507396773e+02, 3.8997037364405418e+02, 4.1288273173906788e+02, 3.6331657327614209e+02, 3.8874925104444759e+02, 3.6568536230961831e+02, 3.8997929930096944e+02, 3.0766058208873443e+02, 3.3007628916707438e+02, 3.1095679032603221e+02, 3.3214170847015549e+02, 3.7417389932974652e+02, 3.9610585314922997e+02, 3.8035396619631911e+02, 4.0089442860025434e+02, 3.8077716282948728e+02, 4.0439557659241609e+02, 3.8495076836644944e+02, 4.0710965835899611e+02, 5.0832346005741056e+02, 5.2918139375030751e+02, 5.0999148566291376e+02, 5.3238824760640534e+02, 3.5895613327835940e+02, 3.7388263235784137e+02, 3.6145315529806305e+02, 3.7979834444073651e+02, 3.7956459278145832e+02, 4.0172961800115581e+02, 3.8172408748658489e+02, 4.0500568949748191e+02, 3.9684913832843944e+02, 4.1936779798804349e+02, 3.9896001344387633e+02, 4.2078747802693186e+02, 3.3493113256513072e+02, 3.5265874034487007e+02, 3.3927703565539474e+02, 3.6107266137720109e+02, 3.6604604197249961e+02, 3.8893228913059670e+02, 3.6730129201251361e+02, 3.9043728041862283e+02, 3.8812581530185560e+02, 4.0924615019224609e+02, 3.9322998085289782e+02, 4.1390337702757438e+02, 4.8856029801345204e+02, 5.0271192916654570e+02, 4.9091594198952845e+02, 5.0809377638444926e+02, 5.2321208035994221e+02, 5.4770952441490192e+02, 5.2817006845838080e+02, 5.4714484189009147e+02, 4.9081225091120268e+02, 5.1240397279603928e+02, 4.9158073027031935e+02, 5.1502480371472871e+02, 5.7223828602721358e+02, 5.9667394727556575e+02, 5.7537894734461975e+02, 5.9925470530439986e+02, 4.9646123158168882e+02, 5.1903534403318656e+02, 5.0181634086118572e+02, 5.2172511442944483e+02, 5.2233159969818155e+02, 5.4780412588510796e+02, 5.2846475284626229e+02, 5.4849754426441416e+02, 4.5617530091144931e+02, 4.7396892884953650e+02, 4.5877481670469268e+02, 4.7577802295466512e+02, 4.4587673834159580e+02, 4.6732395897795834e+02, 4.5162986675993960e+02, 4.6775280428052747e+02, 4.0283354373844770e+02, 4.1961075089899697e+02, 4.0745259059538853e+02, 4.2303359882010614e+02, 5.3834353723774768e+02, 5.6525863139407920e+02, 5.4218387057666916e+02, 5.6547607603652864e+02, 4.4261815891116561e+02, 4.6322139706306598e+02, 4.4557510448028398e+02, 4.6409152553377004e+02, 4.4247192104148161e+02, 4.6619614492253584e+02, 4.4614612324987121e+02, 4.6625206457720230e+02, 3.6128738532891242e+02, 3.8988552843469040e+02, 3.6940156471526564e+02, 3.8850389331677923e+02, 4.7389962473318047e+02, 5.0013101019299427e+02, 4.7841978642421418e+02, 5.0240916591976708e+02, 4.4507921732155654e+02, 4.7390246086556681e+02, 4.5040565227666025e+02, 4.7420235641495236e+02, 4.8993159334334075e+02, 5.1119545519430841e+02, 4.9450301753071705e+02, 5.1079476503475638e+02, 3.9149835455877076e+02, 4.1695134005502371e+02, 3.9850449284689967e+02, 4.1768853701434006e+02, 5.5536615451459932e+02, 5.8218713084686863e+02, 5.6219650600540592e+02, 5.8110371415189206e+02, 3.5857465223194458e+02, 3.7805893452052851e+02, 3.6313044059114281e+02, 3.8278842764472688e+02, 3.9613973998079075e+02, 4.2121250028684204e+02, 4.0322872883880973e+02, 4.2129275763397044e+02, 4.2936205593131211e+02, 4.5353270360878503e+02, 4.3287345252040535e+02, 4.5448469042238418e+02, 4.4950161157908241e+02, 4.7532105082965637e+02, 4.5647550173342893e+02, 4.7547228050864646e+02, 3.2679348365595416e+02, 3.4926301408293159e+02, 3.3184472007084833e+02, 3.4766058741420920e+02, 3.7386411648728529e+02, 3.9861550748020761e+02, 3.7822194089162900e+02, 4.0013870143390176e+02, 4.4829502159394286e+02, 4.7694032786407286e+02, 4.5274923302353994e+02, 4.7569909856079317e+02, 5.0605732715124822e+02, 5.2982960997204441e+02, 5.1018585735851212e+02, 5.3097883224725592e+02, 3.5863665220726045e+02, 3.8682448095468220e+02, 3.6639443664339842e+02, 3.8645991462669110e+02, 4.2980724222044194e+02, 4.4200509624071060e+02, 4.3377896483976394e+02, 4.5049650817962009e+02, 4.7353077646683136e+02, 5.0370872675117209e+02, 4.7734477563720822e+02, 5.0383525959610876e+02, 3.3018963371387275e+02, 3.5335741347599691e+02, 3.3490687757435569e+02, 3.5549069288195227e+02, 5.4332101159480499e+02, 5.5773440615406525e+02, 5.4693692877181081e+02, 5.6229241672395904e+02, 4.3911838198513118e+02, 4.6389559606570378e+02, 4.4555972724814870e+02, 4.6330360136131640e+02, 5.9012746767991473e+02, 6.0881103345863914e+02, 5.9238046236563105e+02, 6.1153339968383796e+02, 3.3567654669942158e+02, 3.5471649519755044e+02, 3.3738613420476901e+02, 3.6005001180565057e+02, 4.5183734883466576e+02, 4.7792551648388240e+02, 4.5576605194928987e+02, 4.7882989629493864e+02, 4.9963595110319130e+02, 5.2447596823087997e+02, 5.0502830948039860e+02, 5.2575477228206853e+02, 3.0830398627916276e+02, 3.3105832470397951e+02, 3.1259710901928895e+02, 3.3410602914065612e+02, 3.2743062231073293e+02, 3.4891769728491801e+02, 3.3177463909525744e+02, 3.5362578896828563e+02, 4.7519868494408144e+02, 4.9515900441603736e+02, 4.7779717459656456e+02, 4.9826625741531501e+02, 4.9284871034497542e+02, 5.1106984057352037e+02, 4.9641742709973187e+02, 5.1336922593850761e+02, 3.5619924997896692e+02, 3.7973909500494273e+02, 3.6036976487086139e+02, 3.8244786836827933e+02, 5.1023777988632258e+02, 5.2792203133332578e+02, 5.1181598214733094e+02, 5.3093252840119374e+02, 5.8515851970733684e+02, 6.0662095917829583e+02, 5.8836080558705828e+02, 6.0856740950778476e+02, 4.2320528132965376e+02, 4.4433409233260238e+02, 4.2774087770870437e+02, 4.4493227381084881e+02, 5.3649403282476419e+02, 5.6002649142365817e+02, 5.4100544048421602e+02, 5.6344537433495304e+02, 3.2108481178606974e+02, 3.3751402850679085e+02, 3.2639602686352305e+02, 3.4280497127600313e+02, 3.6088723193495770e+02, 3.8330727327246012e+02, 3.6766216892694246e+02, 3.8408740198273415e+02, 5.3789217565204069e+02, 5.6077082817082771e+02, 5.4561433429711803e+02, 5.6002190651264800e+02, 3.8542525382667549e+02, 4.0818706679585972e+02, 3.8989237977139476e+02, 4.1071672112601937e+02, 4.4017080999360439e+02, 4.6096607829162730e+02, 4.4148597908498385e+02, 4.6196829584408204e+02, 4.4910149091628733e+02, 4.7307394363534456e+02, 4.5076663700944351e+02, 4.7551430237289520e+02, 3.9227814682587132e+02, 4.1257798087214985e+02, 3.9521371950921736e+02, 4.1711897460767489e+02, 5.1452231508718626e+02, 5.3859526400720893e+02, 5.1952695545599056e+02, 5.3961923578685878e+02, 3.8109275356108719e+02, 4.0346504014461300e+02, 3.8610825630499738e+02, 4.0617030886712132e+02, 4.8452457505595487e+02, 5.0041974589465406e+02, 4.8964722068875346e+02, 5.0550298995865631e+02, 3.9804275290318742e+02, 4.2264782863487699e+02, 4.0321007872679951e+02, 4.2492264399123434e+02, 5.0509147743746217e+02, 5.2641842260951853e+02, 5.0615604907658002e+02, 5.2851782681184159e+02, 3.3459128881879548e+02, 3.5785989581765483e+02, 3.4014053555863410e+02, 3.6113224451566020e+02, 3.7243330242446217e+02, 3.9454364197091792e+02, 3.7709573464905105e+02, 3.9881470989101706e+02, 4.6373112347911342e+02, 4.9281947700430516e+02, 4.6700883320630629e+02, 4.9432223003118827e+02, 4.8356479533205874e+02, 4.9924019843893802e+02, 4.8602244108327392e+02, 5.0403944602754200e+02, 4.9405865887431497e+02, 5.1764099704293153e+02, 4.9706952654679344e+02, 5.1857657553800686e+02, 3.2353192335630808e+02, 3.4294458004548534e+02, 3.3005085921688982e+02, 3.4832237869662674e+02, 3.7709990325592833e+02, 4.0170421910177203e+02, 3.8082050238146007e+02, 4.0277160778705706e+02, 5.3575655043259815e+02, 5.5597457504626493e+02, 5.4128699868812475e+02, 5.5631870299488321e+02, 4.0289822061838851e+02, 4.2011136295440394e+02, 4.0596438967835684e+02, 4.2376691548223067e+02, 4.9819597054194503e+02, 5.2512706626398779e+02, 5.0197315929161960e+02, 5.2498152747596998e+02, 4.6817667276634273e+02, 5.0014722377303497e+02, 4.7458649647723576e+02, 5.0150495171951650e+02, 4.1941666791857625e+02, 4.3883151509608655e+02, 4.2401675298355462e+02, 4.4187117909268017e+02, 4.4249214476881394e+02, 4.6979092814746605e+02, 4.5029339653448335e+02, 4.7008378840721508e+02, 3.5083981057495157e+02, 3.7313087632713695e+02, 3.5453905916645419e+02, 3.7328522070000724e+02, 5.9181740721854158e+02, 6.1605214530968453e+02, 5.9371833379543057e+02, 6.1944402449941288e+02, 4.5118997327463666e+02, 4.7157660592958536e+02, 4.5537464602637550e+02, 4.7369769489472503e+02, 4.0138177193179956e+02, 4.1688091486099427e+02, 4.0497942623326634e+02, 4.2129355581523492e+02, 3.2454476068904751e+02, 3.4375410350243283e+02, 3.2903937444908257e+02, 3.4952628701737717e+02, 3.2747645819233173e+02, 3.5223863743599901e+02, 3.3462584368670485e+02, 3.5238457621937755e+02, 5.1406293910821455e+02, 5.4054861864779025e+02, 5.1862961318339524e+02, 5.3983332800144319e+02, 3.2626786506568948e+02, 3.4484875304946956e+02, 3.2968597510617190e+02, 3.5115983614977830e+02, 4.3161832975765424e+02, 4.5816388988101232e+02, 4.3575161757387821e+02, 4.5976959274894392e+02, 3.5654924037338890e+02, 3.8348265216764844e+02, 3.6337728104134629e+02, 3.8304023786626510e+02, 4.8355605334720593e+02, 5.0545440221729081e+02, 4.8988058276802548e+02, 5.0618475071249503e+02, 4.0865412723946616e+02, 4.2800407219894146e+02, 4.1095472883899140e+02, 4.3167357399059108e+02, 2.9708316761901597e+02, 3.1383146748172811e+02, 2.9852303627317781e+02, 3.1710940115047504e+02, 4.7142270881905046e+02, 4.8987477487142007e+02, 4.7426138183490190e+02, 4.9403105234490903e+02, 3.6559540566801468e+02, 3.8870805730365379e+02, 3.6991533799271076e+02, 3.9018512214896242e+02, 5.3051276561692873e+02, 5.5329760522784727e+02, 5.3526924112310326e+02, 5.5512839001953125e+02, 4.9480860427837490e+02, 5.1417711766271100e+02, 4.9754426266298464e+02, 5.1841294991322388e+02, 3.7755705785212410e+02, 3.9871403752122859e+02, 3.8399149816388353e+02, 3.9960423516196516e+02, 5.4606883830754020e+02, 5.7269177786419971e+02, 5.5192452991915388e+02, 5.7279122308323679e+02, 3.7257595764014530e+02, 3.9118140540161784e+02, 3.7687331126515454e+02, 3.9896571592453080e+02, 5.2752105969967772e+02, 5.5611293296971098e+02, 5.3281649703346557e+02, 5.5594920150426572e+02, 4.3231846898537026e+02, 4.5288085667282348e+02, 4.3724671179152733e+02, 4.5453580950036348e+02, 4.7848078271205947e+02, 4.9368761153563361e+02, 4.8122739366968841e+02, 4.9813960591790141e+02, 4.1534041583572440e+02, 4.3799832356033329e+02, 4.1706050141647705e+02, 4.4120345083811236e+02, 4.2450222526363888e+02, 4.4987978590265880e+02, 4.2579221415895904e+02, 4.5062389839125194e+02, 5.3367829890285134e+02, 5.5925299920437146e+02, 5.3827600387794030e+02, 5.5875107897809198e+02, 3.1886322192082901e+02, 3.4604588931737567e+02, 3.2494503946587514e+02, 3.4498806567101104e+02, 4.5828995348069998e+02, 4.8134664875820539e+02, 4.6362842114441025e+02, 4.8218008418611402e+02, 3.2815013315367082e+02, 3.5330311766072475e+02, 3.3495746008397487e+02, 3.5350425839038832e+02, 4.5574559510937661e+02, 4.8461323076426964e+02, 4.6148981459068813e+02, 4.8263615785873958e+02, 4.2501531271042046e+02, 4.5132404339430190e+02, 4.2823468757230540e+02, 4.5342670023963024e+02, 3.7302979260694212e+02, 3.9811608227111651e+02, 3.7780483413354148e+02, 3.9775933708215859e+02, 5.3852258883589616e+02, 5.5889183953662018e+02, 5.4315382086627653e+02, 5.5817153685794256e+02, 3.5722233146453829e+02, 3.8308198559090272e+02, 3.6280918007156259e+02, 3.8401915651539724e+02, 4.8783906491191323e+02, 5.0943975381762459e+02, 4.9217676882174038e+02, 5.1161007146016738e+02, 4.6331654743950884e+02, 4.7499075201329407e+02, 4.6705071715769213e+02, 4.8374951558367218e+02, 4.2992453268172954e+02, 4.4705802004563787e+02, 4.3466409215168113e+02, 4.5143517678668394e+02, 5.8618728290886418e+02, 6.0641021558623345e+02, 5.8936993438739410e+02, 6.0675386578249834e+02, 4.9964299424902913e+02, 5.2969306085468259e+02, 5.0356864383992928e+02, 5.2869887670804815e+02
  }; 
  std::vector<double > expected_dy_dem_x = {
    -8.5282566239703315e-04, 9.7434896238470878e-05, 2.8198670103749745e-05, 1.4683718725367045e-04, 9.7434896238470878e-05, -8.2177981795691663e-04, 1.4730179246350320e-04, 2.2697700888374512e-04, 2.8198670103749745e-05, 1.4730179246350320e-04, -3.0546099757163860e-04, -1.0691955275624962e-04, 1.4683718725367045e-04, 2.2697700888374512e-04, -1.0691955275624962e-04, -2.0472393176281583e-04, -5.8986194101090419e-04, 2.0301485015849167e-05, 1.4477690521761920e-04, 1.5589944596906697e-04, 2.0301485015849167e-05, -3.4790826051777767e-04, 1.6188954118095066e-04, -6.4754798873391454e-05, 1.4477690521761920e-04, 1.6188954118095066e-04, -2.9910593935885945e-04, -5.0936876433791144e-05, 1.5589944596906697e-04, -6.4754798873391454e-05, -5.0936876433791144e-05, -1.0355517826698125e-04, -6.9459162938867685e-04, 2.8327565248668782e-05, 2.8430463755414195e-05, 4.6197796678653893e-05, 2.8327565248668782e-05, -4.3779001120184660e-04, 3.9125697200477542e-05, -3.1649070137933027e-05, 2.8430463755414195e-05, 3.9125697200477542e-05, -4.0417658999342403e-04, 7.6519185026183547e-05, 4.6197796678653893e-05, -3.1649070137933027e-05, 7.6519185026183547e-05, -2.8017988936616456e-04, -8.6012936276845748e-04, 8.9176446815027605e-05, 1.6318850169617433e-05, 1.4131109278314074e-04, 8.9176446815027605e-05, -2.3539344428552647e-04, 1.0554839943982053e-04, 6.1754240894486574e-05, 1.6318850169617433e-05, 1.0554839943982053e-04, -2.2356938850427748e-04, -5.5818570386833549e-05, 1.4131109278314074e-04, 6.1754240894486574e-05, -5.5818570386833549e-05, -1.8579307724742348e-04, -1.4579471606530545e-05, 1.8373628547591411e-06, 6.3404455687761808e-09, 1.6520017494432617e-05, 1.8373628547591411e-06, 4.0055076619841326e-05, 5.1870915506862245e-07, 6.5455154995692458e-06, 6.3404455687761808e-09, 5.1870915506862245e-07, 3.5777013395772088e-05, 1.2331072770409084e-06, 1.6520017494432617e-05, 6.5455154995692458e-06, 1.2331072770409084e-06, 2.9330374271367200e-05, -1.0591838639597137e-03, 3.7324386487840001e-04, 1.1201603730535799e-04, -1.3094998715550417e-04, 3.7324386487840001e-04, -5.3825225173688483e-04, 1.5433463803274103e-05, 6.7929980996522018e-06, 1.1201603730535799e-04, 1.5433463803274103e-05, -1.5347431592130682e-04, 7.3816404184980853e-05, -1.3094998715550417e-04, 6.7929980996522018e-06, 7.3816404184980853e-05, -1.4291206449640258e-04, -3.3653765271671784e-04, 9.6409327441248667e-05, 6.4078783813068993e-05, -5.7869265471838981e-05, 9.6409327441248667e-05, -2.2563161687222687e-04, 7.2686803292055054e-05, -6.2940087651933607e-05, 6.4078783813068993e-05, 7.2686803292055054e-05, -1.6173581616879356e-04, 8.8234028851700132e-05, -5.7869265471838981e-05, -6.2940087651933607e-05, 8.8234028851700132e-05, -9.8164250335740287e-05, -4.8591645753528860e-04, 9.7740935502860828e-05, 4.4478158377719349e-05, 1.0419035578929442e-04, 9.7740935502860828e-05, -2.8008833575539116e-04, 1.0234342742699657e-05, -1.1066375197239399e-05, 4.4478158377719349e-05, 1.0234342742699657e-05, -2.7922668025205693e-04, 1.1806531746953321e-04, 1.0419035578929442e-04, -1.1066375197239399e-05, 1.1806531746953321e-04, -1.9974381044785472e-04, -4.5059018192044660e-04, 1.5855953261830535e-04, 1.0703891128048314e-04, -2.9320496830173838e-05, 1.5855953261830535e-04, -2.0101672795536590e-04, 5.3750835060043594e-06, 6.3549045572453374e-05, 1.0703891128048314e-04, 5.3750835060043594e-06, -2.0012584084945853e-04, 8.1458143700506442e-05, -2.9320496830173838e-05, 6.3549045572453374e-05, 8.1458143700506442e-05, -1.7784532544621600e-04, -4.7553664863859020e-04, 9.0606794366112880e-05, 1.1547757782783547e-04, 1.7942202135921617e-04, 9.0606794366112880e-05, -3.7929902055660708e-04, 1.1141005377050407e-04, -1.0369999356845449e-04, 1.1547757782783547e-04, 1.1141005377050407e-04, -3.0010715447777566e-04, 5.9933061644597410e-05, 1.7942202135921617e-04, -1.0369999356845449e-04, 5.9933061644597410e-05, -1.5711713725349039e-04, -8.4512694843494427e-04, -1.5998766504508188e-04, 1.3459366005811189e-04, 8.9050023157920225e-05, -1.5998766504508188e-04, -7.4497721059562944e-04, 2.1490465386259777e-04, 8.6993211035125107e-06, 1.3459366005811189e-04, 2.1490465386259777e-04, -3.5600902729500730e-04, 1.2490893288676265e-04, 8.9050023157920225e-05, 8.6993211035125107e-06, 1.2490893288676265e-04, -2.4912698171829185e-04, -5.4677729864457437e-04, 1.4544760640130386e-04, 2.1553577462634675e-04, -5.7697338533785043e-05, 1.4544760640130386e-04, -3.9389932680879196e-04, 9.3103780652668911e-05, 1.5781465334615180e-04, 2.1553577462634675e-04, 9.3103780652668911e-05, -3.5209769647293266e-04, 3.0908080405118161e-05, -5.7697338533785043e-05, 1.5781465334615180e-04, 3.0908080405118161e-05, -2.9381991178282840e-04, -8.4897434901643008e-04, 2.4958296800820011e-04, 1.6042793880630297e-04, 2.0191539006263895e-04, 2.4958296800820011e-04, -4.9074044762242083e-04, -3.8390868153238754e-05, 6.9794232794373798e-06, 1.6042793880630297e-04, -3.8390868153238754e-05, -2.3180481912080813e-04, -1.2344065882196416e-04, 2.0191539006263895e-04, 6.9794232794373798e-06, -1.2344065882196416e-04, -1.9034910644016834e-04, -3.9234583079674319e-04, 1.0779962022557863e-04, 7.7172205961845708e-05, -1.0845300489032052e-04, 1.0779962022557863e-04, -3.6501653375163899e-04, 1.6932449587587277e-04, 1.1497268397185604e-04, 7.7172205961845708e-05, 1.6932449587587277e-04, -2.4040175903203856e-04, 6.3315499528010007e-05, -1.0845300489032052e-04, 1.1497268397185604e-04, 6.3315499528010007e-05, -1.4974518011387353e-04, -7.5415253127048964e-04, 1.4628668950921841e-04, 1.6870584651280783e-04, 1.4071636815485435e-04, 1.4628668950921841e-04, -3.5212613519392216e-04, 8.9576029143352727e-05, -4.6556408920235956e-05, 1.6870584651280783e-04, 8.9576029143352727e-05, -2.7822614419127146e-04, -7.8397846864094857e-05, 1.4071636815485435e-04, -4.6556408920235956e-05, -7.8397846864094857e-05, -2.7346041679651505e-04, -2.6033241393473680e-04, 6.1297134521054865e-05, 1.1370943254758424e-05, 4.1345709213983918e-05, 6.1297134521054865e-05, -2.0636544320363793e-04, 3.6633072227909512e-05, 9.6487308065657876e-05, 1.1370943254758424e-05, 3.6633072227909512e-05, -1.7929253284262379e-04, 1.0075401050272592e-04, 4.1345709213983918e-05, 9.6487308065657876e-05, 1.0075401050272592e-04, -1.7514728993513846e-04, -9.1976596775803973e-04, -1.1250093174975719e-05, 1.0574848982308227e-04, 5.6892733088968351e-05, -1.1250093174975719e-05, -5.3677767474141075e-04, 7.5975050471457976e-05, 2.1341143425148652e-04, 1.0574848982308227e-04, 7.5975050471457976e-05, -4.6910404481979227e-04, -1.1961907952442812e-04, 5.6892733088968351e-05, 2.1341143425148652e-04, -1.1961907952442812e-04, -1.6713401053931241e-04, -5.0318411138792780e-04, -7.8642752393614670e-06, 1.4734980833474556e-04, 1.5694775605953879e-04, -7.8642752393614670e-06, -4.3428679183052686e-04, 1.3240571026484175e-04, 9.4284982663807307e-05, 1.4734980833474556e-04, 1.3240571026484175e-04, -2.6476905195442599e-04, -4.4663985184858534e-05, 1.5694775605953879e-04, 9.4284982663807307e-05, -4.4663985184858534e-05, -1.4901238055304647e-04, -5.2022971006193295e-04, 1.8673817993987294e-04, 3.4824093151832877e-06, 1.9316715603711834e-04, 1.8673817993987294e-04, -3.5661136332554733e-04, 9.2514978038235173e-05, -8.6662703285468833e-07, 3.4824093151832877e-06, 9.2514978038235173e-05, -3.4175347533838051e-04, 8.7641158627568827e-05, 1.9316715603711834e-04, -8.6662703285468833e-07, 8.7641158627568827e-05, -2.3228701071836513e-04, -2.3172744537639032e-04, -2.0145061787998218e-05, 8.0361470649018278e-05, 7.8686158095771946e-05, -2.0145061787998218e-05, -2.1788437548850563e-04, 6.8244915676574325e-05, 4.7753842109443553e-05, 8.0361470649018278e-05, 6.8244915676574325e-05, -1.8538465680992033e-04, 6.3885883987663494e-06, 7.8686158095771946e-05, 4.7753842109443553e-05, 6.3885883987663494e-06, -1.5576199151219941e-04, -2.6053492859149329e-04, 3.7985008257765683e-05, -4.1618594585238569e-05, 1.2029024299682188e-04, 3.7985008257765683e-05, -2.5883101840537494e-04, 2.5194049224745282e-05, 3.9122106536011156e-05, -4.1618594585238569e-05, 2.5194049224745282e-05, -1.8215627475922963e-04, 9.5955293419038848e-05, 1.2029024299682188e-04, 3.9122106536011156e-05, 9.5955293419038848e-05, -8.8495058887861342e-05, -8.5077111031875798e-04, 2.7142179798126236e-05, 2.3506811184181804e-04, -4.0221741191713819e-05, 2.7142179798126236e-05, -5.8825160593922092e-04, 1.2928972567669391e-04, 1.8492434110243213e-04, 2.3506811184181804e-04, 1.2928972567669391e-04, -4.8258381050380911e-04, 3.8157653583435203e-05, -4.0221741191713819e-05, 1.8492434110243213e-04, 3.8157653583435203e-05, -1.3868330525066390e-04, -1.0046100956135153e-03, 1.0071981850677016e-04, 2.8872287092350934e-05, 2.7319207214565589e-05, 1.0071981850677016e-04, -5.8995054305638166e-04, 1.9420289297011076e-04, -6.4394518219290390e-05, 2.8872287092350934e-05, 1.9420289297011076e-04, -4.6301081539337568e-04, 6.2018876700662711e-05, 2.7319207214565589e-05, -6.4394518219290390e-05, 6.2018876700662711e-05, -3.1496980814001716e-04, -3.5505598207892898e-04, 4.2612480787834219e-05, 4.6241360306879771e-06, 2.1108926449578879e-05, 4.2612480787834219e-05, -7.2955350707598794e-06, 1.8755820202733821e-05, -2.6907330166430605e-06, 4.6241360306879771e-06, 1.8755820202733821e-05, -1.6364300965012292e-06, -2.4890773965917357e-06, 2.1108926449578879e-05, -2.6907330166430605e-06, -2.4890773965917357e-06, -3.1119034082904818e-06, -1.3157832950043162e-03, 1.5109719057770362e-04, 2.2136411827069661e-04, 1.5620989616059463e-04, 1.5109719057770362e-04, -6.9909797727330165e-04, 1.3446109058413912e-04, 1.1910768000198964e-04, 2.2136411827069661e-04, 1.3446109058413912e-04, -5.1538523518062426e-04, 7.5113122085345235e-05, 1.5620989616059463e-04, 1.1910768000198964e-04, 7.5113122085345235e-05, -3.0505421799441914e-04, -3.0462471772100332e-04, 3.9065280474790656e-05, 1.4614293236463156e-04, 9.5882906751313209e-05, 3.9065280474790656e-05, -1.9543435847266125e-04, -1.1587160757702439e-05, 1.1931573498340947e-04, 1.4614293236463156e-04, -1.1587160757702439e-05, -1.8470088623319614e-04, 2.0760996552120055e-05, 9.5882906751313209e-05, 1.1931573498340947e-04, 2.0760996552120055e-05, -1.6350571548014739e-04, -1.0266618133570869e-03, 2.2637567583948763e-04, 4.5648808840412684e-05, 1.0877858120403682e-04, 2.2637567583948763e-04, -3.5855168729171305e-04, 1.0575495913196480e-04, 4.7811314368940493e-05, 4.5648808840412684e-05, 1.0575495913196480e-04, -2.0795540905090660e-04, -2.8126314053445194e-05, 1.0877858120403682e-04, 4.7811314368940493e-05, -2.8126314053445194e-05, -1.7015380275751095e-04, -1.0008635815443789e-03, 1.0735782597685222e-04, -8.2342347671546411e-05, -1.0621035075752513e-04, 1.0735782597685222e-04, -3.9974471825416052e-04, -4.2847890972143996e-05, 1.1148431692879854e-04, -8.2342347671546411e-05, -4.2847890972143996e-05, -1.0364328030944446e-04, 1.8027890592285884e-05, -1.0621035075752513e-04, 1.1148431692879854e-04, 1.8027890592285884e-05, -5.3335283910055137e-05, -1.1022946107544056e-03, 1.2081709463727365e-04, -8.2220753605772352e-06, 1.9181878385071303e-04, 1.2081709463727365e-04, -6.5229668590924652e-04, 2.4088842641070782e-04, 3.0891558204400955e-05, -8.2220753605772352e-06, 2.4088842641070782e-04, -2.8026542830655177e-04, 4.0661846631706496e-05, 1.9181878385071303e-04, 3.0891558204400955e-05, 4.0661846631706496e-05, -1.8847765937598992e-04, -2.4152123416571131e-04, -8.6922232482105472e-05, 1.6955733405143119e-04, -6.4111931600053363e-05, -8.6922232482105472e-05, -2.3487488104965331e-04, 5.1809081045441156e-05, 2.1850790757452379e-05, 1.6955733405143119e-04, 5.1809081045441156e-05, -2.0805036913184400e-04, -3.4798889866819799e-05, -6.4111931600053363e-05, 2.1850790757452379e-05, -3.4798889866819799e-05, -1.2312192870086894e-04, -8.8445499497716014e-05, 2.4421506868587198e-05, 2.2044662993515158e-06, 6.5601836003054636e-05, 2.4421506868587198e-05, -5.6415856340379447e-05, 9.2118704714902022e-05, -1.9706075570445630e-05, 2.2044662993515158e-06, 9.2118704714902022e-05, -4.0161585013125762e-05, 5.5260071625401637e-05, 6.5601836003054636e-05, -1.9706075570445630e-05, 5.5260071625401637e-05, -3.3100174236203148e-05, -8.2209958500230578e-04, -1.0375911757141743e-04, 2.0710347102188484e-04, -2.4978971692820028e-05, -1.0375911757141743e-04, -7.3910742021759002e-04, 5.5770606372779485e-06, 1.0998087187508114e-04, 2.0710347102188484e-04, 5.5770606372779485e-06, -3.0781601772972918e-04, 1.7042830142744166e-04, -2.4978971692820028e-05, 1.0998087187508114e-04, 1.7042830142744166e-04, -1.9931789083998724e-04, -8.2864124175878646e-04, 2.1156993777400108e-04, 1.3222387946538444e-04, 7.3125614419211014e-05, 2.1156993777400108e-04, -6.7998120575166903e-04, -4.5284032495574803e-05, 1.5448833703626970e-04, 1.3222387946538444e-04, -4.5284032495574803e-05, -1.6486495415349870e-04, -2.7910903682007980e-05, 7.3125614419211014e-05, 1.5448833703626970e-04, -2.7910903682007980e-05, -1.3616141316573496e-04, -6.9168427037508595e-04, 1.6848337105401589e-04, 2.0347536376145238e-05, 2.1730204740541038e-04, 1.6848337105401589e-04, -5.1567181939462376e-04, 2.2442346917809767e-04, -4.1679702475652895e-05, 2.0347536376145238e-05, 2.2442346917809767e-04, -2.7886738080818829e-04, -7.2100020041017474e-05, 2.1730204740541038e-04, -4.1679702475652895e-05, -7.2100020041017474e-05, -2.1591694500250683e-04, -6.3118866694050128e-04, 1.7407698534034082e-04, 2.2506708310326124e-04, -1.1855521616198067e-04, 1.7407698534034082e-04, -3.4276284162076975e-04, -2.4678327316965964e-05, -7.0132865868384085e-05, 2.2506708310326124e-04, -2.4678327316965964e-05, -2.4829751991729555e-04, 8.0665853806108728e-05, -1.1855521616198067e-04, -7.0132865868384085e-05, 8.0665853806108728e-05, -1.4560588738992748e-04, -5.4516146248809595e-04, 1.5429566078092839e-04, 7.3002508020663260e-05, -5.4127939476372286e-05, 1.5429566078092839e-04, -2.7006749001243577e-04, 3.8245018464081647e-05, 6.4001466507229872e-05, 7.3002508020663260e-05, 3.8245018464081647e-05, -1.9064634129416447e-04, 4.8315978083461554e-05, -5.4127939476372286e-05, 6.4001466507229872e-05, 4.8315978083461554e-05, -9.6287270269265838e-05, -1.0867871706203747e-03, 2.2665889399974761e-05, 3.8527790611792381e-04, -5.7606042046986583e-05, 2.2665889399974761e-05, -5.9377950867244152e-04, 1.6458617522517848e-04, 9.8647825618332862e-05, 3.8527790611792381e-04, 1.6458617522517848e-04, -3.5517610380986437e-04, 1.5047714871992010e-06, -5.7606042046986583e-05, 9.8647825618332862e-05, 1.5047714871992010e-06, -2.4847179034300285e-04, 1.7287370288645611e-05, 2.4751905195362399e-05, 5.7409278650844171e-06, 1.5778384555210318e-06, 2.4751905195362399e-05, 6.9233671176431198e-05, 1.2056763828265809e-05, 5.8193528185755228e-06, 5.7409278650844171e-06, 1.2056763828265809e-05, 2.5803013934721890e-05, 9.7800078032772889e-06, 1.5778384555210318e-06, 5.8193528185755228e-06, 9.7800078032772889e-06, 1.2290894822139189e-05, -4.7276129504627868e-04, 1.7996071145545987e-04, -2.3559613078385275e-05, 9.1817364759875372e-05, 1.7996071145545987e-04, -4.4031640931680089e-04, 1.3129665680176059e-04, 8.5753307504504326e-05, -2.3559613078385275e-05, 1.3129665680176059e-04, -2.6082369278761529e-04, 1.1008038444960020e-04, 9.1817364759875372e-05, 8.5753307504504326e-05, 1.1008038444960020e-04, -2.2448972892423485e-04, 7.3552911328923082e-05, -4.6386393976681180e-07, -3.6302661188033895e-07, 8.1292949427203692e-06, -4.6386393976681180e-07, 7.1855824442516002e-05, 2.0977058635296311e-06, -8.1660148046199487e-07, -3.6302661188033895e-07, 2.0977058635296311e-06, 4.9178179355036989e-05, 5.5111033912396161e-07, 8.1292949427203692e-06, -8.1660148046199487e-07, 5.5111033912396161e-07, 4.3126931159686622e-05, -1.0356645478699321e-03, 3.5655021996677344e-05, 1.7863455145561712e-04, 9.9345386863453332e-05, 3.5655021996677344e-05, -4.6868369051367967e-04, 8.4528986648654719e-05, 2.6178454134616406e-05, 1.7863455145561712e-04, 8.4528986648654719e-05, -4.0189105052683167e-04, 1.7827808102152204e-04, 9.9345386863453332e-05, 2.6178454134616406e-05, 1.7827808102152204e-04, -2.4096643692971789e-04, -5.2947177689736285e-04, 2.9155995696660334e-04, 1.0881309013420403e-04, 6.5216605248019719e-05, 2.9155995696660334e-04, -3.7174127902678917e-04, -1.0713195660439511e-05, -1.4652487345689542e-04, 1.0881309013420403e-04, -1.0713195660439511e-05, -3.0848787251277967e-04, -8.1788880974243585e-05, 6.5216605248019719e-05, -1.4652487345689542e-04, -8.1788880974243585e-05, -1.8187514475847530e-04, -8.1675147016875278e-04, -9.1132812142916361e-05, 3.7581090557227133e-04, -1.6391843424681004e-05, -9.1132812142916361e-05, -8.0928426677666680e-04, 1.0186682914852628e-04, 6.6974048500429245e-05, 3.7581090557227133e-04, 1.0186682914852628e-04, -3.9501800512992450e-04, 1.1097843258641806e-04, -1.6391843424681004e-05, 6.6974048500429245e-05, 1.1097843258641806e-04, -1.6922741791056576e-04, -9.5550488243767526e-04, 8.9834092429790310e-05, 1.4676450162607620e-04, -8.9486200173685058e-05, 8.9834092429790310e-05, -5.7124935343482407e-04, 1.9674652749940278e-04, 2.7820147231366192e-05, 1.4676450162607620e-04, 1.9674652749940278e-04, -4.5311825527210236e-04, 1.5751505797459724e-04, -8.9486200173685058e-05, 2.7820147231366192e-05, 1.5751505797459724e-04, -2.1504103761769665e-04, -7.4655646881417747e-04, 1.7137670375811731e-04, 2.3305985967898233e-04, 2.0974576016239595e-05, 1.7137670375811731e-04, -6.3490393076444808e-04, -3.7460934394642461e-05, 3.8915692525215832e-05, 2.3305985967898233e-04, -3.7460934394642461e-05, -2.3619871093608590e-04, -9.5966181361813001e-05, 2.0974576016239595e-05, 3.8915692525215832e-05, -9.5966181361813001e-05, -1.5753671328738253e-04, -8.4952522473083828e-04, 1.0905671249046153e-04, 1.6050124252773700e-04, -3.5054030436609191e-06, 1.0905671249046153e-04, -7.8916382592320218e-04, 5.4410597072967622e-05, 3.1697067660733621e-04, 1.6050124252773700e-04, 5.4410597072967622e-05, -6.2431502557835482e-04, 4.0685779353217203e-05, -3.5054030436609191e-06, 3.1697067660733621e-04, 4.0685779353217203e-05, -3.1869838579109982e-04, -4.9197474900203851e-04, 2.3175272353917089e-05, 4.8349993627407357e-05, 8.3431439033521311e-05, 2.3175272353917089e-05, -2.1237686325728994e-04, 1.1579272422842471e-04, 4.4948063413445143e-06, 4.8349993627407357e-05, 1.1579272422842471e-04, -1.4387542985386714e-04, -2.8807020627775499e-05, 8.3431439033521311e-05, 4.4948063413445143e-06, -2.8807020627775499e-05, -8.8314386801545690e-05, -1.0377932964218571e-03, 3.1548342438866215e-04, -7.7539032460135759e-06, 1.5862268899707329e-04, 3.1548342438866215e-04, -5.2279750482530675e-04, -9.7156212604978696e-05, 7.8070746092368879e-05, -7.7539032460135759e-06, -9.7156212604978696e-05, -5.1909921397954076e-04, -7.0888358650239406e-05, 1.5862268899707329e-04, 7.8070746092368879e-05, -7.0888358650239406e-05, -4.3559478522129486e-04, -3.4047542887403288e-04, 9.9485414683848702e-05, 5.3467360125445010e-05, 5.5687160259303899e-05, 9.9485414683848702e-05, -2.1688590318227243e-04, 5.8207991561983353e-05, 3.8807798300090633e-05, 5.3467360125445010e-05, 5.8207991561983353e-05, -1.4444518993710908e-04, 6.9712029871340034e-05, 5.5687160259303899e-05, 3.8807798300090633e-05, 6.9712029871340034e-05, -8.8308431324746653e-05, -3.9748580631234745e-04, 1.6061520126347354e-05, 7.4535335825201364e-05, -1.2455905762848885e-05, 1.6061520126347354e-05, -3.0428877235287100e-04, 6.7638842446531838e-05, 9.0216218435291209e-05, 7.4535335825201364e-05, 6.7638842446531838e-05, -1.8476291197258023e-04, 8.6490256848873625e-05, -1.2455905762848885e-05, 9.0216218435291209e-05, 8.6490256848873625e-05, -1.7290120999552497e-04, -6.3017890323441988e-04, 6.8925477551151667e-05, 1.4591855761896425e-04, 5.8696848733904197e-05, 6.8925477551151667e-05, -4.4840596419734699e-04, 1.7185871633737483e-04, 1.3636588971003942e-04, 1.4591855761896425e-04, 1.7185871633737483e-04, -3.5633566053381324e-04, 6.9798068644545436e-05, 5.8696848733904197e-05, 1.3636588971003942e-04, 6.9798068644545436e-05, -2.8194929183414266e-04, -5.2084239851836716e-04, 1.3919308449155372e-04, 7.9297302299835321e-05, -1.0666209674729959e-04, 1.3919308449155372e-04, -4.8272864193460750e-04, 1.4580575117746091e-04, 1.8231015042159636e-04, 7.9297302299835321e-05, 1.4580575117746091e-04, -2.4109836209905614e-04, -9.6833449169729229e-05, -1.0666209674729959e-04, 1.8231015042159636e-04, -9.6833449169729229e-05, -2.2652176409735576e-04, -5.9265052462615796e-04, 3.2921496507552024e-05, 1.6741839899836377e-04, -1.8287094414409389e-05, 3.2921496507552024e-05, -4.7506545424716396e-04, 8.4264843353050377e-05, 3.2049421513026473e-05, 1.6741839899836377e-04, 8.4264843353050377e-05, -2.6830906645465910e-04, 1.0562771031346049e-04, -1.8287094414409389e-05, 3.2049421513026473e-05, 1.0562771031346049e-04, -1.8350092261002626e-04, -7.5685265706840210e-04, 2.5873322291747580e-04, 6.4147355541750696e-06, 4.8379384836955772e-05, 2.5873322291747580e-04, -4.5814972293314378e-04, 5.2257125816072260e-05, 1.7555007655928345e-04, 6.4147355541750696e-06, 5.2257125816072260e-05, -4.5065665859371718e-04, 1.3365888276934993e-04, 4.8379384836955772e-05, 1.7555007655928345e-04, 1.3365888276934993e-04, -2.8055080587645673e-04, -6.8617367385189203e-04, 2.0111488204472137e-04, -3.5677735636164015e-05, 1.5038190317367591e-05, 2.0111488204472137e-04, -6.8307312914361548e-04, 3.7317688096927270e-04, 2.2841592720268073e-05, -3.5677735636164015e-05, 3.7317688096927270e-04, -5.7456997444991467e-04, 9.8364592445165106e-05, 1.5038190317367591e-05, 2.2841592720268073e-05, 9.8364592445165106e-05, -4.9874689148873266e-04, -9.7937117522682625e-04, 1.3365493445469090e-04, -3.5389680247569871e-05, 1.7409836485831839e-04, 1.3365493445469090e-04, -3.0622931287801688e-04, 2.0447820578798172e-04, -2.0241678808795576e-05, -3.5389680247569871e-05, 2.0447820578798172e-04, -2.9965533718679050e-04, -5.0337561347213358e-05, 1.7409836485831839e-04, -2.0241678808795576e-05, -5.0337561347213358e-05, -9.7218271603616025e-05, -7.2361999623641096e-04, 6.0238770967297993e-05, 9.5583099624811875e-06, -4.8817196772293789e-05, 6.0238770967297993e-05, -4.2873796707020983e-04, 3.5290062490134286e-05, 1.0186668437085330e-04, 9.5583099624811875e-06, 3.5290062490134286e-05, -1.7327171153624178e-04, 7.5826006592362129e-05, -4.8817196772293789e-05, 1.0186668437085330e-04, 7.5826006592362129e-05, -6.6625240506338742e-05, -5.1082007985057531e-04, 9.0145069011309307e-05, 1.0545714803937606e-04, 9.9838943414637320e-05, 9.0145069011309307e-05, -2.9666343813120901e-04, 1.6607259863244859e-04, -8.0518077824595215e-05, 1.0545714803937606e-04, 1.6607259863244859e-04, -2.7888486151681505e-04, 9.9492300205694249e-05, 9.9838943414637320e-05, -8.0518077824595215e-05, 9.9492300205694249e-05, -1.6153484908064224e-04, -3.8893832026680984e-04, 8.4480598688399479e-05, 1.3917939203462009e-04, 6.4028139288043303e-05, 8.4480598688399479e-05, -2.9031480540068355e-04, 4.1581354137412694e-05, 1.3719607068135917e-04, 1.3917939203462009e-04, 4.1581354137412694e-05, -2.5727897912316704e-04, 2.3355557894492145e-05, 6.4028139288043303e-05, 1.3719607068135917e-04, 2.3355557894492145e-05, -2.0869295477029555e-04, -1.2940743236606971e-03, 9.9242112186229852e-05, -3.0883079008754396e-05, 2.4110922845507835e-04, 9.9242112186229852e-05, -5.4844927137480013e-04, 1.5284676340009107e-04, 1.5074954460357989e-04, -3.0883079008754396e-05, 1.5284676340009107e-04, -3.5890880634564429e-04, -9.2111965277796469e-05, 2.4110922845507835e-04, 1.5074954460357989e-04, -9.2111965277796469e-05, -2.1606644503010969e-04, -3.6859095195743705e-04, 1.2811340827727349e-04, 7.1617940606111583e-05, 1.2147695942115610e-04, 1.2811340827727349e-04, -2.4093211232803426e-04, -4.5817408623953358e-05, -2.6602561355328134e-05, 7.1617940606111583e-05, -4.5817408623953358e-05, -1.8715896488104966e-04, -2.9073404906152265e-06, 1.2147695942115610e-04, -2.6602561355328134e-05, -2.9073404906152265e-06, -1.1706145694897137e-04, -6.6786161879298469e-04, 3.5686415150814899e-05, 1.5672913017009308e-04, 8.1161443650996505e-05, 3.5686415150814899e-05, -4.8659658995020956e-04, 1.8844759048223573e-04, 1.8572079841468395e-05, 1.5672913017009308e-04, 1.8844759048223573e-04, -3.3591563943804917e-04, 5.8356892899359846e-05, 8.1161443650996505e-05, 1.8572079841468395e-05, 5.8356892899359846e-05, -2.5729244353890580e-04, -4.9057710957934610e-04, 3.5189384292357178e-05, 1.2768527966492655e-04, 7.7111559864786111e-05, 3.5189384292357178e-05, -3.3022996564975609e-04, 1.1998806440725087e-04, 7.9127474986119613e-05, 1.2768527966492655e-04, 1.1998806440725087e-04, -2.2746335211673159e-04, 8.6400013414019474e-05, 7.7111559864786111e-05, 7.9127474986119613e-05, 8.6400013414019474e-05, -2.0017500168890246e-04, -1.1930564853647864e-03, 3.6059432907568098e-04, -4.5802509267350180e-05, 1.6549786604919792e-04, 3.6059432907568098e-04, -6.6459120881215568e-04, 2.2815747528720748e-04, 5.2558786107152938e-05, -4.5802509267350180e-05, 2.2815747528720748e-04, -6.2636194192342237e-04, 1.8747959874315315e-05, 1.6549786604919792e-04, 5.2558786107152938e-05, 1.8747959874315315e-05, -3.2850961953909732e-04, 7.8706872876127071e-02, -2.2653584740143385e-02, 9.7740231630116456e-04, -8.0082023113196138e-04, -2.2653584740143385e-02, -8.9447422099334685e-03, -8.8792954595688558e-04, 1.1368137224524006e-03, 9.7740231630116456e-04, -8.8792954595688558e-04, -7.7069586145163686e-04, 2.3926064253705276e-04, -8.0082023113196138e-04, 1.1368137224524006e-03, 2.3926064253705276e-04, -6.6984821695051074e-04, -1.0791500301598586e-01, -3.2421420547026750e-02, -1.6310176240427882e-03, -1.6324544291089519e-03, -3.2421420547026750e-02, -1.0068088253218213e-02, 3.7700151002736698e-04, 1.5579093564988948e-03, -1.6310176240427882e-03, 3.7700151002736698e-04, -6.4009621154418304e-04, 1.3364317447552753e-04, -1.6324544291089519e-03, 1.5579093564988948e-03, 1.3364317447552753e-04, -4.5908668219426775e-04, 1.9931647893026413e-02, 1.8868322719129860e-02, -2.6059845702808022e-04, -1.7677688147390257e-04, 1.8868322719129860e-02, -2.0969852051011485e-04, 3.6441845096447370e-04, 2.7994468344729460e-04, -2.6059845702808022e-04, 3.6441845096447370e-04, -2.8402192286764761e-04, -5.7796869103119775e-06, -1.7677688147390257e-04, 2.7994468344729460e-04, -5.7796869103119775e-06, -2.7098438358809471e-04, -2.5171876544209310e-01, -1.6215224556807420e-02, -1.7135769001415840e-03, 1.5448964301369569e-03, -1.6215224556807420e-02, -2.3023489339995557e-03, 1.5454079463723322e-03, 1.4540171518868922e-04, -1.7135769001415840e-03, 1.5454079463723322e-03, -1.5783435634697221e-03, -5.6267811205058696e-04, 1.5448964301369569e-03, 1.4540171518868922e-04, -5.6267811205058696e-04, -1.4668478620555464e-03, 9.0064272324944780e-02, 1.0159854544206332e-02, -1.8417068624857591e-03, 1.5581049875507725e-03, 1.0159854544206332e-02, -1.2626008140885292e-03, 5.5672594951240815e-04, -6.6992565886242451e-04, -1.8417068624857591e-03, 5.5672594951240815e-04, -6.3183326791236682e-04, 3.4048390925801674e-04, 1.5581049875507725e-03, -6.6992565886242451e-04, 3.4048390925801674e-04, -4.5748292658650842e-04, -2.2443359343759173e-01, 2.3550848933061329e-02, -1.3605814923240537e-03, 1.6581748189729430e-03, 2.3550848933061329e-02, -1.2119208694257528e-03, 1.1877044380419087e-03, -8.7237437059008887e-04, -1.3605814923240537e-03, 1.1877044380419087e-03, -1.0281058010702063e-03, -1.6587408018026506e-04, 1.6581748189729430e-03, -8.7237437059008887e-04, -1.6587408018026506e-04, -1.0202663289786004e-03, -2.6189782764010544e-01, 2.2986538547258420e-02, -1.7632069264149162e-03, 1.5107406905049286e-03, 2.2986538547258420e-02, -1.2746144428941505e-03, 4.8343451999544908e-04, -5.7379894194384067e-04, -1.7632069264149162e-03, 4.8343451999544908e-04, -5.6480453719830008e-04, 3.4954233236744335e-04, 1.5107406905049286e-03, -5.7379894194384067e-04, 3.4954233236744335e-04, -4.8900362963805524e-04, -1.2749879550430313e-01, 2.8523823603441460e-02, -1.9125154882043663e-03, 2.7084423469016369e-03, 2.8523823603441460e-02, -2.3862377659643530e-03, 5.1372875563453473e-04, -4.3154165895067698e-04, -1.9125154882043663e-03, 5.1372875563453473e-04, -1.1276693699735670e-03, -8.2543254355266842e-05, 2.7084423469016369e-03, -4.3154165895067698e-04, -8.2543254355266842e-05, -1.0951105630241573e-03, -1.0158866176089715e-01, 1.6602982315561777e-02, -1.7772582548894245e-03, 4.3920384137976376e-04, 1.6602982315561777e-02, -4.7547131566108777e-03, 6.8783893805187952e-05, -1.0748720663370313e-03, -1.7772582548894245e-03, 6.8783893805187952e-05, -5.0205120710799611e-04, -3.3919151133434616e-05, 4.3920384137976376e-04, -1.0748720663370313e-03, -3.3919151133434616e-05, -3.1422927937441901e-04, 1.5108981059488835e-01, 2.1974044174935103e-03, 4.9973793800626900e-04, -2.0324655241621987e-03, 2.1974044174935103e-03, -2.0249834345665027e-03, 2.8912368069502044e-04, -3.9641649235281848e-04, 4.9973793800626900e-04, 2.8912368069502044e-04, -1.4279057483715719e-03, 2.3314451382963299e-04, -2.0324655241621987e-03, -3.9641649235281848e-04, 2.3314451382963299e-04, -9.6409814362172263e-04, -9.7276844843051602e-02, 3.5504450866312058e-03, 3.8203830614491319e-03, -1.4507036855037911e-03, 3.5504450866312058e-03, -1.1050016265867703e-03, 3.0086962405142534e-05, 2.4446145351075344e-04, 3.8203830614491319e-03, 3.0086962405142534e-05, -1.8455518785688229e-03, 6.3062318909916208e-04, -1.4507036855037911e-03, 2.4446145351075344e-04, 6.3062318909916208e-04, -8.0531364204684895e-04, 2.9804711899684446e-02, -1.5978165071995631e-02, 1.0778430397325950e-03, -1.4446815201809952e-03, -1.5978165071995631e-02, -5.6345296642827322e-03, -1.0626058855508918e-03, 5.0267944657573355e-04, 1.0778430397325950e-03, -1.0626058855508918e-03, -1.0914650387547676e-03, 4.3259937074976290e-04, -1.4446815201809952e-03, 5.0267944657573355e-04, 4.3259937074976290e-04, -4.5142572576815595e-04, -6.9494494593566603e-02, -2.0051133800610695e-02, 5.8710738033530515e-04, 3.5010545121283096e-04, -2.0051133800610695e-02, -7.1098727986929232e-03, -2.5423159406186779e-04, -9.3348474227718226e-04, 5.8710738033530515e-04, -2.5423159406186779e-04, -6.0375150441947952e-04, 2.7259811627839867e-04, 3.5010545121283096e-04, -9.3348474227718226e-04, 2.7259811627839867e-04, -5.4004855753860101e-04, 1.5401777363000305e-01, 8.1160613829283474e-04, 9.2628051082108370e-04, 3.6211771998279100e-03, 8.1160613829283474e-04, -1.7141151995087387e-03, -3.3990186206657631e-04, -2.5417245475395459e-04, 9.2628051082108370e-04, -3.3990186206657631e-04, -1.4122852387503289e-03, -1.0293746792916486e-04, 3.6211771998279100e-03, -2.5417245475395459e-04, -1.0293746792916486e-04, -1.2188212673550846e-03, -1.2066137822324684e-01, -2.1235012929347232e-02, 1.6254696003078779e-03, -1.2375969117924457e-03, -2.1235012929347232e-02, -6.7234109883531987e-03, 4.4368086424732868e-05, 5.4519256781239238e-04, 1.6254696003078779e-03, 4.4368086424732868e-05, -1.7851002974240047e-03, 2.6435810786128557e-04, -1.2375969117924457e-03, 5.4519256781239238e-04, 2.6435810786128557e-04, -9.5219784353280741e-04, -2.0428062162336544e-01, -1.8822402400988779e-02, 8.0995888860823685e-04, -1.1746114214952719e-03, -1.8822402400988779e-02, -3.1320256402858366e-03, -9.4173163158250614e-04, 5.3739665278471852e-04, 8.0995888860823685e-04, -9.4173163158250614e-04, -8.4068628230452394e-04, 2.2479483070440945e-04, -1.1746114214952719e-03, 5.3739665278471852e-04, 2.2479483070440945e-04, -7.5550494619625963e-04, 2.0478820977633771e-02, 5.6432816347106261e-03, 1.5567905281500807e-03, 3.1015131190170152e-03, 5.6432816347106261e-03, -1.8593392130277192e-03, -1.0887013744527499e-03, -5.9319521599679871e-04, 1.5567905281500807e-03, -1.0887013744527499e-03, -1.8709510047864347e-03, -1.6277602269798984e-04, 3.1015131190170152e-03, -5.9319521599679871e-04, -1.6277602269798984e-04, -1.8685922653237117e-03, 6.5107726886614783e-03, -3.6209927731580757e-03, -3.8090764358667738e-04, 4.8090075186154230e-04, -3.6209927731580757e-03, -2.5033792471679753e-03, 2.3549698237273272e-04, -6.0379270164610918e-04, -3.8090764358667738e-04, 2.3549698237273272e-04, -7.2631802550718566e-04, 3.6336152250252679e-04, 4.8090075186154230e-04, -6.0379270164610918e-04, 3.6336152250252679e-04, -5.9720775259365871e-04, 1.5597924802072299e-01, -9.1287267636976852e-03, 5.1940698209609363e-03, -1.9270196737078854e-03, -9.1287267636976852e-03, -1.0171355227070189e-03, -8.3707115487426011e-04, 2.6648470329260969e-04, 5.1940698209609363e-03, -8.3707115487426011e-04, -1.5133538294868042e-03, 5.0193401691492020e-04, -1.9270196737078854e-03, 2.6648470329260969e-04, 5.0193401691492020e-04, -7.5563292076018306e-04, -5.1184574889172579e-02, 2.7987397416586360e-02, 7.5080665467791617e-04, 7.0012226943657642e-04, 2.7987397416586360e-02, -2.1716159037027593e-03, -4.8086372671787576e-04, -9.8018175618315873e-04, 7.5080665467791617e-04, -4.8086372671787576e-04, -7.3577207641989818e-04, 2.6562080093313106e-04, 7.0012226943657642e-04, -9.8018175618315873e-04, 2.6562080093313106e-04, -6.0973448697062660e-04, 1.3382668541587697e-01, -2.2722610733945561e-02, -1.2434543017359170e-03, -1.2728876503270323e-03, -2.2722610733945561e-02, -4.3688188071787232e-03, 7.7645284186351441e-04, 6.3845101211561532e-04, -1.2434543017359170e-03, 7.7645284186351441e-04, -7.3990375201463685e-04, -2.2683288029159060e-04, -1.2728876503270323e-03, 6.3845101211561532e-04, -2.2683288029159060e-04, -6.7815800933636403e-04, 1.3120488245988418e-01, 4.8547089951903696e-02, 5.2274693388694210e-04, 4.0755937244519420e-04, 4.8547089951903696e-02, -8.3907942102404050e-03, -3.8252224092104130e-04, -4.0281273644884673e-04, 5.2274693388694210e-04, -3.8252224092104130e-04, -6.3441175364586163e-04, 3.6516056969289123e-04, 4.0755937244519420e-04, -4.0281273644884673e-04, 3.6516056969289123e-04, -6.1351796194961811e-04, -1.5706881122068012e-01, -2.8064609799324989e-02, 5.2866261510743358e-04, -5.0158079779070628e-04, -2.8064609799324989e-02, -7.9255987347370254e-03, -7.2907309715153476e-04, 2.0023722312570202e-04, 5.2866261510743358e-04, -7.2907309715153476e-04, -8.7726820594463044e-04, 9.3347733493378919e-04, -5.0158079779070628e-04, 2.0023722312570202e-04, 9.3347733493378919e-04, -7.6444145077611959e-04, -2.4185449825431532e-01, 9.3190796925950465e-03, -1.0360517460863226e-03, 7.5166654771481383e-04, 9.3190796925950465e-03, -1.8089927328024354e-03, 4.5529238180270712e-04, -6.7548648300266129e-04, -1.0360517460863226e-03, 4.5529238180270712e-04, -9.8195456656893299e-04, 3.2953602624600028e-04, 7.5166654771481383e-04, -6.7548648300266129e-04, 3.2953602624600028e-04, -7.5088680434060126e-04, -6.2266646786067938e-03, 4.3482306684820587e-02, -6.7931544150714681e-04, -1.1318057792932172e-03, 4.3482306684820587e-02, -3.0163016880633831e-03, 1.1154407743767898e-03, 1.2680847876108238e-03, -6.7931544150714681e-04, 1.1154407743767898e-03, -6.2686682105641005e-04, 2.4799994581475311e-05, -1.1318057792932172e-03, 1.2680847876108238e-03, 2.4799994581475311e-05, -4.8261912829217966e-04, 4.4034487767024420e-02, 1.2027693141635914e-02, -3.1617252369308421e-04, -1.3810034906793043e-03, 1.2027693141635914e-02, -1.9189382672973364e-03, 3.5771288333242082e-04, 3.2903469104204127e-04, -3.1617252369308421e-04, 3.5771288333242082e-04, -7.7434480573853985e-04, 1.4662364658262446e-04, -1.3810034906793043e-03, 3.2903469104204127e-04, 1.4662364658262446e-04, -7.1146947717666163e-04, -1.7439979214498852e-01, 2.5559515911645361e-02, -1.3609574326154626e-03, -8.1347979141622453e-04, 2.5559515911645361e-02, -1.9101252004779083e-03, 5.8401786740861872e-04, 2.6463889212369153e-04, -1.3609574326154626e-03, 5.8401786740861872e-04, -1.2022614404840581e-03, 1.9183593028871340e-04, -8.1347979141622453e-04, 2.6463889212369153e-04, 1.9183593028871340e-04, -7.2688162163724512e-04, -2.6243218345287456e-01, 4.9398209870091560e-03, -1.5696233107405566e-03, 1.0567220238967725e-03, 4.9398209870091560e-03, -1.4022787059415794e-03, 5.8256688059597295e-04, 1.9025682403384436e-05, -1.5696233107405566e-03, 5.8256688059597295e-04, -1.3070453333682249e-03, -3.3851763928833433e-04, 1.0567220238967725e-03, 1.9025682403384436e-05, -3.3851763928833433e-04, -1.2320723061259361e-03, -8.2714390070501104e-02, 1.0975412304762084e-02, -4.2098382115161030e-04, -6.7702215349947506e-04, 1.0975412304762084e-02, -8.7719105355609575e-03, 6.4626568971351604e-04, 3.4082672855708366e-04, -4.2098382115161030e-04, 6.4626568971351604e-04, -5.3896694179129197e-04, 1.8641783252149489e-04, -6.7702215349947506e-04, 3.4082672855708366e-04, 1.8641783252149489e-04, -3.3770767382408195e-04, -1.2193197837136689e-01, -1.5380109380286541e-02, 3.3246097773883404e-04, -1.6628731429037037e-03, -1.5380109380286541e-02, -2.5373182102857170e-03, -2.0443003453976912e-05, 8.2993773737306147e-04, 3.3246097773883404e-04, -2.0443003453976912e-05, -8.8731220769894020e-04, -6.0009982488096482e-05, -1.6628731429037037e-03, 8.2993773737306147e-04, -6.0009982488096482e-05, -7.1835196502551967e-04, 7.8012293187519954e-02, 3.1132058063563710e-02, -1.1696899428820292e-03, -1.3753629772876416e-03, 3.1132058063563710e-02, -2.9320533071647394e-03, 4.4209006788966515e-04, 5.4507080398151985e-04, -1.1696899428820292e-03, 4.4209006788966515e-04, -6.3061860103715917e-04, 2.3835122850300404e-04, -1.3753629772876416e-03, 5.4507080398151985e-04, 2.3835122850300404e-04, -4.8807112103491492e-04, 1.2489186610021678e-01, -4.2121994803512846e-03, -1.4615798111060961e-03, -1.3284544933660910e-03, -4.2121994803512846e-03, -1.9469301448134307e-03, 2.4383944981524552e-04, 9.0191595070716760e-04, -1.4615798111060961e-03, 2.4383944981524552e-04, -8.4489411054921443e-04, -3.2983470816998103e-04, -1.3284544933660910e-03, 9.0191595070716760e-04, -3.2983470816998103e-04, -5.5892089821921545e-04, -1.3647684084529246e-01, 3.9776937406723417e-02, 6.1334383189688029e-04, -8.9816660782599911e-04, 3.9776937406723417e-02, -4.3020139627246353e-04, -9.3557080941627938e-04, 7.7958935546057592e-04, 6.1334383189688029e-04, -9.3557080941627938e-04, -3.5211495153066340e-04, 5.8831013523111768e-05, -8.9816660782599911e-04, 7.7958935546057592e-04, 5.8831013523111768e-05, -3.1382659001747163e-04, -1.6918244557222134e-01, -2.6159967833569130e-02, -1.5521334165285558e-03, -1.6552342040953793e-03, -2.6159967833569130e-02, -8.5733501045166700e-03, 1.1884549627826878e-03, 2.9341595161121387e-04, -1.5521334165285558e-03, 1.1884549627826878e-03, -6.8065594315602643e-04, 1.8544180606965729e-04, -1.6552342040953793e-03, 2.9341595161121387e-04, 1.8544180606965729e-04, -4.5742794945487230e-04, -2.0437904412209100e-02, 2.0278428462028566e-02, -3.1833318892537861e-04, -1.5672358504625003e-03, 2.0278428462028566e-02, -2.3308820806625680e-03, -9.2413164888836781e-05, 1.2261910114897223e-03, -3.1833318892537861e-04, -9.2413164888836781e-05, -6.1509973454375463e-04, -3.1369065713858962e-04, -1.5672358504625003e-03, 1.2261910114897223e-03, -3.1369065713858962e-04, -6.1311372710779475e-04, -2.1068663677001948e-01, 3.0586587729756580e-02, -1.4638083866968235e-03, -1.7663639913775599e-03, 3.0586587729756580e-02, -2.4896000109830450e-03, 1.0878021744662348e-03, 5.5784495882122158e-04, -1.4638083866968235e-03, 1.0878021744662348e-03, -8.5226768150814753e-04, 2.4896475900177203e-04, -1.7663639913775599e-03, 5.5784495882122158e-04, 2.4896475900177203e-04, -7.2954677906140835e-04, -2.0670514661104566e-01, 2.3101872560098982e-03, -6.3615804468624706e-04, -1.0191121784747393e-03, 2.3101872560098982e-03, -4.5012725771569565e-03, 3.0966024212130121e-04, 7.3480770548280236e-04, -6.3615804468624706e-04, 3.0966024212130121e-04, -7.6577049132799655e-04, 1.9069869693581136e-04, -1.0191121784747393e-03, 7.3480770548280236e-04, 1.9069869693581136e-04, -3.3060687835284803e-04, 1.4979203013904469e-01, 7.1888739604317664e-03, -1.6498112176118718e-03, 7.6090317854697837e-04, 7.1888739604317664e-03, -1.6847252134716941e-03, 9.1765413550792092e-04, -8.1660576268565398e-04, -1.6498112176118718e-03, 9.1765413550792092e-04, -5.6736119553899445e-04, 2.4293054607895927e-04, 7.6090317854697837e-04, -8.1660576268565398e-04, 2.4293054607895927e-04, -3.0141462646083878e-04, -2.5893180917593467e-01, -8.1773154879442519e-03, -1.8051666448928912e-03, -1.7078409149329419e-03, -8.1773154879442519e-03, -2.4391627814064182e-03, 2.5949401569512947e-04, 7.3814751053530889e-04, -1.8051666448928912e-03, 2.5949401569512947e-04, -8.9181287706463540e-04, 1.2172298924298193e-04, -1.7078409149329419e-03, 7.3814751053530889e-04, 1.2172298924298193e-04, -5.5666018893034495e-04, 1.3114296578438139e-01, -6.0075695408917090e-03, 4.3242635386152908e-04, -1.6174936298550607e-03, -6.0075695408917090e-03, -2.1679629901973250e-03, -1.4790030682634993e-04, 4.0251669474305628e-04, 4.3242635386152908e-04, -1.4790030682634993e-04, -6.4946095998946827e-04, 2.8330245317322158e-04, -1.6174936298550607e-03, 4.0251669474305628e-04, 2.8330245317322158e-04, -5.4324532966633539e-04, 1.5527234406654167e-01, 4.5641696399707443e-02, -1.1740442464421269e-03, -1.5447474252538395e-03, 4.5641696399707443e-02, -6.1793537674581797e-03, 1.5275860858276267e-03, 8.6030738024539066e-04, -1.1740442464421269e-03, 1.5275860858276267e-03, -7.8182161800352231e-04, -1.5885947204160602e-04, -1.5447474252538395e-03, 8.6030738024539066e-04, -1.5885947204160602e-04, -7.3143195173575981e-04, 1.1697380540622421e-01, -1.8452554290786850e-03, 1.0016961110488366e-03, -1.4829998143344009e-03, -1.8452554290786850e-03, -1.1489869626221500e-03, -4.0492587305436355e-04, 2.7582642932447637e-04, 1.0016961110488366e-03, -4.0492587305436355e-04, -8.2641017439131223e-04, 3.3828661526212394e-04, -1.4829998143344009e-03, 2.7582642932447637e-04, 3.3828661526212394e-04, -7.1775652801919342e-04, 2.4087451790493968e-02, 3.6657022667584582e-02, -2.3160169352650246e-05, -1.4754112553395189e-03, 3.6657022667584582e-02, -2.7192998188347670e-03, 4.9290573568910629e-04, 4.2019978689329402e-04, -2.3160169352650246e-05, 4.9290573568910629e-04, -8.0300459280031010e-04, 3.0740767103767887e-04, -1.4754112553395189e-03, 4.2019978689329402e-04, 3.0740767103767887e-04, -6.4767348263235984e-04, -1.6342252605621727e-01, 1.8127756599951576e-02, -1.1824339446502448e-03, -5.6869655256144131e-04, 1.8127756599951576e-02, -5.4663896424227282e-03, 9.1072733783564201e-04, -3.4788638053916024e-05, -1.1824339446502448e-03, 9.1072733783564201e-04, -6.6244397559521830e-04, -2.5432935828759249e-04, -5.6869655256144131e-04, -3.4788638053916024e-05, -2.5432935828759249e-04, -4.8751736339739109e-04, -1.5701412918240615e-01, 2.7992421613277401e-02, -4.6515704530449996e-04, -7.9964297888608410e-04, 2.7992421613277401e-02, -3.9221662977877072e-03, 2.9742173175084299e-04, 7.9338187798423123e-04, -4.6515704530449996e-04, 2.9742173175084299e-04, -5.5822864771270446e-04, 2.1181161515901515e-04, -7.9964297888608410e-04, 7.9338187798423123e-04, 2.1181161515901515e-04, -3.9618825805997281e-04, -1.2003184408108214e-01, 1.8018611826677796e-03, -1.4587721561363381e-03, -1.4251735569210393e-03, 1.8018611826677796e-03, -2.3078955332620707e-03, 3.8402353601999531e-04, 3.6911457383390317e-04, -1.4587721561363381e-03, 3.8402353601999531e-04, -1.1519702353104452e-03, 9.8372557539751129e-05, -1.4251735569210393e-03, 3.6911457383390317e-04, 9.8372557539751129e-05, -7.3110630617569865e-04, -1.6462935008848217e-01, 1.0600946531245254e-02, 3.6977083048745467e-03, -1.4181644891152485e-03, 1.0600946531245254e-02, -1.3992372112707173e-03, 3.4296475948198595e-04, -1.1160182310149349e-03, 3.6977083048745467e-03, 3.4296475948198595e-04, -1.6724888886693919e-03, -7.8051702685589782e-04, -1.4181644891152485e-03, -1.1160182310149349e-03, -7.8051702685589782e-04, -1.4795383843152874e-03, 2.5193698717292578e-03, -7.2228540313489780e-03, 8.7131868658691573e-04, -1.1871506186637458e-03, -7.2228540313489780e-03, -8.3981655790035283e-03, -3.1337460147976907e-05, 1.7507484534873217e-04, 8.7131868658691573e-04, -3.1337460147976907e-05, -1.1381726073134719e-03, 9.0691674803716218e-05, -1.1871506186637458e-03, 1.7507484534873217e-04, 9.0691674803716218e-05, -5.4923843003268163e-04, -9.8541123283475321e-02, 2.0328745160678043e-02, -2.0458389881609796e-03, 9.0630002244413007e-04, 2.0328745160678043e-02, -7.4221841135019870e-04, 5.3925274862334381e-04, -9.0169207887240497e-04, -2.0458389881609796e-03, 5.3925274862334381e-04, -8.1237048011580354e-04, -1.7572671277406646e-04, 9.0630002244413007e-04, -9.0169207887240497e-04, -1.7572671277406646e-04, -4.4334028399372748e-04, -2.7234646577534043e-02, 2.5369573930940532e-02, 1.5705630781754590e-04, 6.1198876277706281e-04, 2.5369573930940532e-02, -1.3071102928106637e-03, -7.2368957471257269e-04, -5.2265333441466977e-04, 1.5705630781754590e-04, -7.2368957471257269e-04, -1.1462134164282704e-03, 2.3337377507278166e-04, 6.1198876277706281e-04, -5.2265333441466977e-04, 2.3337377507278166e-04, -7.2368697376535771e-04, -2.4800412677279193e-01, 3.0558589210589435e-02, -1.7679744500246292e-03, -1.5482210113520617e-03, 3.0558589210589435e-02, -2.4786384007542978e-03, 8.5356892230528767e-04, 4.3403640403337902e-04, -1.7679744500246292e-03, 8.5356892230528767e-04, -8.3267405947969693e-04, 9.7644740296861087e-05, -1.5482210113520617e-03, 4.3403640403337902e-04, 9.7644740296861087e-05, -7.6184659130409797e-04, 6.4088879122978254e-02, 7.4033191067212354e-03, -3.0166036111540026e-04, 2.2866639862654022e-03, 7.4033191067212354e-03, -1.9075281126971072e-03, -1.7513934189862141e-04, -8.3685859198624453e-04, -3.0166036111540026e-04, -1.7513934189862141e-04, -6.4451282241398183e-04, 1.0242732795762495e-04, 2.2866639862654022e-03, -8.3685859198624453e-04, 1.0242732795762495e-04, -4.7151425790170642e-04, 2.6280963047272420e-03, -8.2523616999923399e-03, 6.9274155947225767e-04, 2.2806878867334188e-04, -8.2523616999923399e-03, -9.9628281026221477e-04, 2.5812365885309900e-04, -1.1568156376056965e-04, 6.9274155947225767e-04, 2.5812365885309900e-04, -1.0820703009744815e-03, -3.1530431722761752e-05, 2.2806878867334188e-04, -1.1568156376056965e-04, -3.1530431722761752e-05, -7.5527985458567228e-04, 9.1101115309797379e-02, -2.2884644065069411e-02, 9.1368322276223378e-04, -1.0850217992609608e-03, -2.2884644065069411e-02, -2.2375718156060894e-03, -6.8171614704544544e-04, 4.3298786621578863e-04, 9.1368322276223378e-04, -6.8171614704544544e-04, -6.0655582575581761e-04, -1.9700957313198807e-04, -1.0850217992609608e-03, 4.3298786621578863e-04, -1.9700957313198807e-04, -5.4760699412119591e-04, -2.2640416371139069e-01, -2.5191853524724098e-02, -1.3198312724450061e-03, -1.3359296338435942e-03, -2.5191853524724098e-02, -7.4114781706104268e-03, 1.4884771292347921e-03, 1.5714670158787022e-03, -1.3198312724450061e-03, 1.4884771292347921e-03, -1.3119866716855199e-03, -1.5536016251956771e-04, -1.3359296338435942e-03, 1.5714670158787022e-03, -1.5536016251956771e-04, -5.5696348361036394e-04, 9.2726790578004134e-02, -2.0242369791069288e-03, 3.8405423708959545e-04, 6.3967354157029978e-04, -2.0242369791069288e-03, -2.0157885093086683e-03, -3.2058306533741196e-04, 4.2971640692212861e-04, 3.8405423708959545e-04, -3.2058306533741196e-04, -1.9162959308769002e-03, -6.3827678873427419e-04, 6.3967354157029978e-04, 4.2971640692212861e-04, -6.3827678873427419e-04, -1.1765363907219604e-03, -1.1010994988318533e-01, 1.8364595516921723e-03, -1.7052805868601824e-03, 1.5722132456195729e-03, 1.8364595516921723e-03, -1.6428731888699357e-03, -6.9125587365518731e-05, -6.1003796613763421e-04, -1.7052805868601824e-03, -6.9125587365518731e-05, -1.3517785548352037e-03, 3.9700219843950759e-04, 1.5722132456195729e-03, -6.1003796613763421e-04, 3.9700219843950759e-04, -9.2229729865463410e-04, 1.0482002463291755e-01, 4.1269081557235562e-02, -1.4243305558994911e-03, 7.2560546133989428e-04, 4.1269081557235562e-02, -2.4533418282568198e-03, 1.3112208013762515e-03, -8.1980100268941986e-04, -1.4243305558994911e-03, 1.3112208013762515e-03, -6.5149545825962077e-04, -7.9051325639480671e-05, 7.2560546133989428e-04, -8.1980100268941986e-04, -7.9051325639480671e-05, -2.9459876874997148e-04, 5.2687763814020426e-02, 2.5753172346694865e-02, -1.1364673445506180e-03, 1.6847984517648468e-03, 2.5753172346694865e-02, -1.9744024088759471e-03, 6.5730101175142199e-04, -7.6106378367768782e-04, -1.1364673445506180e-03, 6.5730101175142199e-04, -6.8322027298045856e-04, -2.8125846979498703e-04, 1.6847984517648468e-03, -7.6106378367768782e-04, -2.8125846979498703e-04, -6.4384013872712724e-04, 5.9218429229155281e-02, -4.4827537798794370e-03, 1.0270811096682296e-03, -1.9168586516354947e-03, -4.4827537798794370e-03, -6.8593562640291818e-04, -4.6835704849159830e-04, -2.2268361484443280e-04, 1.0270811096682296e-03, -4.6835704849159830e-04, -1.3752987145318814e-03, 3.1079072153330253e-04, -1.9168586516354947e-03, -2.2268361484443280e-04, 3.1079072153330253e-04, -9.2178851145784926e-04, 6.4476070763014870e-02, -8.2336865840800244e-03, -8.2613444706260115e-05, 2.2870252609144106e-03, -8.2336865840800244e-03, -3.2744036284686373e-03, -4.1704987639591122e-05, -6.4166807270754048e-04, -8.2613444706260115e-05, -4.1704987639591122e-05, -4.1548386737107250e-04, -1.7479369462839750e-05, 2.2870252609144106e-03, -6.4166807270754048e-04, -1.7479369462839750e-05, -3.4493527017004036e-04, -6.1828450559953466e-03, 2.8428624253357817e-02, -7.5163309079767377e-04, 5.4940663791714793e-04, 2.8428624253357817e-02, -6.7829893110121844e-03, 8.1954861327358602e-04, -5.3114117045863587e-04, -7.5163309079767377e-04, 8.1954861327358602e-04, -6.0173813996780567e-04, -6.7160875496170326e-05, 5.4940663791714793e-04, -5.3114117045863587e-04, -6.7160875496170326e-05, -2.4845337051236009e-04, 1.0533880384113113e-01, 3.6210071469509400e-02, -1.7107999791441781e-03, -4.7083865881270926e-04, 3.6210071469509400e-02, -2.5591369610882472e-03, 1.0474090798181057e-03, 1.1172328488792965e-04, -1.7107999791441781e-03, 1.0474090798181057e-03, -6.2681311095400482e-04, -1.0956014522883990e-04, -4.7083865881270926e-04, 1.1172328488792965e-04, -1.0956014522883990e-04, -6.2294976074032634e-04, 1.1902524122755653e-01, -1.0909771422571959e-02, 1.2448713677229743e-03, -7.8880695949750681e-04, -1.0909771422571959e-02, -1.5951056840545162e-03, 2.7429495897176952e-04, 7.3506920307663841e-05, 1.2448713677229743e-03, 2.7429495897176952e-04, -9.7786177177501001e-04, 6.6672113049240779e-04, -7.8880695949750681e-04, 7.3506920307663841e-05, 6.6672113049240779e-04, -5.0679343969428484e-04, 1.6159868780566031e-01, 3.7481421868546007e-03, 3.3383110783462289e-03, -1.4389234118571464e-03, 3.7481421868546007e-03, -1.8935398127113731e-03, 2.5240285683527449e-04, 7.9691796069654658e-04, 3.3383110783462289e-03, 2.5240285683527449e-04, -1.3490096726389840e-03, 1.9074939429963151e-04, -1.4389234118571464e-03, 7.9691796069654658e-04, 1.9074939429963151e-04, -8.9877461888945853e-04, -2.2502909073369459e-01, -3.7321287736186322e-03, -1.7987858311244466e-03, -1.9708047702503991e-03, -3.7321287736186322e-03, -1.9214934405923476e-03, 3.5283302489755764e-04, 4.8110254301636892e-04, -1.7987858311244466e-03, 3.5283302489755764e-04, -1.2680475239585940e-03, 2.0205708932592430e-04, -1.9708047702503991e-03, 4.8110254301636892e-04, 2.0205708932592430e-04, -7.8681400841451241e-04, -2.3952675967064883e-02, -6.5409371210018051e-03, -2.6851469943078203e-04, -4.9805803828584922e-04, -6.5409371210018051e-03, -3.7561313498678302e-03, 2.3206665741903022e-04, 3.0048228666978370e-04, -2.6851469943078203e-04, 2.3206665741903022e-04, -4.4121780270757531e-04, -8.2215427654899162e-05, -4.9805803828584922e-04, 3.0048228666978370e-04, -8.2215427654899162e-05, -3.7500716387283193e-04, -2.1228367131798687e-01, 2.7113291916486364e-02, 4.6016317977870395e-04, -1.9594764054362895e-03, 2.7113291916486364e-02, -1.0853572773374739e-03, 2.5219233819137219e-04, 5.1172231054065541e-04, 4.6016317977870395e-04, 2.5219233819137219e-04, -1.8213699224644336e-03, 3.7393213810628812e-04, -1.9594764054362895e-03, 5.1172231054065541e-04, 3.7393213810628812e-04, -5.5588635692437049e-04, -1.2594061059151607e-01, 1.2592656724822970e-02, -4.0285977545487228e-04, -4.4341698620668172e-04, 1.2592656724822970e-02, -6.1572534159074592e-03, 4.8152144273438187e-04, -4.9727853505236708e-04, -4.0285977545487228e-04, 4.8152144273438187e-04, -9.3221660800086681e-04, 4.3322214079744763e-04, -4.4341698620668172e-04, -4.9727853505236708e-04, 4.3322214079744763e-04, -6.2440230731627326e-04, -1.3585509657998510e-01, -3.8909226522543441e-03, 3.0193138572521729e-03, -4.6754349870445496e-04, -3.8909226522543441e-03, -5.6220236698656771e-03, -8.0283448531211330e-04, 4.9313364840345667e-04, 3.0193138572521729e-03, -8.0283448531211330e-04, -8.4724654438547091e-04, -4.1535841093396958e-04, -4.6754349870445496e-04, 4.9313364840345667e-04, -4.1535841093396958e-04, -4.7533675347965273e-04, -2.1524465492323114e-01, 2.6830885704129219e-02, 4.8987007530070020e-03, -7.4769890428344238e-04, 2.6830885704129219e-02, -2.4008792532451296e-03, -4.3520127006076755e-04, -5.5384351394842390e-04, 4.8987007530070020e-03, -4.3520127006076755e-04, -1.9799533182669562e-03, 3.8152653140380451e-04, -7.4769890428344238e-04, -5.5384351394842390e-04, 3.8152653140380451e-04, -5.9785566430098553e-04, -1.6784213165410733e-01, 2.0244058370466202e-02, -1.3420658225188609e-03, -1.3189834234737445e-03, 2.0244058370466202e-02, -7.2263618147349398e-03, 1.1939034574010880e-03, 9.4667802145852230e-04, -1.3420658225188609e-03, 1.1939034574010880e-03, -7.6018644585713153e-04, -1.0210604952061623e-04, -1.3189834234737445e-03, 9.4667802145852230e-04, -1.0210604952061623e-04, -4.0821100223754577e-04, -2.3751039223678280e-01, 2.6165234489045515e-02, -1.9846169871215727e-03, 3.7170136665050013e-03, 2.6165234489045515e-02, -9.2783860491590594e-04, 2.8032134504712048e-04, -9.6957018524106912e-04, -1.9846169871215727e-03, 2.8032134504712048e-04, -1.2399063877565513e-03, 1.0528263449886494e-06, 3.7170136665050013e-03, -9.6957018524106912e-04, 1.0528263449886494e-06, -1.0651880667174132e-03, 6.8982016656450096e-02, -1.0194592948666651e-02, 4.0224436318745071e-04, -1.1696801694026104e-03, -1.0194592948666651e-02, -2.2058854995895081e-03, 4.3964931839049595e-05, 3.0469030637087147e-04, 4.0224436318745071e-04, 4.3964931839049595e-05, -1.3777303555632778e-03, 4.3404728696010988e-04, -1.1696801694026104e-03, 3.0469030637087147e-04, 4.3404728696010988e-04, -4.0950956530560686e-04, -9.2461109228483468e-02, -1.3650469255974099e-03, 6.9549155108044203e-04, -1.3791803108254750e-03, -1.3650469255974099e-03, -3.4426360382142198e-03, -8.9312514713293023e-04, 1.5185160693596093e-03, 6.9549155108044203e-04, -8.9312514713293023e-04, -1.2055712134559134e-03, 4.1803484747986825e-04, -1.3791803108254750e-03, 1.5185160693596093e-03, 4.1803484747986825e-04, -8.1179190435472248e-04, 1.7492329868952405e-01, -2.9646943331972139e-02, -6.6563429686947173e-04, 4.4682634999685810e-04, -2.9646943331972139e-02, -2.4173338183744193e-03, 3.3542502232973938e-04, 1.9443059924745616e-05, -6.6563429686947173e-04, 3.3542502232973938e-04, -9.9183926207136765e-04, 2.0084203476038989e-04, 4.4682634999685810e-04, 1.9443059924745616e-05, 2.0084203476038989e-04, -6.3908876172596529e-04, 3.1539924140147259e-02, 7.6934952984409844e-03, 3.6809732723858749e-03, -1.9589949144150562e-03, 7.6934952984409844e-03, -1.0048732991394538e-03, -6.8525949419794615e-04, 1.8196951541743413e-04, 3.6809732723858749e-03, -6.8525949419794615e-04, -1.9447331645722941e-03, 1.5283056340779168e-04, -1.9589949144150562e-03, 1.8196951541743413e-04, 1.5283056340779168e-04, -9.1738980564369424e-04, -3.9105676791886118e-02, 7.5467303744346081e-03, -1.8311155447274202e-03, 3.9722587176520933e-03, 7.5467303744346081e-03, -2.4625304120398338e-03, 6.5110354661161197e-04, -1.1424140297801545e-03, -1.8311155447274202e-03, 6.5110354661161197e-04, -7.6013689055211709e-04, 3.1982239567331837e-04, 3.9722587176520933e-03, -1.1424140297801545e-03, 3.1982239567331837e-04, -6.7960924512481386e-04, -6.1502540343009511e-02, -2.5918936122811376e-02, 8.2260585699679700e-04, -8.5737616123583824e-04, -2.5918936122811376e-02, -9.1045995335339511e-03, -7.6582517466873253e-04, 2.8347777788018374e-04, 8.2260585699679700e-04, -7.6582517466873253e-04, -9.8142522999483802e-04, 1.5709724166556660e-04, -8.5737616123583824e-04, 2.8347777788018374e-04, 1.5709724166556660e-04, -4.6604755267205529e-04, 2.1148032486205992e-01, -6.3731337543181353e-03, 8.0925966188404811e-04, 7.1463137701211561e-04, -6.3731337543181353e-03, -9.3133813463367691e-04, -1.3767800389944088e-04, -7.8134699474057532e-04, 8.0925966188404811e-04, -1.3767800389944088e-04, -5.9804522674363695e-04, -2.4139815546091799e-04, 7.1463137701211561e-04, -7.8134699474057532e-04, -2.4139815546091799e-04, -4.7788602351705350e-04, -3.7426472661389397e-02, 2.8157517432252185e-02, -1.0934144857086604e-03, 3.1458337980653973e-06, 2.8157517432252185e-02, -5.9309295616162740e-03, 2.5241788599436376e-04, 5.8278212231620947e-04, -1.0934144857086604e-03, 2.5241788599436376e-04, -5.9659440322057725e-04, 1.4773715153137406e-04, 3.1458337980653973e-06, 5.8278212231620947e-04, 1.4773715153137406e-04, -4.9439441008183914e-04, 1.2948178533847016e-01, -4.4858655966967973e-03, -7.3394293433360475e-04, -1.8318789975846868e-03, -4.4858655966967973e-03, -1.3111242346283915e-03, -1.0753742916959626e-03, 6.1098836231564713e-04, -7.3394293433360475e-04, -1.0753742916959626e-03, -1.7980863990064372e-03, 4.7774929182747947e-04, -1.8318789975846868e-03, 6.1098836231564713e-04, 4.7774929182747947e-04, -7.2636447350640115e-04, 1.1246840827726504e-01, 2.1631039403096977e-02, -1.6528967084977182e-03, -1.3069704047438378e-03, 2.1631039403096977e-02, -6.2735534467153794e-03, 9.1784915417337241e-04, 3.7040218222533875e-04, -1.6528967084977182e-03, 9.1784915417337241e-04, -6.1695925898898460e-04, 5.1243512009102464e-05, -1.3069704047438378e-03, 3.7040218222533875e-04, 5.1243512009102464e-05, -5.8607009651544847e-04, 2.3191443887515172e-02, -2.6201262501037315e-03, -7.6581304428420961e-04, -7.0793868722308494e-04, -2.6201262501037315e-03, -1.2427377919089994e-03, 1.3774011176280213e-04, 5.3774177980385463e-04, -7.6581304428420961e-04, 1.3774011176280213e-04, -4.4342025234310304e-04, 9.5568301616175372e-05, -7.0793868722308494e-04, 5.3774177980385463e-04, 9.5568301616175372e-05, -2.5406888063130668e-04, 9.3549762929661148e-02, 2.4789338496675476e-02, -1.7999250937495298e-03, 9.1491381013646730e-04, 2.4789338496675476e-02, -2.4686873006394385e-03, 1.1959407625742012e-04, 2.3453642308929890e-04, -1.7999250937495298e-03, 1.1959407625742012e-04, -1.3058948205367103e-03, 2.8220390404668665e-04, 9.1491381013646730e-04, 2.3453642308929890e-04, 2.8220390404668665e-04, -9.0785502558073951e-04, 8.0716780382424247e-02, 2.5365518135899486e-02, -1.0966084834676559e-03, 3.9092402053228742e-04, 2.5365518135899486e-02, -3.5742604372390177e-04, 1.1161995819547624e-03, -2.3097494896500610e-04, -1.0966084834676559e-03, 1.1161995819547624e-03, -9.9846801442279387e-04, -3.3563094825744084e-04, 3.9092402053228742e-04, -2.3097494896500610e-04, -3.3563094825744084e-04, -4.9557683336977874e-04, 4.0111243527158481e-02, -5.1743679607531489e-03, -6.4668882267963457e-04, -5.3256658217573259e-04, -5.1743679607531489e-03, -2.1959890278307748e-03, 3.3406917357637071e-04, 5.5860960683749177e-04, -6.4668882267963457e-04, 3.3406917357637071e-04, -4.0449951144626246e-04, 1.4870745971877001e-04, -5.3256658217573259e-04, 5.5860960683749177e-04, 1.4870745971877001e-04, -4.0088619373289668e-04, 1.3936559957096936e-02, -9.2345720437320422e-03, 1.7112603251330989e-03, -1.5812360931300338e-03, -9.2345720437320422e-03, -6.0853404733679922e-03, -8.1587691393434074e-04, 1.5127202442355710e-03, 1.7112603251330989e-03, -8.1587691393434074e-04, -1.0582512267918579e-03, 3.0169179197568852e-04, -1.5812360931300338e-03, 1.5127202442355710e-03, 3.0169179197568852e-04, -6.9818940668481635e-04, 1.2271035315361421e-01, 3.3834534832647936e-02, -8.4425345932574085e-04, -1.2845411056578771e-03, 3.3834534832647936e-02, -2.7021681799793487e-03, 1.4589329290161041e-03, 6.8134662217169816e-04, -8.4425345932574085e-04, 1.4589329290161041e-03, -8.5494381562856267e-04, 1.0288019018269524e-04, -1.2845411056578771e-03, 6.8134662217169816e-04, 1.0288019018269524e-04, -7.3984903838043902e-04, 1.3426877609097060e-01, 1.7349015756059596e-02, -1.3246192802241865e-03, -1.9305711238934450e-03, 1.7349015756059596e-02, -1.5270102850098125e-03, 4.4956077650381329e-04, 1.9714221201937447e-04, -1.3246192802241865e-03, 4.4956077650381329e-04, -6.4182469515364075e-04, 2.0433900996145839e-04, -1.9305711238934450e-03, 1.9714221201937447e-04, 2.0433900996145839e-04, -5.1586663656365934e-04, 8.6391392047467014e-02, 3.6980521889860229e-02, 9.3321794676103585e-04, 9.3948476321605902e-04, 3.6980521889860229e-02, -9.8928180871077319e-03, -5.3070991717869105e-04, -6.2377425133496771e-04, 9.3321794676103585e-04, -5.3070991717869105e-04, -3.0488330333303663e-04, 1.5659386456603057e-05, 9.3948476321605902e-04, -6.2377425133496771e-04, 1.5659386456603057e-05, -2.7999703918634182e-04, 1.0146744017771264e-01, 7.2816252131513558e-03, -1.6155238061515398e-03, 2.5644205137853007e-04, 7.2816252131513558e-03, -6.3112672678755539e-03, 1.6890811365672615e-03, 2.7693395172731348e-04, -1.6155238061515398e-03, 1.6890811365672615e-03, -1.2647032121969489e-03, -2.9370354320717849e-04, 2.5644205137853007e-04, 2.7693395172731348e-04, -2.9370354320717849e-04, -6.2342159510005504e-04, 1.2959056902281882e-01, -6.1301776131238232e-05, 1.6534216868320365e-03, -1.3058105872678105e-03, -6.1301776131238232e-05, -1.4249381206094562e-03, -9.5380678395206903e-04, 4.7419065106550553e-04, 1.6534216868320365e-03, -9.5380678395206903e-04, -1.5076699002388233e-03, 6.4805275159887318e-04, -1.3058105872678105e-03, 4.7419065106550553e-04, 6.4805275159887318e-04, -8.8238756291255597e-04, 8.9247536658271412e-02, 2.3842441423826456e-04, -1.4020150585281280e-03, -5.1152963328585229e-04, 2.3842441423826456e-04, -9.0191620517334706e-04, 2.8625020652046294e-04, -4.8584743596851983e-04, -1.4020150585281280e-03, 2.8625020652046294e-04, -1.0559260959327309e-03, 7.8831939884397011e-04, -5.1152963328585229e-04, -4.8584743596851983e-04, 7.8831939884397011e-04, -1.7109718079099097e-03, 1.8544185491158613e-01, -1.0718215088244560e-03, -1.8813810349262525e-03, -1.9339063688273953e-03, -1.0718215088244560e-03, -7.2274547605494753e-04, 8.6435447211605384e-04, -3.6026940405211872e-04, -1.8813810349262525e-03, 8.6435447211605384e-04, -8.1277716432238999e-04, -3.7277556893117323e-05, -1.9339063688273953e-03, -3.6026940405211872e-04, -3.7277556893117323e-05, -6.3915541802464406e-04, 1.4434415789530322e-01, -2.6872190143700809e-03, -1.0846599699061007e-03, -6.4477346277669280e-04, -2.6872190143700809e-03, -5.6018401280834278e-03, -5.0911052653693770e-05, 9.6450041626136844e-04, -1.0846599699061007e-03, -5.0911052653693770e-05, -9.4975456411969575e-04, 3.1940035065807030e-04, -6.4477346277669280e-04, 9.6450041626136844e-04, 3.1940035065807030e-04, -9.2420815563382878e-04, 7.8171789374052239e-02, 1.1131802654471883e-02, 1.7637127962972779e-03, 9.4754776914784435e-04, 1.1131802654471883e-02, -1.3560867793273460e-03, -1.0739127680493021e-03, 3.5149852956582349e-04, 1.7637127962972779e-03, -1.0739127680493021e-03, -1.7712750948741785e-03, -4.9962373537378436e-04, 9.4754776914784435e-04, 3.5149852956582349e-04, -4.9962373537378436e-04, -1.1574313866688994e-03, 5.2957801369084900e-02, -1.0005678772364536e-02, -4.7804628490494196e-04, -1.2361403815386134e-03, -1.0005678772364536e-02, -4.5116744307715714e-03, 4.1017691673670646e-04, 9.4250866230064672e-04, -4.7804628490494196e-04, 4.1017691673670646e-04, -9.2170564193822815e-04, 2.5987259125205417e-04, -1.2361403815386134e-03, 9.4250866230064672e-04, 2.5987259125205417e-04, -4.6176740062320114e-04, 1.0365332441174736e-01, -9.8221692578944128e-03, -1.9915804870139055e-03, -1.4829964959047716e-03, -9.8221692578944128e-03, -8.0048197952266309e-04, 2.0484157742938923e-04, 9.2083194131700275e-04, -1.9915804870139055e-03, 2.0484157742938923e-04, -7.4074324466875886e-04, 4.6683122189394826e-05, -1.4829964959047716e-03, 9.2083194131700275e-04, 4.6683122189394826e-05, -4.1774348179361514e-04, -1.3421959250355708e-01, 3.3713260029558795e-03, -1.3243455638564110e-03, -1.6977772976177158e-03, 3.3713260029558795e-03, -4.3427989568832846e-03, 1.5008659836834226e-03, 3.6385328660509515e-04, -1.3243455638564110e-03, 1.5008659836834226e-03, -4.4959639797028332e-04, -3.5993966797194079e-05, -1.6977772976177158e-03, 3.6385328660509515e-04, -3.5993966797194079e-05, -3.9959494583247839e-04, 1.5319795291380678e-01, 1.5606938575385582e-02, 1.2896044217671962e-04, 1.4042986843700814e-03, 1.5606938575385582e-02, -1.6968432451613968e-03, 6.1781606247467071e-04, -8.1022537873411268e-04, 1.2896044217671962e-04, 6.1781606247467071e-04, -9.0781561089793507e-04, 1.6085869694517344e-04, 1.4042986843700814e-03, -8.1022537873411268e-04, 1.6085869694517344e-04, -4.7576363868138846e-04, 1.2254882374915720e-01, 1.4693545363766116e-04, 2.1938591971393732e-03, -3.9982695744349866e-04, 1.4693545363766116e-04, -1.8792585045041851e-03, 4.2828698130133657e-04, 4.5172919991448188e-04, 2.1938591971393732e-03, 4.2828698130133657e-04, -1.0432885144689712e-03, -4.1920428823997481e-04, -3.9982695744349866e-04, 4.5172919991448188e-04, -4.1920428823997481e-04, -5.0654766396187863e-04, 6.2567741767689450e-02, -1.5942792665184773e-02, 9.4219357229582805e-04, -1.0047556566068546e-03, -1.5942792665184773e-02, -4.9222058747801188e-03, -8.8081902987161898e-04, 8.5096048171422992e-04, 9.4219357229582805e-04, -8.8081902987161898e-04, -6.4309961958789396e-04, -2.4752901697258346e-05, -1.0047556566068546e-03, 8.5096048171422992e-04, -2.4752901697258346e-05, -4.2749730100807973e-04, 2.0912880324801708e-01, -7.6064433064355411e-03, 5.3323058431332623e-04, -2.0532588685479958e-03, -7.6064433064355411e-03, -1.3135732341439657e-03, -7.8988659553189968e-04, 3.7928836724313318e-04, 5.3323058431332623e-04, -7.8988659553189968e-04, -7.3649612756357917e-04, -2.6573320308412903e-04, -2.0532588685479958e-03, 3.7928836724313318e-04, -2.6573320308412903e-04, -5.7797801692182097e-04, 1.5055274915795547e-01, -2.1924936777925716e-02, -1.2612611024713787e-03, 2.7821375886116877e-03, -2.1924936777925716e-02, -4.2068916459438062e-03, 1.3684687816957373e-03, -9.0195379182343130e-04, -1.2612611024713787e-03, 1.3684687816957373e-03, -1.2345358774530297e-03, -3.4235325803685078e-04, 2.7821375886116877e-03, -9.0195379182343130e-04, -3.4235325803685078e-04, -5.3816147544009192e-04, -9.4235991321761955e-02, -2.1367388228175833e-02, 1.0448569989099396e-03, 1.7485944032731482e-03, -2.1367388228175833e-02, -2.6716566352546589e-03, -7.3073829452656989e-04, -8.9610200660087183e-04, 1.0448569989099396e-03, -7.3073829452656989e-04, -6.7501385163585615e-04, 2.0355441125821877e-04, 1.7485944032731482e-03, -8.9610200660087183e-04, 2.0355441125821877e-04, -5.7236545019238698e-04, -6.9503808891479835e-02, 3.1383773305167471e-03, 1.5986828965354864e-03, -1.7402981803352200e-03, 3.1383773305167471e-03, -1.2489391870377849e-03, -8.5751835076954214e-04, 5.8268795422606202e-04, 1.5986828965354864e-03, -8.5751835076954214e-04, -1.5076108825684306e-03, -7.4944126836778806e-04, -1.7402981803352200e-03, 5.8268795422606202e-04, -7.4944126836778806e-04, -1.1142665347040458e-03, 4.7151474002859579e-02, 3.1740728795928382e-02, -9.4301630376494167e-04, -9.8957451562421933e-04, 3.1740728795928382e-02, -3.0449847294980667e-03, 7.3961197038087075e-04, 1.1737609646021582e-03, -9.4301630376494167e-04, 7.3961197038087075e-04, -5.3898208391981741e-04, 1.2215824265585573e-04, -9.8957451562421933e-04, 1.1737609646021582e-03, 1.2215824265585573e-04, -4.4878575781268185e-04, 6.9890878585001953e-02, 5.5058801359721072e-03, 4.3303599481317440e-04, 6.7321007698798990e-03, 5.5058801359721072e-03, -1.3315438647224626e-03, 2.4082287446273412e-04, -1.1070907494787486e-03, 4.3303599481317440e-04, 2.4082287446273412e-04, -1.6833930700655335e-03, -8.3440886703805834e-04, 6.7321007698798990e-03, -1.1070907494787486e-03, -8.3440886703805834e-04, -1.5967950989918100e-03, 8.5697346753994430e-02, -1.8323684437467489e-02, -5.9473967389843570e-04, -8.4314615829175212e-04, -1.8323684437467489e-02, -1.1875494620811390e-03, 9.7079341037182275e-04, 2.7501065040690445e-04, -5.9473967389843570e-04, 9.7079341037182275e-04, -5.2204544453808501e-04, 2.0919905664672838e-04, -8.4314615829175212e-04, 2.7501065040690445e-04, 2.0919905664672838e-04, -4.2639051308978156e-04, -2.2631222057764766e-01, -1.3601514363752679e-02, -1.6137759080852433e-03, 1.4950759744726269e-03, -1.3601514363752679e-02, -2.6453255589728329e-03, 3.3968249078500379e-04, -7.5978605583900977e-04, -1.6137759080852433e-03, 3.3968249078500379e-04, -7.5010511151759902e-04, 1.0313781788359500e-04, 1.4950759744726269e-03, -7.5978605583900977e-04, 1.0313781788359500e-04, -5.9448373489452483e-04, 4.1116271730053472e-02, -4.5650281290770516e-03, 1.0174302480600848e-03, -7.4144675491881571e-04, -4.5650281290770516e-03, -3.0111597874487158e-03, 4.1892149452060594e-04, 2.5662370553909404e-04, 1.0174302480600848e-03, 4.1892149452060594e-04, -1.6351264041670321e-03, 4.1540798986628444e-04, -7.4144675491881571e-04, 2.5662370553909404e-04, 4.1540798986628444e-04, -1.5888041899304089e-03, 3.8822005325296664e-02, 3.4682085173453489e-02, 1.1383554058731083e-03, 6.9763412662967174e-04, 3.4682085173453489e-02, -3.8778621426546131e-03, -1.0502459984301810e-03, -6.7815726314415445e-04, 1.1383554058731083e-03, -1.0502459984301810e-03, -9.5953811566263974e-04, 3.1547011250005413e-04, 6.9763412662967174e-04, -6.7815726314415445e-04, 3.1547011250005413e-04, -4.9094447850356326e-04, -1.3275117419010990e-01, 7.7532610202420025e-03, 2.6481743952388775e-04, -1.0233025705150341e-03, 7.7532610202420025e-03, -3.5307144422284118e-03, 3.6081301612281790e-04, 4.2984812221947383e-04, 2.6481743952388775e-04, 3.6081301612281790e-04, -9.6620391750736523e-04, -1.8268752035532475e-04, -1.0233025705150341e-03, 4.2984812221947383e-04, -1.8268752035532475e-04, -7.6865748942518946e-04, 2.0902111595826358e-02, 2.8778407466407915e-02, -7.3589637063263200e-04, -7.9232400295570942e-04, 2.8778407466407915e-02, -6.8244148733939813e-03, 4.6837342411344191e-04, 3.8337154291441424e-04, -7.3589637063263200e-04, 4.6837342411344191e-04, -3.9870959441253668e-04, 6.3661217652106041e-05, -7.9232400295570942e-04, 3.8337154291441424e-04, 6.3661217652106041e-05, -3.1873633147878725e-04, 1.2306903655844117e-01, 1.1790694654017940e-02, -1.6930694484504614e-03, -1.4478486853861244e-03, 1.1790694654017940e-02, -2.6362432912232283e-04, 5.7801647588433605e-04, -5.0260654622532848e-04, -1.6930694484504614e-03, 5.7801647588433605e-04, -1.0057986783918533e-03, -3.8473412149296924e-04, -1.4478486853861244e-03, -5.0260654622532848e-04, -3.8473412149296924e-04, -8.4155363764574717e-04, -2.6072264441980286e-01, -5.3839312494948985e-03, -9.8286481836498294e-04, -1.1077071063072626e-03, -5.3839312494948985e-03, -2.8144397517049936e-03, 1.3570909178396836e-03, 2.0352636344653444e-04, -9.8286481836498294e-04, 1.3570909178396836e-03, -9.6948887126791080e-04, 2.4502863167189274e-04, -1.1077071063072626e-03, 2.0352636344653444e-04, 2.4502863167189274e-04, -5.5674073681467461e-04, -1.4461247437719649e-01, -1.3593073092315819e-02, -1.4591789215271309e-03, -1.8444309608458772e-03, -1.3593073092315819e-02, -1.3790376045237883e-03, 3.6507611650380594e-04, 1.0989155862134194e-03, -1.4591789215271309e-03, 3.6507611650380594e-04, -8.2908061421262179e-04, -1.9093220436421467e-04, -1.8444309608458772e-03, 1.0989155862134194e-03, -1.9093220436421467e-04, -7.4603886066833670e-04, 1.5718948391852267e-01, 3.7509266885863875e-02, -1.6535289369067915e-03, -1.5835485386314300e-03, 3.7509266885863875e-02, -5.9100449278194633e-03, 3.5324348250094338e-04, 3.2687210216937634e-04, -1.6535289369067915e-03, 3.5324348250094338e-04, -1.0567635462974483e-03, -3.8959429122272150e-06, -1.5835485386314300e-03, 3.2687210216937634e-04, -3.8959429122272150e-06, -6.7923415962746719e-04, -2.0460083814262353e-01, 2.6461245236457143e-02, -1.0964643716453355e-03, -2.0155849422843325e-03, 2.6461245236457143e-02, -1.1607499563668883e-02, 4.9712684089718660e-04, 1.0744196203423314e-03, -1.0964643716453355e-03, 4.9712684089718660e-04, -1.2575560415559299e-03, 3.5355569910289946e-04, -2.0155849422843325e-03, 1.0744196203423314e-03, 3.5355569910289946e-04, -5.9829675272084996e-04, 1.4227457831415008e-01, 3.7409193782549421e-02, -1.6999608012668766e-03, -1.4775810720134223e-03, 3.7409193782549421e-02, -6.6980266639126880e-03, 3.7313860360236049e-04, 3.6390843416024218e-04, -1.6999608012668766e-03, 3.7313860360236049e-04, -6.8923641265649434e-04, -1.1118512619169452e-04, -1.4775810720134223e-03, 3.6390843416024218e-04, -1.1118512619169452e-04, -3.6167006383143143e-04, -3.0408057058263434e-02, 2.8102062565578297e-03, -9.9186210750588349e-05, -1.0848067328911566e-03, 2.8102062565578297e-03, -1.9168669695793325e-03, -1.5989044944160041e-04, 3.7928404911171667e-04, -9.9186210750588349e-05, -1.5989044944160041e-04, -6.4212418303488965e-04, 1.2414097957366861e-04, -1.0848067328911566e-03, 3.7928404911171667e-04, 1.2414097957366861e-04, -4.8937310642877495e-04, -5.8151762326818325e-02, 2.0612537512420814e-02, -1.8069350755089380e-03, -1.9159225235797013e-03, 2.0612537512420814e-02, -1.5273838578175230e-03, 4.8641178441277146e-04, 5.7168029371084457e-04, -1.8069350755089380e-03, 4.8641178441277146e-04, -8.5373804438111515e-04, 2.1202613463988789e-04, -1.9159225235797013e-03, 5.7168029371084457e-04, 2.1202613463988789e-04, -7.8732691228072034e-04, 1.1798334731925102e-01, -2.8140161709447171e-02, -1.2130478454804230e-03, 4.6360451013415833e-04, -2.8140161709447171e-02, -2.5008525901788615e-03, 1.3314100722865963e-03, -4.2462405872217889e-04, -1.2130478454804230e-03, 1.3314100722865963e-03, -1.0941534938684865e-03, 5.1529382431827911e-04, 4.6360451013415833e-04, -4.2462405872217889e-04, 5.1529382431827911e-04, -6.7010849513206446e-04, -1.9635177370699608e-01, 3.1453073526812375e-03, 1.9943467720728159e-04, 1.8490379843829265e-03, 3.1453073526812375e-03, -1.4755660222860181e-03, 2.5216877122513355e-04, -7.8528688355206447e-04, 1.9943467720728159e-04, 2.5216877122513355e-04, -1.4555949485632702e-03, -5.9788067272640536e-04, 1.8490379843829265e-03, -7.8528688355206447e-04, -5.9788067272640536e-04, -1.4009824713669468e-03, 1.8079617326597403e-01, 1.3311705456384233e-02, -1.6813583174003447e-03, 1.6754281220701891e-03, 1.3311705456384233e-02, -2.5836933131966949e-03, 1.2524623632335693e-03, -4.4318906832989434e-04, -1.6813583174003447e-03, 1.2524623632335693e-03, -1.1071301248058326e-03, 1.6237170251639789e-04, 1.6754281220701891e-03, -4.4318906832989434e-04, 1.6237170251639789e-04, -5.8066403722343185e-04, -4.7658243260452392e-02, -1.1547225654362255e-02, -1.6724724586724625e-04, -8.6129819877703328e-04, -1.1547225654362255e-02, -3.2589278968339326e-03, 2.6655390367207022e-04, 2.2553348630838165e-04, -1.6724724586724625e-04, 2.6655390367207022e-04, -3.8468694210936846e-04, 2.0656031333140019e-04, -8.6129819877703328e-04, 2.2553348630838165e-04, 2.0656031333140019e-04, -3.5394037175600837e-04, -6.6559656789261540e-02, 3.6780140422847912e-02, -1.0833735822547434e-03, 1.3914255331022606e-04, 3.6780140422847912e-02, -3.3904219310184804e-03, 5.4509538508334726e-04, -2.2439596920688072e-04, -1.0833735822547434e-03, 5.4509538508334726e-04, -1.1195941512654017e-03, 1.0549891235828525e-05, 1.3914255331022606e-04, -2.2439596920688072e-04, 1.0549891235828525e-05, -5.8598966626073352e-04
  };
  std::vector<double > expected_dy_dem = {
    4.8687245272451135e-03, 5.5397159651024933e-03, 5.4642599386694624e-03, 5.6057159373549721e-03, 5.5397159651024933e-03, 4.8806501836285432e-03, 5.6063767619383984e-03, 5.6970860664459413e-03, 5.4642599386694624e-03, 5.6063767619383984e-03, 5.1211835750794290e-03, 5.3223602254697877e-03, 5.6057159373549721e-03, 5.6970860664459413e-03, 5.3223602254697877e-03, 5.2081125072059725e-03, 4.5292484636524086e-03, 4.9816448819259198e-03, 5.1363544712933759e-03, 5.1501696199608019e-03, 4.9816448819259198e-03, 4.6419992655419269e-03, 5.1569135569294903e-03, 4.8945949693767234e-03, 5.1363544712933759e-03, 5.1569135569294903e-03, 4.6706613224722264e-03, 4.9092906666249794e-03, 5.1501696199608019e-03, 4.8945949693767234e-03, 4.9092906666249794e-03, 4.8515691645339065e-03, 3.0190652370495003e-03, 3.4898418636317798e-03, 3.4899656132580579e-03, 3.5145415393083900e-03, 3.4898418636317798e-03, 3.1452916478866737e-03, 3.5037937416394702e-03, 3.4286490652383700e-03, 3.4899656132580579e-03, 3.5037937416394702e-03, 3.1627359787623427e-03, 3.5804187550924349e-03, 3.5145415393083900e-03, 3.4286490652383700e-03, 3.5804187550924349e-03, 3.2322057910012985e-03, 3.6840833901333001e-03, 4.3387482039692832e-03, 4.2515867787302417e-03, 4.4155206099863904e-03, 4.3387482039692832e-03, 4.0028491849676334e-03, 4.3652298563497116e-03, 4.3014839026378881e-03, 4.2515867787302417e-03, 4.3652298563497116e-03, 4.0124345907042516e-03, 4.1790409970907686e-03, 4.4155206099863904e-03, 4.3014839026378881e-03, 4.1790409970907686e-03, 4.0456958994549621e-03, 4.7788898285209408e-03, 4.7316589641173863e-03, 4.7277506758881538e-03, 4.7420787786160946e-03, 4.7316589641173863e-03, 4.7632472674770847e-03, 4.7277799549445667e-03, 4.7294160442947122e-03, 4.7277506758881538e-03, 4.7277799549445667e-03, 4.7576353824550499e-03, 4.7311669494084236e-03, 4.7420787786160946e-03, 4.7294160442947122e-03, 4.7311669494084236e-03, 4.7516945819656171e-03, 3.9248662197341371e-03, 4.9180169646964866e-03, 4.7190463613870446e-03, 4.4520204316217879e-03, 4.9180169646964866e-03, 4.1556621508365569e-03, 4.6033674111750095e-03, 4.5946737014459435e-03, 4.7190463613870446e-03, 4.6033674111750095e-03, 4.4277151435242147e-03, 4.6668537390335040e-03, 4.4520204316217879e-03, 4.5946737014459435e-03, 4.6668537390335040e-03, 4.4390865038161998e-03, 3.7758343215872881e-03, 4.1709220560399215e-03, 4.1202109662083035e-03, 3.9893563131548088e-03, 4.1709220560399215e-03, 3.8379626600639266e-03, 4.1328523107198936e-03, 3.9840470230024889e-03, 4.1202109662083035e-03, 4.1328523107198936e-03, 3.8852759103779593e-03, 4.1580920004019896e-03, 3.9893563131548088e-03, 3.9840470230024889e-03, 4.1580920004019896e-03, 3.9467666481718391e-03, 3.9761642677066033e-03, 4.4504099654305816e-03, 4.3794412854383678e-03, 4.4604317957851781e-03, 4.4504099654305816e-03, 4.0768567666647814e-03, 4.3435449806077473e-03, 4.3222112460340181e-03, 4.3794412854383678e-03, 4.3435449806077473e-03, 4.0773633573082564e-03, 4.4803490047300660e-03, 4.4604317957851781e-03, 4.3222112460340181e-03, 4.4803490047300660e-03, 4.1310317786866901e-03, 4.3424352854361066e-03, 4.9111142266166450e-03, 4.8395299678665781e-03, 4.6865337839814593e-03, 4.9111142266166450e-03, 4.5038688193735138e-03, 4.7214010478928668e-03, 4.7827433155358395e-03, 4.8395299678665781e-03, 4.7214010478928668e-03, 4.5047095985936833e-03, 4.8043858107812464e-03, 4.6865337839814593e-03, 4.7827433155358395e-03, 4.8043858107812464e-03, 4.5266636394073641e-03, 5.0023501655291321e-03, 5.4960776974766461e-03, 5.5277863655162403e-03, 5.6131610328358644e-03, 5.4960776974766461e-03, 5.0497823718039583e-03, 5.5223616852066977e-03, 5.2893854856376011e-03, 5.5277863655162403e-03, 5.5223616852066977e-03, 5.0964808619146599e-03, 5.4611470394996591e-03, 5.6131610328358644e-03, 5.2893854856376011e-03, 5.4611470394996591e-03, 5.2261512984334412e-03, 3.9613105413924812e-03, 4.4015218128590642e-03, 4.7307418574636991e-03, 4.6640477363723105e-03, 4.4015218128590642e-03, 4.0082410785944010e-03, 4.8261944934070503e-03, 4.5757895595947961e-03, 4.7307418574636991e-03, 4.8261944934070503e-03, 4.2233067127250678e-03, 4.7151130208320496e-03, 4.6640477363723105e-03, 4.5757895595947961e-03, 4.7151130208320496e-03, 4.3106975949268253e-03, 4.7334182996649809e-03, 5.3634328062759831e-03, 5.4504527709104602e-03, 5.1343603133321243e-03, 5.3634328062759831e-03, 4.8165188916604821e-03, 5.2922209819789611e-03, 5.3818126119621716e-03, 5.4504527709104602e-03, 5.2922209819789611e-03, 4.8435704822708701e-03, 5.2240647899442503e-03, 5.1343603133321243e-03, 5.3818126119621716e-03, 5.2240647899442503e-03, 4.8868508221224377e-03, 4.7996614634904892e-03, 5.7179083120858371e-03, 5.6117201232891321e-03, 5.6700701716033263e-03, 5.7179083120858371e-03, 4.9727735792746818e-03, 5.3848863488571300e-03, 5.4305318435656936e-03, 5.6117201232891321e-03, 5.3848863488571300e-03, 5.1731090323620544e-03, 5.2948377822407506e-03, 5.6700701716033263e-03, 5.4305318435656936e-03, 5.2948377822407506e-03, 5.2191935738847518e-03, 5.0888074222028307e-03, 5.5682241956695952e-03, 5.5311688481500410e-03, 5.3354587343858242e-03, 5.5682241956695952e-03, 5.1039796573406886e-03, 5.6527375470408862e-03, 5.5776264780928323e-03, 5.5311688481500410e-03, 5.6527375470408862e-03, 5.1908856775166106e-03, 5.5157564883515529e-03, 5.3354587343858242e-03, 5.5776264780928323e-03, 5.5157564883515529e-03, 5.2868882706481306e-03, 4.1148293948602473e-03, 4.8099243464647095e-03, 4.8354127941843744e-03, 4.8024021654871083e-03, 4.8099243464647095e-03, 4.3036710353764468e-03, 4.7276148863981300e-03, 4.5819645174844182e-03, 4.8354127941843744e-03, 4.7276148863981300e-03, 4.3517326519376268e-03, 4.5484962243548931e-03, 4.8024021654871083e-03, 4.5819645174844182e-03, 4.5484962243548931e-03, 4.3552076928133352e-03, 4.4103831260207836e-03, 4.7323280089558032e-03, 4.6792976546604689e-03, 4.7101816275088885e-03, 4.7323280089558032e-03, 4.4526464210458746e-03, 4.7051812634566420e-03, 4.7775181030841720e-03, 4.6792976546604689e-03, 4.7051812634566420e-03, 4.4777362867795979e-03, 4.7837047168366176e-03, 4.7101816275088885e-03, 4.7775181030841720e-03, 4.7837047168366176e-03, 4.4818283635942383e-03, 4.8171219099102398e-03, 5.4329072017648130e-03, 5.5577769098679687e-03, 5.5021033559999686e-03, 5.4329072017648130e-03, 4.9840681446863353e-03, 5.5228366571162838e-03, 5.6998588607070494e-03, 5.5577769098679687e-03, 5.5228366571162838e-03, 5.0189254656526020e-03, 5.3181989951699288e-03, 5.5021033559999686e-03, 5.6998588607070494e-03, 5.3181989951699288e-03, 5.2634498662377308e-03, 4.6530516200842852e-03, 5.0650394647562338e-03, 5.2488756975870273e-03, 5.2624908207797184e-03, 5.0650394647562338e-03, 4.6874447846501164e-03, 5.2268492983034561e-03, 5.1745585095054458e-03, 5.2488756975870273e-03, 5.2268492983034561e-03, 4.7952117024116173e-03, 5.0276292129730416e-03, 5.2624908207797184e-03, 5.1745585095054458e-03, 5.0276292129730416e-03, 4.9122789880896404e-03, 4.9251289238065234e-03, 5.5933241606014724e-03, 5.3718594158626860e-03, 5.6008531360396017e-03, 5.5933241606014724e-03, 5.0150407582346635e-03, 5.4662584346395404e-03, 5.3675120118810739e-03, 5.3718594158626860e-03, 5.4662584346395404e-03, 5.0248322936143662e-03, 5.4605145072560580e-03, 5.6008531360396017e-03, 5.3675120118810739e-03, 5.4605145072560580e-03, 5.1143948516248604e-03, 3.7657249048296967e-03, 3.9486926147620297e-03, 4.0691576682980483e-03, 4.0664780157542643e-03, 3.9486926147620297e-03, 3.7736205874903724e-03, 4.0495831622273807e-03, 4.0206411044168824e-03, 4.0691576682980483e-03, 4.0495831622273807e-03, 3.7937874360149263e-03, 3.9752869288898511e-03, 4.0664780157542643e-03, 4.0206411044168824e-03, 3.9752869288898511e-03, 3.8149050745084684e-03, 5.0114061217704613e-03, 5.2617991497744074e-03, 5.1790540139945674e-03, 5.3591951134087162e-03, 5.2617991497744074e-03, 5.0120596768805908e-03, 5.2487154791349359e-03, 5.2629872576859908e-03, 5.1790540139945674e-03, 5.2487154791349359e-03, 5.0448755388764347e-03, 5.3303535417822852e-03, 5.3591951134087162e-03, 5.2629872576859908e-03, 5.3303535417822852e-03, 5.1174676770792023e-03, 4.8377902633377264e-03, 5.3788546108106241e-03, 5.6040768285432335e-03, 5.3105068959469794e-03, 5.3788546108106241e-03, 4.9326524445286032e-03, 5.4991607490083253e-03, 5.5655132712644469e-03, 5.6040768285432335e-03, 5.4991607490083253e-03, 4.9741473776001794e-03, 5.3900550171932238e-03, 5.3105068959469794e-03, 5.5655132712644469e-03, 5.3900550171932238e-03, 5.1950052918756442e-03, 3.2492587714875146e-03, 3.9827109719638674e-03, 3.8774234602011355e-03, 3.8757465280329336e-03, 3.9827109719638674e-03, 3.4344256880305358e-03, 4.0545162671736575e-03, 3.7835976611712702e-03, 3.8774234602011355e-03, 4.0545162671736575e-03, 3.4953556313526311e-03, 3.9175382918411519e-03, 3.8757465280329336e-03, 3.7835976611712702e-03, 3.9175382918411519e-03, 3.5756760339217433e-03, 4.7617721014200634e-03, 4.8614225555244890e-03, 4.8279075259455451e-03, 4.8427156866381622e-03, 4.8614225555244890e-03, 4.8195643885916269e-03, 4.8405369639889255e-03, 4.8156734615472999e-03, 4.8279075259455451e-03, 4.8405369639889255e-03, 4.8197639580753243e-03, 4.8155984576041654e-03, 4.8427156866381622e-03, 4.8156734615472999e-03, 4.8155984576041654e-03, 4.8158790994777771e-03, 4.5833139216121957e-03, 5.4837863258358531e-03, 5.5638146695959553e-03, 5.4909136024647049e-03, 5.4837863258358531e-03, 4.8077007992908590e-03, 5.4604862042020273e-03, 5.4396976154026198e-03, 5.5638146695959553e-03, 5.4604862042020273e-03, 4.8833715685529635e-03, 5.3864868915666220e-03, 5.4909136024647049e-03, 5.4396976154026198e-03, 5.3864868915666220e-03, 4.9933154810546838e-03, 5.1071558319641056e-03, 5.4433074957792454e-03, 5.5765474271101826e-03, 5.5076635863146820e-03, 5.4433074957792454e-03, 5.1894387573805066e-03, 5.3922841131452456e-03, 5.5390126993166908e-03, 5.5765474271101826e-03, 5.3922841131452456e-03, 5.2001066482717309e-03, 5.4246759715010128e-03, 5.5076635863146820e-03, 5.5390126993166908e-03, 5.4246759715010128e-03, 5.2227895716483279e-03, 4.0497679429561092e-03, 4.9282556022888424e-03, 4.7237087909624649e-03, 4.8020213273712292e-03, 4.9282556022888424e-03, 4.3464895120150539e-03, 4.7976125238518097e-03, 4.7260356905951930e-03, 4.7237087909624649e-03, 4.7976125238518097e-03, 4.4574002582117803e-03, 4.6487121118467404e-03, 4.8020213273712292e-03, 4.7260356905951930e-03, 4.6487121118467404e-03, 4.4956041562837267e-03, 4.9714633531457494e-03, 5.7206656536672494e-03, 5.5180734069265810e-03, 5.4919793509825418e-03, 5.7206656536672494e-03, 5.2356045663686296e-03, 5.5596394964592278e-03, 5.7261136434031473e-03, 5.5180734069265810e-03, 5.5596394964592278e-03, 5.4948204143983092e-03, 5.6210477153196018e-03, 5.4919793509825418e-03, 5.7261136434031473e-03, 5.6210477153196018e-03, 5.5487852497226155e-03, 4.5489572462475468e-03, 5.4201128096244833e-03, 5.2786942174057458e-03, 5.5227997797472469e-03, 5.4201128096244833e-03, 4.7506506604289601e-03, 5.5748809286163452e-03, 5.3179890118108808e-03, 5.2786942174057458e-03, 5.5748809286163452e-03, 4.9901034258736697e-03, 5.3280021534388728e-03, 5.5227997797472469e-03, 5.3179890118108808e-03, 5.3280021534388728e-03, 5.0865046620443850e-03, 5.1827253238118367e-03, 5.3230838505120767e-03, 5.6092186758799996e-03, 5.3498800832996584e-03, 5.3230838505120767e-03, 5.1866043895766913e-03, 5.4707858854025323e-03, 5.4396236153839645e-03, 5.6092186758799996e-03, 5.4707858854025323e-03, 5.2034777387438419e-03, 5.3820989828010021e-03, 5.3498800832996584e-03, 5.4396236153839645e-03, 5.3820989828010021e-03, 5.2795140455242154e-03, 4.9373256245385227e-03, 5.0306921107680144e-03, 5.0091821137527148e-03, 5.0745697481229361e-03, 5.0306921107680144e-03, 4.9460721328636499e-03, 5.0969673520163961e-03, 4.9827250786815078e-03, 5.0091821137527148e-03, 5.0969673520163961e-03, 4.9517391298398959e-03, 5.0636541925258224e-03, 5.0745697481229361e-03, 4.9827250786815078e-03, 5.0636541925258224e-03, 4.9552504666375910e-03, 4.9253932922107505e-03, 5.3550337394986059e-03, 5.7052084741338500e-03, 5.4398733606965252e-03, 5.3550337394986059e-03, 4.9574861537077779e-03, 5.4706377679931946e-03, 5.5861137412303828e-03, 5.7052084741338500e-03, 5.4706377679931946e-03, 5.1587536865196583e-03, 5.6684419038570740e-03, 5.4398733606965252e-03, 5.5861137412303828e-03, 5.6684419038570740e-03, 5.2466699874090649e-03, 4.8003051442717763e-03, 5.6347570986480860e-03, 5.5318100167355980e-03, 5.4577257727782651e-03, 5.6347570986480860e-03, 4.8631401810418006e-03, 5.3361212366442329e-03, 5.5641617598327581e-03, 5.5318100167355980e-03, 5.3361212366442329e-03, 5.2040986395562412e-03, 5.3538907108157440e-03, 5.4577257727782651e-03, 5.5641617598327581e-03, 5.3538907108157440e-03, 5.2371703144156933e-03, 4.4297692564271461e-03, 5.1376827019044427e-03, 4.9522665099534903e-03, 5.1833712956327353e-03, 5.1376827019044427e-03, 4.5080542081015985e-03, 5.1885572418010912e-03, 4.8897090121346205e-03, 4.9522665099534903e-03, 5.1885572418010912e-03, 4.6450870564566172e-03, 4.8578374835205329e-03, 5.1833712956327353e-03, 4.8897090121346205e-03, 4.8578374835205329e-03, 4.6996959359605593e-03, 4.7160296966838235e-03, 5.4354504254331372e-03, 5.4914673382449068e-03, 5.0994910096800114e-03, 5.4354504254331372e-03, 4.8780256297317678e-03, 5.1983414836785551e-03, 5.1516527659604631e-03, 5.4914673382449068e-03, 5.1983414836785551e-03, 4.9576745968284569e-03, 5.3076257372673850e-03, 5.0994910096800114e-03, 5.1516527659604631e-03, 5.3076257372673850e-03, 5.0692404281867864e-03, 3.7521616561831035e-03, 4.3041195036684684e-03, 4.2083507066731441e-03, 4.0701551841232234e-03, 4.3041195036684684e-03, 3.8824364771630269e-03, 4.1647702647614748e-03, 4.1958378911293734e-03, 4.2083507066731441e-03, 4.1647702647614748e-03, 3.9355724928669756e-03, 4.1762562220603594e-03, 4.0701551841232234e-03, 4.1958378911293734e-03, 4.1762562220603594e-03, 4.0252316104492768e-03, 4.6691024276046839e-03, 5.4358497609484843e-03, 5.7984562413035670e-03, 5.3548860709007389e-03, 5.4358497609484843e-03, 4.8958005316626745e-03, 5.6061623938377849e-03, 5.5174561676182539e-03, 5.7984562413035670e-03, 5.6061623938377849e-03, 5.0465532622400548e-03, 5.4146406099752648e-03, 5.3548860709007389e-03, 5.5174561676182539e-03, 5.4146406099752648e-03, 5.1458567514192288e-03, 4.7873760079603245e-03, 4.7132530407841666e-03, 4.7097574777507523e-03, 4.7067597555051121e-03, 4.7132530407841666e-03, 4.7759539827926852e-03, 4.7079931840557261e-03, 4.7054012333601347e-03, 4.7097574777507523e-03, 4.7079931840557261e-03, 4.7228911829172273e-03, 4.7124589687313331e-03, 4.7067597555051121e-03, 4.7054012333601347e-03, 4.7124589687313331e-03, 4.7141024992431325e-03, 4.7653857276584981e-03, 5.3935337863564433e-03, 5.1518363112552411e-03, 5.2735623271459057e-03, 5.3935337863564433e-03, 4.7820910815419837e-03, 5.3263045464322246e-03, 5.2662666132495747e-03, 5.1518363112552411e-03, 5.3263045464322246e-03, 4.8989837691361037e-03, 5.2967809909708055e-03, 5.2735623271459057e-03, 5.2662666132495747e-03, 5.2967809909708055e-03, 4.9322596897032446e-03, 4.7680183858758744e-03, 4.6997587251910548e-03, 4.6997371537680086e-03, 4.7022616189482079e-03, 4.6997587251910548e-03, 4.7586592022394198e-03, 4.7000771623067050e-03, 4.6999788734553346e-03, 4.6997371537680086e-03, 4.7000771623067050e-03, 4.7355142545157962e-03, 4.6997484975064945e-03, 4.7022616189482079e-03, 4.6999788734553346e-03, 4.6997484975064945e-03, 4.7310105077216554e-03, 4.8458569989126826e-03, 5.5268069114665867e-03, 5.7047145500931061e-03, 5.5972004900509010e-03, 5.5268069114665867e-03, 5.0812217431459358e-03, 5.5795445843535817e-03, 5.5171878865958018e-03, 5.7047145500931061e-03, 5.5795445843535817e-03, 5.1164073324255592e-03, 5.7042719550623056e-03, 5.5972004900509010e-03, 5.5171878865958018e-03, 5.7042719550623056e-03, 5.2296532393988453e-03, 5.0331052677300868e-03, 5.8126537574760377e-03, 5.6116616631243848e-03, 5.5610714403935496e-03, 5.8126537574760377e-03, 5.1251590071031677e-03, 5.4834432263391871e-03, 5.3387073396366554e-03, 5.6116616631243848e-03, 5.4834432263391871e-03, 5.1721761378333781e-03, 5.4102404378702880e-03, 5.5610714403935496e-03, 5.3387073396366554e-03, 5.4102404378702880e-03, 5.2983146020102812e-03, 4.5634809762413915e-03, 5.0708627795713048e-03, 5.5285155509920162e-03, 5.1479022947186481e-03, 5.0708627795713048e-03, 4.5667821151481602e-03, 5.2739955449695626e-03, 5.2334032096775420e-03, 5.5285155509920162e-03, 5.2739955449695626e-03, 4.7796850268603851e-03, 5.2855491938456917e-03, 5.1479022947186481e-03, 5.2334032096775420e-03, 5.2855491938456917e-03, 4.9846472734427676e-03, 4.3408943946436742e-03, 5.0828126111047292e-03, 5.1619429658240372e-03, 4.8950748576602138e-03, 5.0828126111047292e-03, 4.5132933116312137e-03, 5.2279735123596507e-03, 5.0148402712815654e-03, 5.1619429658240372e-03, 5.2279735123596507e-03, 4.5757840526439138e-03, 5.1782251466555721e-03, 4.8950748576602138e-03, 5.0148402712815654e-03, 5.1782251466555721e-03, 4.7573202851706603e-03, 4.5244066537111763e-03, 5.3139854411244740e-03, 5.3841932493787804e-03, 5.1243544377133250e-03, 5.3139854411244740e-03, 4.5788274266713343e-03, 5.0657051731653390e-03, 5.1426785687150312e-03, 5.3841932493787804e-03, 5.0657051731653390e-03, 4.8535063031089169e-03, 5.0053417498441321e-03, 5.1243544377133250e-03, 5.1426785687150312e-03, 5.0053417498441321e-03, 4.9387189843115254e-03, 4.1561105459001855e-03, 4.8760140670205537e-03, 4.9530604056372751e-03, 4.7505323982066205e-03, 4.8760140670205537e-03, 4.1827775726392021e-03, 4.8099710346094313e-03, 5.0738733877216434e-03, 4.9530604056372751e-03, 4.8099710346094313e-03, 4.2585652889670211e-03, 4.7953656364286730e-03, 4.7505323982066205e-03, 5.0738733877216434e-03, 4.7953656364286730e-03, 4.4343641159264166e-03, 3.8850145135094689e-03, 4.2621118153951384e-03, 4.2895589113090549e-03, 4.3362464279518660e-03, 4.2621118153951384e-03, 4.0308729657790154e-03, 4.3844806003525494e-03, 4.2431337390287519e-03, 4.2895589113090549e-03, 4.3844806003525494e-03, 4.0886915647727800e-03, 4.2096924634853674e-03, 4.3362464279518660e-03, 4.2431337390287519e-03, 4.2096924634853674e-03, 4.1471058237790934e-03, 4.0748278012573509e-03, 5.0975121874835549e-03, 4.7643646721661492e-03, 4.9684148451479976e-03, 5.0975121874835549e-03, 4.3184840883046935e-03, 4.6729488469095803e-03, 4.8545826387352059e-03, 4.7643646721661492e-03, 4.6729488469095803e-03, 4.3205131005967286e-03, 4.7004116957686162e-03, 4.9684148451479976e-03, 4.8545826387352059e-03, 4.7004116957686162e-03, 4.3690205971449432e-03, 4.9909978133227360e-03, 5.4143910989253663e-03, 5.3601062423874191e-03, 5.3625046092275102e-03, 5.4143910989253663e-03, 5.0724427507293137e-03, 5.3652489479395936e-03, 5.3446386733428074e-03, 5.3601062423874191e-03, 5.3652489479395936e-03, 5.1460907707869393e-03, 5.3780861391384124e-03, 5.3625046092275102e-03, 5.3446386733428074e-03, 5.3780861391384124e-03, 5.2120089804020249e-03, 3.9588108570032090e-03, 4.2938117793838125e-03, 4.3611063350752835e-03, 4.2651906389425988e-03, 4.2938117793838125e-03, 4.0073255645855172e-03, 4.3518483851969093e-03, 4.3842419740188166e-03, 4.3611063350752835e-03, 4.3518483851969093e-03, 4.0893058354619380e-03, 4.3784881764625605e-03, 4.2651906389425988e-03, 4.3842419740188166e-03, 4.3784881764625605e-03, 4.0997083424903474e-03, 4.7902809088108339e-03, 5.3533071692810326e-03, 5.4529697742326999e-03, 5.3421394953302170e-03, 5.3533071692810326e-03, 4.8783628762572584e-03, 5.4898943571368179e-03, 5.4389677679356945e-03, 5.4529697742326999e-03, 5.4898943571368179e-03, 4.9324715462178625e-03, 5.3542755941681317e-03, 5.3421394953302170e-03, 5.4389677679356945e-03, 5.3542755941681317e-03, 4.9864655774714602e-03, 4.2147742524955437e-03, 4.8044404091749406e-03, 4.7174654013479485e-03, 4.5212986560996676e-03, 4.8044404091749406e-03, 4.2334336465773776e-03, 4.8136572475988510e-03, 4.8526412903096890e-03, 4.7174654013479485e-03, 4.8136572475988510e-03, 4.3841364814263201e-03, 4.5319687487354911e-03, 4.5212986560996676e-03, 4.8526412903096890e-03, 4.5319687487354911e-03, 4.3968275756536071e-03, 4.0044555899961193e-03, 4.4761433683108247e-03, 4.6472307349424728e-03, 4.4243677432400045e-03, 4.4761433683108247e-03, 4.0591447141326868e-03, 4.5360985593542293e-03, 4.4752304699918616e-03, 4.6472307349424728e-03, 4.5360985593542293e-03, 4.1784992937999085e-03, 4.5671014827176528e-03, 4.4243677432400045e-03, 4.4752304699918616e-03, 4.5671014827176528e-03, 4.2505134990343130e-03, 4.9235489798322716e-03, 5.7605067104734096e-03, 5.4765479512553930e-03, 5.5189947100062961e-03, 5.7605067104734096e-03, 5.0563592914372041e-03, 5.5230364268243756e-03, 5.6783945214777731e-03, 5.4765479512553930e-03, 5.5230364268243756e-03, 5.0602340964368484e-03, 5.6195955397581694e-03, 5.5189947100062961e-03, 5.6783945214777731e-03, 5.6195955397581694e-03, 5.1685388328162494e-03, 4.5391542914077748e-03, 5.3162333178131448e-03, 5.0344382645984304e-03, 5.0853779913647874e-03, 5.3162333178131448e-03, 4.5405811858949636e-03, 5.4256287620576297e-03, 5.0932428800818767e-03, 5.0344382645984304e-03, 5.4256287620576297e-03, 4.5923554538614669e-03, 5.1764781936595632e-03, 5.0853779913647874e-03, 5.0932428800818767e-03, 5.1764781936595632e-03, 4.6315286436058034e-03, 4.8241517294518987e-03, 5.6107202492192646e-03, 5.4225910095940417e-03, 5.6682617800773672e-03, 5.6107202492192646e-03, 5.1440593741325126e-03, 5.7028655987132184e-03, 5.4379837043436550e-03, 5.4225910095940417e-03, 5.7028655987132184e-03, 5.1490285191096163e-03, 5.4071926623830719e-03, 5.6682617800773672e-03, 5.4379837043436550e-03, 5.4071926623830719e-03, 5.3570980160283933e-03, 5.0497164090830202e-03, 5.6354102305264170e-03, 5.5833976153072101e-03, 5.5241887515719923e-03, 5.6354102305264170e-03, 5.1844311703979455e-03, 5.6093229622724144e-03, 5.6832732406642099e-03, 5.5833976153072101e-03, 5.6093229622724144e-03, 5.3845110635961542e-03, 5.6525395728626391e-03, 5.5241887515719923e-03, 5.6832732406642099e-03, 5.6525395728626391e-03, 5.5054350484104982e-03, 4.7330318788156075e-03, 5.2558542628192498e-03, 5.2754180637923608e-03, 5.2680668623478954e-03, 5.2558542628192498e-03, 4.8583176679629775e-03, 5.3617411087909300e-03, 5.0763527226022447e-03, 5.2754180637923608e-03, 5.3617411087909300e-03, 4.8719763416853719e-03, 5.2676200731791344e-03, 5.2680668623478954e-03, 5.0763527226022447e-03, 5.2676200731791344e-03, 4.9861268237371891e-03, 4.4829218835174276e-03, 4.9248762537746826e-03, 5.0024520635936409e-03, 4.9006320187329356e-03, 4.9248762537746826e-03, 4.5440399582473258e-03, 4.8761752126013965e-03, 4.9995342540547251e-03, 5.0024520635936409e-03, 4.8761752126013965e-03, 4.5687972074181541e-03, 4.8573575677983922e-03, 4.9006320187329356e-03, 4.9995342540547251e-03, 4.8573575677983922e-03, 4.6113723269492028e-03, 4.7439766500629171e-03, 5.6665405738237223e-03, 5.5308219569568514e-03, 5.8507003829033413e-03, 5.6665405738237223e-03, 5.0720272017036588e-03, 5.7362709767074119e-03, 5.7332701844372063e-03, 5.5308219569568514e-03, 5.7362709767074119e-03, 5.1913803385325689e-03, 5.4671990661370592e-03, 5.8507003829033413e-03, 5.7332701844372063e-03, 5.4671990661370592e-03, 5.3276953731318695e-03, 4.1781480426967242e-03, 4.6569448684048234e-03, 4.5751840200780334e-03, 4.6474757680489750e-03, 4.6569448684048234e-03, 4.2572109329085161e-03, 4.4514347800524946e-03, 4.4710709510486640e-03, 4.5751840200780334e-03, 4.4514347800524946e-03, 4.3020526773420746e-03, 4.4948839390591307e-03, 4.6474757680489750e-03, 4.4710709510486640e-03, 4.4948839390591307e-03, 4.3748034929899484e-03, 4.3313384846384567e-03, 4.8609426130105955e-03, 5.0178932944894578e-03, 4.9114981624153410e-03, 4.8609426130105955e-03, 4.4156139708581314e-03, 5.0527692323661466e-03, 4.8434482548828555e-03, 5.0178932944894578e-03, 5.0527692323661466e-03, 4.5006787363920647e-03, 4.8851573490110390e-03, 4.9114981624153410e-03, 4.8434482548828555e-03, 4.8851573490110390e-03, 4.5585418241746826e-03, 4.6655021290269603e-03, 5.1099289511134065e-03, 5.2222030661634514e-03, 5.1555694826168827e-03, 5.1099289511134065e-03, 4.7523395276319845e-03, 5.2110469413705869e-03, 5.1579337232921206e-03, 5.2222030661634514e-03, 5.2110469413705869e-03, 4.8305384374289825e-03, 5.1666370817119011e-03, 5.1555694826168827e-03, 5.1579337232921206e-03, 5.1666370817119011e-03, 4.8571729590057358e-03, 4.4124832580118107e-03, 5.5124750974480611e-03, 5.1133380051136147e-03, 5.3588860042126296e-03, 5.5124750974480611e-03, 4.6356559976615270e-03, 5.4305254470557798e-03, 5.2131271012044759e-03, 5.1133380051136147e-03, 5.4305254470557798e-03, 4.6534597410828934e-03, 5.1783873042292455e-03, 5.3588860042126296e-03, 5.2131271012044759e-03, 5.1783873042292455e-03, 4.8236077833933117e-03, -9.6615927935495179e-03, 6.8675588255994405e-03, 1.0945473142527546e-03, -1.1194179153164361e-03, 6.8675588255994405e-03, -3.6346241719092134e-03, -5.8138983110610643e-04, 1.2243832363445957e-03, 1.0945473142527546e-03, -5.8138983110610643e-04, -4.6126147746582667e-04, 6.3180189590662426e-04, -1.1194179153164361e-03, 1.2243832363445957e-03, 6.3180189590662426e-04, -3.6362492012642004e-04, -1.2936789941773327e-02, 9.1335782726763882e-03, -9.2413647644373851e-04, -9.1704209021694640e-04, 9.1335782726763882e-03, -4.3195816573411861e-03, 1.5488956851291041e-03, 2.2741681746236771e-03, -9.2413647644373851e-04, 1.5488956851291041e-03, 4.0145236950450106e-04, 1.1955645031987922e-03, -9.1704209021694640e-04, 2.2741681746236771e-03, 1.1955645031987922e-03, 5.9101407236907759e-04, -5.3962989027005557e-03, 2.6072667157267145e-03, -8.2947112894151754e-04, -8.4707999007982405e-04, 2.6072667157267145e-03, -1.9454893539958128e-03, 1.3259854799795544e-04, 9.1413360753332847e-05, -8.2947112894151754e-04, 1.3259854799795544e-04, -5.1496376171848712e-04, -2.0587710943157896e-04, -8.4707999007982405e-04, 9.1413360753332847e-05, -2.0587710943157896e-04, -4.9949758378796459e-04, -1.7429393257872950e-02, 8.3520701836941741e-03, -1.3077437245125536e-03, 2.6219650960785422e-03, 8.3520701836941741e-03, -2.1730131032824999e-03, 2.9672791558086049e-03, 1.5427551148408693e-03, -1.3077437245125536e-03, 2.9672791558086049e-03, -1.2507874901661125e-04, 8.2649701074271687e-04, 2.6219650960785422e-03, 1.5427551148408693e-03, 8.2649701074271687e-04, -2.3883234105498484e-05, -1.3830306151965368e-02, 8.6140679080944672e-03, -1.0519351576461367e-03, 2.8626024695093547e-03, 8.6140679080944672e-03, -1.9075258568341821e-03, 2.0138742914406317e-03, 6.3743572321268256e-04, -1.0519351576461367e-03, 2.0138742914406317e-03, 6.7646549781383313e-04, 1.7337725787928556e-03, 2.8626024695093547e-03, 6.3743572321268256e-04, 1.7337725787928556e-03, 8.5614628175256790e-04, -1.8403458798923876e-02, 7.8573984911785699e-03, -1.5961302550980016e-03, 3.5149754327317441e-03, 7.8573984911785699e-03, -1.7067248914369689e-03, 2.5330322771104944e-03, 6.0551635352428294e-04, -1.5961302550980016e-03, 2.5330322771104944e-03, 4.5693878376751882e-04, 1.3178252989731669e-03, 3.5149754327317441e-03, 6.0551635352428294e-04, 1.3178252989731669e-03, 4.6425349761707751e-04, -1.7006699057036175e-02, 7.6077168403978004e-03, -1.2881631030799989e-03, 2.9480535843260710e-03, 7.6077168403978004e-03, -1.9702066590096216e-03, 2.0108629639478673e-03, 7.9516080819711594e-04, -1.2881631030799989e-03, 2.0108629639478673e-03, 8.0433046450099942e-04, 1.8038266298348227e-03, 2.9480535843260710e-03, 7.9516080819711594e-04, 1.8038266298348227e-03, 8.8160771996069693e-04, -1.3854826825508055e-02, 8.0479162307344476e-03, -5.4775445908707208e-04, 3.4108070940140215e-03, 8.0479162307344476e-03, -2.4855624480393168e-03, 2.0010342207153007e-03, 9.0050864299703079e-04, -5.4775445908707208e-04, 2.0010342207153007e-03, 2.2879961439639510e-04, 1.2455851470582276e-03, 3.4108070940140215e-03, 9.0050864299703079e-04, 1.2455851470582276e-03, 2.5797630491429058e-04, -1.3110891255545737e-02, 7.4933352500272960e-03, -3.9694223029317251e-04, 1.8696987208199419e-03, 7.4933352500272960e-03, -2.7269680038459173e-03, 1.3403236271558815e-03, 2.3125877913683179e-04, -3.9694223029317251e-04, 1.3403236271558815e-03, 7.7648354810912158e-04, 1.2366194463463297e-03, 1.8696987208199419e-03, 2.3125877913683179e-04, 1.2366194463463297e-03, 9.6189796048403537e-04, -1.3232672426819813e-02, 4.6823041218628670e-03, 1.8611702707055700e-03, -8.3085468064121430e-04, 4.6823041218628670e-03, -8.0583799511241597e-04, 1.5487811484838697e-03, 8.1349281204434981e-04, 1.8611702707055700e-03, 1.5487811484838697e-03, -1.2621786723316788e-04, 1.4631208905251433e-03, -8.3085468064121430e-04, 8.1349281204434981e-04, 1.4631208905251433e-03, 2.7511955514886215e-04, -1.5084537572866579e-02, 7.1293848562809948e-03, 3.7045468755946658e-03, -1.4711529451730022e-03, 7.1293848562809948e-03, -1.8494973697146082e-03, 1.3524358852716983e-03, 1.5936537318735912e-03, 3.7045468755946658e-03, 1.3524358852716983e-03, -5.7047546733440834e-04, 2.0738159150412733e-03, -1.4711529451730022e-03, 1.5936537318735912e-03, 2.0738159150412733e-03, 5.0829312908897773e-04, -1.1837724802376451e-02, 8.0065879433286139e-03, 2.5212064219669013e-03, -8.6580744742516692e-04, 8.0065879433286139e-03, -2.7205322761259480e-03, -2.2105454381026531e-04, 1.4586534642126341e-03, 2.5212064219669013e-03, -2.2105454381026531e-04, -2.4777193779670914e-04, 1.4026084563219037e-03, -8.6580744742516692e-04, 1.4586534642126341e-03, 1.4026084563219037e-03, 3.8679517983707091e-04, -1.2017287033769334e-02, 6.9442711205541319e-03, 1.8032964267264526e-03, 9.4303015390613293e-04, 6.9442711205541319e-03, -3.5149126553830593e-03, 2.3699469146257939e-04, -4.5705934851597888e-04, 1.8032964267264526e-03, 2.3699469146257939e-04, -1.3586411786986857e-04, 8.4154434886370209e-04, 9.4303015390613293e-04, -4.5705934851597888e-04, 8.4154434886370209e-04, -6.9789884734637771e-05, -1.6094817869361303e-02, 6.3002762847164506e-03, 2.2530843424977648e-03, 3.8816772736172305e-03, 6.3002762847164506e-03, -1.3384245408796698e-03, 1.0043242756394048e-03, 1.0894870315372434e-03, 2.2530843424977648e-03, 1.0043242756394048e-03, -1.2100553317588711e-05, 1.2384575776262850e-03, 3.8816772736172305e-03, 1.0894870315372434e-03, 1.2384575776262850e-03, 1.5692877333876084e-04, -1.4045801776472706e-02, 8.9584932766103818e-03, 2.6014796744964234e-03, 1.0166144512118521e-04, 8.9584932766103818e-03, -3.2080958107171351e-03, 1.3686944034468785e-03, 2.0148513302307739e-03, 2.6014796744964234e-03, 1.3686944034468785e-03, -4.7783480807389827e-04, 1.6221316661178631e-03, 1.0166144512118521e-04, 2.0148513302307739e-03, 1.6221316661178631e-03, 3.6300160393023845e-04, -1.5035351590565366e-02, 9.6530182335056031e-03, 2.1949862437937429e-03, 1.8246414683111131e-04, 9.6530182335056031e-03, -2.6652597726363591e-03, 3.9640886823489533e-04, 2.0283144683530636e-03, 2.1949862437937429e-03, 3.9640886823489533e-04, 4.9399384235801198e-04, 1.5872284744377334e-03, 1.8246414683111131e-04, 2.0283144683530636e-03, 1.5872284744377334e-03, 5.7853947086566285e-04, -1.3983142687551818e-02, 5.0756892732599047e-03, 5.1905234137764912e-03, 4.2875838849719752e-03, 5.0756892732599047e-03, -9.4954694217068230e-04, 1.8883020854449403e-04, 6.7109554143711891e-04, 5.1905234137764912e-03, 1.8883020854449403e-04, -8.4870028551829930e-04, 1.1077830644977793e-03, 4.2875838849719752e-03, 6.7109554143711891e-04, 1.1077830644977793e-03, -7.8542966877660964e-04, -1.3600736364920495e-02, 9.7195178003623480e-03, 9.3917635136515779e-04, 1.9513372114623364e-03, 9.7195178003623480e-03, -2.5366246539418099e-03, 1.5797585617940194e-03, 7.0858722530550288e-04, 9.3917635136515779e-04, 1.5797585617940194e-03, 5.8251868528788402e-04, 1.7783091417839559e-03, 1.9513372114623364e-03, 7.0858722530550288e-04, 1.7783091417839559e-03, 7.1541539011648952e-04, -1.5411936953103653e-02, 7.3903417706619335e-03, 4.5483022121753222e-03, -8.9677881534670116e-04, 7.3903417706619335e-03, -1.8311445673321121e-03, 5.0618507124800330e-04, 1.6497657392883489e-03, 4.5483022121753222e-03, 5.0618507124800330e-04, -1.0944142931277624e-04, 2.0053974090094044e-03, -8.9677881534670116e-04, 1.6497657392883489e-03, 2.0053974090094044e-03, 5.8688361598166873e-04, -1.5877997586428029e-02, 7.0102564979234233e-03, 2.3822117395892084e-03, 2.4183758414625888e-03, 7.0102564979234233e-03, -2.0572286784362988e-03, 3.5983393342809214e-04, -1.3917845780270373e-04, 2.3822117395892084e-03, 3.5983393342809214e-04, 9.3742516843216294e-05, 1.1681434312541931e-03, 2.4183758414625888e-03, -1.3917845780270373e-04, 1.1681434312541931e-03, 2.2289605656281757e-04, -1.4083572828047439e-02, 7.9925244381302291e-03, -6.0284983439355796e-04, -9.7568039067081366e-04, 7.9925244381302291e-03, -2.8403745612453242e-03, 1.4149913418989291e-03, 1.3483783335542488e-03, -6.0284983439355796e-04, 1.4149913418989291e-03, -7.9567702505795620e-05, 4.5761961508970946e-04, -9.7568039067081366e-04, 1.3483783335542488e-03, 4.5761961508970946e-04, -1.8122180927645343e-05, -1.3011750140965523e-02, 8.0448027672424538e-03, 1.3711087550206127e-03, 1.2861069552821227e-03, 8.0448027672424538e-03, -3.4752261499698942e-03, 3.7416175157491864e-04, 3.5251373821010203e-04, 1.3711087550206127e-03, 3.7416175157491864e-04, 1.0668685970538342e-04, 1.2410321451126983e-03, 1.2861069552821227e-03, 3.5251373821010203e-04, 1.2410321451126983e-03, 1.2833570311562067e-04, -1.0240113275587109e-02, 6.1802880789633766e-03, 1.3904451755038282e-03, -3.0192736293871718e-04, 6.1802880789633766e-03, -3.0059440450167932e-03, -5.3368175414203413e-04, 4.7195090306965839e-04, 1.3904451755038282e-03, -5.3368175414203413e-04, -7.9556056354311339e-04, 9.5483655393905145e-04, -3.0192736293871718e-04, 4.7195090306965839e-04, 9.5483655393905145e-04, -5.7134829653405345e-04, -1.3385066274392758e-02, 6.6124934381380064e-03, -1.2821932840326072e-03, 2.0730056600946553e-03, 6.6124934381380064e-03, -1.9317403170367104e-03, 1.2403275688648368e-03, -8.1880449480140711e-06, -1.2821932840326072e-03, 1.2403275688648368e-03, -2.9734471249323222e-04, 1.1154847964356678e-03, 2.0730056600946553e-03, -8.1880449480140711e-06, 1.1154847964356678e-03, -8.2008990837446980e-05, -1.2832033261169851e-02, 7.1731149113646135e-03, -1.3178043396281812e-03, -8.1927059876190744e-04, 7.1731149113646135e-03, -3.8547355138079868e-03, 1.3689397012382246e-03, 1.4741597574298045e-03, -1.3178043396281812e-03, 1.3689397012382246e-03, -1.5523748509968895e-04, 5.2913940932647796e-04, -8.1927059876190744e-04, 1.4741597574298045e-03, 5.2913940932647796e-04, -2.0477161752664730e-06, -1.9353179288859976e-02, 8.2472993213544895e-03, 1.1328241708247928e-03, 1.0173474843959841e-04, 8.2472993213544895e-03, -2.0348560585739840e-03, 1.8916142915004761e-03, 1.8422284519757142e-03, 1.1328241708247928e-03, 1.8916142915004761e-03, 6.6390870098819582e-04, 1.6001417768552631e-03, 1.0173474843959841e-04, 1.8422284519757142e-03, 1.6001417768552631e-03, 7.2754320201389323e-04, -1.8034057030268318e-02, 8.1439718393683594e-03, -1.4927369306321973e-03, 4.4653038520066791e-04, 8.1439718393683594e-03, -2.0375629958202432e-03, 1.9844371297367868e-03, 1.5706327924026185e-03, -1.4927369306321973e-03, 1.9844371297367868e-03, 8.4221508811039951e-05, 1.4760224149450302e-03, 4.4653038520066791e-04, 1.5706327924026185e-03, 1.4760224149450302e-03, 5.3324147164490450e-04, -1.9858435274308524e-02, 5.5927944148301684e-03, -1.5438870160433414e-03, 3.3657100726607308e-03, 5.5927944148301684e-03, 2.3561660401123010e-04, 2.3242973956863057e-03, 1.5999686201749661e-03, -1.5438870160433414e-03, 2.3242973956863057e-03, 3.1805397259977025e-04, 1.2466021708669767e-03, 3.3657100726607308e-03, 1.5999686201749661e-03, 1.2466021708669767e-03, 3.8368966980689126e-04, -9.7281699245688677e-03, 6.3301451421522454e-03, -2.1014055387616102e-04, -1.0747609780239144e-03, 6.3301451421522454e-03, -3.4334745573678408e-03, 8.1169421191581016e-04, 6.4971659824279585e-04, -2.1014055387616102e-04, 8.1169421191581016e-04, -3.3545824360928884e-04, 4.5259596268414320e-04, -1.0747609780239144e-03, 6.4971659824279585e-04, 4.5259596268414320e-04, -1.1830597768979520e-04, -1.6332140614730220e-02, 9.0103128113567417e-03, 1.5571710079426081e-03, -6.0630677294044237e-04, 9.0103128113567417e-03, -2.4498309848700814e-03, 1.1243148388670240e-03, 1.9746725100914823e-03, 1.5571710079426081e-03, 1.1243148388670240e-03, 2.4215985584758782e-04, 1.0849950462954012e-03, -6.0630677294044237e-04, 1.9746725100914823e-03, 1.0849950462954012e-03, 4.0955394785959507e-04, -1.3036079872743208e-02, 8.1986656104820928e-03, -4.1339688016818390e-04, -7.9169837147628590e-04, 8.1986656104820928e-03, -3.0128993657090463e-03, 1.3087483787852701e-03, 1.3783682086432115e-03, -4.1339688016818390e-04, 1.3087483787852701e-03, 1.0389730541704824e-04, 1.0307092574933089e-03, -7.9169837147628590e-04, 1.3783682086432115e-03, 1.0307092574933089e-03, 2.5367532767235548e-04, -1.3984645154594681e-02, 8.3445337042039359e-03, -1.5668162012331865e-03, -1.6294897225424144e-03, 8.3445337042039359e-03, -2.3222775494725553e-03, 1.5981596851179622e-03, 2.2297148976875006e-03, -1.5668162012331865e-03, 1.5981596851179622e-03, 4.9099274793647457e-04, 1.0006803325697039e-03, -1.6294897225424144e-03, 2.2297148976875006e-03, 1.0006803325697039e-03, 7.7225711991308439e-04, -1.0878208304283613e-02, 6.8495335213857884e-03, 1.8367434011084490e-03, -1.1684248224645396e-03, 6.8495335213857884e-03, -3.7485460530336514e-03, -4.5636048439838095e-04, 1.1909478868148576e-03, 1.8367434011084490e-03, -4.5636048439838095e-04, 1.3521556398979253e-04, 5.5654021720440735e-04, -1.1684248224645396e-03, 1.1909478868148576e-03, 5.5654021720440735e-04, 1.7634298653690025e-04, -1.3695683195390350e-02, 9.6440337102124008e-03, -1.1111079511340462e-03, -7.3806515965964433e-04, 9.6440337102124008e-03, -4.4655385326203868e-03, 2.6568699762222737e-03, 1.4535689858293593e-03, -1.1111079511340462e-03, 2.6568699762222737e-03, 4.0767188718331062e-04, 1.3035911326184557e-03, -7.3806515965964433e-04, 1.4535689858293593e-03, 1.3035911326184557e-03, 6.4104771006401936e-04, -1.8783865558349294e-02, 9.5046988369441830e-03, 1.0054895662265832e-03, -1.3398595612765494e-03, 9.5046988369441830e-03, -2.4387572360332795e-03, 1.2308518058462559e-03, 2.3676189965730725e-03, 1.0054895662265832e-03, 1.2308518058462559e-03, 7.0028547773139820e-04, 1.0101870932540413e-03, -1.3398595612765494e-03, 2.3676189965730725e-03, 1.0101870932540413e-03, 7.0233475365099978e-04, -1.4976622456425184e-02, 8.1162153169009460e-03, -1.3827823800513477e-03, -9.0475962868004594e-04, 8.1162153169009460e-03, -2.2249946889018480e-03, 2.1152052285084320e-03, 1.8399989448963172e-03, -1.3827823800513477e-03, 2.1152052285084320e-03, 2.8805366919883429e-04, 1.4321728932099045e-03, -9.0475962868004594e-04, 1.8399989448963172e-03, 1.4321728932099045e-03, 4.1014738409446026e-04, -1.1408226145512439e-02, 6.4954304965538492e-03, -1.2001987796160765e-03, -9.3863075040407956e-04, 6.4954304965538492e-03, -2.1295410823541430e-03, 8.3445635040981805e-04, 1.0828225854915745e-03, -1.2001987796160765e-03, 8.3445635040981805e-04, -3.5131917652677573e-04, 6.5050284812873853e-04, -9.3863075040407956e-04, 1.0828225854915745e-03, 6.5050284812873853e-04, 9.2967121716285277e-05, -1.3540012040553353e-02, 6.5044103809259023e-03, -1.4509842112690869e-03, 2.9456259587854984e-03, 6.5044103809259023e-03, -2.1362340178470861e-03, 2.1384291485579830e-03, 4.4150731301810292e-04, -1.4509842112690869e-03, 2.1384291485579830e-03, 6.8321237604588041e-04, 1.5155198702477583e-03, 2.9456259587854984e-03, 4.4150731301810292e-04, 1.5155198702477583e-03, 9.4537651413804154e-04, -1.6246993041419768e-02, 7.8928849361846465e-03, -1.0371149787786690e-03, -1.1988565506819290e-03, 7.8928849361846465e-03, -2.1711861031565201e-03, 1.5625386477991353e-03, 2.0766924041950999e-03, -1.0371149787786690e-03, 1.5625386477991353e-03, 3.6916286503139387e-04, 1.3956257087938428e-03, -1.1988565506819290e-03, 2.0766924041950999e-03, 1.3956257087938428e-03, 7.0753221752847730e-04, -1.3605718835333182e-02, 8.4677963790206132e-03, 1.5674417326158496e-03, -8.5156763496229099e-04, 8.4677963790206132e-03, -2.0207185798241187e-03, 8.5611012401802392e-04, 1.5345153178721719e-03, 1.5674417326158496e-03, 8.5611012401802392e-04, 3.4310085919516103e-04, 1.3423485494321341e-03, -8.5156763496229099e-04, 1.5345153178721719e-03, 1.3423485494321341e-03, 4.5225478537197169e-04, -1.4669000264706085e-02, 8.7488167172959999e-03, -1.4091880634556062e-03, -1.0017125355292859e-03, 8.7488167172959999e-03, -3.0719648092492838e-03, 2.3683327512114935e-03, 1.8164163784652701e-03, -1.4091880634556062e-03, 2.3683327512114935e-03, 1.8550057165905962e-04, 8.3199462205668607e-04, -1.0017125355292859e-03, 1.8164163784652701e-03, 8.3199462205668607e-04, 2.3623702228027553e-04, -1.3384842502986008e-02, -7.4284413610738024e-04, 2.2164427066970675e-03, -1.6984495314060527e-03, -7.4284413610738024e-04, -1.1789069761800031e-04, 5.5226050924804017e-04, 1.2865230734008021e-03, 2.2164427066970675e-03, 5.5226050924804017e-04, 1.6158157787987345e-04, 1.4162104619029536e-03, -1.6984495314060527e-03, 1.2865230734008021e-03, 1.4162104619029536e-03, 2.5984053718450023e-04, -1.4270238868634912e-02, 8.7435299844129590e-03, 1.3121371658921229e-03, -1.4459562540351310e-03, 8.7435299844129590e-03, -2.5869716021176296e-03, 1.9816371858388513e-03, 1.8906964142812917e-03, 1.3121371658921229e-03, 1.9816371858388513e-03, 5.2299567205402252e-04, 1.6974470674424424e-03, -1.4459562540351310e-03, 1.8906964142812917e-03, 1.6974470674424424e-03, 6.8040298431208874e-04, -1.3927808495450104e-02, 9.8114319729643538e-03, -1.4585605825814291e-03, 5.1081452718003395e-04, 9.8114319729643538e-03, -3.1780317017032489e-03, 1.9510988088846683e-03, 1.0552731530989561e-03, -1.4585605825814291e-03, 1.9510988088846683e-03, 4.1351930697924790e-04, 8.3639732480242888e-04, 5.1081452718003395e-04, 1.0552731530989561e-03, 8.3639732480242888e-04, 5.9577771535064973e-04, -1.2005957611549042e-02, 6.5269829696843855e-03, 5.4227086053001321e-06, -1.2166655959930230e-03, 6.5269829696843855e-03, -2.8587968071345869e-03, 8.7526046059167601e-04, 1.1870931547370881e-03, 5.4227086053001321e-06, 8.7526046059167601e-04, -9.3426039127427613e-05, 7.3532331884749720e-04, -1.2166655959930230e-03, 1.1870931547370881e-03, 7.3532331884749720e-04, 8.0025894282650164e-05, -1.3643474898358156e-02, 7.2377155928434068e-03, -1.2401442140379342e-03, -1.2740975088610677e-03, 7.2377155928434068e-03, -2.2422690205721159e-03, 1.5138822054081335e-03, 1.4904684300819143e-03, -1.2401442140379342e-03, 1.5138822054081335e-03, -1.3634361034485141e-04, 1.1127686221486200e-03, -1.2740975088610677e-03, 1.4904684300819143e-03, 1.1127686221486200e-03, 2.6190429702892281e-04, -1.8536129654681068e-02, 5.7362215425607876e-03, 3.7077483503927737e-03, 5.3703505121290920e-03, 5.7362215425607876e-03, -1.5089926703986004e-03, 1.7790988909616276e-03, 2.4855814646503223e-04, 3.7077483503927737e-03, 1.7790988909616276e-03, -2.6330472344847811e-04, 5.6773516831324072e-04, 5.3703505121290920e-03, 2.4855814646503223e-04, 5.6773516831324072e-04, -7.5082904071627644e-05, -1.2009357144285096e-02, 8.3436157388768785e-03, 1.4898887848690406e-03, -1.1644905255429930e-03, 8.3436157388768785e-03, -3.9039776700446403e-03, 6.7845541120046616e-04, 8.9957003910951026e-04, 1.4898887848690406e-03, 6.7845541120046616e-04, -4.3136022070644790e-04, 8.0279376655449392e-04, -1.1644905255429930e-03, 8.9957003910951026e-04, 8.0279376655449392e-04, 1.4214812713657745e-04, -1.3087027777011376e-02, 8.1091117611986480e-03, -9.9940829784200174e-04, 3.0841860053121063e-03, 8.1091117611986480e-03, -1.8957247580462895e-03, 2.0851167099702368e-03, 4.9914625071405998e-04, -9.9940829784200174e-04, 2.0851167099702368e-03, 5.8420276661913983e-04, 1.2124350953385600e-03, 3.0841860053121063e-03, 4.9914625071405998e-04, 1.2124350953385600e-03, 9.4839886112247610e-04, -1.4389875409702553e-02, 5.9650198667490139e-03, 2.7789793386952099e-03, 1.1951993133499255e-03, 5.9650198667490139e-03, -1.5525484868771592e-03, -1.8249951551237587e-04, 2.3756213628496397e-05, 2.7789793386952099e-03, -1.8249951551237587e-04, -7.0686530665496237e-04, 8.4787536338310149e-04, 1.1951993133499255e-03, 2.3756213628496397e-05, 8.4787536338310149e-04, -1.8249697460956133e-04, -1.6493749736099662e-02, 8.9845954108499354e-03, -6.5855511936865679e-04, -1.2916630860458668e-03, 8.9845954108499354e-03, -2.2720543779065185e-03, 2.0777202119131770e-03, 1.7945117300401194e-03, -6.5855511936865679e-04, 2.0777202119131770e-03, 3.7547177825330777e-04, 1.3207948522699173e-03, -1.2916630860458668e-03, 1.7945117300401194e-03, 1.3207948522699173e-03, 4.4592713214989318e-04, -1.1661413908588582e-02, 5.3356769263466705e-03, 2.3910148956967888e-05, 2.0144431709342532e-03, 5.3356769263466705e-03, -2.3763451303913793e-03, 1.5795406491315219e-04, -5.2947905482373585e-04, 2.3910148956967888e-05, 1.5795406491315219e-04, -3.3709897439123792e-04, 4.4156371402711333e-04, 2.0144431709342532e-03, -5.2947905482373585e-04, 4.4156371402711333e-04, -1.6067267371488200e-04, -1.2127195499525786e-02, 6.3575178498569175e-03, 2.7885477665962593e-03, 1.4103487851294598e-03, 6.3575178498569175e-03, -1.9866201831196012e-03, 1.4532946357492936e-03, 1.0405145770188389e-03, 2.7885477665962593e-03, 1.4532946357492936e-03, 1.1650211077524758e-04, 1.1231612548733749e-03, 1.4103487851294598e-03, 1.0405145770188389e-03, 1.1231612548733749e-03, 4.1629479593797221e-04, -1.0520573085213737e-02, 6.8711276675652456e-03, 1.6939148906612810e-03, -9.8113687728168184e-04, 6.8711276675652456e-03, -2.6887735100749720e-03, -2.1586496673177543e-04, 1.0064124321346908e-03, 1.6939148906612810e-03, -2.1586496673177543e-04, -1.4067199641936031e-04, 2.9361950909233638e-04, -9.8113687728168184e-04, 1.0064124321346908e-03, 2.9361950909233638e-04, -7.9727460669166473e-05, -1.5912209340202287e-02, 8.8708507277150267e-03, -2.2876273236139503e-04, -1.2962376027821204e-03, 8.8708507277150267e-03, -3.7886872287483438e-03, 2.2364194787288061e-03, 2.3055217337219964e-03, -2.2876273236139503e-04, 2.2364194787288061e-03, -2.2121966075386214e-04, 9.2457524181229541e-04, -1.2962376027821204e-03, 2.3055217337219964e-03, 9.2457524181229541e-04, 5.0819851534159976e-04, -1.1988487259813843e-02, -1.0817915696993614e-03, 4.4055451227390865e-03, 2.6194469136628352e-03, -1.0817915696993614e-03, -9.4238486903406541e-04, 7.7092876812179679e-04, 1.6765166378430332e-03, 4.4055451227390865e-03, 7.7092876812179679e-04, -7.0957594439696422e-04, 4.6632501327589830e-04, 2.6194469136628352e-03, 1.6765166378430332e-03, 4.6632501327589830e-04, -1.7141234209432641e-05, -1.2965555240827500e-02, 4.6872799977542403e-03, -1.4510821237139582e-03, 3.7946233749072901e-03, 4.6872799977542403e-03, -3.5962713002839149e-04, 1.0943003685336375e-03, 5.6646742816718408e-04, -1.4510821237139582e-03, 1.0943003685336375e-03, -1.0401090694716338e-04, 1.7088920364535401e-03, 3.7946233749072901e-03, 5.6646742816718408e-04, 1.7088920364535401e-03, 2.7162106952229655e-04, -1.4785199674470367e-02, 8.0633700283524075e-03, -5.6495833882158305e-04, 2.4514928345558051e-03, 8.0633700283524075e-03, -3.2143330398933306e-03, 1.9126378978111445e-03, 4.8878097615942593e-05, -5.6495833882158305e-04, 1.9126378978111445e-03, 2.1638725769767891e-04, 8.0709190039421428e-04, 2.4514928345558051e-03, 4.8878097615942593e-05, 8.0709190039421428e-04, 5.8999550418438625e-04, -1.4240209598961997e-02, 6.7516548024444747e-03, -5.1918416449977969e-04, 2.2353477983456612e-03, 6.7516548024444747e-03, -1.8474456163168917e-03, 1.2971818549383650e-03, -1.5014058192087238e-04, -5.1918416449977969e-04, 1.2971818549383650e-03, -7.3709152533265676e-05, 3.5066038413611596e-04, 2.2353477983456612e-03, -1.5014058192087238e-04, 3.5066038413611596e-04, -3.3978637630894203e-05, -1.3007652156842001e-02, 6.6856636493797493e-03, 2.9160109924347812e-03, -6.5543528412060508e-04, 6.6856636493797493e-03, -1.8216554256699276e-03, 7.3027879176171099e-04, 9.7092376946287130e-04, 2.9160109924347812e-03, 7.3027879176171099e-04, -1.0356785011530854e-04, 1.5729902578397168e-03, -6.5543528412060508e-04, 9.7092376946287130e-04, 1.5729902578397168e-03, 2.9497919465760276e-04, -1.0866405763036151e-02, 5.3513859835064457e-03, 2.4060930773512137e-04, 1.9862948106334644e-03, 5.3513859835064457e-03, -1.8512769013365881e-03, 2.8133169930445625e-04, -3.4053514307311997e-04, 2.4060930773512137e-04, 2.8133169930445625e-04, -1.0872990161973775e-04, 3.0543245383033921e-04, 1.9862948106334644e-03, -3.4053514307311997e-04, 3.0543245383033921e-04, -3.2564062326252566e-05, -9.0348481159891574e-03, 4.9368779887051665e-03, -7.7858023749495433e-04, 1.0920385408053164e-03, 4.9368779887051665e-03, -2.4651064596398460e-03, 7.2405402568656097e-04, -4.7031756933928247e-04, -7.7858023749495433e-04, 7.2405402568656097e-04, -5.4175927276914012e-04, 2.2338122120519862e-05, 1.0920385408053164e-03, -4.7031756933928247e-04, 2.2338122120519862e-05, -1.6681805314778045e-04, -1.7304180355604392e-02, 8.6652343814632091e-03, -1.2246474341539783e-03, 8.2415022799262484e-04, 8.6652343814632091e-03, -2.2303662865870645e-03, 2.2578893430555296e-03, 1.4121004619557782e-03, -1.2246474341539783e-03, 2.2578893430555296e-03, 6.6297648327747090e-04, 1.1885000811279875e-03, 8.2415022799262484e-04, 1.4121004619557782e-03, 1.1885000811279875e-03, 6.6695685275927760e-04, -1.0778073152356201e-02, 6.3694652581600224e-03, 1.6961032371909813e-03, -1.0948355265557148e-03, 6.3694652581600224e-03, -3.4260749027166322e-03, 7.2077630136983231e-04, 4.4084306708303315e-04, 1.6961032371909813e-03, 7.2077630136983231e-04, -8.9011520033262931e-04, 9.7699882816715137e-04, -1.0948355265557148e-03, 4.4084306708303315e-04, 9.7699882816715137e-04, -1.6721134424032506e-04, -1.5880217492160682e-02, 3.6937157026263458e-03, 4.3136575901598258e-03, -1.5179193912709036e-03, 3.6937157026263458e-03, -1.1384551327959617e-03, 1.6183111798056420e-03, 2.1843622767156786e-03, 4.3136575901598258e-03, 1.6183111798056420e-03, 3.6830220626843141e-05, 1.5392367332523269e-03, -1.5179193912709036e-03, 2.1843622767156786e-03, 1.5392367332523269e-03, 4.4276775065660106e-04, -1.6165406785950832e-02, 5.8699367964453637e-03, -1.2859790511595471e-03, -9.6075957427906315e-04, 5.8699367964453637e-03, -1.1179968213466582e-03, 1.7183301947139779e-03, 1.9085251825466231e-03, -1.2859790511595471e-03, 1.7183301947139779e-03, 4.8200250785465073e-05, 1.4857105304615032e-03, -9.6075957427906315e-04, 1.9085251825466231e-03, 1.4857105304615032e-03, 4.8795341166811253e-04, -1.0013561677409232e-02, 4.0961622741432311e-03, -1.1185134603428390e-03, -1.0574249764454893e-03, 4.0961622741432311e-03, -1.7667047214563205e-03, 4.4148465732737679e-04, 5.1292958257300033e-04, -1.1185134603428390e-03, 4.4148465732737679e-04, -3.2715402184443172e-04, 5.9087815524321886e-05, -1.0574249764454893e-03, 5.1292958257300033e-04, 5.9087815524321886e-05, -2.5498418232061302e-04, -1.5836685529134305e-02, 7.9890379919545819e-03, 2.0022017376080106e-03, -7.4049310281811551e-04, 7.9890379919545819e-03, -1.8638004635911647e-03, 1.6707614648490442e-03, 2.0576430038936316e-03, 2.0022017376080106e-03, 1.6707614648490442e-03, -3.8921469816428380e-04, 1.8660395072033363e-03, -7.4049310281811551e-04, 2.0576430038936316e-03, 1.8660395072033363e-03, 8.3166983679526074e-04, -1.5585823655705712e-02, 8.6547358140740775e-03, 6.4685805130901839e-04, 6.0437717832279090e-04, 8.6547358140740775e-03, -2.9179966185179798e-03, 1.6650090091244428e-03, 5.4772087545596447e-04, 6.4685805130901839e-04, 1.6650090091244428e-03, 1.0944173789827910e-04, 1.6193714005056402e-03, 6.0437717832279090e-04, 5.4772087545596447e-04, 1.6193714005056402e-03, 4.1435400171744153e-04, -1.2002918703686777e-02, 8.5494004897721486e-03, 2.6869376009802685e-03, 2.8041002192664066e-04, 8.5494004897721486e-03, -3.3375720513194084e-03, -6.4781613669761683e-05, 1.3524488057429884e-03, 2.6869376009802685e-03, -6.4781613669761683e-05, -1.0720086261486713e-04, 3.3638662164407361e-04, 2.8041002192664066e-04, 1.3524488057429884e-03, 3.3638662164407361e-04, 2.7204403023007185e-04, -1.5230508969721116e-02, 8.0033674082133788e-03, 4.5505572033502154e-03, 6.3142263681769913e-04, 8.0033674082133788e-03, -2.2473990191216016e-03, 9.4766049239732128e-04, 8.2712654749629762e-04, 4.5505572033502154e-03, 9.4766049239732128e-04, -8.7138227660763510e-04, 1.8741234298296900e-03, 6.3142263681769913e-04, 8.2712654749629762e-04, 1.8741234298296900e-03, 7.8238202994568230e-04, -1.4728673062431606e-02, 7.7272261248470383e-03, -6.5330828262795480e-04, -1.0320780914468404e-03, 7.7272261248470383e-03, -3.4770903165693631e-03, 1.7224962220012408e-03, 1.6016916176218841e-03, -6.5330828262795480e-04, 1.7224962220012408e-03, -1.0624168683721165e-05, 6.7411356195351047e-04, -1.0320780914468404e-03, 1.6016916176218841e-03, 6.7411356195351047e-04, 3.5793923973344256e-04, -1.5365215679984470e-02, 7.7326906220242997e-03, -8.7919884112348649e-04, 3.9232895421004452e-03, 7.7326906220242997e-03, -1.8951873402245514e-03, 1.6702212822668559e-03, 3.8698617614536183e-04, -8.7919884112348649e-04, 1.6702212822668559e-03, 1.4305624533357813e-04, 1.3483365102715016e-03, 3.9232895421004452e-03, 3.8698617614536183e-04, 1.3483365102715016e-03, 2.9887961813433576e-04, -1.5308665984215052e-02, 6.4035427214453088e-03, 3.2264588182182893e-03, -1.2172293673001523e-03, 6.4035427214453088e-03, -2.1803365653642855e-03, 8.1169763975199303e-04, 1.1516553650030236e-03, 3.2264588182182893e-03, 8.1169763975199303e-04, -8.9273426545469822e-04, 1.3149492890516085e-03, -1.2172293673001523e-03, 1.1516553650030236e-03, 1.3149492890516085e-03, 3.4916307447500070e-04, -1.4177990755768224e-02, 8.4436539885229638e-03, 1.9644514003780713e-03, -1.4051939351763857e-03, 8.4436539885229638e-03, -2.6365958058229824e-03, 2.7988734419438126e-04, 2.3791557288914468e-03, 1.9644514003780713e-03, 2.7988734419438126e-04, -9.3295814287705590e-06, 1.7397564635589064e-03, -1.4051939351763857e-03, 2.3791557288914468e-03, 1.7397564635589064e-03, 3.5990020010247216e-04, -1.4509970137912609e-02, 8.3321965664366754e-03, 1.9636760666178182e-04, 1.4472834003371236e-03, 8.3321965664366754e-03, -3.1644286858689462e-03, 1.3130696372032696e-03, 8.9901256003085657e-04, 1.9636760666178182e-04, 1.3130696372032696e-03, -1.1641434273373312e-04, 1.1005872558455100e-03, 1.4472834003371236e-03, 8.9901256003085657e-04, 1.1005872558455100e-03, 2.2352300907388465e-04, -1.4191547859266384e-02, 7.2008193102188825e-03, 3.7147795995076251e-03, -9.3769917155450059e-04, 7.2008193102188825e-03, -1.8544479396288801e-03, 6.8480624138753587e-04, 1.5662746452927681e-03, 3.7147795995076251e-03, 6.8480624138753587e-04, -6.5351803821489724e-04, 1.5327770952292775e-03, -9.3769917155450059e-04, 1.5662746452927681e-03, 1.5327770952292775e-03, 4.5630359182475774e-04, -1.4160940337820836e-02, 7.8821478615683557e-03, -9.8558148594463752e-04, 3.7918168562442430e-03, 7.8821478615683557e-03, -2.1790556607648682e-03, 2.0369416094564120e-03, 1.4304949644710783e-04, -9.8558148594463752e-04, 2.0369416094564120e-03, 5.0614978147559312e-04, 1.6610917581866963e-03, 3.7918168562442430e-03, 1.4304949644710783e-04, 1.6610917581866963e-03, 5.8794575109223548e-04, -9.2845894059316349e-03, 6.4939565529886596e-03, 1.4724840417364997e-03, -5.6610856876894574e-04, 6.4939565529886596e-03, -3.7833463506718019e-03, -4.7204290292012798e-04, 6.9241613661032045e-04, 1.4724840417364997e-03, -4.7204290292012798e-04, -8.1865701212015295e-04, 4.9894256490768405e-04, -5.6610856876894574e-04, 6.9241613661032045e-04, 4.9894256490768405e-04, -1.6611368267292618e-04, -1.6184598560687900e-02, 6.8439613963293747e-03, 1.7365578719469512e-03, 2.5532525388744873e-03, 6.8439613963293747e-03, -1.6997340703512266e-03, 8.1255506906787128e-04, 1.5422686239700562e-04, 1.7365578719469512e-03, 8.1255506906787128e-04, 3.3892711957371837e-04, 7.0860872528022347e-04, 2.5532525388744873e-03, 1.5422686239700562e-04, 7.0860872528022347e-04, 4.6427613812592781e-04, -1.2357824977244209e-02, 6.9688664588778747e-03, -1.0006387693880701e-03, 5.1736619278341814e-04, 6.9688664588778747e-03, -3.6183785683711568e-03, 8.2525839785551063e-04, 1.1173236493360916e-03, -1.0006387693880701e-03, 8.2525839785551063e-04, -1.0729556618775974e-04, 6.7298930398621047e-04, 5.1736619278341814e-04, 1.1173236493360916e-03, 6.7298930398621047e-04, -3.1875208496333698e-08, -1.4252206077143996e-02, 6.2144795121130665e-03, 5.2879460633076993e-03, -1.0233446873137595e-03, 6.2144795121130665e-03, -1.5331372596218611e-03, 2.2209966824697589e-04, 2.0306655712737896e-03, 5.2879460633076993e-03, 2.2209966824697589e-04, -1.0936295576075275e-03, 1.9226034908899328e-03, -1.0233446873137595e-03, 2.0306655712737896e-03, 1.9226034908899328e-03, 5.5839135772282368e-04, -1.3330238816035098e-02, 8.1905708096769846e-03, -7.6394721968447781e-04, -2.2394664524934586e-04, 8.1905708096769846e-03, -3.0167954985111760e-03, 1.9263001035794555e-03, 1.5435010884285658e-03, -7.6394721968447781e-04, 1.9263001035794555e-03, 4.3194129081048293e-04, 1.1144179655621770e-03, -2.2394664524934586e-04, 1.5435010884285658e-03, 1.1144179655621770e-03, 4.6419314960482224e-04, -9.3078896127232972e-03, 3.7808378683754900e-03, -8.2500659938291763e-04, -9.2253721497522736e-04, 3.7808378683754900e-03, -1.3735593478715945e-03, 2.6895103878370749e-04, 6.0702527043364398e-04, -8.2500659938291763e-04, 2.6895103878370749e-04, -3.5102799517677157e-04, 2.1534278727519608e-04, -9.2253721497522736e-04, 6.0702527043364398e-04, 2.1534278727519608e-04, -1.4676179836516589e-04, -1.7610358444604211e-02, 7.7354116237610682e-03, -4.3061286359086953e-04, 3.1429218095944938e-03, 7.7354116237610682e-03, -2.3939505233226636e-03, 1.4834692755721455e-03, 1.6181041921510780e-03, -4.3061286359086953e-04, 1.4834692755721455e-03, 8.0959866125124443e-05, 1.6836715825834035e-03, 3.1429218095944938e-03, 1.6181041921510780e-03, 1.6836715825834035e-03, 4.4455549963187051e-04, -1.1327541090185321e-02, 8.0271674256418221e-03, -1.0748118107689127e-03, 1.0220978517679886e-03, 8.0271674256418221e-03, -3.7625982726974937e-03, 1.4015004959102217e-03, 2.9941859123995497e-04, -1.0748118107689127e-03, 1.4015004959102217e-03, -4.7414240813170117e-04, 1.8984462650148025e-04, 1.0220978517679886e-03, 2.9941859123995497e-04, 1.8984462650148025e-04, 1.9168610525451880e-05, -7.7599972015153637e-03, 5.0487328889732026e-03, -1.0150335177867968e-03, -1.0787256637662084e-03, 5.0487328889732026e-03, -3.8283334708152520e-03, 4.8095191605469594e-04, 1.0961988375689778e-03, -1.0150335177867968e-03, 4.8095191605469594e-04, -3.5006941784132919e-04, 2.5142046401834721e-04, -1.0787256637662084e-03, 1.0961988375689778e-03, 2.5142046401834721e-04, -3.4601993607214204e-04, -1.6722037962919063e-02, 8.9023027147699402e-03, 2.8475764924646074e-03, -1.3668464681863240e-03, 8.9023027147699402e-03, -3.0464816895161466e-03, 5.5483638104875219e-04, 2.5866682413927889e-03, 2.8475764924646074e-03, 5.5483638104875219e-04, 3.2244817585743671e-04, 1.7335129486130759e-03, -1.3668464681863240e-03, 2.5866682413927889e-03, 1.7335129486130759e-03, 6.7373810044801786e-04, -1.3043290920668447e-02, 7.5390776005711682e-03, -1.4967658915720180e-03, -1.1709919402049843e-03, 7.5390776005711682e-03, -2.3042283980880748e-03, 1.8948249232033040e-03, 1.4633606749955709e-03, -1.4967658915720180e-03, 1.8948249232033040e-03, -1.1525903461801575e-04, 8.6522916210846480e-04, -1.1709919402049843e-03, 1.4633606749955709e-03, 8.6522916210846480e-04, -3.7584188113171969e-06, -1.5585713708593366e-02, 8.6119952233053958e-03, 2.0853199702149908e-04, -3.6538641086258830e-04, 8.6119952233053958e-03, -2.0708945444859184e-03, 2.0916162538495752e-03, 1.6963122585672433e-03, 2.0853199702149908e-04, 2.0916162538495752e-03, 8.4673232959246606e-04, 1.7050167169310555e-03, -3.6538641086258830e-04, 1.6963122585672433e-03, 1.7050167169310555e-03, 9.7321838069529471e-04, -8.5883608444249915e-03, 5.1230145745255022e-03, 8.9159902137280552e-04, 1.2313522195822745e-03, 5.1230145745255022e-03, -3.2070396434171729e-03, -4.0842243388821992e-04, -5.0228366774250242e-04, 8.9159902137280552e-04, -4.0842243388821992e-04, -1.6659900154853617e-04, 1.6703129248579686e-04, 1.2313522195822745e-03, -5.0228366774250242e-04, 1.6703129248579686e-04, -1.3910653088204271e-04, -1.7177487424496159e-02, 8.6439434323196465e-03, -1.2676542069329643e-03, 1.5530920065632684e-03, 8.6439434323196465e-03, -3.0711886933060752e-03, 2.6503690364040600e-03, 1.5823408628991603e-03, -1.2676542069329643e-03, 2.6503690364040600e-03, 2.0205318440554335e-05, 9.7190007034572039e-04, 1.5530920065632684e-03, 1.5823408628991603e-03, 9.7190007034572039e-04, 6.3167332201993298e-04, -1.8198829655079997e-02, 6.1783746997468043e-03, 2.7097557207645976e-03, 1.0674413677482549e-04, 6.1783746997468043e-03, -1.5255143488708853e-03, 4.2446808059708652e-04, 2.0056066309057513e-03, 2.7097557207645976e-03, 4.2446808059708652e-04, -7.0722767103247085e-05, 2.1439352866911227e-03, 1.0674413677482549e-04, 2.0056066309057513e-03, 2.1439352866911227e-03, 4.9248673587442768e-04, -1.2899230683789387e-02, 3.8809561952671224e-03, 5.8590703877280138e-03, 7.0773016587898281e-04, 3.8809561952671224e-03, -1.7333578324938207e-03, 1.5513687237511255e-03, 7.3324212478700988e-04, 5.8590703877280138e-03, 1.5513687237511255e-03, -1.6842888582058607e-03, 2.0427657447758315e-03, 7.0773016587898281e-04, 7.3324212478700988e-04, 2.0427657447758315e-03, -3.9900791227274096e-04, -1.3724818137332397e-02, 4.4851048250000233e-03, -1.3002218055153201e-03, -1.2182844898688022e-03, 4.4851048250000233e-03, -1.8202270259962889e-03, 1.9639130830478775e-03, 7.5413518528937972e-04, -1.3002218055153201e-03, 1.9639130830478775e-03, 3.1870016559458009e-04, 1.0685796268949520e-03, -1.2182844898688022e-03, 7.5413518528937972e-04, 1.0685796268949520e-03, 4.8322321243228277e-04, -1.2727886752614260e-02, 7.6627520867563600e-03, -1.0977617387408160e-03, -9.2741573884433924e-05, 7.6627520867563600e-03, -3.0923177506530018e-03, 5.2725763824365925e-04, 1.3750576763160460e-03, -1.0977617387408160e-03, 5.2725763824365925e-04, -3.8624246299677348e-04, 9.9356026784475603e-04, -9.2741573884433924e-05, 1.3750576763160460e-03, 9.9356026784475603e-04, -3.6185112057586651e-04, -1.4230368421296529e-02, 6.4613018087884382e-03, 4.2545431560881697e-03, 2.3312567462464729e-03, 6.4613018087884382e-03, -1.5885108206906821e-03, 3.4554820247452228e-04, 1.8419118470444126e-03, 4.2545431560881697e-03, 3.4554820247452228e-04, -2.8748861071839916e-04, 9.0566105830775748e-04, 2.3312567462464729e-03, 1.8419118470444126e-03, 9.0566105830775748e-04, 2.7039215950598432e-04, -1.2948564663328069e-02, 8.4157282283072385e-03, 5.0620127290202754e-04, -1.3314748626910642e-03, 8.4157282283072385e-03, -3.5176641019498255e-03, 1.5307289251449395e-03, 1.8525663157440806e-03, 5.0620127290202754e-04, 1.5307289251449395e-03, 5.6978788798275784e-05, 1.2935940913392739e-03, -1.3314748626910642e-03, 1.8525663157440806e-03, 1.2935940913392739e-03, 5.2341304653500667e-04, -1.2728855074017827e-02, 7.6246707479808553e-03, -9.3224478600061457e-04, -1.5620738423386569e-03, 7.6246707479808553e-03, -1.9782856856559788e-03, 1.4103550247563932e-03, 2.0801314899663139e-03, -9.3224478600061457e-04, 1.4103550247563932e-03, 4.6054846597137436e-04, 1.2330604509034212e-03, -1.5620738423386569e-03, 2.0801314899663139e-03, 1.2330604509034212e-03, 7.7627861087214880e-04, -1.7487269493133485e-02, 8.1945615648457912e-03, -1.3867371780327564e-03, -7.7203633752733088e-04, 8.1945615648457912e-03, -2.6839597442567947e-03, 2.3107751960829994e-03, 1.6061326831885306e-03, -1.3867371780327564e-03, 2.3107751960829994e-03, 6.8401777560147333e-04, 1.1030118862660431e-03, -7.7203633752733088e-04, 1.6061326831885306e-03, 1.1030118862660431e-03, 7.3617364729802910e-04, -1.3077682176402587e-02, 6.5573215542587115e-03, 8.9992300772369772e-04, 1.8631593971488946e-03, 6.5573215542587115e-03, -1.7553672105479552e-03, 1.4263355120099006e-03, -6.6131788423017066e-05, 8.9992300772369772e-04, 1.4263355120099006e-03, -1.5795558529122932e-04, 9.3709040689480281e-04, 1.8631593971488946e-03, -6.6131788423017066e-05, 9.3709040689480281e-04, 2.7558380426612552e-04, -1.2016216250619665e-02, 1.0198974276762779e-03, 2.9684095074686417e-03, 4.7574388367168719e-04, 1.0198974276762779e-03, -1.0457484751015638e-03, 1.4462132483450711e-03, 1.4655862021442318e-03, 2.9684095074686417e-03, 1.4462132483450711e-03, -1.1640147094591868e-04, 4.5714086841669362e-04, 4.7574388367168719e-04, 1.4655862021442318e-03, 4.5714086841669362e-04, 3.7349208876016085e-04, -1.2729011740008157e-02, 6.2751467801390199e-03, 2.7374611452219005e-03, -4.8769041908477083e-04, 6.2751467801390199e-03, -2.5912066920437101e-03, -3.6502488298821795e-04, 1.2747675934628886e-03, 2.7374611452219005e-03, -3.6502488298821795e-04, -1.3461493454670274e-04, 5.1297874213225157e-04, -4.8769041908477083e-04, 1.2747675934628886e-03, 5.1297874213225157e-04, 9.4116610547478451e-05, -1.6566854215408953e-02, 7.5656107280793628e-03, 2.2151664856272313e-03, -6.2355508020778901e-04, 7.5656107280793628e-03, -1.6767633757818533e-03, 7.2857964830252552e-04, 2.0018839786305805e-03, 2.2151664856272313e-03, 7.2857964830252552e-04, 7.8168565633001156e-04, 1.2563330405130704e-03, -6.2355508020778901e-04, 2.0018839786305805e-03, 1.2563330405130704e-03, 9.4171843217346913e-04, -1.3827220555148755e-02, 8.0412338777692237e-03, -9.2914695167431839e-04, 2.5139109709975873e-03, 8.0412338777692237e-03, -2.8902523593109979e-03, 1.7337506184933089e-03, -2.4479541495431615e-04, -9.2914695167431839e-04, 1.7337506184933089e-03, -6.2590822563885222e-04, 3.3033744058861008e-04, 2.5139109709975873e-03, -2.4479541495431615e-04, 3.3033744058861008e-04, 1.1867575245440103e-04, -1.1673022270160038e-02, 6.3818705599438547e-03, 1.5529035996520919e-03, 1.9023499244602438e-03, 6.3818705599438547e-03, -2.7838066962823493e-03, -3.4731692421037671e-04, -5.1143360268925109e-04, 1.5529035996520919e-03, -3.4731692421037671e-04, -2.9269524595909200e-04, 6.5189571167041226e-04, 1.9023499244602438e-03, -5.1143360268925109e-04, 6.5189571167041226e-04, -1.8842002149771150e-04, -1.7624872761522331e-02, 7.6102659079345675e-03, 2.9313602118366056e-03, -1.2670120134682693e-03, 7.6102659079345675e-03, -1.6176859045345274e-03, 5.2235785563708548e-04, 2.1125237303853172e-03, 2.9313602118366056e-03, 5.2235785563708548e-04, -6.9336521692627494e-05, 6.2961316498085299e-04, -1.2670120134682693e-03, 2.1125237303853172e-03, 6.2961316498085299e-04, 2.8049822298363992e-04, -1.1443728662686095e-02, 7.1090692233263322e-03, -1.0267468148229923e-03, -9.7148107774755140e-04, 7.1090692233263322e-03, -3.5986082376354236e-03, 1.0764295384459879e-03, 1.4077630540134337e-03, -1.0267468148229923e-03, 1.0764295384459879e-03, -1.4573111804904847e-04, 5.4872481291025343e-04, -9.7148107774755140e-04, 1.4077630540134337e-03, 5.4872481291025343e-04, -4.9397324463356642e-05, -1.4863131313394926e-02, 6.3276765757360525e-03, 4.1762520161465356e-03, 4.6274316270408979e-03, 6.3276765757360525e-03, -1.5123375588949818e-03, 1.5393235939542785e-03, 1.7038958618260523e-04, 4.1762520161465356e-03, 1.5393235939542785e-03, -3.8236797488742761e-04, 4.2645241632206950e-04, 4.6274316270408979e-03, 1.7038958618260523e-04, 4.2645241632206950e-04, -2.8027135821990324e-04, -9.2269149280535777e-03, 6.1800015820290153e-03, -1.1177505002325030e-03, -7.3655389049955076e-04, 6.1800015820290153e-03, -3.1949632173689504e-03, 9.2780949436812210e-04, 5.4061711672642406e-04, -1.1177505002325030e-03, 9.2780949436812210e-04, -3.6714991602973209e-04, 4.4326007298994439e-04, -7.3655389049955076e-04, 5.4061711672642406e-04, 4.4326007298994439e-04, -2.6509650841867525e-04, -1.8043017394515380e-02, 8.2372721119834628e-03, -1.3666634730605748e-03, 2.5937673526110440e-03, 8.2372721119834628e-03, -2.2765382593275749e-03, 1.8098836907605163e-03, 6.2774788742545431e-04, -1.3666634730605748e-03, 1.8098836907605163e-03, 6.3750682573144961e-04, 1.5016614599137833e-03, 2.5937673526110440e-03, 6.2774788742545431e-04, 1.5016614599137833e-03, 7.9656988901641562e-04, -1.7677863320201812e-02, 7.9918211430818238e-03, 2.8809808774680002e-03, 3.3219012282079618e-04, 7.9918211430818238e-03, -2.5093243675945506e-03, 1.6427685072652385e-03, 1.3849057522712679e-03, 2.8809808774680002e-03, 1.6427685072652385e-03, -6.6341536325757559e-04, 1.6383230989587684e-03, 3.3219012282079618e-04, 1.3849057522712679e-03, 1.6383230989587684e-03, -5.4016870687916257e-04, -1.2521451784673619e-02, 9.4223977497539906e-03, 2.8055309806167853e-03, 1.7872667456776705e-03, 9.4223977497539906e-03, -3.2829775106665285e-03, -1.4133846391320361e-05, 3.4392328922804288e-04, 2.8055309806167853e-03, -1.4133846391320361e-05, 6.9100703062136178e-05, 1.4271286897663935e-03, 1.7872667456776705e-03, 3.4392328922804288e-04, 1.4271286897663935e-03, 5.3937434576994730e-04, -1.3632536222978362e-02, 1.0257748639522706e-02, 1.4462286898582958e-03, 1.1312437976068149e-04, 1.0257748639522706e-02, -3.6576998284675250e-03, 1.6043422861050061e-03, 1.7092618248746980e-03, 1.4462286898582958e-03, 1.6043422861050061e-03, 1.6618519504767670e-04, 9.6235513287789881e-04, 1.1312437976068149e-04, 1.7092618248746980e-03, 9.6235513287789881e-04, 3.5802719238072031e-04, -9.2473425953727914e-03, 5.4646516574637042e-03, -9.5962421166676426e-04, -7.8247003179074371e-04, 5.4646516574637042e-03, -2.7506657954682067e-03, 5.9386441787538592e-04, 5.4897582411844530e-04, -9.5962421166676426e-04, 5.9386441787538592e-04, -3.0196113116772263e-04, 1.8573011529360198e-04, -7.8247003179074371e-04, 5.4897582411844530e-04, 1.8573011529360198e-04, -2.1319293163917321e-04, -1.2206117329009541e-02, 6.1092810650537708e-03, -1.4481345745921150e-03, -2.9722362809001516e-04, 6.1092810650537708e-03, -1.9126144266505905e-03, 1.7554634731526244e-03, 5.5972781767352870e-04, -1.4481345745921150e-03, 1.7554634731526244e-03, 8.6367120618161951e-05, 6.7487884435146381e-04, -2.9722362809001516e-04, 5.5972781767352870e-04, 6.7487884435146381e-04, 2.3556476013967504e-04, -1.5414965310465042e-02, 7.3079303890448630e-03, -6.8902344013111860e-05, -1.3856544124642479e-03, 7.3079303890448630e-03, -2.3520366982052667e-03, 2.2813099826687437e-03, 1.1422089660014121e-03, -6.8902344013111860e-05, 2.2813099826687437e-03, -5.6644557392149263e-05, 1.1994499087383925e-03, -1.3856544124642479e-03, 1.1422089660014121e-03, 1.1994499087383925e-03, 3.4944002873506328e-04, -1.1752221672219454e-02, 6.9456319878067867e-03, -1.5705985744796634e-03, -1.2694046046713740e-03, 6.9456319878067867e-03, -2.1753723772528176e-03, 1.5503236118177893e-03, 2.0219529729626610e-03, -1.5705985744796634e-03, 1.5503236118177893e-03, 2.4923829829079700e-04, 8.6809285519335883e-04, -1.2694046046713740e-03, 2.0219529729626610e-03, 8.6809285519335883e-04, 3.2743478195986473e-04, -1.4690777928137583e-02, 9.3382417975744429e-03, -8.7839174936228269e-04, -1.0828156619940759e-03, 9.3382417975744429e-03, -3.6232340991021171e-03, 1.5142500530220151e-03, 1.4677066708721873e-03, -8.7839174936228269e-04, 1.5142500530220151e-03, 4.0376228484767084e-06, 1.0556394847561596e-03, -1.0828156619940759e-03, 1.4677066708721873e-03, 1.0556394847561596e-03, 3.6668747259171032e-04, -1.5476441143750821e-02, 9.2269293204535301e-03, 3.6995872897747060e-04, -7.7034041709245649e-04, 9.2269293204535301e-03, -4.4645128477425761e-03, 2.1128383054205796e-03, 2.4504815100855485e-03, 3.6995872897747060e-04, 2.1128383054205796e-03, 2.2586802223079191e-04, 1.8926509467373552e-03, -7.7034041709245649e-04, 2.4504815100855485e-03, 1.8926509467373552e-03, 8.5536596431988856e-04, -1.5609938715099692e-02, 8.9557198628165934e-03, -1.3057139142808542e-03, -8.7481229959170993e-06, 8.9557198628165934e-03, -3.2036744864203165e-03, 1.8940821063869206e-03, 1.8774348378665215e-03, -1.3057139142808542e-03, 1.8940821063869206e-03, 7.2606869807052658e-04, 1.3119329296710162e-03, -8.7481229959170993e-06, 1.8774348378665215e-03, 1.3119329296710162e-03, 1.0619415404491685e-03, -1.5481617424794581e-02, 7.3302600110515892e-03, 6.5644710521001073e-04, -1.2283650081392702e-03, 7.3302600110515892e-03, -1.8696748976957526e-03, 5.9596303915765750e-04, 1.2499531031902422e-03, 6.5644710521001073e-04, 5.9596303915765750e-04, 9.7138240642967119e-05, 8.8503568194063412e-04, -1.2283650081392702e-03, 1.2499531031902422e-03, 8.8503568194063412e-04, 2.5511830692021193e-04, -1.3520103229756882e-02, 7.8484109792015359e-03, -4.1632387603416781e-04, -1.1558280730735919e-03, 7.8484109792015359e-03, -2.0728512914414475e-03, 1.9517286698148926e-03, 2.0216583965520000e-03, -4.1632387603416781e-04, 1.9517286698148926e-03, 4.6063232535377560e-04, 1.5362873491442208e-03, -1.1558280730735919e-03, 2.0216583965520000e-03, 1.5362873491442208e-03, 5.2457975844262875e-04, -1.5104116485397874e-02, 8.5473834321937604e-03, -1.3043437235430149e-03, 1.5276622030354890e-03, 8.5473834321937604e-03, -3.3780289659805359e-03, 1.9847858497536674e-03, 5.0757574599316559e-04, -1.3043437235430149e-03, 1.9847858497536674e-03, -1.5945405766001441e-04, 1.5678019969852818e-03, 1.5276622030354890e-03, 5.0757574599316559e-04, 1.5678019969852818e-03, 2.4763257841851471e-04, -1.6361908776597107e-02, 4.3568452185025310e-03, 3.4563556520869625e-03, 4.3658362914368865e-03, 4.3568452185025310e-03, -8.6002608849411477e-04, 1.1935067562380381e-03, 9.5763305550593627e-05, 3.4563556520869625e-03, 1.1935067562380381e-03, -6.5655114602498324e-04, 2.8551486975809026e-04, 4.3658362914368865e-03, 9.5763305550593627e-05, 2.8551486975809026e-04, -5.2757450862172910e-04, -1.7807729170147439e-02, 7.1610610051428998e-03, -1.1911025226577043e-03, 2.6056388311463353e-03, 7.1610610051428998e-03, -2.1885651750746023e-03, 2.9274154172681229e-03, 8.3377402546824613e-04, -1.1911025226577043e-03, 2.9274154172681229e-03, 1.7570402880203167e-04, 1.4504468369839752e-03, 2.6056388311463353e-03, 8.3377402546824613e-04, 1.4504468369839752e-03, 6.9093609359350367e-04, -1.1247931682705574e-02, 5.7455202196775934e-03, 1.1174148432837694e-04, -1.0001185298297672e-03, 5.7455202196775934e-03, -2.1567917357754388e-03, 6.2799688175952328e-04, 5.6474713215460648e-04, 1.1174148432837694e-04, 6.2799688175952328e-04, -1.1840763525279758e-04, 5.3189815096175985e-04, -1.0001185298297672e-03, 5.6474713215460648e-04, 5.3189815096175985e-04, -8.5340380560854686e-05, -1.0115751598013022e-02, 7.1450423354329218e-03, -9.6769024323713497e-04, 6.0983843256720333e-04, 7.1450423354329218e-03, -2.6969102530045707e-03, 1.0319270924417643e-03, 2.3496098746511552e-04, -9.6769024323713497e-04, 1.0319270924417643e-03, -8.0513400430597755e-04, 4.7088258363160609e-04, 6.0983843256720333e-04, 2.3496098746511552e-04, 4.7088258363160609e-04, -1.4457178691538466e-04
  };

  std::vector<double> dy = {
    -3.7309172874861328e-03, 1.3333653131861634e-03, 8.8577244948839816e-04, 4.4771776498148510e-04, -3.2036744215949474e-03, 1.5721737770764861e-03, 7.5774810984830811e-04, -7.6103439612831651e-06, -1.5642091060224157e-03, 2.0953017056858877e-03, 1.8124937780487031e-04, -1.0725465141096370e-03, -2.2923883203997790e-03, 1.8300760226060355e-03, 4.8940452841059862e-04, -6.7210654905128198e-04, -4.3341964593999359e-03, 1.4253156363736956e-03, 9.8923131293439642e-04, 1.2115998085801848e-03, -2.6188268847725871e-03, 1.7119021466805964e-03, 5.6117501695963988e-04, -4.2324237308625010e-04, -2.2900131399922951e-03, 1.8386032061780638e-03, 5.2171200216442610e-04, -6.4883325259721075e-04, -2.5812803651831646e-03, 1.7293876231322676e-03, 6.0622938832230022e-04, -4.3579477573257375e-04, -2.8530249847228155e-03, 1.6808033517384546e-03, 6.6042307748444143e-04, -2.8824157968878450e-04, -3.7393733570642322e-03, 1.3716770835582519e-03, 8.7227862962462044e-04, 4.5872483076204578e-04, -2.4437272319513359e-03, 1.7400758488808985e-03, 5.1182653748711650e-04, -5.8105073770823191e-04, -3.2810369412823396e-03, 1.4918691558186718e-03, 7.4724281784686224e-04, 6.3875403362581882e-05, -3.4247726827394570e-03, 1.4560852013918019e-03, 7.6169488667705810e-04, 1.5409667480043344e-04, -3.7529573893496722e-03, 1.3819905220282573e-03, 8.6645778079868173e-04, 4.5529019815005340e-04, -2.7761885434245126e-03, 1.6221283633832189e-03, 6.4100239162366926e-04, -2.8385959725213443e-04, -2.8619525975001991e-03, 1.6742414664644566e-03, 6.5987011922647798e-04, -2.5588583656454151e-04, -3.5782213588599009e-03, 1.4067925694494811e-03, 8.1801204214687574e-04, 2.9417370593075526e-04, -3.2179311027623852e-03, 1.5351083071313909e-03, 7.6347536572857384e-04, -1.2101519294540594e-05, -3.5358134475080953e-03, 1.4165640362083939e-03, 8.2941835466963714e-04, 2.5395670515060458e-04, -2.3142024782931113e-03, 1.8181293172609410e-03, 5.4151803735599758e-04, -6.0053505167333827e-04, -4.0744831658946472e-03, 1.3071202590006017e-03, 9.9633651691117707e-04, 8.1295718049464744e-04, -3.8475776506513007e-03, 1.2962018740413476e-03, 9.3330073985875681e-04, 5.8452572124980187e-04, -1.9683320699194757e-03, 1.8795410802464392e-03, 3.5931418446205485e-04, -7.9622117146730320e-04, -4.2836432069418432e-03, 1.3057358949544792e-03, 1.0478903069398337e-03, 1.1388072821866995e-03, -3.6481289572086509e-03, 1.2680834323314254e-03, 9.1419213899072288e-04, 4.1250969611241915e-04, -3.7868589170986242e-03, 1.4248346144113545e-03, 8.6769642282752434e-04, 4.8009987220807757e-04, -2.8109243740096651e-03, 1.6305799665922716e-03, 6.4582051914641788e-04, -2.7233613703581204e-04, -3.8714234700849403e-03, 1.4365872229829926e-03, 7.9039059028440748e-04, 5.8082810834859922e-04, -3.2390351248452994e-03, 1.5083636177925740e-03, 7.0100191142906398e-04, 2.1276162385565475e-05, -4.0758464441795483e-03, 1.3467789743563711e-03, 9.0375839572505727e-04, 8.1824793954867955e-04, -4.2307140951998419e-03, 1.3156828039467543e-03, 1.0778378449497364e-03, 9.7419386839855905e-04, -3.8482460366827680e-03, 1.3425192918780234e-03, 8.4666567817293223e-04, 6.0686241880002418e-04, -3.5314219963828199e-03, 1.4381299141681125e-03, 7.9553487485571899e-04, 2.6599193472912579e-04, -3.0625963328189260e-03, 1.5598565683800933e-03, 7.2517085286940468e-04, -1.1417249492739269e-04, -3.2401979571803855e-03, 1.5423006052675326e-03, 7.2952676962876912e-04, -8.5276110538955337e-06, -2.3676304952203239e-03, 1.7913062056963405e-03, 5.4550664708489952e-04, -5.8142337266284694e-04, -3.3562413373964786e-03, 1.4439022806622475e-03, 7.3437787621236539e-04, 1.1756361872177236e-04, -4.3718193202676135e-03, 1.3310441122746876e-03, 1.1562039243607975e-03, 1.1472230349748561e-03, -3.3313992651614545e-03, 1.4915589370723611e-03, 7.8084944429722110e-04, 9.1372270882632316e-05, -4.3740557131606459e-03, 1.3268717399460552e-03, 1.1579324109626387e-03, 1.1521185202595687e-03, -3.7927167356510412e-03, 1.3231482293682613e-03, 8.4755885080500565e-04, 5.4665126459383327e-04, -3.5935568152285231e-03, 1.4290305096829330e-03, 7.8606733253349130e-04, 3.1315221994287850e-04, -3.1614896010873366e-03, 1.5105982619965496e-03, 7.0021276781268450e-04, -2.3983710609199078e-05, -3.0147657599133232e-03, 1.5495419519657451e-03, 6.6899185166963951e-04, -1.2057880405017928e-04, -2.9963762079088952e-03, 1.6034868108259063e-03, 6.3607675253841956e-04, -1.8417206074768401e-04, -2.7426643259774895e-03, 1.6157336038172625e-03, 6.1401235615143987e-04, -3.3306000572104970e-04, -2.4766813065329693e-03, 1.7832827610314490e-03, 5.7063483799111604e-04, -5.1939389006707012e-04, -2.7058508682563827e-03, 1.6218793335994073e-03, 5.7753543630265211e-04, -3.4623185385953561e-04, -3.6714826224726309e-03, 1.4597702029387118e-03, 8.5442239573998893e-04, 3.7440232615804407e-04, -2.5070783356414134e-03, 1.7472384470121067e-03, 5.6462790247820919e-04, -4.6769781044539899e-04, -3.4387661142797959e-03, 1.4535061065990102e-03, 7.7895608021457275e-04, 2.0354737904839946e-04, -2.7050922014808390e-03, 1.6959138589712618e-03, 6.1077224833082030e-04, -3.8335512759285180e-04, -2.5394784289842513e-03, 1.7326482568320832e-03, 5.8030789834628870e-04, -4.9658497358456876e-04, -3.7139080629854208e-03, 1.3083146125837427e-03, 8.8709895889324357e-04, 4.3181952475237497e-04, -3.0902912715277077e-03, 1.5458493373768866e-03, 6.8330337138244770e-04, -7.7274160748078970e-05, -3.6486457748529568e-03, 1.4380340692779169e-03, 8.0537862363315113e-04, 3.6166524605696793e-04, -3.8259014218855834e-03, 1.3935398904790382e-03, 8.5063806525072705e-04, 5.0369999227149601e-04, -3.3219004182506043e-03, 1.5169900953600937e-03, 7.2943565247969642e-04, 1.2454041603774481e-04, -2.9710886292812757e-03, 1.6122308537815642e-03, 6.9407008210209398e-04, -1.8550200210251709e-04, -3.5823989245151611e-03, 1.3803897342254585e-03, 7.9659655171532566e-04, 2.9806889205486018e-04, -2.6709594617153878e-03, 1.7132749589768494e-03, 6.1556197573809268e-04, -3.9142476838036435e-04, -2.9481681479607618e-03, 1.5766328367677427e-03, 6.6232144637444707e-04, -1.4989734301076280e-04, -3.2491817681866895e-03, 1.5341764317035110e-03, 7.6268657981340220e-04, 2.4406488167046862e-05, -3.2248794286049952e-03, 1.4615786669513607e-03, 7.3069596608385794e-04, 5.0300823976094416e-05, 1.2628166438797038e-03, -8.9274753600505690e-04, -4.9076860067750170e-04, -4.1869309125592256e-04, 1.3715102644465138e-03, -1.0141291898274978e-03, -7.8766533967201816e-04, -3.9772035849276288e-04, 1.1612302578037791e-03, -4.3053803181958750e-04, -2.0146672160117711e-04, -7.4016307381392259e-04, 1.4537946412679723e-03, -9.5065863784825301e-04, -1.0343570332467453e-03, -3.8768498653108665e-04, 1.3854917882825165e-03, -1.0295014786804450e-03, -9.6373001786993968e-04, -3.0535774540021835e-04, 1.4511572929488627e-03, -9.2318578761469057e-04, -1.0422547691855640e-03, -4.2723072416751189e-04, 1.4452773695581647e-03, -9.7728273043188804e-04, -1.0741338772551449e-03, -3.0937363161101300e-04, 1.5259064198728280e-03, -8.8493370962583592e-04, -1.2007486502659927e-03, -3.1227283339035905e-04, 1.5436700653155932e-03, -8.7589313303263426e-04, -1.3280253258668860e-03, -1.8105115666848938e-04, 1.5404932421320258e-03, -8.5758359271832579e-04, -1.4832458365412898e-03, 2.6407770476321191e-06, 1.4155612513337844e-03, -1.0046531590963029e-03, -9.6842134578424706e-04, -3.5401027400996205e-04, 1.3400184836343154e-03, -1.0256045874409653e-03, -6.5169805282558834e-04, -4.2701606068519234e-04, 1.2857877730087135e-03, -9.0508762673802764e-04, -5.1943388839087771e-04, -4.6352002092798518e-04, 1.5051360776270669e-03, -8.9594973727753411e-04, -1.1527368214360100e-03, -3.3755565066477403e-04, 1.4546640992893533e-03, -9.5988516608341162e-04, -9.1623755155505670e-04, -4.8588890598821486e-04, 1.4016196272903870e-03, -1.0178182975371106e-03, -9.9041538684325634e-04, -3.1234386991993196e-04, 1.4055482177189956e-03, -1.0213236463436626e-03, -9.7796586357687832e-04, -3.0205558859203868e-04, 1.4242664925470684e-03, -9.8289044930037375e-04, -9.1476699353148475e-04, -4.3593144707404561e-04, 1.4563487652851604e-03, -9.5674318018110129e-04, -1.0204295900713581e-03, -3.8614169684175954e-04, 1.3340538380055412e-03, -9.8166445704493547e-04, -6.4235456808529520e-04, -4.6185514700680652e-04, 1.3251633800902419e-03, -9.7699364526281410e-04, -6.0020814973974911e-04, -4.4027417584270871e-04, 1.3352824913690901e-03, -9.3227658428344747e-04, -6.1244190731189806e-04, -4.9720054122240971e-04, 1.2307343717364581e-03, -8.8718012579170583e-04, -3.7907952728977293e-04, -4.7149395834188992e-04, 1.2872312473441560e-03, -1.0074761274442257e-03, -6.9178075288798071e-04, -2.7705625448618486e-04, 1.2927150624045740e-03, -9.7803534445332430e-04, -4.8720068931597341e-04, -4.6004378064328215e-04, 1.4257607447382041e-03, -9.2923784202873067e-04, -9.6755887729674294e-04, -4.6242569285732927e-04, 1.3914989006502964e-03, -1.0200176224497951e-03, -9.2458206518511248e-04, -3.4506509486466449e-04, 1.4333760204447944e-03, -9.1097262948909249e-04, -1.2188972198513615e-03, -2.5996549081574896e-04, 1.2461083659099338e-03, -8.2861754923992321e-04, -4.1605933810697306e-04, -4.8905777062213857e-04, 1.3768615064283817e-03, -9.9713742062896974e-04, -7.9858980387651933e-04, -4.3504985424060790e-04, 1.3291889767625101e-03, -9.9040477132564600e-04, -6.5776027239921122e-04, -3.9846418355279120e-04, 1.5206075965447940e-03, -9.2006057004575127e-04, -1.2474234877704595e-03, -2.3140418373219520e-04, 1.2887820380652511e-03, -9.3080226682111587e-04, -5.2786640162325342e-04, -4.4118156984124777e-04, 1.3907544080002891e-03, -9.6351013629205012e-04, -7.8303340377082974e-04, -4.7622449399401109e-04, 1.4091048902409534e-03, -9.7169766598279418e-04, -9.3316898961782319e-04, -4.0724649531488546e-04, 1.3879165258355152e-03, -1.0811464187553267e-03, -8.8168502399533827e-04, -3.0373866499100119e-04, 1.2870954343195211e-03, -8.0890289393696527e-04, -5.3267861480527198e-04, -4.9356122412130170e-04, 1.5429774711287242e-03, -8.5866927657185196e-04, -1.3306313542314914e-03, -1.7873354099492435e-04, 1.4021085501997211e-03, -1.0221324371805936e-03, -9.2699019936940438e-04, -3.5288337262228114e-04, 1.3239521433104891e-03, -1.0047418588945290e-03, -8.3997109532851777e-04, -2.7449751294088233e-04, 1.3868837677795806e-03, -1.0276648847350152e-03, -7.1775681753454717e-04, -4.5782917392179828e-04, 1.5808700010297582e-03, -8.3038113202047045e-04, -1.6908149849389628e-03, 2.5410913367872757e-04, 1.4647947565545553e-03, -9.5678426470656116e-04, -9.6423665069701801e-04, -4.5175848785730601e-04, 1.3804322148250373e-03, -9.9700774526987799e-04, -8.1337331990322353e-04, -4.0374879312031649e-04, 1.2800075192210976e-03, -9.2649222387085459e-04, -5.2976884029422029e-04, -4.2936605007220911e-04, 1.3810570455247023e-03, -1.0722378487912155e-03, -7.7520984586550872e-04, -3.6667718738961482e-04, 1.4037862914692491e-03, -9.9147719341820565e-04, -9.5712521087853390e-04, -3.7439255803680066e-04, 1.3299618332732993e-03, -9.9744087373244928e-04, -6.3658280665772381e-04, -4.0128206925905106e-04, 1.5066576047840761e-03, -8.7658152159021132e-04, -1.2789382944763108e-03, -2.3242884748562141e-04, 1.3071504645501193e-03, -8.8996140075365670e-04, -4.9614457597987795e-04, -5.5075072441456200e-04, 1.4159595821463559e-03, -9.9120400447633844e-04, -8.8041573992293201e-04, -4.2244235314895873e-04, 1.2554376918387320e-03, -7.9168866122310321e-04, -4.5152569311177868e-04, -5.2227602995275849e-04, 1.5629805055743966e-03, -8.5058550567704435e-04, -1.3544920149855563e-03, -1.5043929062635852e-04, 1.2912095035131571e-03, -9.1748375464204240e-04, -5.3427771054738980e-04, -4.4418198090508067e-04, 1.4057467167300063e-03, -9.6192143297912003e-04, -7.2872273247311125e-04, -5.4389115598480571e-04, 1.5409804354399271e-03, -8.6418016393906435e-04, -1.5638051161781471e-03, 1.3537325148278473e-04, 1.5124150369572446e-03, -9.0296330713242421e-04, -1.4053433983987566e-03, -5.3260164448894459e-06, 1.3265199858472445e-03, -1.0277688029524160e-03, -7.2309275058722795e-04, -3.4610937063137806e-04, 1.3022445273983721e-03, -9.6922788833204770e-04, -5.7901862780536037e-04, -4.2446243249374797e-04, 1.5616377636392905e-03, -8.6248219043335368e-04, -1.3732629178650024e-03, -1.3294236495870761e-04, 1.2462257930009543e-03, -8.1096438665143804e-04, -4.9300621444041675e-04, -4.4992238895687783e-04, 1.2048138996092884e-03, -7.4155402937961089e-04, -3.8562341095634543e-04, -4.8265185178004110e-04, 1.3997918624215518e-03, -1.0216209066369918e-03, -9.4397461640859136e-04, -3.4199098846130318e-04, 1.2620735286065163e-03, -8.5604575570593841e-04, -4.6109387630229590e-04, -4.8688792774158394e-04, 1.5208163918870386e-03, -8.8722580384502858e-04, -1.1514411523661054e-03, -3.6068716415424309e-04, 1.5616431264257710e-03, -8.6373104473164315e-04, -1.2257596188148397e-03, -3.1867733110531793e-04, 1.2389429452407711e-03, -7.3425077652598814e-04, -3.7818319125320504e-04, -5.5296180344098229e-04, 1.4236745199894749e-03, -9.8144413894297945e-04, -1.0339917147206214e-03, -3.3224350123284209e-04, 1.3639301846054431e-03, -9.7698616283006996e-04, -7.6271561854903563e-04, -4.4038843862668760e-04, 1.3319077186367961e-03, -9.8418504392616744e-04, -6.1766568127290646e-04, -4.5146401018658297e-04, 1.4441953622589801e-03, -9.5685273246004965e-04, -1.0902814510323519e-03, -3.0850762291715034e-04, 1.3433425680632694e-03, -9.9356279190803516e-04, -6.1534605867470541e-04, -4.6558966036282527e-04, 1.4546708164129235e-03, -9.6300590913229187e-04, -1.1337359994421921e-03, -2.5746740945545017e-04, 1.3087856139503663e-03, -1.0168973495678301e-03, -6.4497486510166216e-04, -3.7542838371827940e-04, 1.4352742897946794e-03, -1.0009281183037142e-03, -8.1467745598339078e-04, -4.9780948738641084e-04, 1.3267280323664397e-03, -9.9210831897400889e-04, -7.2110752592905965e-04, -3.7053587233734035e-04, 1.4367724596286544e-03, -9.7287646205622543e-04, -1.0689733437145245e-03, -3.0929713667895097e-04, 1.4284826558297228e-03, -1.0032946508087481e-03, -9.3215819081625623e-04, -3.9266944529891222e-04, 1.2638165713808633e-03, -9.4203549844022077e-04, -4.3172960405687657e-04, -4.4825396345361454e-04, 1.3144188019784330e-03, -1.0229345575007232e-03, -7.8213089400696050e-04, -2.9459056286120584e-04, 1.2977967295550502e-03, -9.1823850004044442e-04, -5.4312108628579527e-04, -4.4973852658337552e-04, 1.4589399346793047e-03, -9.6337020175007505e-04, -9.5571443993837163e-04, -4.3500741544292166e-04, 1.3679082255077248e-03, -1.0456586778204123e-03, -7.9689290020671321e-04, -3.6447108180251604e-04, 1.2192301505625884e-03, -6.8914758742765522e-04, -4.1801535483624729e-04, -5.0855084936264909e-04, 1.4209422098361410e-03, -9.7982501545086425e-04, -9.5383290882026508e-04, -4.0628628933239729e-04, 1.2840876758166296e-03, -9.5726205004418880e-04, -5.9263894588719901e-04, -3.6034174047262833e-04, 1.2193989165566138e-03, -8.6362711921495882e-04, -3.3089474187258407e-04, -4.7367739380385751e-04, 1.4454340065456679e-03, -9.4903106726323190e-04, -9.4294645768342182e-04, -4.7443129921609459e-04, 1.3223313806910361e-03, -1.0793092901145601e-03, -6.6527927680775072e-04, -3.2359110026424040e-04, 1.4973920733738924e-03, -8.8491990550246182e-04, -1.2171591571912377e-03, -3.1820729740532089e-04, 1.2211117894376268e-03, -6.9737457441970436e-04, -3.8056940530299850e-04, -5.5878299644200971e-04, 1.3871354491036012e-03, -1.0196636806439811e-03, -8.9397096134337427e-04, -3.7123677529844246e-04, 1.5073496738918853e-03, -8.9914274586309299e-04, -1.1100923521957767e-03, -3.9534394591372900e-04, 1.5389834372201414e-03, -8.6865302431473463e-04, -1.2678597357811232e-03, -2.2479040064971316e-04, 1.5857715616750692e-03, -8.4802792400804413e-04, -1.4431505536957709e-03, -6.5066771441232851e-05, 1.3040976914584432e-03, -9.5378487842587192e-04, -5.6107062491615094e-04, -4.3607781750943416e-04, 1.4361202688561447e-03, -9.5224831111481809e-04, -1.1297794380246147e-03, -2.6778384205976237e-04, 1.3635676357551174e-03, -9.9412255599946506e-04, -7.3051951765478731e-04, -4.4154800562627911e-04, 1.5508477502083700e-03, -8.7939607075253085e-04, -1.3561935393377267e-03, -1.2635932200992647e-04, 1.3977902932929805e-03, -9.9082462373056976e-04, -8.0283463213426192e-04, -4.5650787679754265e-04, 1.3207741731525238e-03, -9.6358005340555517e-04, -6.3085951867438014e-04, -4.3968075348902217e-04, 1.6252559503457818e-03, -8.1207361624099851e-04, -1.5190942898645995e-03, 3.4005528914352132e-05, 1.2909097015961842e-03, -9.6864624807368213e-04, -5.2347902381152912e-04, -4.3715405458455165e-04, 1.4001851162801044e-03, -9.6767807815415017e-04, -1.1232365779831662e-03, -2.6481040763848013e-04, 1.3217217954799262e-03, -9.7991362264913690e-04, -5.5341730738921137e-04, -4.8295238369989513e-04, 1.2640698090863750e-03, -9.4752318346179938e-04, -4.4218067665729841e-04, -4.6578091847270366e-04, 1.4951267809199774e-03, -9.1642762891185319e-04, -1.0214860239958733e-03, -4.6970740845900466e-04, 1.2841169680887078e-03, -8.6417312011187616e-04, -4.8407383177561302e-04, -5.0088996321260085e-04, 1.3512353593900953e-03, -1.0439736418993391e-03, -9.0759977568137897e-04, -3.0173432033581658e-04, 1.2345305066023997e-03, -8.6838807328022921e-04, -4.0413743732280768e-04, -4.4479537319962951e-04, 1.4466525287875924e-03, -9.5170674859887969e-04, -9.7973885160627201e-04, -4.3948849284228546e-04, 1.3725941331708027e-03, -1.0166781230845619e-03, -7.6755671498962628e-04, -4.3191896703312273e-04, 1.3538563227843109e-03, -1.0199928751009691e-03, -7.7442160079980896e-04, -3.8161567314677245e-04, 1.3859472864117407e-03, -1.0345636883744270e-03, -8.1387538504034307e-04, -4.0318758271787206e-04, 1.2260084446081257e-03, -8.1329688437282478e-04, -3.8608177755934897e-04, -4.6857032807702829e-04, 1.6004862228002157e-03, -8.5869813229410576e-04, -1.4050654852032346e-03, -9.6057664582574606e-05, 1.3459385533108785e-03, -1.0014225817083209e-03, -7.5445110209810162e-04, -3.6394681092073613e-04, 1.5802112204707694e-03, -8.8418143184290860e-04, -1.3656321230276084e-03, -9.9859855886459247e-05, 1.3938777586773245e-03, -9.8734047951481258e-04, -8.2208943704233193e-04, -4.0539504453435344e-04, 1.4360158838886581e-03, -9.5466630949037588e-04, -1.0695021763836086e-03, -3.4966385012963883e-04, 1.4782335719419745e-03, -9.2096462932788139e-04, -9.9386049752195902e-04, -4.9044154671578190e-04, 1.3242075112925250e-03, -9.0801458127461564e-04, -6.9494238580068419e-04, -4.0874412726708961e-04, 1.4746718485486884e-03, -9.4454358380030991e-04, -1.2097928041591858e-03, -1.9567585923707621e-04, 1.3680805611761193e-03, -9.9714444979884850e-04, -6.7787533895967075e-04, -4.8246661902258490e-04, 1.3149700282666921e-03, -9.8943531187651343e-04, -6.8955875031408869e-04, -4.0063500875313666e-04, 1.3856527284201953e-03, -1.0075706013894159e-03, -8.9064557198323456e-04, -3.8669351114642469e-04, 1.2372161408350122e-03, -8.1355539160972760e-04, -5.0496057042071407e-04, -4.0950187262171203e-04, 1.2788105421023745e-03, -8.8057490788653024e-04, -5.8240597405691328e-04, -3.9217722061436343e-04
  };
  const int nloc = 192;
  const int nnei_i = 4;
  const int nnei_j = 4;
  const int last_layer_size = 4;

  void SetUp() override {
  }
  void TearDown() override {
  }
};

TEST_F(TestTabulateSeT, tabulate_fusion_se_t_cpu)
{
  std::vector<double> xyz_scatter(nloc * last_layer_size, 0);
  deepmd::tabulate_fusion_se_t_cpu<double>(&xyz_scatter[0], &table[0], &info[0], &em_x[0], &em[0], nloc, nnei_i, nnei_j, last_layer_size);
  EXPECT_EQ(xyz_scatter.size(), nloc * last_layer_size);
  EXPECT_EQ(xyz_scatter.size(), expected_xyz_scatter.size());
  for (int jj = 0; jj < xyz_scatter.size(); ++jj) {
    EXPECT_LT(fabs(xyz_scatter[jj] - expected_xyz_scatter[jj]) , 1e-5);
  }
}

TEST_F(TestTabulateSeT, tabulate_fusion_se_t_grad_cpu)
{
  std::vector<double> dy_dem_x(em_x.size());
  std::vector<double> dy_dem(em.size());
  deepmd::tabulate_fusion_se_t_grad_cpu<double>(&dy_dem_x[0], &dy_dem[0], &table[0], &info[0], &em_x[0], &em[0], &dy[0], nloc, nnei_i, nnei_j, last_layer_size);
  EXPECT_EQ(dy_dem_x.size(), nloc * nnei_i * nnei_j);
  EXPECT_EQ(dy_dem.size(), nloc * nnei_i * nnei_j);
  EXPECT_EQ(dy_dem_x.size(), expected_dy_dem_x.size());
  EXPECT_EQ(dy_dem.size(), expected_dy_dem.size());
  for (int jj = 0; jj < dy_dem_x.size(); ++jj) {
    EXPECT_LT(fabs(dy_dem_x[jj] - expected_dy_dem_x[jj]) , 1e-5);
  }
  for (int jj = 0; jj < dy_dem.size(); ++jj) {
    EXPECT_LT(fabs(dy_dem[jj] - expected_dy_dem[jj]) , 1e-5);
  }
}

#if GOOGLE_CUDA
TEST_F(TestTabulateSeT, tabulate_fusion_se_t_gpu_cuda)
{
  std::vector<double> xyz_scatter(nloc * last_layer_size, 0.0);
  double * xyz_scatter_dev = NULL, * table_dev = NULL, * em_x_dev = NULL, * em_dev = NULL;
  deepmd::malloc_device_memory_sync(xyz_scatter_dev, xyz_scatter);
  deepmd::malloc_device_memory_sync(table_dev, table);
  deepmd::malloc_device_memory_sync(em_x_dev, em_x);
  deepmd::malloc_device_memory_sync(em_dev, em);
  deepmd::tabulate_fusion_se_t_gpu_cuda<double>(xyz_scatter_dev, table_dev, &info[0], em_x_dev, em_dev, nloc, nnei_i, nnei_j, last_layer_size);
  // deepmd::tabulate_fusion_se_t_cpu<double>(&xyz_scatter[0], &table[0], &info[0], &em_x[0], &em[0], nloc, nnei_i, nnei_j, last_layer_size);
  deepmd::memcpy_device_to_host(xyz_scatter_dev, xyz_scatter);
  deepmd::delete_device_memory(xyz_scatter_dev);
  deepmd::delete_device_memory(table_dev);
  deepmd::delete_device_memory(em_x_dev);
  deepmd::delete_device_memory(em_dev);

  EXPECT_EQ(xyz_scatter.size(), nloc * last_layer_size);
  EXPECT_EQ(xyz_scatter.size(), expected_xyz_scatter.size());
  for (int jj = 0; jj < xyz_scatter.size() / 100; ++jj){
    EXPECT_LT(fabs(xyz_scatter[jj] - expected_xyz_scatter[jj]) , 1e-5);
  }
}

TEST_F(TestTabulateSeT, tabulate_fusion_se_a_grad_gpu_cuda)
{
  std::vector<double> dy_dem_x(em_x.size(), 0.0);
  std::vector<double> dy_dem(em.size(), 0.0);

  double * dy_dem_x_dev = NULL, * dy_dem_dev = NULL, * table_dev = NULL, * em_x_dev = NULL, * em_dev = NULL, * dy_dev = NULL;
  deepmd::malloc_device_memory_sync(dy_dem_x_dev, dy_dem_x);
  deepmd::malloc_device_memory_sync(dy_dem_dev, dy_dem);
  deepmd::malloc_device_memory_sync(table_dev, table);
  deepmd::malloc_device_memory_sync(em_x_dev, em_x);
  deepmd::malloc_device_memory_sync(em_dev, em);
  deepmd::malloc_device_memory_sync(dy_dev, dy);
  deepmd::tabulate_fusion_se_t_grad_gpu_cuda<double>(dy_dem_x_dev, dy_dem_dev, table_dev, &info[0], em_x_dev, em_dev, dy_dev, nloc, nnei_i, nnei_j, last_layer_size);
  deepmd::memcpy_device_to_host(dy_dem_x_dev, dy_dem_x);
  deepmd::memcpy_device_to_host(dy_dem_dev, dy_dem);
  deepmd::delete_device_memory(dy_dem_x_dev);
  deepmd::delete_device_memory(dy_dem_dev);
  deepmd::delete_device_memory(table_dev);
  deepmd::delete_device_memory(em_x_dev);
  deepmd::delete_device_memory(em_dev);
  deepmd::delete_device_memory(dy_dev);

  EXPECT_EQ(dy_dem_x.size(), nloc * nnei_i * nnei_j);
  EXPECT_EQ(dy_dem.size(), nloc * nnei_i * nnei_j);
  EXPECT_EQ(dy_dem_x.size(), expected_dy_dem_x.size());
  EXPECT_EQ(dy_dem.size(), expected_dy_dem.size());
  for (int jj = 0; jj < dy_dem_x.size(); ++jj){
    EXPECT_LT(fabs(dy_dem_x[jj] - expected_dy_dem_x[jj]) , 1e-5);
  }
  for (int jj = 0; jj < dy_dem.size(); ++jj){
    EXPECT_LT(fabs(dy_dem[jj] - expected_dy_dem[jj]) , 1e-5);
  }
}
#endif // GOOGLE_CUDA

#if TENSORFLOW_USE_ROCM
TEST_F(TestTabulateSeT, tabulate_fusion_se_t_gpu_rocm)
{
  std::vector<double> xyz_scatter(nloc * last_layer_size, 0.0);
  double * xyz_scatter_dev = NULL, * table_dev = NULL, * em_x_dev = NULL, * em_dev = NULL;
  deepmd::malloc_device_memory_sync(xyz_scatter_dev, xyz_scatter);
  deepmd::malloc_device_memory_sync(table_dev, table);
  deepmd::malloc_device_memory_sync(em_x_dev, em_x);
  deepmd::malloc_device_memory_sync(em_dev, em);
  deepmd::tabulate_fusion_se_t_gpu_rocm<double>(xyz_scatter_dev, table_dev, &info[0], em_x_dev, em_dev, nloc, nnei_i, nnei_j, last_layer_size);
  deepmd::memcpy_device_to_host(xyz_scatter_dev, xyz_scatter);
  deepmd::delete_device_memory(xyz_scatter_dev);
  deepmd::delete_device_memory(table_dev);
  deepmd::delete_device_memory(em_x_dev);
  deepmd::delete_device_memory(em_dev);

  EXPECT_EQ(xyz_scatter.size(), nloc * last_layer_size);
  EXPECT_EQ(xyz_scatter.size(), expected_xyz_scatter.size());
  for (int jj = 0; jj < xyz_scatter.size() / 100; ++jj){
    EXPECT_LT(fabs(xyz_scatter[jj] - expected_xyz_scatter[jj]) , 1e-5);
  }
}

TEST_F(TestTabulateSeT, tabulate_fusion_se_t_grad_gpu_rocm)
{
  std::vector<double> dy_dem_x(em_x.size(), 0.0);
  std::vector<double> dy_dem(em.size(), 0.0);

  double * dy_dem_x_dev = NULL, * dy_dem_dev = NULL, * table_dev = NULL, * em_x_dev = NULL, * em_dev = NULL, * dy_dev = NULL;
  deepmd::malloc_device_memory_sync(dy_dem_x_dev, dy_dem_x);
  deepmd::malloc_device_memory_sync(dy_dem_dev, dy_dem);
  deepmd::malloc_device_memory_sync(table_dev, table);
  deepmd::malloc_device_memory_sync(em_x_dev, em_x);
  deepmd::malloc_device_memory_sync(em_dev, em);
  deepmd::malloc_device_memory_sync(dy_dev, dy);
  deepmd::tabulate_fusion_se_t_grad_gpu_rocm<double>(dy_dem_x_dev, dy_dem_dev, table_dev, &info[0], em_x_dev, em_dev, dy_dev, nloc, nnei_i, nnei_j, last_layer_size);
  deepmd::memcpy_device_to_host(dy_dem_x_dev, dy_dem_x);
  deepmd::memcpy_device_to_host(dy_dem_dev, dy_dem);
  deepmd::delete_device_memory(dy_dem_x_dev);
  deepmd::delete_device_memory(dy_dem_dev);
  deepmd::delete_device_memory(table_dev);
  deepmd::delete_device_memory(em_x_dev);
  deepmd::delete_device_memory(em_dev);
  deepmd::delete_device_memory(dy_dev);

  EXPECT_EQ(dy_dem_x.size(), nloc * nnei_i * nnei_j);
  EXPECT_EQ(dy_dem.size(), nloc * nnei_i * nnei_j);
  EXPECT_EQ(dy_dem_x.size(), expected_dy_dem_x.size());
  EXPECT_EQ(dy_dem.size(), expected_dy_dem.size());
  for (int jj = 0; jj < dy_dem_x.size(); ++jj){
    EXPECT_LT(fabs(dy_dem_x[jj] - expected_dy_dem_x[jj]) , 1e-5);
  }
  for (int jj = 0; jj < dy_dem.size(); ++jj){
    EXPECT_LT(fabs(dy_dem[jj] - expected_dy_dem[jj]) , 1e-5);
  }
}
#endif // TENSORFLOW_USE_ROCM
