# DeePMD-kit(Deep Potential Molecular Dynamics)
## 模型介绍

DeePMD-kit是深度势能分子动力学的开源项目。分子动力学是一套分子模拟方法，该方法主要依靠牛顿力学来模拟分子体系的运动。分子动力学在微观世界模拟中起着承载作用，在物理、化学、生物、材料科学以及力学等领域都有着非常重要的应用。

深势科技成功将DeePMD-kit进行了并行化，首次实现了具有AIMD精度的第一性原理分子动力学模拟的商业与原子规模的应用，为分子动力学提供了革命性的高性能解决方案。

## 模型结构

DeePMD-Kit,参考https://docs.deepmodeling.com/projects/deepmd/en/master/index.html

## DeePMD代码参考版本

版本：v2.1.5

原始代码位置：https://github.com/deepmodeling/deepmd-kit

## 数据集

示例中验证的数据集来自：

wget http://pai-blade.oss-accelerate.aliyuncs.com/bladedisc_notebook_binaries/data/disc_deepmd_example/data.tar.gz

tar -xvf data.tar.gz

实际业务测试请选择合适的数据集进行测试。

## 训练

### 环境配置
提供[光源](https://www.sourcefind.cn/#/service-details)拉取的训练的docker镜像：

* 训练镜像：
  docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:deepmd

* 激活镜像环境及运行测试
  source /root/env_disc.sh

  cd /root/test_case/water
 
  sh run.sh

* python依赖安装：

  pip3 install -r requirement.txt

### 安装(如使用镜像，则无需再次安装)

export ROCM_ROOT=/opt/dtk-22.04.2

DP_VARIANT=rocm  python3 -m pip install .  -i https://pypi.tuna.tsinghua.edu.cn/simple --trusted-host pypi.tuna.tsinghua.edu.cn

### 单卡测试

使用BladeDISC加速的测试命令（此处以单机单卡规模为例说明）,请根据实际使用的卡id号调整run.sh中指定的卡号：

    bash run.sh

如果需要关闭BladeDISC加速，需要注释掉main.py文件中的如下内容：

    disc.enable()

### 准确率验证 

准确率通过对比优化前与优化后的输出文件lcurve.out输出趋势一致进行确认；

## 历史版本

* https://developer.hpccube.com/codes/modelzoo/bladedisc_deepmd

## 参考

* https://github.com/deepmodeling/deepmd-kit 

