#!/bin/bash
# Copyright 2021 The BladeDISC Authors. All rights reserved.
# Licensed under the Apache License, Version 2.0 (the License);
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an AS IS BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.



#export DP_INTERFACE_PREC=low

#!/bin/bash

#get DTKROOT by env.sh location
export DTKROOT=/opt/dtk-22.04.2
export AMDGPU_TARGETS="gfx906"
export ROCMVER=22.04.2
export DTK_HOME=/opt/dtk-22.04.2

export ROCM_PATH=${DTK_HOME}
export HIP_PATH=${DTK_HOME}/hip
export PATH=${DTK_HOME}/bin:${DTK_HOME}/llvm/bin:${DTK_HOME}/hip/bin:${DTK_HOME}/miopen/bin:$PATH
export LD_LIBRARY_PATH=${DTK_HOME}/lib:${DTK_HOME}/lib64:${DTK_HOME}/hip/lib:${DTK_HOME}/llvm/lib:${DTK_HOME}/miopen/lib:$LD_LIBRARY_PATH
export INCLUDE=${DTK_HOME}/include:${DTK_HOME}/hip/include:${DTK_HOME}/llvm/include:$INCLUDE
export C_INCLUDE_PATH=${DTK_HOME}/include:${DTK_HOME}/hip/include:${DTK_HOME}/llvm/include:$C_INCLUDE_PATH
export CPLUS_INCLUDE_PATH=${DTK_HOME}/include:$CPLUS_INCLUDE_PATH
export MIOPEN_SYSTEM_DB_PATH=${DTK_HOME}/miopen/share/miopen/db/

export PYTHONPATH=/usr/local/
export PATH=${PYTHONPATH}/bin/:$PATH
export LD_LIBRARY_PATH=/usr/local/lib/python3.7:/usr/local/lib/python3.7/site-packages/torch/lib:$LD_LIBRARY_PATH
export INCLUDE=/opt/rh/devtoolset-7/root/usr/lib/gcc/x86_64-redhat-linux/7/include:/usr/local/include/python3.7m:/usr/local/lib/python3.7/site-packages/torch/include/:$INCLUDE
export INCLUDE_PATH=/opt/rh/devtoolset-7/root/usr/lib/gcc/x86_64-redhat-linux/7/include:/usr/local/include/python3.7m:/usr/local/lib/python3.7/site-packages/torch/include/:$INCLUDE
export C_INCLUDE_PATH=/opt/rh/devtoolset-7/root/usr/lib/gcc/x86_64-redhat-linux/7/include:/usr/local/include/python3.7m:/usr/local/lib/python3.7/site-packages/torch/include/:$C_INCLUDE_PATH
export CPLUS_INCLUDE_PATH=/opt/rh/devtoolset-7/root/usr/lib/gcc/x86_64-redhat-linux/7/include:/usr/local/include/python3.7m:/usr/local/lib/python3.7/site-packages/torch/include/:$CPLUS_INCLUDE_PATH

export CUDA_VISIBLE_DEVICES=3
export HIP_VISIBLE_DEVICES=3

export DISC_DEBUG=0
export TAO_ENFORCE_VERBOSE_COMPILATION_LOG=0
export TF_CPP_VMODULE=disc_compiler=0
export DISC_ROCM_PATH=/opt/dtk-22.04.2/
export ROCM_PATH=/opt/dtk-22.04.2/
python3 main.py train input.json
