# How to tune Fitting/embedding-net size ?

Here are some test forms on fitting-net size tuning or embedding-net size tuning performed on several different systems.


## Al2O3

### Fitting net size tuning form on Al2O3: (embedding-net size: [25,50,100])

Fitting-net size | Energy L2err(eV) | Energy L2err/Natoms(eV) | Force L2err(eV/Angstrom)
---|---|---|---
[240,240,240] |   1.742252e-02 |  7.259383e-05 |  4.014115e-02 
[80,80,80]    |   1.799349e-02 |  7.497287e-05 |  4.042977e-02 
[40,40,40]    |   1.799036e-02 |  7.495984e-05 |  4.068806e-02 
[20,20,20]    |   1.834032e-02 |  7.641801e-05 |  4.094784e-02 
[10,10,10]    |   1.913058e-02 |  7.971073e-05 |  4.154775e-02 
[5,5,5]       |   1.932914e-02 |  8.053808e-05 |  4.188052e-02 
[4,4,4]       |   1.944832e-02 |  8.103467e-05 |  4.217826e-02 
[3,3,3]       |   2.068631e-02 |  8.619296e-05 |  4.300497e-02 
[2,2,2]       |   2.267962e-02 |  9.449840e-05 |  4.413609e-02 
[1,1,1]       |   2.813596e-02 |  1.172332e-04 |  4.781115e-02 
[]            |   3.135002e-02 |  1.306251e-04 |  5.373120e-02 

_[] means no hidden layer, but there is still a linear output layer. This situation is equal to the linear regression._

### Embedding net size tuning form on Al2O3: (Fitting-net size: [240,240,240])

Embedding-net size | Energy L2err(eV) | Energy L2err/Natoms(eV) | Force L2err(eV/Angstrom)
---|---|---|---
[25,50,100]  | 1.742252e-02  | 7.259383e-05  | 4.014115e-02  
[10,20,40]   | 2.909990e-02  | 1.212496e-04  | 4.734667e-02  
[5,10,20]    | 3.357767e-02  | 1.399070e-04  | 5.706385e-02  
[4,8,16]     | 6.060367e-02  | 2.525153e-04  | 7.333304e-02  
[3,6,12]     | 5.656043e-02  | 2.356685e-04  | 7.793539e-02  
[2,4,8]      | 5.277023e-02  | 2.198759e-04  | 7.459995e-02  
[1,2,4]      | 1.302282e-01  | 5.426174e-04  | 9.672238e-02  


## Cu

### Fitting net size tuning form on Cu: (embedding-net size: [25,50,100])

Fitting-net size | Energy L2err(eV) | Energy L2err/Natoms(eV) | Force L2err(eV/Angstrom)
---|---|---|---
[240,240,240]  | 4.135548e-02   |  1.615449e-04   |  8.940946e-02
[20,20,20]     | 4.323858e-02   |  1.689007e-04   |  8.955762e-02 
[10,10,10]     | 4.399364e-02   |  1.718502e-04   |  8.962891e-02 
[5,5,5]        | 4.468404e-02   |  1.745470e-04   |  8.970111e-02 
[4,4,4]        | 4.463580e-02   |  1.743586e-04   |  8.972011e-02 
[3,3,3]        | 4.493758e-02   |  1.755374e-04   |  8.971303e-02 
[2,2,2]        | 4.500736e-02   |  1.758100e-04   |  8.973878e-02 
[1,1,1]        | 4.542073e-02   |  1.774247e-04   |  8.964761e-02 
[]             | 4.545168e-02   |  1.775456e-04   |  8.983201e-02 

### Embedding net size tuning form on Cu: (Fitting-net size: [240,240,240])

Embedding-net size | Energy L2err(eV) | Energy L2err/Natoms(eV) | Force L2err(eV/Angstrom)
---|---|---|---
[25,50,100]          | 4.135548e-02  |  1.615449e-04  |  8.940946e-02  
[20,40,80]           | 4.203562e-02  |  1.642016e-04  |  8.925881e-02  
[15,30,60]           | 4.146672e-02  |  1.619794e-04  |  8.936911e-02  
[10,20,40]           | 4.263060e-02  |  1.665258e-04  |  8.955818e-02  
[5,10,20]            | 4.994913e-02  |  1.951138e-04  |  9.007786e-02   
[4,8,16]             | 1.022157e-01  |  3.992802e-04  |  9.532119e-02   
[3,6,12]             | 1.362098e-01  |  5.320695e-04  |  1.073860e-01   
[2,4,8]              | 7.061800e-02  |  2.758515e-04  |  9.126418e-02   
[1,2,4] && seed = 1  | 9.843161e-02  |  3.844985e-04  |  9.348505e-02   
[1,2,4] && seed = 2  | 9.404335e-02  |  3.673568e-04  |  9.304089e-02   
[1,2,4] && seed = 3  | 1.508016e-01  |  5.890688e-04  |  1.382356e-01   
[1,2,4] && seed = 4  | 9.686949e-02  |  3.783965e-04  |  9.294820e-02   


## Water

### Fitting net size tuning form on water: (embedding-net size: [25,50,100])

Fitting-net size | Energy L2err/Natoms(eV) | Force L2err(eV/Angstrom)
---|---|---
[240,240,240]  | 9.1589E-04  | 5.1540E-02
[200,200,200]  | 9.3221E-04  | 5.2366E-02
[160,160,160]  | 9.4274E-04  | 5.3403E-02
[120,120,120]  | 9.5407E-04  | 5.3093E-02
[80,80,80]     | 9.4605E-04  | 5.3402E-02
[40,40,40]     | 9.8533E-04  | 5.5790E-02
[20,20,20]     | 1.0057E-03  | 5.8232E-02
[10,10,10]     | 1.0466E-03  | 6.2279E-02
[5,5,5]        | 1.1154E-03  | 6.7994E-02
[4,4,4]        | 1.1289E-03  | 6.9613E-02
[3,3,3]        | 1.2368E-03  | 7.9786E-02
[2,2,2]        | 1.3558E-03  | 9.7042E-02
[1,1,1]        | 1.4633E-03  | 1.1265E-01
[]             | 1.5193E-03  | 1.2136E-01

### Embedding net size tuning form on water: (Fitting-net size: [240,240,240])

Embedding-net size | Energy L2err/Natoms(eV) | Force L2err(eV/Angstrom)
---|---|---
[25,50,100]  | 9.1589E-04  | 5.1540E-02
[20,40,80]   | 9.5080E-04  | 5.3593E-02
[15,30,60]   | 9.7996E-04  | 5.6338E-02
[10,20,40]   | 1.0353E-03  | 6.2776E-02
[5,10,20]    | 1.1254E-03  | 7.3195E-02
[4,8,16]     | 1.2495E-03  | 8.0371E-02
[3,6,12]     | 1.3604E-03  | 9.9883E-02
[2,4,8]      | 1.4358E-03  | 9.7389E-02
[1,2,4]      | 2.1765E-03  | 1.7276E-01


## Mg-Al

### Fitting net size tuning form on Mg-Al: (embedding-net size: [25,50,100])

Fitting-net size | Energy L2err/Natoms(eV) | Force L2err(eV/Angstrom)
---|---|---
[240,240,240]  | 3.9606e-03  | 1.6289e-02
[200,200,200]  | 3.9449e-03  | 1.6471e-02
[160,160,160]  | 4.0947e-03  | 1.6413e-02
[120,120,120]  | 3.9234e-03  | 1.6283e-02
[80,80,80]     | 3.9758e-03  | 1.6506e-02
[40,40,40]     | 3.9142e-03  | 1.6348e-02
[20,20,20]     | 4.1302e-03  | 1.7006e-02
[10,10,10]     | 4.3433e-03  | 1.7524e-02
[5,5,5]        | 5.3154e-03  | 1.9716e-02
[4,4,4]        | 5.4210e-03  | 1.9710e-02
[2,2,2]        | 6.2667e-03  | 2.2568e-02
[1,1,1]        | 7.3676e-03  | 2.6375e-02
[]             | 7.3999e-03  | 2.6097e-02

### Embedding net size tuning form on Mg-Al: (Fitting-net size: [240,240,240])

Embedding-net size | Energy L2err/Natoms(eV) | Force L2err(eV/Angstrom)
---|---|---
[25,50,100]  | 3.9606e-03  | 1.6289e-02
[20,40,80]   | 4.0292e-03  | 1.6555e-02
[15,30,60]   | 4.1743e-03  | 1.7026e-02
[10,20,40]   | 4.8138e-03  | 1.8516e-02
[5,10,20]    | 5.6052e-03  | 2.0709e-02
[4,8,16]     | 6.1335e-03  | 2.1450e-02
[3,6,12]     | 6.6469e-03  | 2.3003e-02
[2,4,8]      | 6.8222e-03  | 2.6318e-02
[1,2,4]      | 1.0678e-02  | 3.9559e-02
