# DeePMD
## 论文
参考End-to-end Symmetry Preserving Inter-atomic Potential Energy Model for Finite and Extended Systems
https://dl.acm.org/doi/pdf/10.5555/3327345.3327356

## 模型结构
DeePMD-kit是深度势能分子动力学的开源项目。分子动力学是一套分子模拟方法，该方法主要依靠牛顿力学来模拟分子体系的运动。分子动力学在微观世界模拟中起着承载作用，在物理、化学、生物、材料科>学以及力学等领域都有着非常重要的应用。

深势科技成功将DeePMD-kit进行了并行化，首次实现了具有AIMD精度的第一性原理分子动力学模拟的商业与原子规模的应用，为分子动力学提供了革命性的高性能解决方案。
![DeePMD_backbone](DeePMD_backbone.png)

## 算法原理
DeePMD-kit使用第一性原理计算的输入、输出结果来训练模型。
模型输入：原子坐标x, y, z和元素种类；
模型输出：体系能量，能量对坐标的一阶导数值（原子受力）；

1、首先根据原子坐标和种类生成矩阵，矩阵可在旋转和平移的情况下保持不变，以保证第一性原理的计算结果不变；
2、将矩阵输入一个多层全连接网络（fitting net），得到该体系中单个原子的能量，求和即可得到体系总能量；
3、体系总能量对原子坐标求一阶导，一阶导对应原子受力；
4、将模型输出结果（能量+原子受力）输入分子动力学模拟软件LAMMPS中求解动力学结果；
![Algorithm_principle](Algorithm_principle.png)

## 环境配置
### Docker(方法一)
提供[光源](https://www.sourcefind.cn/#/service-details)拉取的训练的docker镜像：

训练镜像：
```
  docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:deepmd
  docker run -it -v /path/your_code_data/:/path/your_code_data/ --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash

```
激活镜像环境及运行测试
```
  source /root/env_disc.sh

```
python依赖安装：

```
  pip3 install -r requirements.txt
```
## 数据集

示例中验证的数据集来自：

```
wget http://pai-blade.oss-accelerate.aliyuncs.com/bladedisc_notebook_binaries/data/disc_deepmd_example/data.tar.gz

tar -xvf data.tar.gz
data
    ├── data_0
    ├── data_1
        ├──set.000
        ├──set.001
        ...
    ├── data_2
    ├── data_3

```

实际业务测试请选择合适的数据集进行测试。

## 训练

### 安装(如使用镜像，则无需再次安装)
```
export ROCM_ROOT=/opt/dtk-22.04.2

DP_VARIANT=rocm  python3 -m pip install .  -i https://pypi.tuna.tsinghua.edu.cn/simple --trusted-host pypi.tuna.tsinghua.edu.cn
```
### 单卡测试

使用BladeDISC加速的测试命令（此处以单机单卡规模为例说明）,请根据实际使用的卡id号调整run.sh中指定的卡号：
```
    cd /root/test_case/water

    bash run.sh
```
如果需要关闭BladeDISC加速，需要注释掉main.py文件中的如下内容：
```
    disc.enable()
```
## result
无

### 精度
![DeePMD_result](DeePMD_result.jpg)

## 应用场景
### 算法类别
AI For Science

### 热点行业
能源,科研,制造

## 源码仓库及问题反馈

https://developer.sourcefind.cn/codes/modelzoo/bladedisc_deepmd

## 参考资料

https://github.com/deepmodeling/deepmd-kit 

